/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.hp;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.GccCompatibleCCompiler;
import net.sf.antcontrib.cpptasks.hp.HPLinker;
import org.apache.tools.ant.types.Environment;

public final class HPCompiler
extends GccCompatibleCCompiler {
    private String identifier;
    private File[] includePath;
    private static final HPCompiler instance = new HPCompiler("cc", false, null);

    private HPCompiler(String command, boolean newEnvironment, Environment env) {
        super(command, "-help", false, null, newEnvironment, env);
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    public static HPCompiler getInstance() {
        return instance;
    }

    public File[] getEnvironmentIncludePath() {
        if (this.includePath == null) {
            File compilerIncludeDir;
            File ccLoc = CUtil.getExecutableLocation("cc");
            if (ccLoc != null && (compilerIncludeDir = new File(new File(ccLoc, "../include").getAbsolutePath())).exists()) {
                this.includePath = new File[2];
                this.includePath[0] = compilerIncludeDir;
            }
            if (this.includePath == null) {
                this.includePath = new File[1];
            }
            this.includePath[this.includePath.length - 1] = new File("/usr/include");
        }
        return this.includePath;
    }

    public void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("+z");
        }
    }

    public void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 1: 
            case 2: {
                args.addElement("+w");
            }
        }
    }

    public Linker getLinker(LinkType linkType) {
        return HPLinker.getInstance().getLinker(linkType);
    }
}

