/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntValueHashMap;

public class User {
    private boolean isSys;
    private boolean isPublic;
    private String sName;
    private String sPassword;
    private Grantee grantee;

    User(String string, String string2, Grantee grantee) throws HsqlException {
        boolean bl;
        this.sName = string;
        this.grantee = grantee;
        boolean bl2 = bl = this.grantee != null || GranteeManager.isReserved(string);
        if (!bl) {
            Trace.doAssert(false, Trace.getMessage(234) + ": " + string);
        }
        this.setPassword(string2);
        this.isSys = string.equals("_SYSTEM");
        this.isPublic = string.equals("PUBLIC");
    }

    String getName() {
        return this.sName;
    }

    void setPassword(String string) throws HsqlException {
        this.sPassword = string;
    }

    void checkPassword(String string) throws HsqlException {
        Trace.check(string.equals(this.sPassword), 33);
    }

    boolean isSys() {
        return this.isSys;
    }

    boolean isPublic() {
        return this.isPublic;
    }

    String getAlterUserDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.sName).append(' ');
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("PASSWORD").append(' ');
        stringBuffer.append('\"').append(this.sPassword).append('\"');
        return stringBuffer.toString();
    }

    String getCreateUserDDL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.sName).append(' ');
        stringBuffer.append("PASSWORD").append(' ');
        stringBuffer.append('\"').append(this.sPassword).append('\"');
        return stringBuffer.toString();
    }

    public String getConnectStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CONNECT").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.sName);
        return stringBuffer.toString();
    }

    Grantee getGrantee() {
        return this.grantee;
    }

    void setGrantee(Grantee grantee) throws HsqlException {
        if (this.grantee != null) {
            Trace.doAssert(false, Trace.getMessage(235) + ": " + this.sName);
        }
        this.grantee = grantee;
    }

    boolean isAdmin() {
        return this.grantee.isAdmin();
    }

    String[] listGrantedTablePrivileges(HsqlNameManager.HsqlName hsqlName) {
        return this.grantee.listGrantedTablePrivileges(hsqlName);
    }

    HashSet getGrantedClassNames(boolean bl) throws HsqlException {
        return this.grantee.getGrantedClassNames(bl);
    }

    IntValueHashMap getRights() {
        return this.grantee.getRights();
    }

    void checkAdmin() throws HsqlException {
        this.grantee.checkAdmin();
    }

    void check(Object object, int n) throws HsqlException {
        this.grantee.check(object, n);
    }

    boolean isAccessible(Object object, int n) throws HsqlException {
        return this.grantee.isAccessible(object, n);
    }

    boolean isAccessible(Object object) throws HsqlException {
        return this.grantee.isAccessible(object);
    }
}

