/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.ber;

import com.vizdom.ber.BerContentsInputStream;
import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerModule;
import com.vizdom.ber.BerObject;
import com.vizdom.ber.BerObjectEnumeration;
import com.vizdom.util.UnreachableCodeException;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class BerSequence
extends BerObject {
    static final BerIdentifier gIDENTIFIER = new BerIdentifier(32, 16);
    protected BerObject[] mSequence;
    private ByteArrayOutputStream mCachedContents;

    protected BerSequence() {
    }

    public BerSequence(BerObject[] aSequence) {
        this.mSequence = new BerObject[aSequence.length];
        System.arraycopy(aSequence, 0, this.mSequence, 0, aSequence.length);
    }

    @Override
    public BerIdentifier getIdentifier() {
        return gIDENTIFIER;
    }

    private synchronized void mCacheContents() {
        if (this.mCachedContents == null) {
            try {
                this.mCachedContents = new ByteArrayOutputStream();
                for (int i = 0; i < this.mSequence.length; ++i) {
                    this.mSequence[i].writeTo(this.mCachedContents);
                }
            }
            catch (IOException e) {
                throw new UnreachableCodeException();
            }
        }
    }

    @Override
    protected final int mGetLength() {
        if (this.mCachedContents == null) {
            this.mCacheContents();
        }
        return this.mCachedContents.size();
    }

    @Override
    protected final void mWriteContents(OutputStream anOut) throws IOException {
        if (this.mCachedContents == null) {
            this.mCacheContents();
        }
        this.mCachedContents.writeTo(anOut);
    }

    @Override
    protected void mReadContents(InputStream anIn, BerModule aModule, BerIdentifier anIdentifier, int aLength) throws IOException {
        BerObject bero;
        BerContentsInputStream inContents = new BerContentsInputStream(anIn, aLength);
        Vector<BerObject> beroV = new Vector<BerObject>();
        while ((bero = aModule.readFrom(inContents)) != null) {
            beroV.addElement(bero);
        }
        if (inContents.getCount() != aLength) {
            throw new EOFException();
        }
        this.mSequence = new BerObject[beroV.size()];
        beroV.copyInto(this.mSequence);
    }

    public Enumeration<?> elements() {
        return new BerObjectEnumeration(this.mSequence);
    }

    public BerObject[] toArray() {
        BerObject[] sequence = new BerObject[this.mSequence.length];
        System.arraycopy(this.mSequence, 0, sequence, 0, this.mSequence.length);
        return sequence;
    }

    @Override
    public String toString() {
        if (this.mSequence.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.mSequence[0].toString());
        for (int i = 1; i < this.mSequence.length; ++i) {
            buf.append(", ");
            buf.append(this.mSequence[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

