# Generated by default/object.tt
package Paws::SecurityHub::AwsRdsDbSubnetGroup;
  use Moose;
  has DbSubnetGroupArn => (is => 'ro', isa => 'Str');
  has DbSubnetGroupDescription => (is => 'ro', isa => 'Str');
  has DbSubnetGroupName => (is => 'ro', isa => 'Str');
  has SubnetGroupStatus => (is => 'ro', isa => 'Str');
  has Subnets => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsRdsDbSubnetGroupSubnet]');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsRdsDbSubnetGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsRdsDbSubnetGroup object:

  $service_obj->Method(Att1 => { DbSubnetGroupArn => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsRdsDbSubnetGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->DbSubnetGroupArn

=head1 DESCRIPTION

Information about the subnet group for the database instance.

=head1 ATTRIBUTES


=head2 DbSubnetGroupArn => Str

The ARN of the subnet group.


=head2 DbSubnetGroupDescription => Str

The description of the subnet group.


=head2 DbSubnetGroupName => Str

The name of the subnet group.


=head2 SubnetGroupStatus => Str

The status of the subnet group.


=head2 Subnets => ArrayRef[L<Paws::SecurityHub::AwsRdsDbSubnetGroupSubnet>]

A list of subnets in the subnet group.


=head2 VpcId => Str

The VPC ID of the subnet group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

