# Generated by default/object.tt
package Paws::ES::AutoTuneOptionsOutput;
  use Moose;
  has ErrorMessage => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::AutoTuneOptionsOutput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::AutoTuneOptionsOutput object:

  $service_obj->Method(Att1 => { ErrorMessage => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::AutoTuneOptionsOutput object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorMessage

=head1 DESCRIPTION

Specifies the Auto-Tune options: the Auto-Tune desired state for the
domain and list of maintenance schedules.

=head1 ATTRIBUTES


=head2 ErrorMessage => Str

Specifies the error message while enabling or disabling the Auto-Tune.


=head2 State => Str

Specifies the C<AutoTuneState> for the Elasticsearch domain.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

