package Math::Abacus;

use strict;
use warnings;

=head1 NAME

Math::Abacus - A toy model of Chinese abacus

=head1 VERSION

Version 0.01

The module is drafting.

=cut

our $VERSION = '0.01';


=head1 SYNOPSIS

    use Math::Abacus;

    Math::Abacus->num_of_digits(4);
    my $abacus = Math::Abacus->new(460);
    $abacus->add(1);
    $abacus->subtract(5);
    $abacus->show();

    # PRINT
    +-+-+-+-+-+
    | x x x x |
    | x x | | |
    | | | x x |
    +-+-+-+-+-+
    | | x | x |
    | x x x | |
    | x x x x |
    | x x x x |
    | x | x x |
    | x x x x |
    +-+-+-+-+-+


=head1 METHODS

=head2 show

=head2 add

=head2 subtract

=head1 AUTHOR

Cheok-Yin Fung, C<< <fungcheokyin at gmail.com> >>

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Math::Abacus


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Math-Abacus>

=item * CPAN Ratings

L<https://cpanratings.perl.org/d/Math-Abacus>

=item * Search CPAN

L<https://metacpan.org/release/Math-Abacus>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2022 by Cheok-Yin Fung.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)


=cut

1; # End of Math::Abacus
