# Generated by default/object.tt
package Paws::GreengrassV2::IoTJobExecutionsRolloutConfig;
  use Moose;
  has ExponentialRate => (is => 'ro', isa => 'Paws::GreengrassV2::IoTJobExponentialRolloutRate', request_name => 'exponentialRate', traits => ['NameInRequest']);
  has MaximumPerMinute => (is => 'ro', isa => 'Int', request_name => 'maximumPerMinute', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::IoTJobExecutionsRolloutConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::IoTJobExecutionsRolloutConfig object:

  $service_obj->Method(Att1 => { ExponentialRate => $value, ..., MaximumPerMinute => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::IoTJobExecutionsRolloutConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->ExponentialRate

=head1 DESCRIPTION

Contains information about the rollout configuration for a job. This
configuration defines the rate at which the job deploys a configuration
to a fleet of target devices.

=head1 ATTRIBUTES


=head2 ExponentialRate => L<Paws::GreengrassV2::IoTJobExponentialRolloutRate>

The exponential rate to increase the job rollout rate.


=head2 MaximumPerMinute => Int

The maximum number of devices that receive a pending job notification,
per minute.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

