use strict;
use warnings;
use utf8;
use Test::More;
use t::Util;

sub run;

my $parser = make_parser
    q{05202,"016  ","0160812","ｱｷﾀｹﾝ","ﾉｼﾛｼ","ﾅｶｼﾞﾏ(1-97-116)","秋田県","能代市","中嶋（１−９７〜１１６）",1,0,0,0,0,0},
    q{04205,"988  ","9880927","ﾐﾔｷﾞｹﾝ","ｹｾﾝﾇﾏｼ","ｶﾗｸﾜﾁｮｳﾆｼﾓｳﾈ(200ﾊﾞﾝｲｼﾞｮｳ)","宮城県","気仙沼市","唐桑町西舞根（２００番以上）",1,0,0,0,0,0},
    q{44201,"870  ","8700924","ｵｵｲﾀｹﾝ","ｵｵｲﾀｼ","ﾏｷ(1-3ﾁｮｳﾒ､ｼﾗﾀｷB･C､ﾀｶﾐ)","大分県","大分市","牧（１〜３丁目、白滝Ｂ・Ｃ、高見）",1,0,0,0,0,0},
    q{45206,"88301","8830104","ﾐﾔｻﾞｷｹﾝ","ﾋｭｳｶﾞｼ","ﾄｳｺﾞｳﾁｮｳﾔﾏｹﾞﾎﾞ(513ﾉ1ｲﾅｲ)","宮崎県","日向市","東郷町山陰戊（５１３の１以内）",1,0,0,0,0,0},
    q{46201,"892  ","8920876","ｶｺﾞｼﾏｹﾝ","ｶｺﾞｼﾏｼ","ｵｶﾉﾊﾗﾁｮｳ(832ﾉ2･4)","鹿児島県","鹿児島市","岡之原町（８３２の２・４）",1,0,0,0,0,0},
    q{45201,"88917","8891713","ﾐﾔｻﾞｷｹﾝ","ﾐﾔｻﾞｷｼ","ﾀｶｵｶﾁｮｳｶﾐｸﾗﾅｶﾞ(1206-1268ﾊﾞﾝﾁ､ｳﾁﾉﾔｴ)","宮崎県","宮崎市","高岡町上倉永（１２０６〜１２６８番地、内の八重）",1,0,0,0,0,0},
    q{01632,"08011","0801189","ﾎｯｶｲﾄﾞｳ","ｶﾄｳｸﾞﾝｼﾎﾛﾁｮｳ","ｼﾎﾛ(ﾐﾅﾐｲｯｸ18ｺﾞｳ-21ｺﾞｳ)","北海道","河東郡士幌町","士幌（南一区１８号〜２１号南）",1,0,0,1,0,0},
    q{01639,"08915","0891583","ﾎｯｶｲﾄﾞｳ","ｶｻｲｸﾞﾝｻﾗﾍﾞﾂﾑﾗ","ｶﾐｻﾗﾍﾞﾂ(1ｸ)","北海道","河西郡更別村","上更別（１区）",1,0,0,0,0,0},
    q{01639,"08915","0891542","ﾎｯｶｲﾄﾞｳ","ｶｻｲｸﾞﾝｻﾗﾍﾞﾂﾑﾗ","ｻﾗﾍﾞﾂ(ｸ)","北海道","河西郡更別村","更別（区）",1,0,0,0,0,0},
    q{01639,"08915","0891562","ﾎｯｶｲﾄﾞｳ","ｶｻｲｸﾞﾝｻﾗﾍﾞﾂﾑﾗ","ｻﾗﾍﾞﾂ(ﾋｶﾞｼｸ)","北海道","河西郡更別村","更別（東区）",1,0,0,0,0,0},
    q{08220,"305  ","3050804","ｲﾊﾞﾗｷｹﾝ","ﾂｸﾊﾞｼ","ｱｻﾋ(1)","茨城県","つくば市","旭（１）",1,0,0,0,0,0},
    q{08220,"30026","3002632","ｲﾊﾞﾗｷｹﾝ","ﾂｸﾊﾞｼ","ｱｻﾋ(ｿﾉﾀ)","茨城県","つくば市","旭（その他）",1,0,0,0,0,0},
    q{08220,"305  ","3050801","ｲﾊﾞﾗｷｹﾝ","ﾂｸﾊﾞｼ","ｵｵﾎ(1-1)","茨城県","つくば市","大穂（１−１）",1,0,0,0,0,0},
    q{08220,"305  ","3050802","ｲﾊﾞﾗｷｹﾝ","ﾂｸﾊﾞｼ","ﾀﾁﾊﾗ(1､2､3)","茨城県","つくば市","立原（１、２、３）",1,0,0,0,0,0},
    q{09407,"32503","3250304","ﾄﾁｷﾞｹﾝ","ﾅｽｸﾞﾝﾅｽﾏﾁ","ﾀｶｸｺｳ(2888､5256-6140､6328､6437)","栃木県","那須郡那須町","高久甲（２８８８、５２５６〜６１４０、６３２８、６４３７）",1,0,0,0,0,0},
    q{10425,"37714","3771405","ｸﾞﾝﾏｹﾝ","ｱｶﾞﾂﾏｸﾞﾝﾂﾏｺﾞｲﾑﾗ","ｶﾝﾊﾞﾗ(ﾓﾛｼｺ<ｱｻﾏｴﾝ>)","群馬県","吾妻郡嬬恋村","鎌原（モロシコ「浅間園」）",1,0,0,0,0,0},
    q{10425,"37715","3771528","ｸﾞﾝﾏｹﾝ","ｱｶﾞﾂﾏｸﾞﾝﾂﾏｺﾞｲﾑﾗ","ﾎｼﾏﾀ(ｱｶﾞﾂﾏｺｳｻﾞﾝ､ﾏﾝｻﾞｵﾝｾﾝ)","群馬県","吾妻郡嬬恋村","干俣（吾妻鉱山、万座温泉）",1,0,0,0,0,0},
    q{10429,"37033","3703321","ｸﾞﾝﾏｹﾝ","ｱｶﾞﾂﾏｸﾞﾝﾋｶﾞｼｱｶﾞﾂﾏﾏﾁ","ｲｽﾞﾐｻﾜ(ｴﾎﾞｼ(ﾊﾙﾅｺﾊﾝ)､ｴﾎﾞｼｺｸﾕｳﾘﾝ77ﾘﾝﾊﾝ)","群馬県","吾妻郡東吾妻町","泉沢（烏帽子「榛名湖畔」、烏帽子国有林７７林班）",1,0,0,0,0,0},
    q{13104,"169  ","1690052","ﾄｳｷｮｳﾄ","ｼﾝｼﾞｭｸｸ","ﾄﾔﾏ(3ﾁｮｳﾒ18･21ﾊﾞﾝ)","東京都","新宿区","戸山（３丁目１８・２１番）",1,0,1,0,0,0},
    q{13123,"134  ","1340015","ﾄｳｷｮｳﾄ","ｴﾄﾞｶﾞﾜｸ","ﾆｼﾐｽﾞｴ(4ﾁｮｳﾒ1-2ﾊﾞﾝ･10-27ﾊﾞﾝ､5ﾁｮｳﾒ)","東京都","江戸川区","西瑞江（４丁目１〜２番・１０〜２７番、５丁目）",1,0,1,0,0,0},
    q{27142,"59001","5900105","ｵｵｻｶﾌ","ｻｶｲｼﾅｶｸ","ﾀｹｼﾛﾀﾞｲ(1ﾁｮｳ1-18･13-5-7･9)","大阪府","堺市中区","竹城台（１丁１−１８・１３−５〜７・９）",0,0,1,1,0,0}
;

run '中嶋', 'ナカジマ', '1', ['1-97〜116'], ['1-97-116'];
run '唐桑町西舞根', 'カラクワチョウニシモウネ', '1', ['200番以上'], ['200バンイジョウ'];
run '牧', 'マキ', '3', ['1〜3丁目', '白滝B・C', '高見'], ['1-3チョウメ', 'シラタキB・C', 'タカミ'];
run '東郷町山陰戊', 'トウゴウチョウヤマゲボ', '1', ['513の1以内'], ['513ノ1イナイ'];
run '岡之原町', 'オカノハラチョウ', '1', ['832の2・4'], ['832ノ2・4'];
run '高岡町上倉永', 'タカオカチョウカミクラナガ', '2', ['1206〜1268番地', '内の八重'], ['1206-1268バンチ', 'ウチノヤエ'];
run '士幌', 'シホロ', '1', ['南一区18号〜21号南'], ['ミナミイック18ゴウ-21ゴウ'];
run '上更別', 'カミサラベツ', '1', ['1区'], ['1ク'];
run '更別', 'サラベツ', '1', ['区'], ['ク'];
run '更別', 'サラベツ', '1', ['東区'], ['ヒガシク'];
run '旭', 'アサヒ', '1', ['1'], ['1'];
run '旭', 'アサヒ', '0', [], [];
run '大穂', 'オオホ', '1', ['1-1'], ['1-1'];
run '立原', 'タチハラ', '3', ['1', '2', '3'], ['1', '2', '3'];
run '高久甲', 'タカクコウ', '4', ['2888', '5256〜6140', '6328', '6437'], ['2888', '5256-6140', '6328', '6437'];
run '鎌原', 'カンバラ', '1', ['モロシコ「浅間園」'], ['モロシコ<アサマエン>'];
run '干俣', 'ホシマタ', '2', ['吾妻鉱山', '万座温泉'], ['アガツマコウザン', 'マンザオンセン'];
run '泉沢', 'イズミサワ', '2', ['烏帽子「榛名湖畔」', '烏帽子国有林77林班'], ['エボシ(ハルナコハン)', 'エボシコクユウリン77リンハン'];
run '戸山', 'トヤマ', '1', ['3丁目18・21番'], ['3チョウメ18・21バン'];
run '西瑞江', 'ニシミズエ', '2', ['4丁目1〜2番・10〜27番', '5丁目'], ['4チョウメ1-2バン・10-27バン', '5チョウメ'];
run '竹城台', 'タケシロダイ', '1', ['1丁1-18・13-5〜7・9'], ['1チョウ1-18・13-5-7・9'];



sub run {
    my @args = @_;
    my $row = $parser->fetch_obj;
    is($row->town, $args[0]);
    is($row->town_kana, $args[1]);
    if ($args[2]) {
        is(scalar(@{ $row->subtown }), $args[2]);
        for my $i (0..($args[2] - 1)){
            is($row->subtown->[$i], $args[3]->[$i]);
            is($row->subtown_kana->[$i], $args[4]->[$i]);
        }
    } else {
        is($row->subtown, undef);
    }
};

done_testing;
