# Generated by default/object.tt
package Paws::LocationService::DevicePosition;
  use Moose;
  has DeviceId => (is => 'ro', isa => 'Str');
  has Position => (is => 'ro', isa => 'ArrayRef[Num]', required => 1);
  has ReceivedTime => (is => 'ro', isa => 'Str', required => 1);
  has SampleTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LocationService::DevicePosition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LocationService::DevicePosition object:

  $service_obj->Method(Att1 => { DeviceId => $value, ..., SampleTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LocationService::DevicePosition object:

  $result = $service_obj->Method(...);
  $result->Att1->DeviceId

=head1 DESCRIPTION

Contains the device position details.

=head1 ATTRIBUTES


=head2 DeviceId => Str

The device whose position you retrieved.


=head2 B<REQUIRED> Position => ArrayRef[Num]

The last known device position.


=head2 B<REQUIRED> ReceivedTime => Str

The timestamp for when the tracker resource received the device
position in ISO 8601
(https://www.iso.org/iso-8601-date-and-time-format.html) format:
C<YYYY-MM-DDThh:mm:ss.sssZ>.


=head2 B<REQUIRED> SampleTime => Str

The timestamp at which the device's position was determined. Uses ISO
8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
C<YYYY-MM-DDThh:mm:ss.sssZ>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LocationService>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

