# Generated by default/object.tt
package Paws::SecurityHub::Severity;
  use Moose;
  has Label => (is => 'ro', isa => 'Str');
  has Normalized => (is => 'ro', isa => 'Int');
  has Original => (is => 'ro', isa => 'Str');
  has Product => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::Severity

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::Severity object:

  $service_obj->Method(Att1 => { Label => $value, ..., Product => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::Severity object:

  $result = $service_obj->Method(...);
  $result->Att1->Label

=head1 DESCRIPTION

The severity of the finding.

The finding provider can provide the initial severity. The finding
provider can only update the severity if it has not been updated using
C<BatchUpdateFindings>.

The finding must have either C<Label> or C<Normalized> populated. If
only one of these attributes is populated, then Security Hub
automatically populates the other one. If neither attribute is
populated, then the finding is invalid. C<Label> is the preferred
attribute.

=head1 ATTRIBUTES


=head2 Label => Str

The severity value of the finding. The allowed values are the
following.

=over

=item *

C<INFORMATIONAL> - No issue was found.

=item *

C<LOW> - The issue does not require action on its own.

=item *

C<MEDIUM> - The issue must be addressed but not urgently.

=item *

C<HIGH> - The issue must be addressed as a priority.

=item *

C<CRITICAL> - The issue must be remediated immediately to avoid it
escalating.

=back

If you provide C<Normalized> and do not provide C<Label>, then C<Label>
is set automatically as follows.

=over

=item *

0 - C<INFORMATIONAL>

=item *

1E<ndash>39 - C<LOW>

=item *

40E<ndash>69 - C<MEDIUM>

=item *

70E<ndash>89 - C<HIGH>

=item *

90E<ndash>100 - C<CRITICAL>

=back



=head2 Normalized => Int

Deprecated. The normalized severity of a finding. This attribute is
being deprecated. Instead of providing C<Normalized>, provide C<Label>.

If you provide C<Label> and do not provide C<Normalized>, then
C<Normalized> is set automatically as follows.

=over

=item *

C<INFORMATIONAL> - 0

=item *

C<LOW> - 1

=item *

C<MEDIUM> - 40

=item *

C<HIGH> - 70

=item *

C<CRITICAL> - 90

=back



=head2 Original => Str

The native severity from the finding product that generated the
finding.


=head2 Product => Num

Deprecated. This attribute is being deprecated. Instead of providing
C<Product>, provide C<Original>.

The native severity as defined by the AWS service or integrated partner
product that generated the finding.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

