# Generated by default/object.tt
package Paws::Kendra::SalesforceKnowledgeArticleConfiguration;
  use Moose;
  has CustomKnowledgeArticleTypeConfigurations => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::SalesforceCustomKnowledgeArticleTypeConfiguration]');
  has IncludedStates => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has StandardKnowledgeArticleTypeConfiguration => (is => 'ro', isa => 'Paws::Kendra::SalesforceStandardKnowledgeArticleTypeConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::SalesforceKnowledgeArticleConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::SalesforceKnowledgeArticleConfiguration object:

  $service_obj->Method(Att1 => { CustomKnowledgeArticleTypeConfigurations => $value, ..., StandardKnowledgeArticleTypeConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::SalesforceKnowledgeArticleConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomKnowledgeArticleTypeConfigurations

=head1 DESCRIPTION

Specifies configuration information for the knowledge article types
that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
articles and the standard fields of knowledge articles, or the custom
fields of custom knowledge articles, but not both

=head1 ATTRIBUTES


=head2 CustomKnowledgeArticleTypeConfigurations => ArrayRef[L<Paws::Kendra::SalesforceCustomKnowledgeArticleTypeConfiguration>]

Provides configuration information for custom Salesforce knowledge
articles.


=head2 B<REQUIRED> IncludedStates => ArrayRef[Str|Undef]

Specifies the document states that should be included when Amazon
Kendra indexes knowledge articles. You must specify at least one state.


=head2 StandardKnowledgeArticleTypeConfiguration => L<Paws::Kendra::SalesforceStandardKnowledgeArticleTypeConfiguration>

Provides configuration information for standard Salesforce knowledge
articles.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

