package SVG::Rasterize::Specification::FilterPrimitive;
use strict;
use warnings;

use Params::Validate qw(:types);

use SVG::Rasterize::Regexes qw(:attributes);

# $Id: FilterPrimitive.pm 6484 2011-04-21 09:25:12Z powergnom $

=head1 NAME

C<SVG::Rasterize::Specification::FilterPrimitive> - specification for class FilterPrimitive

=head1 VERSION

Version 0.003005

=cut

our $VERSION = '0.003005';

our %CHILDREN = ('feBlend'             => {'animate'          => 1,
                                           'set'              => 1},
                 'feColorMatrix'       => {'animate'          => 1,
                                           'set'              => 1},
                 'feComponentTransfer' => {'feFuncA'          => 1,
                                           'feFuncB'          => 1,
                                           'feFuncG'          => 1,
                                           'feFuncR'          => 1},
                 'feComposite'         => {'animate'          => 1,
                                           'set'              => 1},
                 'feConvolveMatrix'    => {'animate'          => 1,
                                           'set'              => 1},
                 'feDiffuseLighting'   => {'animate'          => 1,
                                           'animateColor'     => 1,
                                           'feDistantLight'   => 1,
                                           'fePointLight'     => 1,
                                           'feSpotLight'      => 1,
                                           'set'              => 1},
                 'feDisplacementMap'   => {'animate'          => 1,
                                           'set'              => 1},
                 'feFlood'             => {'animate'          => 1,
                                           'animateColor'     => 1,
                                           'set'              => 1},
                 'feGaussianBlur'      => {'animate'          => 1,
                                           'set'              => 1},
                 'feImage'             => {'animate'          => 1,
                                           'animateTransform' => 1,
                                           'set'              => 1},
                 'feMerge'             => {'feMergeNode'      => 1},
                 'feMorphology'        => {'animate'          => 1,
                                           'set'              => 1},
                 'feOffset'            => {'animate'          => 1,
                                           'set'              => 1},
                 'feSpecularLighting'  => {'animate'          => 1,
                                           'animateColor'     => 1,
                                           'feDistantLight'   => 1,
                                           'fePointLight'     => 1,
                                           'feSpotLight'      => 1,
                                           'set'              => 1},
                 'feTile'              => {'animate'          => 1,
                                           'set'              => 1},
                 'feTurbulence'        => {'animate'          => 1,
                                           'set'              => 1});

our %ATTR_VAL = ('feBlend'             => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'in2'                          => {'optional' => 0,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'mode'                         => {'default'  => 'normal',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:normal|multiply|screen|darken|lighten)$/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feColorMatrix'       => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'type'                         => {'default'  => 'matrix',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:matrix|saturate|hueRotate|luminanceToAlpha)$/},
                                           'values'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feComponentTransfer' => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feComposite'         => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'in2'                          => {'optional' => 0,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'k1'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'k2'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'k3'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'k4'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'operator'                     => {'default'  => 'over',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:over|in|out|atop|xor|arithmetic)$/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feConvolveMatrix'    => {'bias'                         => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'divisor'                      => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'edgeMode'                     => {'default'  => 'duplicate',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:duplicate|wrap|none)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'kernelMatrix'                 => {'optional' => 0,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'kernelUnitLength'             => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'order'                        => {'optional' => 0,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'preserveAlpha'                => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:false|true)$/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'targetX'                      => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'targetY'                      => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feDiffuseLighting'   => {'class'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'color'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_PAINT{p_COLOR}},
                                           'color-interpolation'          => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-rendering'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                           'diffuseConstant'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'kernelUnitLength'             => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'lighting-color'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'style'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'surfaceScale'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feDisplacementMap'   => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'in2'                          => {'optional' => 0,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'scale'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xChannelSelector'             => {'default'  => 'A',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:R|G|B|A)$/},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'yChannelSelector'             => {'default'  => 'A',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:R|G|B|A)$/}},
                 'feFlood'             => {'class'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'color'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_PAINT{p_COLOR}},
                                           'color-interpolation'          => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-rendering'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                           'flood-color'                  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'flood-opacity'                => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'style'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feGaussianBlur'      => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'stdDeviation'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feImage'             => {'alignment-baseline'           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|baseline|before\-edge|text\-before\-edge|middle|central|after\-edge|text\-after\-edge|ideographic|alphabetic|hanging|mathematical|inherit)$/},
                                           'baseline-shift'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'class'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'clip'                         => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'clip-path'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'clip-rule'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                           'color'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_PAINT{p_COLOR}},
                                           'color-interpolation'          => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-profile'                => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'color-rendering'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                           'cursor'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'direction'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:ltr|rtl|inherit)$/},
                                           'display'                      => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:inline|block|list\-item|run\-in|compact|marker|table|inline\-table|table\-row\-group|table\-header\-group|table\-footer\-group|table\-row|table\-column\-group|table\-column|table\-cell|table\-caption|none|inherit)$/},
                                           'dominant-baseline'            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|use\-script|no\-change|reset\-size|ideographic|alphabetic|hanging|mathematical|central|middle|text\-after\-edge|text\-before\-edge|inherit)$/},
                                           'enable-background'            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'externalResourcesRequired'    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:false|true)$/},
                                           'fill'                         => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_PAINT{p_PAINT}},
                                           'fill-opacity'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                           'fill-rule'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:nonzero|evenodd|inherit)$/},
                                           'filter'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'flood-color'                  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'flood-opacity'                => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                           'font-family'                  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'font-size'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'font-size-adjust'             => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'font-stretch'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:normal|wider|narrower|ultra\-condensed|extra\-condensed|condensed|semi\-condensed|semi\-expanded|expanded|extra\-expanded|ultra\-expanded|inherit)$/},
                                           'font-style'                   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:normal|italic|oblique|inherit)$/},
                                           'font-variant'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:normal|small\-caps|inherit)$/},
                                           'font-weight'                  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit)$/},
                                           'glyph-orientation-horizontal' => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'glyph-orientation-vertical'   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'image-rendering'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                           'kerning'                      => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'letter-spacing'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'lighting-color'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'marker-end'                   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'marker-mid'                   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'marker-start'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'mask'                         => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'opacity'                      => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                           'overflow'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:visible|hidden|scroll|auto|inherit)$/},
                                           'pointer-events'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:visiblePainted|visibleFill|visibleStroke|visible|painted|fill|stroke|all|none|inherit)$/},
                                           'preserveAspectRatio'          => {'default'  => 'xMidYMid meet',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_VIEW_BOX{p_PAR}},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'shape-rendering'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|optimizeSpeed|crispEdges|geometricPrecision|inherit)$/},
                                           'stop-color'                   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'stop-opacity'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                           'stroke'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_PAINT{p_PAINT}},
                                           'stroke-dasharray'             => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_DASHARRAY{p_DASHARRAY}|^inherit$|^none$/},
                                           'stroke-dashoffset'            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                           'stroke-linecap'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:butt|round|square|inherit)$/},
                                           'stroke-linejoin'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:miter|round|bevel|inherit)$/},
                                           'stroke-miterlimit'            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_NUMBER{p_A_NNNUMBER}|^inherit$/},
                                           'stroke-opacity'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_NUMBER{p_A_NUMBER}|^inherit$/},
                                           'stroke-width'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/$RE_LENGTH{p_A_LENGTH}|^inherit$/},
                                           'style'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'text-anchor'                  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:start|middle|end|inherit)$/},
                                           'text-decoration'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'text-rendering'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|optimizeSpeed|optimizeLegibility|geometricPrecision|inherit)$/},
                                           'unicode-bidi'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:normal|embed|bidi\-override|inherit)$/},
                                           'visibility'                   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:visible|hidden|inherit)$/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'word-spacing'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'writing-mode'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:lr\-tb|rl\-tb|tb\-rl|lr|rl|tb|inherit)$/},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xlink:actuate'                => {'default'  => 'onLoad',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:onLoad)$/},
                                           'xlink:arcrole'                => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xlink:href'                   => {'optional' => 0,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xlink:role'                   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xlink:show'                   => {'default'  => 'embed',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:embed)$/},
                                           'xlink:title'                  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xlink:type'                   => {'default'  => 'simple',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:simple)$/},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'xmlns:xlink'                  => {'default'  => 'http://www.w3.org/1999/xlink',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feMerge'             => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feMorphology'        => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'operator'                     => {'default'  => 'erode',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:erode|dilate)$/},
                                           'radius'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feOffset'            => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'dx'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'dy'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feSpecularLighting'  => {'class'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'color'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_PAINT{p_COLOR}},
                                           'color-interpolation'          => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'color-rendering'              => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|optimizeSpeed|optimizeQuality|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'kernelUnitLength'             => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'lighting-color'               => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'specularConstant'             => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'specularExponent'             => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'style'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'surfaceScale'                 => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feTile'              => {'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'in'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}},
                 'feTurbulence'        => {'baseFrequency'                => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'color-interpolation-filters'  => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:auto|sRGB|linearRGB|inherit)$/},
                                           'height'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'id'                           => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NAME}},
                                           'numOctaves'                   => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'result'                       => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'seed'                         => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_NUMBER{p_A_NUMBER}},
                                           'stitchTiles'                  => {'default'  => 'noStitch',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:stitch|noStitch)$/},
                                           'type'                         => {'default'  => 'turbulence',
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:fractalNoise|turbulence)$/},
                                           'width'                        => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'x'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}},
                                           'xml:base'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/.?/},
                                           'xml:lang'                     => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_XML{p_NMTOKEN}},
                                           'xml:space'                    => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => qr/^(?:default|preserve)$/},
                                           'y'                            => {'optional' => 1,
                                                                              'type'     => SCALAR,
                                                                              'regex'    => $RE_LENGTH{p_A_LENGTH}}});

our %ATTR_HINTS = ('feBlend'             => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feColorMatrix'       => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feComponentTransfer' => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feComposite'         => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feConvolveMatrix'    => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feDiffuseLighting'   => {'color'        => {'color'  => 1},
                                             'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feDisplacementMap'   => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feFlood'             => {'color'        => {'color'  => 1},
                                             'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feGaussianBlur'      => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feImage'             => {'color'        => {'color'  => 1},
                                             'fill'         => {'color'  => 1},
                                             'height'       => {'length' => 1},
                                             'stroke'       => {'color'  => 1},
                                             'stroke-width' => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feMerge'             => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feMorphology'        => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feOffset'            => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feSpecularLighting'  => {'color'        => {'color'  => 1},
                                             'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feTile'              => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}},
                   'feTurbulence'        => {'height'       => {'length' => 1},
                                             'width'        => {'length' => 1},
                                             'x'            => {'length' => 1},
                                             'y'            => {'length' => 1}});

1;


__END__

=pod

=head1 DESCRIPTION

This file was automatically generated using the SVG DTD available
under
L<http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-flat-20030114.dtd>.

See L<SVG::Rasterize::Specification|SVG::Rasterize::Specification>
for more details.


=head1 AUTHOR

Lutz Gehlen, C<< <perl at lutzgehlen.de> >>


=head1 LICENSE AND COPYRIGHT

Copyright 2010-2011 Lutz Gehlen.

This program is free software; you can redistribute it and/or modify
it under the terms of either: the GNU General Public License as
published by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut
