#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

10 СНЕЖНЯ 1948 ГОДА Генеральная Асамблея Арганiзацыi Аб’яднаных Нацый зацвердзiла i абвясцiла Усеагульную дэкларацыю правоў чалавека, поўны тэкст якой прыведзены на гэтых старонках. Прыняўшы гэта рашэнне гiстарычнага значэння, Асамблея звярнулася з заклiкам да ўсiх дзяржаў-членаў Арганiзацыi абнародаваць тэкст Дэкларацыi i зрабiць усё магчымае для «яе распаўсюджвання, абвяшчэння i растлумачэння, галоўным чынам у школах i iншых навучальных установах, без адрознення, якое заснавана на палiтычным статусе краiн або тэрыторый».

УСЕАГУЛЬНАЯ ДЭКЛАРАЦЫЯ ПРАВОЎ ЧАЛАВЕКА
ПРЭАМБУЛА
Прымаючы пад увагу, што прызнанне годнасцi, якая ўласцiва ўсiм членам чалавечай сям’i, i роўных i неад’емных правоў iх з’яўляецца асновай свабоды, справядлiвасцi i ўсеагульнага мiру; i

прымаючы пад увагу, што грэбаванне i пагарда да правоў чалавека прывялi да варварскiх актаў, якiя абураюць сумленне чалавецтва, i што стварэнне такога свету, у якiм людзi будуць мець свабоду слова i перакананняў i будуць свабодныя ад страху i галечы, абвешчана як высокае iмкненне людзей; i

прымаючы пад увагу, што неабходна, каб правы чалавека ахоўвалiся ўладай закону з мэтай забеспячэння таго, каб чалавек не быў вымушаны ўжываць, у якасцi апошняга сродку, паўстання супроць тыранii i прыгнечання; i

прымаючы пад увагу, што неабходна садзейнiчаць развiццю дружалюбных адносiн памiж народамi; i

прымаючы пад увагу, што народы Аб’яднаных Нацый пацвердзiлi ў Статуце сваю веру ў асноўныя правы чалавека, у годнасць i каштоўнасць чалавечай асобы i ў раўнапраўе мужчын i жанчын i вырашылi садзейнiчаць сацыяльнаму прагрэсу i паляпшэнню ўмоў жыцця пры большай свабодзе; i

прымаючы пад увагу, што дзяржавы-члены абавязалiся садзейнiчаць, у супрацоўнiцтве з Арганiзацыяй Аб’яднаных Нацый, усеагульнай павазе i захаванню правоў чалавека i асноўных свабод; i

прымаючы пад увагу, што ўсеагульнае разуменне характару гэтых правоў i свабод мае велiзарнае значэнне для поўнага выканання гэтага абавязацельства:

ГЕНЕРАЛЬНАЯ АСАМБЛЕЯ

абвяшчае

гэту Усеагульную дэкларацыю правоў чалавека ў якасцi задачы, да выканання якой павiнны iмкнуцца ўсе народы i ўсе дзяржавы з тым, каб кожны чалавек i кожны орган грамадства, увесь час маючы на ўвазе гэту Дэкларацыю, iмкнулiся шляхам асветы i адукацыi садзейнiчаць павазе гэтых правоў i свабод i забеспячэнню, шляхам нацыянальных i мiжнародных прагрэсiўных мерапрыемстваў, усеагульнага i эфектыўнага прызнання i ажыццяўлення iх як сярод народаў дзяржаў-членаў Арганiзацыi, так i сярод народаў тэрыторый, што знаходзяцца пад iх юрысдыкцыяй.

Артыкул 1.
Усе людзi нараджаюцца свабоднымi i роўнымi ў сваёй годнасцi i правах. Яны надзелены розумам i сумленнем i павiнны ставiцца адзiн да аднаго ў духу брацтва.

Артыкул 2.
Кожны чалавек павiнен валодаць усiмi правамi i ўсiмi свабодамi, што абвешчаны гэтай Дэкларацыяй, без якога б там нi было адрознення, як напрыклад у адносiнах расы, колеру скуры, полу, мовы, рэлiгii, палiтычных або iншых перакананняў, нацыянальнага або сацыяльнага паходжання, маёмаснага, саслоўнага або iншага становiшча.

Апрача таго, не павiнна рабiцца нiякага адрознення на аснове палiтычнага, прававога або мiжнароднага статуса краiны або тэрыторыi, да якой чалавек належыць, незалежна ад таго, цi з’яўляецца гэта тэрыторыя незалежнай, падапечнай, несамакiравальнай, або як-небудзь iнакш абмежаванай у сваiм суверэнiтэце.

Артыкул 3.
Кожны чалавека мае права на жыццё, на свабоду i на асабiстую недатыкальнасць.

Артыкул 4.
Нiхто не павiнен утрымлiвацца ў рабстве або ў паднявольным стане; рабства i гандаль рабамi забараняюцца ва ўсiх iх выглядах.

Артыкул 5.
Нi над кiм не павiнны ўчыняцца катаваннi або жорсткiя, бесчалавечныя або ўнiжаючыя яго годнасць абыходжанне i пакаранне.

Артыкул 6.
Кожны чалавек, дзе б ён нi знаходзiўся, мае права на прызнанне яго правасуб’ектнасцi.

Артыкул 7.
Усе людзi роўныя перад законам i маюць права, без усякага адрознення, на роўную абарону закону. Усе людзi маюць права на роўную ахову ад якой бы там нi было дыскрымiнацыi, што парушае гэту Дэкларацыю, i ад якога б там нi было падбухторвання да такой дыскрымiнацыi.

Артыкул 8.
Кожны чалавек мае права на эфектыўнае аднаўленне ў правах кампетэнтнымi нацыянальнымi судамi ў выпадках парушэння яго асноўных правоў, якiя дадзены яму канстытуцыяй або законам.

Артыкул 9.
Нi над кiм не павiнны ўчыняцца самавольны арышт, затрыманне або выгнанне.

Артыкул 10.
Кожны чалавек, для вызначэння яго правоў i абавязкаў i для ўстанаўлення абгрунтаванасцi прад’яўленага яму крымiнальнага абвiнавачання, мае права, на падставе поўнай роўнасцi, на тое, каб яго справа была разгледжана публiчна i з захаваннем усiх патрабаванняў справядлiвасцi незалежным i непрадузятым судом.

Артыкул 11.
Кожны чалавек, якi абвiнавачваецца ў злачынстве, мае права лiчыцца невiнаватым да таго часу, пакуль яго вiнаватасць не будзе ўстаноўлена законным парадкам шляхам публiчнага судовага разбору, пры якiм яму забяспечваюцца ўсе магчымасцi для абароны.
Нiхто не можа быць асуджаны за злачынства на падставе ўчынення якога-небудзь дзеяння або за бяздзеянне, якiя ў час iх учынення не з’яўлялiся злачынствам па нацыянальных законах або па мiжнароднаму праву. Не можа таксама накладацца пакаранне больш цяжкае, чым тое, якое магло быць ужыта ў той час, калi злачынства было зроблена.
Артыкул 12.
Нi над кiм не павiнны ўчыняцца самавольнае ўмяшанне ў яго асабiстае i сямейнае жыццё, самавольны замах на недатыкальнасць яго жылля, тайну яго карэспандэнцыi або на яго гонар i рэпутацыю. Кожны чалавек мае права на абарону закону ад такога ўмяшання або такiх замахаў.

Артыкул 13.
Кожны чалавек мае права свабодна перамяшчацца i выбiраць сабе месцапражыванне ў межах кожнай дзяржавы.
Кожны чалавек мае права пакiдаць любую краiну, уключаючы сваю ўласную, i вяртацца ў сваю краiну.
Артыкул 14.
Кожны чалавек мае права шукаць прыстанiшча ад праследавання ў iншых краiнах i карыстацца гэтым прыстанiшчам.
Гэта права не можа быць выкарыстана ў выпадку праследавання, сапраўды заснаванага на ўчыненнi непалiтычнага злачынства, або дзеяння, што супярэчыць мэтам i прынцыпам Арганiзацыi Аб’яднаных Нацый.
Артыкул 15.
Кожны чалавек мае права на грамадзянства.
Нiхто не можа быць самавольна пазбаўлены свайго грамадзянства або права змянiць сваё грамадзянства.
Артыкул 16.
Мужчыны i жанчыны, якiя дасягнулi паўналецця, маюць права без усякiх абмежаванняў, незалежна ад расы, нацыянальнасцi або рэлiгii, браць шлюб i засноўваць сям’ю. Яны карыстаюцца аднолькавымi правамi ў адносiнах узяцця шлюбу, у час знаходжання ў шлюбе i ў час яго скасавання.
Шлюб можа быць заключаны толькi пры свабоднай i поўнай згодзе абодвух бакоў, што бяруць шлюб.
Сям’я з’яўляецца натуральнай i асноўнай ячэйкай грамадства i мае права на абарону з боку грамадства i дзяржавы.
Артыкул 17.
Кожны чалавек мае права валодаць маёмасцю як аднаасобна, так i сумесна з iншымi.
Нiхто не павiнен быць самавольна пазбаўлены сваёй маёмасцi.
Артыкул 18.
Кожны чалавек мае права на свабоду думкi, сумлення i рэлiгii; гэта права ўключае свабоду мяняць сваю рэлiгiю або пераканнi i свабоду спавядаць сваю рэлiгiю або перакананнi як аднаасобна, так i разам з iншымi, публiчным або прыватным парадкам у вучэннi, богаслужэннi i выкананнi рэлiгiйных i рытуальных абрадаў.

Артыкул 19.
Кожны чалавек мае права на свабоду перакананняў i на свабоднае выражэнне iх; гэта права ўключае свабоду бесперашкодна прытрымлiвацца сваiх перакананняў i свабоду шукаць, атрымлiваць i распаўсюджваць iнфармацыю i iдэi любымi сродкамi i незалежна ад дзяржаўных гранiц.

Артыкул 20.
Кожны чалавек мае права на свабоду мiрных сходаў i асацыяцый.
Нiхто не павiнен прымушацца ўступаць у якую-небудзь асацыяцыю.
Артыкул 21.
Кожны чалавек мае права прымаць удзел у кiраваннi сваёй краiнай непасрэдна або пры дапамозе свабодна выбраных прадстаўнiкоў.
Кожны чалавек мае права роўнага доступу да дзяржаўнай службы ў сваёй краiне.
Воля народа павiнна быць асновай улады ўрада; гэта воля павiнна знаходзiць сабе выяўленне ў перыядычных i нефальсiфiкаваных выбарах, якiя павiнны праводзiцца пры ўсеагульным i роўным выбарчым праве, шляхам тайнага галасавання або пры дапамозе iншых раўназначных форм, што забяспечваюць свабоду галасавання.
Артыкул 22.
Кожны чалавек, як член грамадства, мае права на сацыяльнае забеспячэнне i на ажыццяўленне неабходных для падтрымання яго годнасцi i для свабоднага развiцця яго асобы правоў у эканамiчнай, сацыяльнай i культурнай галiнах пры дапамозе нацыянальных намаганняў i мiжнароднага супрацоўнiцтва i ў адпаведнасцi са структурай i рэсурсамi кожнай дзяржавы.

Артыкул 23.
Кожны чалавек мае права на працу, на свабодны выбар работы, на справядлiвыя i добрыя ўмовы працы i на ахову ад беспрацоўя.
Кожны чалавек, без якой-небудзь дыскрымiнацыi, мае права на роўную аплату за роўную працу.
Кожны, хто працуе, мае права на справядлiвую i здавальняючую ўзнагароду, якая забяспечвае вартае чалавека iснаванне для яго самога i яго сям’i, i дапаўняецца, пры неабходнасцi, iншымi сродкамi сацыяльнага забеспячэння.
Кожны чалавек мае права ствараць прафесiянальныя саюзы i ўступаць у прафесiянальные саюзы для аховы сваiх iнтарэсаў.
Артыкул 24.
Кожны чалавек мае права на адпачынак i вольны час, уключаючы права на разумнае абмежаванне рабочага дня i на перыядычны водпуск, якi аплачваецца.

Артыкул 25.
Кожны чалавек мае права на такi жыццёвы ўзровень, уключаючы харч, адзенне, жыллё, медыцынскi догляд i неабходнае сацыяльнае абслугоўванне, якi неабходны для падтрымання здароўя i дабрабыту яго самога i яго сям’i, i права на забеспячэнне на выпадак беспрацоўя, хваробы, iнвалiднасцi, удоўства, надыходу старасцi або iншага выпадку страты сродкаў да iснавання па незалежачых ад яго акалiчнасцях.
Мацярынства i дзяцiнства даюць права на асобую апеку i дапамогу. Усе дзецi, якiя нарадiлiся ў шлюбе або па-за шлюбам, павiнны карыстацца аднолькавай сацыяльнай абаронай.
Артыкул 26.
Кожны чалавек мае права на адукацыю. Адукацыя павiнна быць бясплатнай па меншай меры ў тым, што датычыць пачатковай i агульнай адукацыi. Пачатковая адукацыя павiнна быць абавязковай. Тэхнiчная i прафесiянальная адукацыя павiнна быць агульнадаступнай i вышэйшая адукацыя павiнна быць аднолькава даступнай для ўсiх на падставе здольнасцей кожнага.
Адукацыя павiнна быць накiравана да поўнага развiцця чалавечай асобы i да павелiчэння павагi да правоў чалавека i асноўных свабод. Адукацыя павiнна садзейнiчаць узаемаразуменню, цярпiмасцi i дружбе памiж усiмi народамi, расавымi або рэлiгiйнымi групамi, i павiнна садзейнiчаць дзейнасцi Арганiзацыi Аб’яднаных Нацый па падтрыманню мiру.
Бацькi маюць права прыярытэту ў выбары вiду адукацыi для сваiх малалетнiх дзяцей.
Артыкул 27.
Кожны чалавек мае права свабодна ўдзельнiчаць у культурным жыццi грамадства, цешыцца мастацтвам, удзельнiчаць у навуковым прагрэсе i карыстацца яго дабротамi.
Кожны чалавек мае права на ахову яго маральных i матэрыяльных iнтарэсаў, што з’яўляюцца вынiкам навуковых, лiтаратурных або мастацкiх прац, аўтарам якiх ён з’яўляецца.
Артыкул 28.
Кожны чалавек мае права на сацыяльны i мiжнародны парадак, пры якiм правы i свабоды, што выкладзены ў гэтай Дэкларацыi, могуць быць цалкам ажыццёўлены.

Артыкул 29.
Кожны чалавек мае абавязкi перад грамадствам, у якiм толькi i магчыма свабоднае i поўнае развiццё яго асобы.
Пры ажыццяўленнi сваiх правоў i свабод кожны чалавек павiнен спазнаць толькi такiя абмежаваннi, якiя ўстаноўлены законам выключна з мэтай забеспячэння належнага прызнання i павагi правоў i свабод другiх i задавальнення справядлiвых патрабаванняў маралi, грамадскага парадку i агульнага дабрабыту ў дэмакратычным грамадстве.
Ажыццяўленне гэтых правоў i свабод нi ў якiм разе не павiнна супярэчыць мэтам i прынцыпам Арганiзацыi Аб’яднаных Нацый.
Артыкул 30.
Нiшто ў гэтай Дэкларацыi не можа быць вытлумачана, як прадастаўленне якой-небудзь дзяржаве, групе асоб або асобным людзям права займацца якой-небудзь дзейнасцю або ўчыняць дзеяннi, накiраваныя да знiшчэння правоў i свабод, што выкладзены ў гэтай Дэкларацыi.

TEXT

is(Text::Guess::Language->guess($text),'be','is be');

done_testing;
