/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.document;

import at.ac.tuwien.dbai.pdfwrap.model.document.IXmillumSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import java.awt.Rectangle;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericSegment
implements Cloneable,
IXmillumSegment {
    protected float x1;
    protected float x2;
    protected float y1;
    protected float y2;
    boolean zeroSize = false;

    public GenericSegment() {
    }

    public GenericSegment(float x1, float x2, float y1, float y2) {
        this();
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    public GenericSegment(float[] boundingBox) {
        this();
        this.setBoundingBox(boundingBox);
    }

    public GenericSegment(PDRectangle bBox) {
        this();
        this.setBoundingBox(bBox);
    }

    public float getX1() {
        return this.x1;
    }

    public void setX1(float x1) {
        this.x1 = x1;
    }

    public float getX2() {
        return this.x2;
    }

    public void setX2(float x2) {
        this.x2 = x2;
    }

    public float getY1() {
        return this.y1;
    }

    public void setY1(float y1) {
        this.y1 = y1;
    }

    public float getY2() {
        return this.y2;
    }

    public void setY2(float y2) {
        this.y2 = y2;
    }

    public float getXmid() {
        return (this.x1 + this.x2) / 2.0f;
    }

    public float getYmid() {
        return (this.y1 + this.y2) / 2.0f;
    }

    public float getWidth() {
        return this.x2 - this.x1;
    }

    public float getHeight() {
        return this.y2 - this.y1;
    }

    public float getArea() {
        return this.getHeight() * this.getWidth();
    }

    public String toString() {
        return String.valueOf(this.tagName()) + " - " + this.getAttributes();
    }

    public String getAttributes() {
        return "x1: " + this.x1 + " x2: " + this.x2 + " Xcen: " + this.getXmid() + " y1: " + this.y1 + " y2: " + this.y2 + " Ycen: " + this.getYmid() + " hc: " + this.hashCode();
    }

    @Override
    public void setElementAttributes(Document resultDocument, Element newSegmentElement, GenericSegment pageDim, float resolution) {
        float pageHeight = pageDim.getHeight();
        newSegmentElement.setAttribute("x", Float.toString(this.getX1() * resolution / 72.0f));
        newSegmentElement.setAttribute("y", Float.toString((pageHeight - this.getY1() - this.getHeight()) * resolution / 72.0f));
        newSegmentElement.setAttribute("w", Float.toString(this.getWidth() * resolution / 72.0f));
        newSegmentElement.setAttribute("h", Float.toString(this.getHeight() * resolution / 72.0f));
    }

    public void correctNegativeDimensions() {
        float temp;
        if (this.x1 > this.x2) {
            temp = this.x1;
            this.x1 = this.x2;
            this.x2 = temp;
        }
        if (this.y1 > this.y2) {
            temp = this.y1;
            this.y1 = this.y2;
            this.y2 = temp;
        }
    }

    public void enlargeCoordinates(float amount) {
        this.x1 -= amount;
        this.x2 += amount;
        this.y1 -= amount;
        this.y2 += amount;
    }

    public void scaleCoordinates(float multiple) {
        this.x1 *= multiple;
        this.x2 *= multiple;
        this.y1 *= multiple;
        this.y2 *= multiple;
    }

    public void invertYCoordinates(GenericSegment page) {
        float pageHeight = page.getHeight();
        this.y1 = pageHeight - this.y1;
        this.y2 = pageHeight - this.y2;
    }

    public void rotate(float pointX, float pointY, int amount) {
        float px1 = this.x1 - pointX;
        float px2 = this.x2 - pointX;
        float py1 = this.y1 - pointY;
        float py2 = this.y2 - pointY;
        if (amount == 90 || amount == -270) {
            this.x1 = pointX - py2;
            this.x2 = pointX - py1;
            this.y1 = pointY + px1;
            this.y2 = pointY + px2;
        } else if (amount == 270 || amount == -90) {
            this.x1 = pointX + py1;
            this.x2 = pointX + py2;
            this.y1 = pointY - px2;
            this.y2 = pointY - px1;
        }
    }

    public void rotate(PDPage page) {
        GenericSegment mediaBox = new GenericSegment(page.getMediaBox());
        if (page.getRotation() != null) {
            this.rotate(mediaBox.getX1(), mediaBox.getY1(), page.getRotation());
            if (page.getRotation() == 90 || page.getRotation() == -270) {
                this.x1 += mediaBox.getHeight();
                this.x2 += mediaBox.getHeight();
            } else if (page.getRotation() == 270 || page.getRotation() == -90) {
                this.y1 += mediaBox.getWidth();
                this.y2 += mediaBox.getWidth();
            }
        }
    }

    public void growBoundingBox(GenericSegment thisSegment) {
        if (thisSegment.getX1() < this.x1) {
            this.x1 = thisSegment.getX1();
        }
        if (thisSegment.getY1() < this.y1) {
            this.y1 = thisSegment.getY1();
        }
        if (thisSegment.getX2() > this.x2) {
            this.x2 = thisSegment.getX2();
        }
        if (thisSegment.getY2() > this.y2) {
            this.y2 = thisSegment.getY2();
        }
    }

    public void shrinkBoundingBox(GenericSegment thisSegment) {
        if (SegmentUtils.intersects(this, thisSegment)) {
            if (thisSegment.getX1() > this.x1) {
                this.x1 = thisSegment.getX1();
            }
            if (thisSegment.getY1() > this.y1) {
                this.y1 = thisSegment.getY1();
            }
            if (thisSegment.getX2() < this.x2) {
                this.x2 = thisSegment.getX2();
            }
            if (thisSegment.getY2() < this.y2) {
                this.y2 = thisSegment.getY2();
            }
        } else {
            this.setZeroSize(true);
        }
    }

    public boolean isZeroSize() {
        return this.zeroSize;
    }

    public void setZeroSize(boolean zeroSize) {
        this.zeroSize = zeroSize;
    }

    public Rectangle getBoundingRectangle() {
        int x = (int)this.x1;
        int y = (int)this.y1;
        int w = (int)this.getWidth();
        int h = (int)this.getHeight();
        return new Rectangle(x, y, w, h);
    }

    public void setBoundingBox(float[] bBox) {
        this.x1 = bBox[0];
        this.x2 = bBox[1];
        this.y1 = bBox[2];
        this.y2 = bBox[3];
    }

    public void setBoundingBox(PDRectangle bBox) {
        this.x1 = bBox.getLowerLeftX();
        this.x2 = bBox.getUpperRightX();
        this.y1 = bBox.getLowerLeftY();
        this.y2 = bBox.getUpperRightY();
    }

    public float[] getBoundingBox() {
        float[] bBox = new float[]{this.x1, this.x2, this.y1, this.y2};
        return bBox;
    }

    public PDRectangle toPDRectangle() {
        PDRectangle retVal = new PDRectangle();
        retVal.setLowerLeftX(this.x1);
        retVal.setLowerLeftY(this.y1);
        retVal.setUpperRightX(this.x2);
        retVal.setUpperRightY(this.y2);
        return retVal;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String tagName() {
        String className = Utils.stripClassName(this.getClass().getName());
        StringBuffer retVal = new StringBuffer(className.length());
        boolean afterHyphen = true;
        int n = 0;
        while (n < className.length()) {
            String chr = className.substring(n, n + 1);
            if (chr.toLowerCase().equals(chr)) {
                retVal.append(chr);
                afterHyphen = false;
            } else if (!afterHyphen) {
                retVal.append("-");
                retVal.append(chr.toLowerCase());
                afterHyphen = true;
            } else {
                retVal.append(chr.toLowerCase());
                afterHyphen = true;
            }
            ++n;
        }
        return retVal.toString();
    }

    @Override
    public void addAsXmillum(Document resultDocument, Element parent, GenericSegment pageDim, float resolution) {
        Element newSegmentElement = resultDocument.createElement(this.tagName());
        this.setElementAttributes(resultDocument, newSegmentElement, pageDim, resolution);
        parent.appendChild(newSegmentElement);
    }
}

