#!/usr/bin/perl

package eBay::API::XML::Call::ValidateChallengeInput::ValidateChallengeInputRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ValidateChallengeInputRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::ValidateChallengeInput::ValidateChallengeInputRequestType

=head1 DESCRIPTION

Validates the user response to a GetChallengeToken botblock challenge.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::ValidateChallengeInput::ValidateChallengeInputRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'ChallengeToken', 'xs:string', '', '', '' ]
	, [ 'KeepTokenValid', 'xs:boolean', '', '', '' ]
	, [ 'UserInput', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setChallengeToken()

Botblock token that was returned by GetChallengeToken.

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setChallengeToken {
  my $self = shift;
  $self->{'ChallengeToken'} = shift
}

=head2 getChallengeToken()

#    Returns: 'xs:string'

=cut

sub getChallengeToken {
  my $self = shift;
  return $self->{'ChallengeToken'};
}


=head2 setKeepTokenValid()

Whether the challenge token should remain valid for up to two minutes.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setKeepTokenValid {
  my $self = shift;
  $self->{'KeepTokenValid'} = shift
}

=head2 isKeepTokenValid()

#    Returns: 'xs:boolean'

=cut

sub isKeepTokenValid {
  my $self = shift;
  return $self->{'KeepTokenValid'};
}


=head2 setUserInput()

User response to a botblock challenge.

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setUserInput {
  my $self = shift;
  $self->{'UserInput'} = shift
}

=head2 getUserInput()

#    Returns: 'xs:string'

=cut

sub getUserInput {
  my $self = shift;
  return $self->{'UserInput'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
