/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassConfiguration {
    private Map<String, PropertyInfo> propertyMap_ = new HashMap<String, PropertyInfo>();
    private Map<String, Method> functionMap_ = new HashMap<String, Method>();
    private List<String> constants_ = new ArrayList<String>();
    private String extendedClassName_;
    private final Class<? extends SimpleScriptable> hostClass_;
    private Method jsConstructor_;
    private final Class<?>[] domClasses_;
    private final boolean jsObject_;

    public ClassConfiguration(Class<? extends SimpleScriptable> hostClass, Class<?>[] domClasses, boolean jsObject) {
        Class<? extends SimpleScriptable> superClass = hostClass.getSuperclass();
        this.extendedClassName_ = superClass != SimpleScriptable.class ? superClass.getSimpleName() : "";
        this.hostClass_ = hostClass;
        this.jsObject_ = jsObject;
        this.domClasses_ = domClasses;
    }

    void setJSConstructor(Method jsConstructor) {
        if (this.jsConstructor_ != null) {
            throw new IllegalStateException("Can not have two constructors.");
        }
        this.jsConstructor_ = jsConstructor;
    }

    public void addProperty(String name, Method getter, Method setter) {
        PropertyInfo info = new PropertyInfo(getter, setter);
        this.propertyMap_.put(name, info);
    }

    public void addConstant(String name) {
        this.constants_.add(name);
    }

    public Set<Map.Entry<String, PropertyInfo>> propertyEntries() {
        return this.propertyMap_.entrySet();
    }

    public Set<Map.Entry<String, Method>> functionEntries() {
        return this.functionMap_.entrySet();
    }

    public Set<String> functionKeys() {
        return this.functionMap_.keySet();
    }

    public List<String> constants() {
        return this.constants_;
    }

    public void addFunction(Method method) {
        this.functionMap_.put(method.getName(), method);
    }

    public String getExtendedClassName() {
        return this.extendedClassName_;
    }

    public Class<? extends SimpleScriptable> getHostClass() {
        return this.hostClass_;
    }

    public Method getJsConstructor() {
        return this.jsConstructor_;
    }

    public Class<?>[] getDomClasses() {
        return this.domClasses_;
    }

    public boolean isJsObject() {
        return this.jsObject_;
    }

    public static class PropertyInfo {
        private Method readMethod_;
        private Method writeMethod_;

        public PropertyInfo(Method readMethod, Method writeMethod) {
            this.readMethod_ = readMethod;
            this.writeMethod_ = writeMethod;
        }

        public Method getReadMethod() {
            return this.readMethod_;
        }

        public Method getWriteMethod() {
            return this.writeMethod_;
        }
    }
}

