/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SubqueryList;

public abstract class ValueNode
extends QueryTreeNode {
    public static final int IN_UNKNOWN_CLAUSE = 0;
    public static final int IN_SELECT_LIST = 1;
    public static final int IN_WHERE_CLAUSE = 2;
    public static final int IN_HAVING_CLAUSE = 3;
    protected DataTypeDescriptor dataTypeServices;
    private TypeId typeId;
    private TypeCompiler typeCompiler;
    protected int clause = 0;
    boolean transformed;

    public ValueNode() {
    }

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        this.setType(new DataTypeDescriptor((TypeId)object, (int)((Integer)object2), (int)((Integer)object3), (boolean)((Boolean)object4), (int)((Integer)object5)));
    }

    ValueNode(Object object, Object object2, Object object3, Object object4) throws StandardException {
        this.setType(new DataTypeDescriptor((TypeId)object2, (boolean)((Boolean)object3), (int)((Integer)object4)));
    }

    public String toString() {
        return "";
    }

    public DataTypeDescriptor getTypeServices() {
        return this.dataTypeServices;
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    protected final DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    public TypeCompiler getTypeCompiler() {
        if (this.typeCompiler == null) {
            this.typeCompiler = this.getTypeCompiler(this.getTypeId());
        }
        return this.typeCompiler;
    }

    public void setType(DataTypeDescriptor dataTypeDescriptor) {
        this.dataTypeServices = dataTypeDescriptor;
        this.typeId = dataTypeDescriptor == null ? null : dataTypeDescriptor.getTypeId();
        this.typeCompiler = null;
    }

    public void setDescriptor(DataTypeDescriptor dataTypeDescriptor) {
        this.setType(dataTypeDescriptor);
    }

    public ResultColumn getSourceResultColumn() {
        return null;
    }

    public int getClause() {
        return this.clause;
    }

    public void setClause(int n) {
        this.clause = n;
    }

    void setTransformed() {
        this.transformed = true;
    }

    boolean getTransformed() {
        return this.transformed;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        return this.bindExpression(fromList, subqueryList, vector, false);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector, boolean bl) throws StandardException {
        return this;
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        JavaValueNode javaValueNode = (JavaValueNode)this.getNodeFactory().getNode(28, this, this.getContextManager());
        ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(36, javaValueNode, this.getContextManager());
        valueNode.setType(DataTypeDescriptor.getSQLDataTypeDescriptor(javaValueNode.getJavaTypeName()));
        return valueNode;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        return this;
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (!bl) {
            return this;
        }
        return this.genEqualsFalseTree();
    }

    public ValueNode genEqualsFalseTree() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        BooleanConstantNode booleanConstantNode = (BooleanConstantNode)nodeFactory.getNode(38, Boolean.FALSE, this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)nodeFactory.getNode(41, this, booleanConstantNode, this.getContextManager());
        boolean bl = this.dataTypeServices.isNullable();
        binaryRelationalOperatorNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl));
        return binaryRelationalOperatorNode;
    }

    public ValueNode genIsNullTree() throws StandardException {
        IsNullNode isNullNode = (IsNullNode)this.getNodeFactory().getNode(25, this, this.getContextManager());
        isNullNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
        return isNullNode;
    }

    boolean verifyEliminateNots() {
        return true;
    }

    public ValueNode putAndsOnTop() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        QueryTreeNode queryTreeNode = nodeFactory.getNode(38, Boolean.TRUE, this.getContextManager());
        AndNode andNode = (AndNode)nodeFactory.getNode(39, this, queryTreeNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    public boolean verifyPutAndsOnTop() {
        return true;
    }

    public ValueNode changeToCNF(boolean bl) throws StandardException {
        return this;
    }

    public boolean verifyChangeToCNF() {
        return true;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return true;
    }

    public String getSchemaName() throws StandardException {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public boolean updatableByCursor() {
        return false;
    }

    public String getColumnName() {
        return null;
    }

    JBitSet getTablesReferenced() throws StandardException {
        ReferencedTablesVisitor referencedTablesVisitor = new ReferencedTablesVisitor(new JBitSet(0));
        this.accept(referencedTablesVisitor);
        return referencedTablesVisitor.getTableMap();
    }

    public boolean isCloneable() {
        return false;
    }

    public ValueNode getClone() throws StandardException {
        return null;
    }

    public void copyFields(ValueNode valueNode) {
        this.dataTypeServices = valueNode.getTypeServices();
        this.typeId = valueNode.getTypeId();
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return false;
    }

    public void checkReliability(String string, int n) throws StandardException {
        if ((this.getCompilerContext().getReliability() & n) != 0) {
            this.throwReliabilityException(string);
        }
    }

    public void checkReliability(int n, String string) throws StandardException {
        if ((this.getCompilerContext().getReliability() & n) != 0) {
            String string2 = MessageService.getTextMessage(string);
            this.throwReliabilityException(string2);
        }
    }

    private void throwReliabilityException(String string) throws StandardException {
        String string2 = this.getCompilerContext().getReliability() == 1192 ? "42Y84" : "42Y39";
        throw StandardException.newException(string2, string);
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    public ValueNode checkIsBoolean() throws StandardException {
        ValueNode valueNode = this;
        TypeId typeId = valueNode.getTypeId();
        if (!typeId.systemBuiltIn()) {
            valueNode = valueNode.genSQLJavaSQLTree();
            typeId = valueNode.getTypeId();
        }
        if (!typeId.equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X19", typeId.getSQLTypeName());
        }
        return valueNode;
    }

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    protected final void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateExpression(activationClassBuilder, methodBuilder);
    }

    public void generateFilter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateExpression(expressionClassBuilder, methodBuilder);
    }

    public double selectivity(Optimizable optimizable) {
        if (this.transformed) {
            return 1.0;
        }
        return 0.5;
    }

    void checkTopPredicatesForEqualsConditions(int n, boolean[] blArray, int[] nArray, JBitSet[] jBitSetArray, boolean bl) throws StandardException {
        ValueNode valueNode = this;
        while (valueNode instanceof AndNode) {
            AndNode andNode = (AndNode)valueNode;
            if (andNode.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)andNode.getLeftOperand())).getOperator() == 1) {
                int n2;
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)andNode.getLeftOperand();
                ValueNode valueNode2 = binaryRelationalOperatorNode.getLeftOperand();
                ValueNode valueNode3 = binaryRelationalOperatorNode.getRightOperand();
                if (bl) {
                    for (n2 = 0; n2 < nArray.length && nArray[n2] != n; ++n2) {
                    }
                } else {
                    n2 = -1;
                }
                if (valueNode2 instanceof ColumnReference && ((ColumnReference)valueNode2).getTableNumber() == n) {
                    this.updateMaps(jBitSetArray, blArray, nArray, n, n2, valueNode3, valueNode2);
                } else if (valueNode3 instanceof ColumnReference && ((ColumnReference)valueNode3).getTableNumber() == n) {
                    this.updateMaps(jBitSetArray, blArray, nArray, n, n2, valueNode2, valueNode3);
                }
            }
            valueNode = ((AndNode)valueNode).getRightOperand();
        }
    }

    boolean isBooleanTrue() {
        return false;
    }

    boolean isBooleanFalse() {
        return false;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    private void updateMaps(JBitSet[] jBitSetArray, boolean[] blArray, int[] nArray, int n, int n2, ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        if (valueNode instanceof ConstantNode || valueNode.isParameterNode()) {
            this.setValueCols(jBitSetArray, blArray, ((ColumnReference)valueNode2).getColumnNumber(), n2);
        } else if (valueNode instanceof ColumnReference && ((ColumnReference)valueNode).getTableNumber() != n) {
            int n3;
            int n4 = ((ColumnReference)valueNode).getTableNumber();
            int n5 = ((ColumnReference)valueNode2).getColumnNumber();
            for (n3 = 0; n3 < nArray.length && n4 != nArray[n3]; ++n3) {
            }
            if (n3 == nArray.length) {
                this.setValueCols(jBitSetArray, blArray, n5, n2);
            } else if (jBitSetArray != null) {
                jBitSetArray[n3].set(n5);
            }
        } else {
            int n6;
            JBitSet jBitSet = valueNode.getTablesReferenced();
            int n7 = ((ColumnReference)valueNode2).getColumnNumber();
            for (n6 = 0; n6 < nArray.length && !jBitSet.get(nArray[n6]); ++n6) {
            }
            if (n6 == nArray.length) {
                this.setValueCols(jBitSetArray, blArray, n7, n2);
            } else if (jBitSetArray != null && !jBitSet.get(n)) {
                jBitSetArray[n6].set(n7);
            }
        }
    }

    private void setValueCols(JBitSet[] jBitSetArray, boolean[] blArray, int n, int n2) {
        if (blArray != null) {
            blArray[n] = true;
        }
        if (jBitSetArray != null) {
            if (n2 == -1) {
                for (int i = 0; i < jBitSetArray.length; ++i) {
                    jBitSetArray[i].set(n);
                }
            } else {
                jBitSetArray[n2].set(n);
            }
        }
    }

    public boolean isRelationalOperator() {
        return false;
    }

    public boolean isBinaryEqualsOperatorNode() {
        return false;
    }

    public boolean optimizableEqualityNode(Optimizable optimizable, int n, boolean bl) throws StandardException {
        return false;
    }

    public boolean isParameterNode() {
        return false;
    }
}

