@if not "%echo%" == "on" echo off

if "%1" == "" set BUILD=All
if "%1" == "All" set BUILD=All

if "%1" == "Debug" set BUILD=Debug
if "%1" == "Release" set BUILD=Release

setlocal

if "%1" == "Clean" goto CleanUp
if "%1" == "Help" goto Help
if "%BUILD%" == "Release" goto ReleaseBuild

:DebugBuild
cd build_win32
echo Build the NT Debug version of the db - libdb31.lib and libdb31.dll
msdev Berkeley_DB.dsw /OUT Debug.log /MAKE "db_buildall - Win32 Debug" /REBUILD
cd ..
if not exist build_win32\Debug\libdb31*dll goto DebugBuildFailed
if not exist built mkdir built
if not exist built\WINNT-full mkdir built\WINNT-full
if not exist built\WINNT-full\include mkdir built\WINNT-full\include
if not exist built\WINNT-full\lib mkdir built\WINNT-full\lib
if not exist built\WINNT-full\bin mkdir built\WINNT-full\bin
copy build_win32\Debug\libdb31* built\WINNT-full\lib
copy build_win32\Debug\db_*.exe built\WINNT-full\lib
copy build_win32\*.h built\WINNT-full\include
if "%BUILD%" == "Debug" goto Done

:ReleaseBuild
cd build_win32
echo Build the NT Release version of the db - libdb31.lib and libdb31.dll
msdev Berkeley_DB.dsw /OUT Release.log /MAKE "db_buildall - Win32 Release" /REBUILD
cd ..
if not exist build_win32\Release\libdb31*dll goto ReleaseBuildFailed
if not exist built mkdir built
if not exist built\WINNT-optimize mkdir built\WINNT-optimize
if not exist built\WINNT-optimize\include mkdir built\WINNT-optimize\include
if not exist built\WINNT-optimize\lib mkdir built\WINNT-optimize\lib
if not exist built\WINNT-optimize\bin mkdir built\WINNT-optimize\bin
copy build_win32\Release\libdb31* built\WINNT-optimize\lib
copy build_win32\Release\db_*.exe built\WINNT-optimize\bin
copy build_win32\*.h built\WINNT-optimize\include
if "%BUILD%" == "All" goto Done
if "%BUILD%" == "Release" goto Done

:CleanUp
cd build_win32
echo Clean up the NT Build
msdev Berkeley_DB.dsw /OUT Clean.log /MAKE "db_buildall - Win32 Debug" /CLEAN
msdev Berkeley_DB.dsw /OUT Clean.log /MAKE "db_buildall - Win32 Release" /CLEAN
cd ..
if exist built rm -rf built
goto Done

:DebugBuildFailed
echo ERROR: Debug Build Failed.  Log: build_win32\Debug.log
goto Done

:ReleaseBuildFailed
echo ERROR: Release Build Failed.  Log: build_win32\Release.log
goto Done

:Help
echo "builddb [ All | Debug | Release | Clean | Help ]"

:Done

endlocal
