/* getr8.c -- routines to get a r8 from raw files */
#include "he.h"

int HEgetR8(cmd)
    HE_CMD *cmd;
{
    register int i;
    int xdim = 0, ydim = 0;
    char *image, *pal = NULL;
    int compress = 0;

    if (cmd->argc < 4 || 
	(cmd->argv[1][0] == '-' && findOpt(cmd->argv[1]+1) == HE_HELP))
    {
	puts("getr8 <image> <xdim> <ydim> [-palette <palette>] [-raster|-rle|-imcomp]");
	puts("\tGet a r8 group from raw files");
	puts("\t-palette\tRaw palette file");
	puts("\t-raster\t\tNo compression (default)");
	puts("\t-rle\t\tRun-length compression");
	puts("\t-imcomp\t\tImcomp compression");
	return HE_OK;
    }
    image = cmd->argv[1];
    xdim = atoi(cmd->argv[2]);
    ydim = atoi(cmd->argv[3]);

    for (i = 4; i < cmd->argc; i++)
	if (cmd->argv[i][0] == '-')
	    switch(findOpt(cmd->argv[i]+1))
	    {
	    case HE_PALETTE:
		pal = cmd->argv[++i];
		break;
	    case HE_RASTER:
		compress = 0;
		break;
	    case HE_RLE:
		compress = HE_RLE;
		break;
	    case HE_IMCOMP:
		compress = HE_IMCOMP;
		break;
	    case HE_NOTFOUND:
		unkOpt(cmd->argv[i]);
		return HE_FAIL;
	    case HE_AMBIG:
		ambigOpt(cmd->argv[i]);
		return HE_FAIL;
	    default:
		irrOpt(cmd->argv[i]);
		return HE_FAIL;
	    }
	else
	{
	    unkArg(cmd->argv[i]);
	    return HE_FAIL;
	}

    if (!image)
    {
	fprintf(stderr,"No image file specified.\n");
	return HE_FAIL;
    }
    if (xdim == 0 || ydim == 0)
    {
	fprintf(stderr,"No dimensions specified.\n");
	return HE_FAIL;
    }
    return getR8(xdim, ydim, image, pal, compress);
}

/* end of getr8.c */
