(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Numerical Integration of Differential Equations
:[font = text; inactive; ]
This example comes from section 7.3.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
The Lorenz Attractor
:[font = text; inactive; ]
This is a system of 3 coupled equations
:[font = input; ]
alpha = 26.5;
:[font = input; ]
points = Block[{x, y, z},
RungeKutta[{-3(x-y), -x z + alpha x - y, x y - z},
	{x, y, z}, {0, 1, 0}, {20, 0.04}]];
:[font = input; endGroup; ]
Show[Graphics3D[{Line[points]}], Axes -> Automatic];
:[font = subsection; inactive; startGroup; Cclosed; ]
Forced Oscillation
:[font = text; inactive; ]
This is a perturbed harmonic oscillator. It needs to be written as a system of two first-order equations.
:[font = input; ]
alpha = 0.01;
:[font = input; ]
omega = 1.1;
:[font = input; ]
epsilon = 0.1;
:[font = input; ]
points = Block[{x1, x2},
RungeKutta[{x2, -x1 - alpha x2 + epsilon Cos[omega t]},
	{x1, x2}, {2, 0}, {t, 0, 24Pi, Pi/18}]];
:[font = input; endGroup; endGroup; ]
Show[Graphics[{Line[points]}],
	Axes -> Automatic, AspectRatio->Automatic];
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
BeginPackage["RMPackages`RungeKutta`"]
(*
:[font = input; initialization; ]
*)
RungeKutta::usage = "RungeKutta[{e1,e2,..}, {y1,y2,..}, {a1,a2,..}, {t1, dt}]
	numerically integrates the ei as functions of the yi with inital values ai.
	The integration proceeds in steps of dt from 0 to t1.
	RungeKutta[{e1,e2,..}, {y1,y2,..}, {a1,a2,..}, {t, t0, t1, dt}] integrates
	a time-dependent system from t0 to t1."
(*
:[font = input; initialization; ]
*)
Begin["`Private`"]
(*
:[font = input; initialization; ]
*)
RKStep[f_, y_, y0_, dt_] :=
	Block[{ k1, k2, k3, k4 },
		k1 = dt N[ f /. Thread[y -> y0] ];
		k2 = dt N[ f /. Thread[y -> y0 + k1/2] ];
		k3 = dt N[ f /. Thread[y -> y0 + k2/2] ];
		k4 = dt N[ f /. Thread[y -> y0 + k3] ];
		y0 + (k1 + 2 k2 + 2 k3 + k4)/6
	]
(*
:[font = input; initialization; ]
*)
RungeKutta[f_List, y_List, y0_List, {t1_, dt_}] :=
	NestList[ RKStep[f, y, #, N[dt]]&, N[y0], Round[N[t1/dt]] ] /;
		Length[f] == Length[y] == Length[y0]
(*
:[font = input; initialization; ]
*)
RungeKutta[f_List, y_List, y0_List, {t_, t0_, t1_, dt_}] :=
	Block[{res},
		res = RungeKutta[ Append[f, 1], Append[y, t], Append[y0, t0], {t1 - t0, dt} ];
		Drop[#, -1]& /@ res
	]  /;  Length[f] == Length[y] == Length[y0]
(*
:[font = input; initialization; ]
*)
End[]
(*
:[font = input; initialization; ]
*)
Protect[RungeKutta]
(*
:[font = input; initialization; endGroup; ]
*)
EndPackage[]
(*
^*)