#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULE=src/lib/perl5/COD/CIF/Data/CODNumbers.pm
#END DEPEND--------------------------------------------------------------------

IMPORT_MODULE=$(\
    echo ${INPUT_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

perl -M"${IMPORT_MODULE}" \
<<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2024-05-26 16:42:43 +0300 (Sun, 26 May 2024) $ 
#$Revision: 10064 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.11.0/tests/shtests/have_equiv_timestamps_008.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Data::CODNumbers::timestamps_are_the_same()
#* subroutine. Tests the way the subroutine handles situations when both of
#* the values are datetime timestamps and point to the same moment in time.
#**

use strict;
use warnings;

# use COD::CIF::Data::CODNumbers;

my $value_1 = '2017-01-01T22:00:00.00-03:00';
my $value_2 = '2017-01-01T23:00:00.00-02:00';

my $data_name = '_raman_measurement.datetime_initiated';
my $entry_1 = {
    'timestamp' => {
        $data_name => $value_1,
    }
};

my $entry_2 = {
    'timestamp' => {
        $data_name => $value_2,
    }
};

if ( COD::CIF::Data::CODNumbers::have_equiv_timestamps($entry_1, $entry_2, $data_name) ) {
    print "Values are treated as being the same.\n";
} else {
    print "Values are treated as being different.\n";
}

if ( COD::CIF::Data::CODNumbers::have_equiv_timestamps($entry_2, $entry_1, $data_name) ) {
    print "Values are treated as being the same.\n";
} else {
    print "Values are treated as being different.\n";
}

END_SCRIPT
