
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Shape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LocOpe_WiresOnShape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LocOpe_PntFace.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <gp_Ax1.hxx>
#include <gp_Circ.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LocOpe_GeneratedShape.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Wire.hxx>
#include <gp_Pln.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDS_Face.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <LocOpe_WiresOnShape.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Wire.hxx>
#include <TopoDS_Face.hxx>
#include <TopoDS_Compound.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>

// module includes
#include <LocOpe.hxx>
#include <LocOpe_BuildShape.hxx>
#include <LocOpe_BuildWires.hxx>
#include <LocOpe_CSIntersector.hxx>
#include <LocOpe_CurveShapeIntersector.hxx>
#include <LocOpe_DataMapIteratorOfDataMapOfShapePnt.hxx>
#include <LocOpe_DataMapOfShapePnt.hxx>
#include <LocOpe_DPrism.hxx>
#include <LocOpe_FindEdges.hxx>
#include <LocOpe_FindEdgesInFace.hxx>
#include <LocOpe_GeneratedShape.hxx>
#include <LocOpe_Generator.hxx>
#include <LocOpe_GluedShape.hxx>
#include <LocOpe_Gluer.hxx>
#include <LocOpe_LinearForm.hxx>
#include <LocOpe_Operation.hxx>
#include <LocOpe_Pipe.hxx>
#include <LocOpe_PntFace.hxx>
#include <LocOpe_Prism.hxx>
#include <LocOpe_Revol.hxx>
#include <LocOpe_RevolutionForm.hxx>
#include <LocOpe_SequenceOfCirc.hxx>
#include <LocOpe_SequenceOfLin.hxx>
#include <LocOpe_SequenceOfPntFace.hxx>
#include <LocOpe_SplitDrafts.hxx>
#include <LocOpe_Spliter.hxx>
#include <LocOpe_SplitShape.hxx>
#include <LocOpe_WiresOnShape.hxx>

// template related includes

// ./opencascade/LocOpe_DataMapOfShapePnt.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/LocOpe_DataMapOfShapePnt.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/LocOpe_SequenceOfCirc.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/LocOpe_SequenceOfLin.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/LocOpe_SequenceOfPntFace.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_LocOpe(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("LocOpe"));
py::object klass;

//Python trampoline classes
    class Py_LocOpe_GeneratedShape : public LocOpe_GeneratedShape{
    public:
        using LocOpe_GeneratedShape::LocOpe_GeneratedShape;


        // public pure virtual
         const TopTools_ListOfShape & GeneratingEdges() override { using return_type =  const TopTools_ListOfShape &;
    PYBIND11_OVERLOAD_PURE(return_type,LocOpe_GeneratedShape,GeneratingEdges,) };
        TopoDS_Edge Generated( const TopoDS_Vertex & V) override { using return_type = TopoDS_Edge;
    PYBIND11_OVERLOAD_PURE(return_type,LocOpe_GeneratedShape,Generated,V) };
        TopoDS_Face Generated( const TopoDS_Edge & E) override { using return_type = TopoDS_Face;
    PYBIND11_OVERLOAD_PURE(return_type,LocOpe_GeneratedShape,Generated,E) };
         const TopTools_ListOfShape & OrientedFaces() override { using return_type =  const TopTools_ListOfShape &;
    PYBIND11_OVERLOAD_PURE(return_type,LocOpe_GeneratedShape,OrientedFaces,) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class LocOpe from ./opencascade/LocOpe.hxx
    klass = m.attr("LocOpe");

    // default constructor
    register_default_constructor<LocOpe , shared_ptr<LocOpe>>(m,"LocOpe");

    // nested enums

    static_cast<py::class_<LocOpe , shared_ptr<LocOpe>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Closed_s",
                    (Standard_Boolean (*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) >(&LocOpe::Closed),
                    R"#(Returns Standard_True when the wire <W> is closed on the face <OnF>.)#"  , py::arg("W"),  py::arg("OnF")
          )
        .def_static("Closed_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) >(&LocOpe::Closed),
                    R"#(Returns Standard_True when the edge <E> is closed on the face <OnF>.)#"  , py::arg("E"),  py::arg("OnF")
          )
        .def_static("TgtFaces_s",
                    (Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<Standard_Boolean (*)(  const TopoDS_Edge & ,   const TopoDS_Face & ,   const TopoDS_Face &  ) >(&LocOpe::TgtFaces),
                    R"#(Returns Standard_True when the faces are tangent)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2")
          )
        .def_static("SampleEdges_s",
                    (void (*)(  const TopoDS_Shape & ,  TColgp_SequenceOfPnt &  ) ) static_cast<void (*)(  const TopoDS_Shape & ,  TColgp_SequenceOfPnt &  ) >(&LocOpe::SampleEdges),
                    R"#()#"  , py::arg("S"),  py::arg("Pt")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LocOpe_BuildShape from ./opencascade/LocOpe_BuildShape.hxx
    klass = m.attr("LocOpe_BuildShape");


    // nested enums

    static_cast<py::class_<LocOpe_BuildShape , shared_ptr<LocOpe_BuildShape>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopTools_ListOfShape & >()  , py::arg("L") )
    // custom constructors
    // methods
        .def("Perform",
             (void (LocOpe_BuildShape::*)(  const TopTools_ListOfShape &  ) ) static_cast<void (LocOpe_BuildShape::*)(  const TopTools_ListOfShape &  ) >(&LocOpe_BuildShape::Perform),
             R"#(Builds shape(s) from the list <L>. Uses only the faces of <L>.)#"  , py::arg("L")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_BuildShape::*)() const) static_cast< const TopoDS_Shape & (LocOpe_BuildShape::*)() const>(&LocOpe_BuildShape::Shape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_BuildShape::*)() const) static_cast< const TopoDS_Shape & (LocOpe_BuildShape::*)() const>(&LocOpe_BuildShape::Shape),
             R"#()#"
             
         )
;

    // Class LocOpe_BuildWires from ./opencascade/LocOpe_BuildWires.hxx
    klass = m.attr("LocOpe_BuildWires");


    // nested enums

    static_cast<py::class_<LocOpe_BuildWires , shared_ptr<LocOpe_BuildWires>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopTools_ListOfShape &, const handle<LocOpe_WiresOnShape> & >()  , py::arg("Ledges"),  py::arg("PW") )
    // custom constructors
    // methods
        .def("Perform",
             (void (LocOpe_BuildWires::*)(  const TopTools_ListOfShape & ,   const handle<LocOpe_WiresOnShape> &  ) ) static_cast<void (LocOpe_BuildWires::*)(  const TopTools_ListOfShape & ,   const handle<LocOpe_WiresOnShape> &  ) >(&LocOpe_BuildWires::Perform),
             R"#()#"  , py::arg("Ledges"),  py::arg("PW")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_BuildWires::*)() const) static_cast<Standard_Boolean (LocOpe_BuildWires::*)() const>(&LocOpe_BuildWires::IsDone),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Result",
             ( const TopTools_ListOfShape & (LocOpe_BuildWires::*)() const) static_cast< const TopTools_ListOfShape & (LocOpe_BuildWires::*)() const>(&LocOpe_BuildWires::Result),
             R"#()#"
             
         )
;

    // Class LocOpe_CSIntersector from ./opencascade/LocOpe_CSIntersector.hxx
    klass = m.attr("LocOpe_CSIntersector");


    // nested enums

    static_cast<py::class_<LocOpe_CSIntersector , shared_ptr<LocOpe_CSIntersector>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_CSIntersector::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_CSIntersector::*)(  const TopoDS_Shape &  ) >(&LocOpe_CSIntersector::Init),
             R"#(Performs the intersection between <Ax1 and <S>.)#"  , py::arg("S")
          )
        .def("Perform",
             (void (LocOpe_CSIntersector::*)(  const LocOpe_SequenceOfLin &  ) ) static_cast<void (LocOpe_CSIntersector::*)(  const LocOpe_SequenceOfLin &  ) >(&LocOpe_CSIntersector::Perform),
             R"#()#"  , py::arg("Slin")
          )
        .def("Perform",
             (void (LocOpe_CSIntersector::*)(  const LocOpe_SequenceOfCirc &  ) ) static_cast<void (LocOpe_CSIntersector::*)(  const LocOpe_SequenceOfCirc &  ) >(&LocOpe_CSIntersector::Perform),
             R"#()#"  , py::arg("Scir")
          )
        .def("Perform",
             (void (LocOpe_CSIntersector::*)(  const TColGeom_SequenceOfCurve &  ) ) static_cast<void (LocOpe_CSIntersector::*)(  const TColGeom_SequenceOfCurve &  ) >(&LocOpe_CSIntersector::Perform),
             R"#()#"  , py::arg("Scur")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_CSIntersector::*)() const) static_cast<Standard_Boolean (LocOpe_CSIntersector::*)() const>(&LocOpe_CSIntersector::IsDone),
             R"#(Returns <Standard_True> if the intersection has been done.)#" 
          )
        .def("NbPoints",
             (Standard_Integer (LocOpe_CSIntersector::*)(  const Standard_Integer  ) const) static_cast<Standard_Integer (LocOpe_CSIntersector::*)(  const Standard_Integer  ) const>(&LocOpe_CSIntersector::NbPoints),
             R"#(Returns the number of intersection point on the element of range <I>.)#"  , py::arg("I")
          )
        .def("Point",
             ( const LocOpe_PntFace & (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Integer  ) const) static_cast< const LocOpe_PntFace & (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Integer  ) const>(&LocOpe_CSIntersector::Point),
             R"#(Returns the intersection point of range <Index> on element of range <I>. The points are sorted in increasing order of parameter along the axis.)#"  , py::arg("I"),  py::arg("Index")
          )
        .def("LocalizeAfter",
             (Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CSIntersector::LocalizeAfter),
             R"#(On the element of range <I>, searches the first intersection point located after the parameter <From>, which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point. (IndFrom <= IndTo). <Tol> is used to determine if 2 parameters are equal.)#"  , py::arg("I"),  py::arg("From"),  py::arg("Tol"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("LocalizeBefore",
             (Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Real ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CSIntersector::LocalizeBefore),
             R"#(On the element of range <I>, searches the first intersection point located before the parameter <From>, which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point (IndFrom <= IndTo). <Tol> is used to determine if 2 parameters are equal.)#"  , py::arg("I"),  py::arg("From"),  py::arg("Tol"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("LocalizeAfter",
             (Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CSIntersector::LocalizeAfter),
             R"#(On the element of range <I>, searches the first intersection point located after the index <FromInd> ( >= FromInd + 1), which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point. (IndFrom <= IndTo). <Tol> is used to determine if 2 parameters are equal.)#"  , py::arg("I"),  py::arg("FromInd"),  py::arg("Tol"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("LocalizeBefore",
             (Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CSIntersector::*)(  const Standard_Integer ,   const Standard_Integer ,   const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CSIntersector::LocalizeBefore),
             R"#(On the element of range <I>, searches the first intersection point located before the index <FromInd> ( <= FromInd -1), which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point (IndFrom <= IndTo). <Tol> is used to determine if 2 parameters are equal.)#"  , py::arg("I"),  py::arg("FromInd"),  py::arg("Tol"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("Destroy",
             (void (LocOpe_CSIntersector::*)() ) static_cast<void (LocOpe_CSIntersector::*)() >(&LocOpe_CSIntersector::Destroy),
             R"#()#" 
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_CSIntersector::*)() const) static_cast<Standard_Boolean (LocOpe_CSIntersector::*)() const>(&LocOpe_CSIntersector::IsDone),
             R"#(Returns <Standard_True> if the intersection has been done.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LocOpe_CurveShapeIntersector from ./opencascade/LocOpe_CurveShapeIntersector.hxx
    klass = m.attr("LocOpe_CurveShapeIntersector");


    // nested enums

    static_cast<py::class_<LocOpe_CurveShapeIntersector , shared_ptr<LocOpe_CurveShapeIntersector>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const gp_Ax1 &, const TopoDS_Shape & >()  , py::arg("Axis"),  py::arg("S") )
        .def(py::init<  const gp_Circ &, const TopoDS_Shape & >()  , py::arg("C"),  py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_CurveShapeIntersector::*)(  const gp_Ax1 & ,   const TopoDS_Shape &  ) ) static_cast<void (LocOpe_CurveShapeIntersector::*)(  const gp_Ax1 & ,   const TopoDS_Shape &  ) >(&LocOpe_CurveShapeIntersector::Init),
             R"#(Performs the intersection between <Ax1 and <S>.)#"  , py::arg("Axis"),  py::arg("S")
          )
        .def("Init",
             (void (LocOpe_CurveShapeIntersector::*)(  const gp_Circ & ,   const TopoDS_Shape &  ) ) static_cast<void (LocOpe_CurveShapeIntersector::*)(  const gp_Circ & ,   const TopoDS_Shape &  ) >(&LocOpe_CurveShapeIntersector::Init),
             R"#(Performs the intersection between <Ax1 and <S>.)#"  , py::arg("C"),  py::arg("S")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_CurveShapeIntersector::*)() const) static_cast<Standard_Boolean (LocOpe_CurveShapeIntersector::*)() const>(&LocOpe_CurveShapeIntersector::IsDone),
             R"#(Returns <Standard_True> if the intersection has been done.)#" 
          )
        .def("NbPoints",
             (Standard_Integer (LocOpe_CurveShapeIntersector::*)() const) static_cast<Standard_Integer (LocOpe_CurveShapeIntersector::*)() const>(&LocOpe_CurveShapeIntersector::NbPoints),
             R"#(Returns the number of intersection point.)#" 
          )
        .def("Point",
             ( const LocOpe_PntFace & (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer  ) const) static_cast< const LocOpe_PntFace & (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer  ) const>(&LocOpe_CurveShapeIntersector::Point),
             R"#(Returns the intersection point of range <Index>. The points are sorted in increasing order of parameter along the axis.)#"  , py::arg("Index")
          )
        .def("LocalizeAfter",
             (Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CurveShapeIntersector::LocalizeAfter),
             R"#(Searches the first intersection point located after the parameter <From>, which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point. (IndFrom <= IndTo).)#"  , py::arg("From"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("LocalizeBefore",
             (Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Real ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CurveShapeIntersector::LocalizeBefore),
             R"#(Searches the first intersection point located before the parameter <From>, which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point (IndFrom <= IndTo).)#"  , py::arg("From"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("LocalizeAfter",
             (Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CurveShapeIntersector::LocalizeAfter),
             R"#(Searches the first intersection point located after the index <FromInd> ( >= FromInd + 1), which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point. (IndFrom <= IndTo).)#"  , py::arg("FromInd"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("LocalizeBefore",
             (Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const) static_cast<Standard_Boolean (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer ,  TopAbs_Orientation & ,  Standard_Integer & ,  Standard_Integer &  ) const>(&LocOpe_CurveShapeIntersector::LocalizeBefore),
             R"#(Searches the first intersection point located before the index <FromInd> ( <= FromInd -1), which orientation is not TopAbs_EXTERNAL. If found, returns <Standard_True>. <Or> contains the orientation of the point, <IndFrom> and <IndTo> represents the interval of index in the sequence of intersection point corresponding to the point (IndFrom <= IndTo).)#"  , py::arg("FromInd"),  py::arg("Or"),  py::arg("IndFrom"),  py::arg("IndTo")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_CurveShapeIntersector::*)() const) static_cast<Standard_Boolean (LocOpe_CurveShapeIntersector::*)() const>(&LocOpe_CurveShapeIntersector::IsDone),
             R"#(Returns <Standard_True> if the intersection has been done.)#" 
          )
        .def("NbPoints",
             (Standard_Integer (LocOpe_CurveShapeIntersector::*)() const) static_cast<Standard_Integer (LocOpe_CurveShapeIntersector::*)() const>(&LocOpe_CurveShapeIntersector::NbPoints),
             R"#(Returns the number of intersection point.)#" 
          )
        .def("Point",
             ( const LocOpe_PntFace & (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer  ) const) static_cast< const LocOpe_PntFace & (LocOpe_CurveShapeIntersector::*)(  const Standard_Integer  ) const>(&LocOpe_CurveShapeIntersector::Point),
             R"#(Returns the intersection point of range <Index>. The points are sorted in increasing order of parameter along the axis.)#"  , py::arg("I")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class LocOpe_DPrism from ./opencascade/LocOpe_DPrism.hxx
    klass = m.attr("LocOpe_DPrism");


    // nested enums

    static_cast<py::class_<LocOpe_DPrism , shared_ptr<LocOpe_DPrism>  >>(klass)
    // constructors
        .def(py::init<  const TopoDS_Face &, const Standard_Real, const Standard_Real, const Standard_Real >()  , py::arg("Spine"),  py::arg("Height1"),  py::arg("Height2"),  py::arg("Angle") )
        .def(py::init<  const TopoDS_Face &, const Standard_Real, const Standard_Real >()  , py::arg("Spine"),  py::arg("Height"),  py::arg("Angle") )
    // custom constructors
    // methods
        .def("IsDone",
             (Standard_Boolean (LocOpe_DPrism::*)() const) static_cast<Standard_Boolean (LocOpe_DPrism::*)() const>(&LocOpe_DPrism::IsDone),
             R"#()#" 
          )
        .def("Shapes",
             ( const TopTools_ListOfShape & (LocOpe_DPrism::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (LocOpe_DPrism::*)(  const TopoDS_Shape &  ) const>(&LocOpe_DPrism::Shapes),
             R"#()#"  , py::arg("S")
          )
        .def("Curves",
             (void (LocOpe_DPrism::*)( TColGeom_SequenceOfCurve &  ) const) static_cast<void (LocOpe_DPrism::*)( TColGeom_SequenceOfCurve &  ) const>(&LocOpe_DPrism::Curves),
             R"#()#"  , py::arg("SCurves")
          )
        .def("BarycCurve",
             (handle<Geom_Curve> (LocOpe_DPrism::*)() const) static_cast<handle<Geom_Curve> (LocOpe_DPrism::*)() const>(&LocOpe_DPrism::BarycCurve),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Spine",
             ( const TopoDS_Shape & (LocOpe_DPrism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_DPrism::*)() const>(&LocOpe_DPrism::Spine),
             R"#()#"
             
         )
       .def("Profile",
             ( const TopoDS_Shape & (LocOpe_DPrism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_DPrism::*)() const>(&LocOpe_DPrism::Profile),
             R"#()#"
             
         )
       .def("FirstShape",
             ( const TopoDS_Shape & (LocOpe_DPrism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_DPrism::*)() const>(&LocOpe_DPrism::FirstShape),
             R"#()#"
             
         )
       .def("LastShape",
             ( const TopoDS_Shape & (LocOpe_DPrism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_DPrism::*)() const>(&LocOpe_DPrism::LastShape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_DPrism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_DPrism::*)() const>(&LocOpe_DPrism::Shape),
             R"#()#"
             
         )
;

    // Class LocOpe_FindEdges from ./opencascade/LocOpe_FindEdges.hxx
    klass = m.attr("LocOpe_FindEdges");


    // nested enums

    static_cast<py::class_<LocOpe_FindEdges , shared_ptr<LocOpe_FindEdges>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape &, const TopoDS_Shape & >()  , py::arg("FFrom"),  py::arg("FTo") )
    // custom constructors
    // methods
        .def("Set",
             (void (LocOpe_FindEdges::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (LocOpe_FindEdges::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&LocOpe_FindEdges::Set),
             R"#()#"  , py::arg("FFrom"),  py::arg("FTo")
          )
        .def("InitIterator",
             (void (LocOpe_FindEdges::*)() ) static_cast<void (LocOpe_FindEdges::*)() >(&LocOpe_FindEdges::InitIterator),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (LocOpe_FindEdges::*)() const) static_cast<Standard_Boolean (LocOpe_FindEdges::*)() const>(&LocOpe_FindEdges::More),
             R"#()#" 
          )
        .def("Next",
             (void (LocOpe_FindEdges::*)() ) static_cast<void (LocOpe_FindEdges::*)() >(&LocOpe_FindEdges::Next),
             R"#()#" 
          )
        .def("InitIterator",
             (void (LocOpe_FindEdges::*)() ) static_cast<void (LocOpe_FindEdges::*)() >(&LocOpe_FindEdges::InitIterator),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (LocOpe_FindEdges::*)() const) static_cast<Standard_Boolean (LocOpe_FindEdges::*)() const>(&LocOpe_FindEdges::More),
             R"#()#" 
          )
        .def("Next",
             (void (LocOpe_FindEdges::*)() ) static_cast<void (LocOpe_FindEdges::*)() >(&LocOpe_FindEdges::Next),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("EdgeFrom",
             ( const TopoDS_Edge & (LocOpe_FindEdges::*)() const) static_cast< const TopoDS_Edge & (LocOpe_FindEdges::*)() const>(&LocOpe_FindEdges::EdgeFrom),
             R"#()#"
             
         )
       .def("EdgeTo",
             ( const TopoDS_Edge & (LocOpe_FindEdges::*)() const) static_cast< const TopoDS_Edge & (LocOpe_FindEdges::*)() const>(&LocOpe_FindEdges::EdgeTo),
             R"#()#"
             
         )
       .def("EdgeFrom",
             ( const TopoDS_Edge & (LocOpe_FindEdges::*)() const) static_cast< const TopoDS_Edge & (LocOpe_FindEdges::*)() const>(&LocOpe_FindEdges::EdgeFrom),
             R"#()#"
             
         )
       .def("EdgeTo",
             ( const TopoDS_Edge & (LocOpe_FindEdges::*)() const) static_cast< const TopoDS_Edge & (LocOpe_FindEdges::*)() const>(&LocOpe_FindEdges::EdgeTo),
             R"#()#"
             
         )
;

    // Class LocOpe_FindEdgesInFace from ./opencascade/LocOpe_FindEdgesInFace.hxx
    klass = m.attr("LocOpe_FindEdgesInFace");


    // nested enums

    static_cast<py::class_<LocOpe_FindEdgesInFace , shared_ptr<LocOpe_FindEdgesInFace>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape &, const TopoDS_Face & >()  , py::arg("S"),  py::arg("F") )
    // custom constructors
    // methods
        .def("Set",
             (void (LocOpe_FindEdgesInFace::*)(  const TopoDS_Shape & ,   const TopoDS_Face &  ) ) static_cast<void (LocOpe_FindEdgesInFace::*)(  const TopoDS_Shape & ,   const TopoDS_Face &  ) >(&LocOpe_FindEdgesInFace::Set),
             R"#()#"  , py::arg("S"),  py::arg("F")
          )
        .def("Init",
             (void (LocOpe_FindEdgesInFace::*)() ) static_cast<void (LocOpe_FindEdgesInFace::*)() >(&LocOpe_FindEdgesInFace::Init),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (LocOpe_FindEdgesInFace::*)() const) static_cast<Standard_Boolean (LocOpe_FindEdgesInFace::*)() const>(&LocOpe_FindEdgesInFace::More),
             R"#()#" 
          )
        .def("Next",
             (void (LocOpe_FindEdgesInFace::*)() ) static_cast<void (LocOpe_FindEdgesInFace::*)() >(&LocOpe_FindEdgesInFace::Next),
             R"#()#" 
          )
        .def("Init",
             (void (LocOpe_FindEdgesInFace::*)() ) static_cast<void (LocOpe_FindEdgesInFace::*)() >(&LocOpe_FindEdgesInFace::Init),
             R"#()#" 
          )
        .def("More",
             (Standard_Boolean (LocOpe_FindEdgesInFace::*)() const) static_cast<Standard_Boolean (LocOpe_FindEdgesInFace::*)() const>(&LocOpe_FindEdgesInFace::More),
             R"#()#" 
          )
        .def("Next",
             (void (LocOpe_FindEdgesInFace::*)() ) static_cast<void (LocOpe_FindEdgesInFace::*)() >(&LocOpe_FindEdgesInFace::Next),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Edge",
             ( const TopoDS_Edge & (LocOpe_FindEdgesInFace::*)() const) static_cast< const TopoDS_Edge & (LocOpe_FindEdgesInFace::*)() const>(&LocOpe_FindEdgesInFace::Edge),
             R"#()#"
             
         )
       .def("Edge",
             ( const TopoDS_Edge & (LocOpe_FindEdgesInFace::*)() const) static_cast< const TopoDS_Edge & (LocOpe_FindEdgesInFace::*)() const>(&LocOpe_FindEdgesInFace::Edge),
             R"#()#"
             
         )
;

    // Class LocOpe_GeneratedShape from ./opencascade/LocOpe_GeneratedShape.hxx
    klass = m.attr("LocOpe_GeneratedShape");


    // nested enums

    static_cast<py::class_<LocOpe_GeneratedShape ,opencascade::handle<LocOpe_GeneratedShape> ,Py_LocOpe_GeneratedShape , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GeneratingEdges",
             ( const TopTools_ListOfShape & (LocOpe_GeneratedShape::*)() ) static_cast< const TopTools_ListOfShape & (LocOpe_GeneratedShape::*)() >(&LocOpe_GeneratedShape::GeneratingEdges),
             R"#()#" 
          )
        .def("Generated",
             (TopoDS_Edge (LocOpe_GeneratedShape::*)(  const TopoDS_Vertex &  ) ) static_cast<TopoDS_Edge (LocOpe_GeneratedShape::*)(  const TopoDS_Vertex &  ) >(&LocOpe_GeneratedShape::Generated),
             R"#(Returns the edge created by the vertex <V>. If none, must return a null shape.)#"  , py::arg("V")
          )
        .def("Generated",
             (TopoDS_Face (LocOpe_GeneratedShape::*)(  const TopoDS_Edge &  ) ) static_cast<TopoDS_Face (LocOpe_GeneratedShape::*)(  const TopoDS_Edge &  ) >(&LocOpe_GeneratedShape::Generated),
             R"#(Returns the face created by the edge <E>. If none, must return a null shape.)#"  , py::arg("E")
          )
        .def("OrientedFaces",
             ( const TopTools_ListOfShape & (LocOpe_GeneratedShape::*)() ) static_cast< const TopTools_ListOfShape & (LocOpe_GeneratedShape::*)() >(&LocOpe_GeneratedShape::OrientedFaces),
             R"#(Returns the list of correctly oriented generated faces.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&LocOpe_GeneratedShape::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&LocOpe_GeneratedShape::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (LocOpe_GeneratedShape::*)() const) static_cast< const handle<Standard_Type> & (LocOpe_GeneratedShape::*)() const>(&LocOpe_GeneratedShape::DynamicType),
             R"#()#"
             
         )
;

    // Class LocOpe_Generator from ./opencascade/LocOpe_Generator.hxx
    klass = m.attr("LocOpe_Generator");


    // nested enums

    static_cast<py::class_<LocOpe_Generator , shared_ptr<LocOpe_Generator>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_Generator::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_Generator::*)(  const TopoDS_Shape &  ) >(&LocOpe_Generator::Init),
             R"#(Initializes the algorithm on the shape <S>.)#"  , py::arg("S")
          )
        .def("Perform",
             (void (LocOpe_Generator::*)(  const handle<LocOpe_GeneratedShape> &  ) ) static_cast<void (LocOpe_Generator::*)(  const handle<LocOpe_GeneratedShape> &  ) >(&LocOpe_Generator::Perform),
             R"#()#"  , py::arg("G")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_Generator::*)() const) static_cast<Standard_Boolean (LocOpe_Generator::*)() const>(&LocOpe_Generator::IsDone),
             R"#()#" 
          )
        .def("DescendantFace",
             ( const TopTools_ListOfShape & (LocOpe_Generator::*)(  const TopoDS_Face &  ) ) static_cast< const TopTools_ListOfShape & (LocOpe_Generator::*)(  const TopoDS_Face &  ) >(&LocOpe_Generator::DescendantFace),
             R"#(Returns the descendant face of <F>. <F> may belong to the original shape or to the "generated" shape. The returned face may be a null shape (when <F> disappears).)#"  , py::arg("F")
          )
        .def("Init",
             (void (LocOpe_Generator::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_Generator::*)(  const TopoDS_Shape &  ) >(&LocOpe_Generator::Init),
             R"#(Initializes the algorithm on the shape <S>.)#"  , py::arg("S")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_Generator::*)() const) static_cast<Standard_Boolean (LocOpe_Generator::*)() const>(&LocOpe_Generator::IsDone),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ResultingShape",
             ( const TopoDS_Shape & (LocOpe_Generator::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Generator::*)() const>(&LocOpe_Generator::ResultingShape),
             R"#(Returns the new shape)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_Generator::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Generator::*)() const>(&LocOpe_Generator::Shape),
             R"#(Returns the initial shape)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_Generator::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Generator::*)() const>(&LocOpe_Generator::Shape),
             R"#(Returns the initial shape)#"
             
         )
       .def("ResultingShape",
             ( const TopoDS_Shape & (LocOpe_Generator::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Generator::*)() const>(&LocOpe_Generator::ResultingShape),
             R"#(Returns the new shape)#"
             
         )
;

    // Class LocOpe_Gluer from ./opencascade/LocOpe_Gluer.hxx
    klass = m.attr("LocOpe_Gluer");


    // nested enums

    static_cast<py::class_<LocOpe_Gluer , shared_ptr<LocOpe_Gluer>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape &, const TopoDS_Shape & >()  , py::arg("Sbase"),  py::arg("Snew") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_Gluer::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) ) static_cast<void (LocOpe_Gluer::*)(  const TopoDS_Shape & ,   const TopoDS_Shape &  ) >(&LocOpe_Gluer::Init),
             R"#()#"  , py::arg("Sbase"),  py::arg("Snew")
          )
        .def("Bind",
             (void (LocOpe_Gluer::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) ) static_cast<void (LocOpe_Gluer::*)(  const TopoDS_Face & ,   const TopoDS_Face &  ) >(&LocOpe_Gluer::Bind),
             R"#()#"  , py::arg("Fnew"),  py::arg("Fbase")
          )
        .def("Bind",
             (void (LocOpe_Gluer::*)(  const TopoDS_Edge & ,   const TopoDS_Edge &  ) ) static_cast<void (LocOpe_Gluer::*)(  const TopoDS_Edge & ,   const TopoDS_Edge &  ) >(&LocOpe_Gluer::Bind),
             R"#()#"  , py::arg("Enew"),  py::arg("Ebase")
          )
        .def("OpeType",
             (LocOpe_Operation (LocOpe_Gluer::*)() const) static_cast<LocOpe_Operation (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::OpeType),
             R"#()#" 
          )
        .def("Perform",
             (void (LocOpe_Gluer::*)() ) static_cast<void (LocOpe_Gluer::*)() >(&LocOpe_Gluer::Perform),
             R"#()#" 
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_Gluer::*)() const) static_cast<Standard_Boolean (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::IsDone),
             R"#()#" 
          )
        .def("DescendantFaces",
             ( const TopTools_ListOfShape & (LocOpe_Gluer::*)(  const TopoDS_Face &  ) const) static_cast< const TopTools_ListOfShape & (LocOpe_Gluer::*)(  const TopoDS_Face &  ) const>(&LocOpe_Gluer::DescendantFaces),
             R"#()#"  , py::arg("F")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_Gluer::*)() const) static_cast<Standard_Boolean (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::IsDone),
             R"#()#" 
          )
        .def("OpeType",
             (LocOpe_Operation (LocOpe_Gluer::*)() const) static_cast<LocOpe_Operation (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::OpeType),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ResultingShape",
             ( const TopoDS_Shape & (LocOpe_Gluer::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::ResultingShape),
             R"#()#"
             
         )
       .def("BasisShape",
             ( const TopoDS_Shape & (LocOpe_Gluer::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::BasisShape),
             R"#()#"
             
         )
       .def("GluedShape",
             ( const TopoDS_Shape & (LocOpe_Gluer::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::GluedShape),
             R"#()#"
             
         )
       .def("Edges",
             ( const TopTools_ListOfShape & (LocOpe_Gluer::*)() const) static_cast< const TopTools_ListOfShape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::Edges),
             R"#()#"
             
         )
       .def("TgtEdges",
             ( const TopTools_ListOfShape & (LocOpe_Gluer::*)() const) static_cast< const TopTools_ListOfShape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::TgtEdges),
             R"#()#"
             
         )
       .def("ResultingShape",
             ( const TopoDS_Shape & (LocOpe_Gluer::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::ResultingShape),
             R"#()#"
             
         )
       .def("BasisShape",
             ( const TopoDS_Shape & (LocOpe_Gluer::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::BasisShape),
             R"#()#"
             
         )
       .def("GluedShape",
             ( const TopoDS_Shape & (LocOpe_Gluer::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::GluedShape),
             R"#()#"
             
         )
       .def("Edges",
             ( const TopTools_ListOfShape & (LocOpe_Gluer::*)() const) static_cast< const TopTools_ListOfShape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::Edges),
             R"#()#"
             
         )
       .def("TgtEdges",
             ( const TopTools_ListOfShape & (LocOpe_Gluer::*)() const) static_cast< const TopTools_ListOfShape & (LocOpe_Gluer::*)() const>(&LocOpe_Gluer::TgtEdges),
             R"#()#"
             
         )
;

    // Class LocOpe_LinearForm from ./opencascade/LocOpe_LinearForm.hxx
    klass = m.attr("LocOpe_LinearForm");


    // nested enums

    static_cast<py::class_<LocOpe_LinearForm , shared_ptr<LocOpe_LinearForm>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape &, const gp_Vec &, const gp_Pnt &, const gp_Pnt & >()  , py::arg("Base"),  py::arg("V"),  py::arg("Pnt1"),  py::arg("Pnt2") )
        .def(py::init<  const TopoDS_Shape &, const gp_Vec &, const gp_Vec &, const gp_Pnt &, const gp_Pnt & >()  , py::arg("Base"),  py::arg("V"),  py::arg("Vectra"),  py::arg("Pnt1"),  py::arg("Pnt2") )
    // custom constructors
    // methods
        .def("Perform",
             (void (LocOpe_LinearForm::*)(  const TopoDS_Shape & ,   const gp_Vec & ,   const gp_Pnt & ,   const gp_Pnt &  ) ) static_cast<void (LocOpe_LinearForm::*)(  const TopoDS_Shape & ,   const gp_Vec & ,   const gp_Pnt & ,   const gp_Pnt &  ) >(&LocOpe_LinearForm::Perform),
             R"#()#"  , py::arg("Base"),  py::arg("V"),  py::arg("Pnt1"),  py::arg("Pnt2")
          )
        .def("Perform",
             (void (LocOpe_LinearForm::*)(  const TopoDS_Shape & ,   const gp_Vec & ,   const gp_Vec & ,   const gp_Pnt & ,   const gp_Pnt &  ) ) static_cast<void (LocOpe_LinearForm::*)(  const TopoDS_Shape & ,   const gp_Vec & ,   const gp_Vec & ,   const gp_Pnt & ,   const gp_Pnt &  ) >(&LocOpe_LinearForm::Perform),
             R"#()#"  , py::arg("Base"),  py::arg("V"),  py::arg("Vectra"),  py::arg("Pnt1"),  py::arg("Pnt2")
          )
        .def("Shapes",
             ( const TopTools_ListOfShape & (LocOpe_LinearForm::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (LocOpe_LinearForm::*)(  const TopoDS_Shape &  ) const>(&LocOpe_LinearForm::Shapes),
             R"#()#"  , py::arg("S")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("FirstShape",
             ( const TopoDS_Shape & (LocOpe_LinearForm::*)() const) static_cast< const TopoDS_Shape & (LocOpe_LinearForm::*)() const>(&LocOpe_LinearForm::FirstShape),
             R"#()#"
             
         )
       .def("LastShape",
             ( const TopoDS_Shape & (LocOpe_LinearForm::*)() const) static_cast< const TopoDS_Shape & (LocOpe_LinearForm::*)() const>(&LocOpe_LinearForm::LastShape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_LinearForm::*)() const) static_cast< const TopoDS_Shape & (LocOpe_LinearForm::*)() const>(&LocOpe_LinearForm::Shape),
             R"#()#"
             
         )
;

    // Class LocOpe_Pipe from ./opencascade/LocOpe_Pipe.hxx
    klass = m.attr("LocOpe_Pipe");


    // nested enums

    static_cast<py::class_<LocOpe_Pipe , shared_ptr<LocOpe_Pipe>  >>(klass)
    // constructors
        .def(py::init<  const TopoDS_Wire &, const TopoDS_Shape & >()  , py::arg("Spine"),  py::arg("Profile") )
    // custom constructors
    // methods
        .def("Shapes",
             ( const TopTools_ListOfShape & (LocOpe_Pipe::*)(  const TopoDS_Shape &  ) ) static_cast< const TopTools_ListOfShape & (LocOpe_Pipe::*)(  const TopoDS_Shape &  ) >(&LocOpe_Pipe::Shapes),
             R"#()#"  , py::arg("S")
          )
        .def("Curves",
             ( const TColGeom_SequenceOfCurve & (LocOpe_Pipe::*)(  const TColgp_SequenceOfPnt &  ) ) static_cast< const TColGeom_SequenceOfCurve & (LocOpe_Pipe::*)(  const TColgp_SequenceOfPnt &  ) >(&LocOpe_Pipe::Curves),
             R"#()#"  , py::arg("Spt")
          )
        .def("BarycCurve",
             (handle<Geom_Curve> (LocOpe_Pipe::*)() ) static_cast<handle<Geom_Curve> (LocOpe_Pipe::*)() >(&LocOpe_Pipe::BarycCurve),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Spine",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::Spine),
             R"#()#"
             
         )
       .def("Profile",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::Profile),
             R"#()#"
             
         )
       .def("FirstShape",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::FirstShape),
             R"#()#"
             
         )
       .def("LastShape",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::LastShape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::Shape),
             R"#()#"
             
         )
       .def("Spine",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::Spine),
             R"#()#"
             
         )
       .def("Profile",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::Profile),
             R"#()#"
             
         )
       .def("FirstShape",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::FirstShape),
             R"#()#"
             
         )
       .def("LastShape",
             ( const TopoDS_Shape & (LocOpe_Pipe::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Pipe::*)() const>(&LocOpe_Pipe::LastShape),
             R"#()#"
             
         )
;

    // Class LocOpe_PntFace from ./opencascade/LocOpe_PntFace.hxx
    klass = m.attr("LocOpe_PntFace");


    // nested enums

    static_cast<py::class_<LocOpe_PntFace , shared_ptr<LocOpe_PntFace>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const gp_Pnt &, const TopoDS_Face &, const TopAbs_Orientation, const Standard_Real, const Standard_Real, const Standard_Real >()  , py::arg("P"),  py::arg("F"),  py::arg("Or"),  py::arg("Param"),  py::arg("UPar"),  py::arg("VPar") )
    // custom constructors
    // methods
        .def("Orientation",
             (TopAbs_Orientation (LocOpe_PntFace::*)() const) static_cast<TopAbs_Orientation (LocOpe_PntFace::*)() const>(&LocOpe_PntFace::Orientation),
             R"#()#" 
          )
        .def("Parameter",
             (Standard_Real (LocOpe_PntFace::*)() const) static_cast<Standard_Real (LocOpe_PntFace::*)() const>(&LocOpe_PntFace::Parameter),
             R"#()#" 
          )
        .def("UParameter",
             (Standard_Real (LocOpe_PntFace::*)() const) static_cast<Standard_Real (LocOpe_PntFace::*)() const>(&LocOpe_PntFace::UParameter),
             R"#()#" 
          )
        .def("VParameter",
             (Standard_Real (LocOpe_PntFace::*)() const) static_cast<Standard_Real (LocOpe_PntFace::*)() const>(&LocOpe_PntFace::VParameter),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Pnt",
             ( const gp_Pnt & (LocOpe_PntFace::*)() const) static_cast< const gp_Pnt & (LocOpe_PntFace::*)() const>(&LocOpe_PntFace::Pnt),
             R"#()#"
             
         )
       .def("Face",
             ( const TopoDS_Face & (LocOpe_PntFace::*)() const) static_cast< const TopoDS_Face & (LocOpe_PntFace::*)() const>(&LocOpe_PntFace::Face),
             R"#()#"
             
         )
       .def("ChangeOrientation",
             (TopAbs_Orientation & (LocOpe_PntFace::*)() ) static_cast<TopAbs_Orientation & (LocOpe_PntFace::*)() >(&LocOpe_PntFace::ChangeOrientation),
             R"#()#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class LocOpe_Prism from ./opencascade/LocOpe_Prism.hxx
    klass = m.attr("LocOpe_Prism");


    // nested enums

    static_cast<py::class_<LocOpe_Prism , shared_ptr<LocOpe_Prism>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape &, const gp_Vec & >()  , py::arg("Base"),  py::arg("V") )
        .def(py::init<  const TopoDS_Shape &, const gp_Vec &, const gp_Vec & >()  , py::arg("Base"),  py::arg("V"),  py::arg("Vectra") )
    // custom constructors
    // methods
        .def("Perform",
             (void (LocOpe_Prism::*)(  const TopoDS_Shape & ,   const gp_Vec &  ) ) static_cast<void (LocOpe_Prism::*)(  const TopoDS_Shape & ,   const gp_Vec &  ) >(&LocOpe_Prism::Perform),
             R"#()#"  , py::arg("Base"),  py::arg("V")
          )
        .def("Perform",
             (void (LocOpe_Prism::*)(  const TopoDS_Shape & ,   const gp_Vec & ,   const gp_Vec &  ) ) static_cast<void (LocOpe_Prism::*)(  const TopoDS_Shape & ,   const gp_Vec & ,   const gp_Vec &  ) >(&LocOpe_Prism::Perform),
             R"#()#"  , py::arg("Base"),  py::arg("V"),  py::arg("Vtra")
          )
        .def("Shapes",
             ( const TopTools_ListOfShape & (LocOpe_Prism::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (LocOpe_Prism::*)(  const TopoDS_Shape &  ) const>(&LocOpe_Prism::Shapes),
             R"#()#"  , py::arg("S")
          )
        .def("Curves",
             (void (LocOpe_Prism::*)( TColGeom_SequenceOfCurve &  ) const) static_cast<void (LocOpe_Prism::*)( TColGeom_SequenceOfCurve &  ) const>(&LocOpe_Prism::Curves),
             R"#()#"  , py::arg("SCurves")
          )
        .def("BarycCurve",
             (handle<Geom_Curve> (LocOpe_Prism::*)() const) static_cast<handle<Geom_Curve> (LocOpe_Prism::*)() const>(&LocOpe_Prism::BarycCurve),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("FirstShape",
             ( const TopoDS_Shape & (LocOpe_Prism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Prism::*)() const>(&LocOpe_Prism::FirstShape),
             R"#()#"
             
         )
       .def("LastShape",
             ( const TopoDS_Shape & (LocOpe_Prism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Prism::*)() const>(&LocOpe_Prism::LastShape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_Prism::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Prism::*)() const>(&LocOpe_Prism::Shape),
             R"#()#"
             
         )
;

    // Class LocOpe_Revol from ./opencascade/LocOpe_Revol.hxx
    klass = m.attr("LocOpe_Revol");


    // nested enums

    static_cast<py::class_<LocOpe_Revol , shared_ptr<LocOpe_Revol>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Perform",
             (void (LocOpe_Revol::*)(  const TopoDS_Shape & ,   const gp_Ax1 & ,   const Standard_Real ,   const Standard_Real  ) ) static_cast<void (LocOpe_Revol::*)(  const TopoDS_Shape & ,   const gp_Ax1 & ,   const Standard_Real ,   const Standard_Real  ) >(&LocOpe_Revol::Perform),
             R"#()#"  , py::arg("Base"),  py::arg("Axis"),  py::arg("Angle"),  py::arg("angledec")
          )
        .def("Perform",
             (void (LocOpe_Revol::*)(  const TopoDS_Shape & ,   const gp_Ax1 & ,   const Standard_Real  ) ) static_cast<void (LocOpe_Revol::*)(  const TopoDS_Shape & ,   const gp_Ax1 & ,   const Standard_Real  ) >(&LocOpe_Revol::Perform),
             R"#()#"  , py::arg("Base"),  py::arg("Axis"),  py::arg("Angle")
          )
        .def("Shapes",
             ( const TopTools_ListOfShape & (LocOpe_Revol::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (LocOpe_Revol::*)(  const TopoDS_Shape &  ) const>(&LocOpe_Revol::Shapes),
             R"#()#"  , py::arg("S")
          )
        .def("Curves",
             (void (LocOpe_Revol::*)( TColGeom_SequenceOfCurve &  ) const) static_cast<void (LocOpe_Revol::*)( TColGeom_SequenceOfCurve &  ) const>(&LocOpe_Revol::Curves),
             R"#()#"  , py::arg("SCurves")
          )
        .def("BarycCurve",
             (handle<Geom_Curve> (LocOpe_Revol::*)() const) static_cast<handle<Geom_Curve> (LocOpe_Revol::*)() const>(&LocOpe_Revol::BarycCurve),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("FirstShape",
             ( const TopoDS_Shape & (LocOpe_Revol::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Revol::*)() const>(&LocOpe_Revol::FirstShape),
             R"#()#"
             
         )
       .def("LastShape",
             ( const TopoDS_Shape & (LocOpe_Revol::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Revol::*)() const>(&LocOpe_Revol::LastShape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_Revol::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Revol::*)() const>(&LocOpe_Revol::Shape),
             R"#()#"
             
         )
;

    // Class LocOpe_RevolutionForm from ./opencascade/LocOpe_RevolutionForm.hxx
    klass = m.attr("LocOpe_RevolutionForm");


    // nested enums

    static_cast<py::class_<LocOpe_RevolutionForm , shared_ptr<LocOpe_RevolutionForm>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Perform",
             (void (LocOpe_RevolutionForm::*)(  const TopoDS_Shape & ,   const gp_Ax1 & ,   const Standard_Real  ) ) static_cast<void (LocOpe_RevolutionForm::*)(  const TopoDS_Shape & ,   const gp_Ax1 & ,   const Standard_Real  ) >(&LocOpe_RevolutionForm::Perform),
             R"#()#"  , py::arg("Base"),  py::arg("Axe"),  py::arg("Angle")
          )
        .def("Shapes",
             ( const TopTools_ListOfShape & (LocOpe_RevolutionForm::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (LocOpe_RevolutionForm::*)(  const TopoDS_Shape &  ) const>(&LocOpe_RevolutionForm::Shapes),
             R"#()#"  , py::arg("S")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("FirstShape",
             ( const TopoDS_Shape & (LocOpe_RevolutionForm::*)() const) static_cast< const TopoDS_Shape & (LocOpe_RevolutionForm::*)() const>(&LocOpe_RevolutionForm::FirstShape),
             R"#()#"
             
         )
       .def("LastShape",
             ( const TopoDS_Shape & (LocOpe_RevolutionForm::*)() const) static_cast< const TopoDS_Shape & (LocOpe_RevolutionForm::*)() const>(&LocOpe_RevolutionForm::LastShape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_RevolutionForm::*)() const) static_cast< const TopoDS_Shape & (LocOpe_RevolutionForm::*)() const>(&LocOpe_RevolutionForm::Shape),
             R"#()#"
             
         )
;

    // Class LocOpe_SplitDrafts from ./opencascade/LocOpe_SplitDrafts.hxx
    klass = m.attr("LocOpe_SplitDrafts");


    // nested enums

    static_cast<py::class_<LocOpe_SplitDrafts , shared_ptr<LocOpe_SplitDrafts>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_SplitDrafts::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_SplitDrafts::*)(  const TopoDS_Shape &  ) >(&LocOpe_SplitDrafts::Init),
             R"#(Initializes the algorithm with the shape <S>.)#"  , py::arg("S")
          )
        .def("Perform",
             (void (LocOpe_SplitDrafts::*)(  const TopoDS_Face & ,   const TopoDS_Wire & ,   const gp_Dir & ,   const gp_Pln & ,   const Standard_Real ,   const gp_Dir & ,   const gp_Pln & ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Boolean  ) ) static_cast<void (LocOpe_SplitDrafts::*)(  const TopoDS_Face & ,   const TopoDS_Wire & ,   const gp_Dir & ,   const gp_Pln & ,   const Standard_Real ,   const gp_Dir & ,   const gp_Pln & ,   const Standard_Real ,   const Standard_Boolean ,   const Standard_Boolean  ) >(&LocOpe_SplitDrafts::Perform),
             R"#(Splits the face <F> of the former given shape with the wire <W>. The wire is assumed to lie on the face. Puts a draft angle on both parts of the wire. <Extractg>, <Nplg>, <Angleg> define the arguments for the left part of the wire. <Extractd>, <Npld>, <Angled> define the arguments for the right part of the wire. The draft angle is measured with the direction <Extract>. <Npl> defines the neutral plane (points belonging to the neutral plane are not modified). <Angle> is the value of the draft angle. If <ModifyLeft> is set to <Standard_False>, no draft angle is applied to the left part of the wire. If <ModifyRight> is set to <Standard_False>,no draft angle is applied to the right part of the wire.)#"  , py::arg("F"),  py::arg("W"),  py::arg("Extractg"),  py::arg("NPlg"),  py::arg("Angleg"),  py::arg("Extractd"),  py::arg("NPld"),  py::arg("Angled"),  py::arg("ModifyLeft")=static_cast< const Standard_Boolean>(Standard_True),  py::arg("ModifyRight")=static_cast< const Standard_Boolean>(Standard_True)
          )
        .def("Perform",
             (void (LocOpe_SplitDrafts::*)(  const TopoDS_Face & ,   const TopoDS_Wire & ,   const gp_Dir & ,   const gp_Pln & ,   const Standard_Real  ) ) static_cast<void (LocOpe_SplitDrafts::*)(  const TopoDS_Face & ,   const TopoDS_Wire & ,   const gp_Dir & ,   const gp_Pln & ,   const Standard_Real  ) >(&LocOpe_SplitDrafts::Perform),
             R"#(Splits the face <F> of the former given shape with the wire <W>. The wire is assumed to lie on the face. Puts a draft angle on the left part of the wire. The draft angle is measured with the direction <Extract>. <Npl> defines the neutral plane (points belonging to the neutral plane are not modified). <Angle> is the value of the draft angle.)#"  , py::arg("F"),  py::arg("W"),  py::arg("Extract"),  py::arg("NPl"),  py::arg("Angle")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_SplitDrafts::*)() const) static_cast<Standard_Boolean (LocOpe_SplitDrafts::*)() const>(&LocOpe_SplitDrafts::IsDone),
             R"#(Returns <Standard_True> if the modification has been successfully performed.)#" 
          )
        .def("ShapesFromShape",
             ( const TopTools_ListOfShape & (LocOpe_SplitDrafts::*)(  const TopoDS_Shape &  ) const) static_cast< const TopTools_ListOfShape & (LocOpe_SplitDrafts::*)(  const TopoDS_Shape &  ) const>(&LocOpe_SplitDrafts::ShapesFromShape),
             R"#(Manages the descendant shapes.)#"  , py::arg("S")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("OriginalShape",
             ( const TopoDS_Shape & (LocOpe_SplitDrafts::*)() const) static_cast< const TopoDS_Shape & (LocOpe_SplitDrafts::*)() const>(&LocOpe_SplitDrafts::OriginalShape),
             R"#()#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_SplitDrafts::*)() const) static_cast< const TopoDS_Shape & (LocOpe_SplitDrafts::*)() const>(&LocOpe_SplitDrafts::Shape),
             R"#(Returns the modified shape.)#"
             
         )
;

    // Class LocOpe_SplitShape from ./opencascade/LocOpe_SplitShape.hxx
    klass = m.attr("LocOpe_SplitShape");


    // nested enums

    static_cast<py::class_<LocOpe_SplitShape , shared_ptr<LocOpe_SplitShape>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_SplitShape::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_SplitShape::*)(  const TopoDS_Shape &  ) >(&LocOpe_SplitShape::Init),
             R"#(Initializes the process on the shape <S>.)#"  , py::arg("S")
          )
        .def("CanSplit",
             (Standard_Boolean (LocOpe_SplitShape::*)(  const TopoDS_Edge &  ) const) static_cast<Standard_Boolean (LocOpe_SplitShape::*)(  const TopoDS_Edge &  ) const>(&LocOpe_SplitShape::CanSplit),
             R"#(Tests if it is possible to split the edge <E>.)#"  , py::arg("E")
          )
        .def("Add",
             (void (LocOpe_SplitShape::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge &  ) ) static_cast<void (LocOpe_SplitShape::*)(  const TopoDS_Vertex & ,   const Standard_Real ,   const TopoDS_Edge &  ) >(&LocOpe_SplitShape::Add),
             R"#(Adds the vertex <V> on the edge <E>, at parameter <P>.)#"  , py::arg("V"),  py::arg("P"),  py::arg("E")
          )
        .def("Add",
             (Standard_Boolean (LocOpe_SplitShape::*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) ) static_cast<Standard_Boolean (LocOpe_SplitShape::*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) >(&LocOpe_SplitShape::Add),
             R"#(Adds the wire <W> on the face <F>.)#"  , py::arg("W"),  py::arg("F")
          )
        .def("Add",
             (Standard_Boolean (LocOpe_SplitShape::*)(  const TopTools_ListOfShape & ,   const TopoDS_Face &  ) ) static_cast<Standard_Boolean (LocOpe_SplitShape::*)(  const TopTools_ListOfShape & ,   const TopoDS_Face &  ) >(&LocOpe_SplitShape::Add),
             R"#(Adds the list of wires <Lwires> on the face <F>.)#"  , py::arg("Lwires"),  py::arg("F")
          )
        .def("DescendantShapes",
             ( const TopTools_ListOfShape & (LocOpe_SplitShape::*)(  const TopoDS_Shape &  ) ) static_cast< const TopTools_ListOfShape & (LocOpe_SplitShape::*)(  const TopoDS_Shape &  ) >(&LocOpe_SplitShape::DescendantShapes),
             R"#(Returns the list of descendant shapes of <S>.)#"  , py::arg("S")
          )
        .def("LeftOf",
             ( const TopTools_ListOfShape & (LocOpe_SplitShape::*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) ) static_cast< const TopTools_ListOfShape & (LocOpe_SplitShape::*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) >(&LocOpe_SplitShape::LeftOf),
             R"#(Returns the "left" part defined by the wire <W> on the face <F>. The returned list of shape is in fact a list of faces. The face <F> is considered with its topological orientation in the original shape. <W> is considered with its orientation.)#"  , py::arg("W"),  py::arg("F")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_SplitShape::*)() const) static_cast< const TopoDS_Shape & (LocOpe_SplitShape::*)() const>(&LocOpe_SplitShape::Shape),
             R"#(Returns the "original" shape.)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_SplitShape::*)() const) static_cast< const TopoDS_Shape & (LocOpe_SplitShape::*)() const>(&LocOpe_SplitShape::Shape),
             R"#(Returns the "original" shape.)#"
             
         )
;

    // Class LocOpe_Spliter from ./opencascade/LocOpe_Spliter.hxx
    klass = m.attr("LocOpe_Spliter");


    // nested enums

    static_cast<py::class_<LocOpe_Spliter , shared_ptr<LocOpe_Spliter>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_Spliter::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_Spliter::*)(  const TopoDS_Shape &  ) >(&LocOpe_Spliter::Init),
             R"#(Initializes the algorithm on the shape <S>.)#"  , py::arg("S")
          )
        .def("Perform",
             (void (LocOpe_Spliter::*)(  const handle<LocOpe_WiresOnShape> &  ) ) static_cast<void (LocOpe_Spliter::*)(  const handle<LocOpe_WiresOnShape> &  ) >(&LocOpe_Spliter::Perform),
             R"#()#"  , py::arg("PW")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_Spliter::*)() const) static_cast<Standard_Boolean (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::IsDone),
             R"#()#" 
          )
        .def("DescendantShapes",
             ( const TopTools_ListOfShape & (LocOpe_Spliter::*)(  const TopoDS_Shape &  ) ) static_cast< const TopTools_ListOfShape & (LocOpe_Spliter::*)(  const TopoDS_Shape &  ) >(&LocOpe_Spliter::DescendantShapes),
             R"#(Returns the list of descendant shapes of <S>.)#"  , py::arg("S")
          )
        .def("Init",
             (void (LocOpe_Spliter::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_Spliter::*)(  const TopoDS_Shape &  ) >(&LocOpe_Spliter::Init),
             R"#(Initializes the algorithm on the shape <S>.)#"  , py::arg("S")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_Spliter::*)() const) static_cast<Standard_Boolean (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::IsDone),
             R"#()#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ResultingShape",
             ( const TopoDS_Shape & (LocOpe_Spliter::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::ResultingShape),
             R"#(Returns the new shape)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_Spliter::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::Shape),
             R"#(Returns the initial shape)#"
             
         )
       .def("DirectLeft",
             ( const TopTools_ListOfShape & (LocOpe_Spliter::*)() const) static_cast< const TopTools_ListOfShape & (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::DirectLeft),
             R"#(Returns the faces which are the left of the projected wires and which are)#"
             
         )
       .def("Left",
             ( const TopTools_ListOfShape & (LocOpe_Spliter::*)() const) static_cast< const TopTools_ListOfShape & (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::Left),
             R"#(Returns the faces of the "left" part on the shape. (It is build from DirectLeft, with the faces connected to this set, and so on...).)#"
             
         )
       .def("Shape",
             ( const TopoDS_Shape & (LocOpe_Spliter::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::Shape),
             R"#(Returns the initial shape)#"
             
         )
       .def("ResultingShape",
             ( const TopoDS_Shape & (LocOpe_Spliter::*)() const) static_cast< const TopoDS_Shape & (LocOpe_Spliter::*)() const>(&LocOpe_Spliter::ResultingShape),
             R"#(Returns the new shape)#"
             
         )
;

    // Class LocOpe_WiresOnShape from ./opencascade/LocOpe_WiresOnShape.hxx
    klass = m.attr("LocOpe_WiresOnShape");


    // nested enums

    static_cast<py::class_<LocOpe_WiresOnShape ,opencascade::handle<LocOpe_WiresOnShape>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_WiresOnShape::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_WiresOnShape::*)(  const TopoDS_Shape &  ) >(&LocOpe_WiresOnShape::Init),
             R"#()#"  , py::arg("S")
          )
        .def("Add",
             (Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopTools_SequenceOfShape &  ) ) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopTools_SequenceOfShape &  ) >(&LocOpe_WiresOnShape::Add),
             R"#(Add splitting edges or wires for whole initial shape without additional specification edge->face, edge->edge This method puts edge on the corresponding faces from initial shape)#"  , py::arg("theEdges")
          )
        .def("SetCheckInterior",
             (void (LocOpe_WiresOnShape::*)(  const Standard_Boolean  ) ) static_cast<void (LocOpe_WiresOnShape::*)(  const Standard_Boolean  ) >(&LocOpe_WiresOnShape::SetCheckInterior),
             R"#(Set the flag of check internal intersections default value is True (to check))#"  , py::arg("ToCheckInterior")
          )
        .def("Bind",
             (void (LocOpe_WiresOnShape::*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) ) static_cast<void (LocOpe_WiresOnShape::*)(  const TopoDS_Wire & ,   const TopoDS_Face &  ) >(&LocOpe_WiresOnShape::Bind),
             R"#()#"  , py::arg("W"),  py::arg("F")
          )
        .def("Bind",
             (void (LocOpe_WiresOnShape::*)(  const TopoDS_Compound & ,   const TopoDS_Face &  ) ) static_cast<void (LocOpe_WiresOnShape::*)(  const TopoDS_Compound & ,   const TopoDS_Face &  ) >(&LocOpe_WiresOnShape::Bind),
             R"#()#"  , py::arg("Comp"),  py::arg("F")
          )
        .def("Bind",
             (void (LocOpe_WiresOnShape::*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) ) static_cast<void (LocOpe_WiresOnShape::*)(  const TopoDS_Edge & ,   const TopoDS_Face &  ) >(&LocOpe_WiresOnShape::Bind),
             R"#()#"  , py::arg("E"),  py::arg("F")
          )
        .def("Bind",
             (void (LocOpe_WiresOnShape::*)(  const TopoDS_Edge & ,   const TopoDS_Edge &  ) ) static_cast<void (LocOpe_WiresOnShape::*)(  const TopoDS_Edge & ,   const TopoDS_Edge &  ) >(&LocOpe_WiresOnShape::Bind),
             R"#()#"  , py::arg("EfromW"),  py::arg("EonFace")
          )
        .def("BindAll",
             (void (LocOpe_WiresOnShape::*)() ) static_cast<void (LocOpe_WiresOnShape::*)() >(&LocOpe_WiresOnShape::BindAll),
             R"#()#" 
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_WiresOnShape::*)() const) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)() const>(&LocOpe_WiresOnShape::IsDone),
             R"#()#" 
          )
        .def("InitEdgeIterator",
             (void (LocOpe_WiresOnShape::*)() ) static_cast<void (LocOpe_WiresOnShape::*)() >(&LocOpe_WiresOnShape::InitEdgeIterator),
             R"#()#" 
          )
        .def("MoreEdge",
             (Standard_Boolean (LocOpe_WiresOnShape::*)() ) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)() >(&LocOpe_WiresOnShape::MoreEdge),
             R"#()#" 
          )
        .def("Edge",
             (TopoDS_Edge (LocOpe_WiresOnShape::*)() ) static_cast<TopoDS_Edge (LocOpe_WiresOnShape::*)() >(&LocOpe_WiresOnShape::Edge),
             R"#()#" 
          )
        .def("OnFace",
             (TopoDS_Face (LocOpe_WiresOnShape::*)() ) static_cast<TopoDS_Face (LocOpe_WiresOnShape::*)() >(&LocOpe_WiresOnShape::OnFace),
             R"#(Returns the face of the shape on which the current edge is projected.)#" 
          )
        .def("OnEdge",
             (Standard_Boolean (LocOpe_WiresOnShape::*)( TopoDS_Edge &  ) ) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)( TopoDS_Edge &  ) >(&LocOpe_WiresOnShape::OnEdge),
             R"#(If the current edge is projected on an edge, returns <Standard_True> and sets the value of <E>. Otherwise, returns <Standard_False>.)#"  , py::arg("E")
          )
        .def("NextEdge",
             (void (LocOpe_WiresOnShape::*)() ) static_cast<void (LocOpe_WiresOnShape::*)() >(&LocOpe_WiresOnShape::NextEdge),
             R"#()#" 
          )
        .def("OnVertex",
             (Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Vertex & ,  TopoDS_Vertex &  ) ) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Vertex & ,  TopoDS_Vertex &  ) >(&LocOpe_WiresOnShape::OnVertex),
             R"#()#"  , py::arg("Vwire"),  py::arg("Vshape")
          )
        .def("OnEdge",
             (Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Vertex & ,  TopoDS_Edge & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Vertex & ,  TopoDS_Edge & ,  Standard_Real &  ) >(&LocOpe_WiresOnShape::OnEdge),
             R"#(If the vertex <V> lies on an edge of the original shape, returns <Standard_True> and sets the concerned edge in <E>, and the parameter on the edge in <P>. Else returns <Standard_False>.)#"  , py::arg("V"),  py::arg("E"),  py::arg("P")
          )
        .def("OnEdge",
             (Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,  TopoDS_Edge & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Vertex & ,   const TopoDS_Edge & ,  TopoDS_Edge & ,  Standard_Real &  ) >(&LocOpe_WiresOnShape::OnEdge),
             R"#(If the vertex <V> lies on an edge of the original shape, returns <Standard_True> and sets the concerned edge in <E>, and the parameter on the edge in <P>. Else returns <Standard_False>.)#"  , py::arg("V"),  py::arg("EdgeFrom"),  py::arg("E"),  py::arg("P")
          )
        .def("IsFaceWithSection",
             (Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Shape &  ) const>(&LocOpe_WiresOnShape::IsFaceWithSection),
             R"#(tells is the face to be split by section or not)#"  , py::arg("aFace")
          )
        .def("SetCheckInterior",
             (void (LocOpe_WiresOnShape::*)(  const Standard_Boolean  ) ) static_cast<void (LocOpe_WiresOnShape::*)(  const Standard_Boolean  ) >(&LocOpe_WiresOnShape::SetCheckInterior),
             R"#(Set the flag of check internal intersections default value is True (to check))#"  , py::arg("ToCheckInterior")
          )
        .def("IsDone",
             (Standard_Boolean (LocOpe_WiresOnShape::*)() const) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)() const>(&LocOpe_WiresOnShape::IsDone),
             R"#()#" 
          )
        .def("IsFaceWithSection",
             (Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Shape &  ) const) static_cast<Standard_Boolean (LocOpe_WiresOnShape::*)(  const TopoDS_Shape &  ) const>(&LocOpe_WiresOnShape::IsFaceWithSection),
             R"#(tells is the face to be split by section or not)#"  , py::arg("aFace")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&LocOpe_WiresOnShape::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&LocOpe_WiresOnShape::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (LocOpe_WiresOnShape::*)() const) static_cast< const handle<Standard_Type> & (LocOpe_WiresOnShape::*)() const>(&LocOpe_WiresOnShape::DynamicType),
             R"#()#"
             
         )
;

    // Class LocOpe_GluedShape from ./opencascade/LocOpe_GluedShape.hxx
    klass = m.attr("LocOpe_GluedShape");


    // nested enums

    static_cast<py::class_<LocOpe_GluedShape ,opencascade::handle<LocOpe_GluedShape>  , LocOpe_GeneratedShape >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const TopoDS_Shape & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (LocOpe_GluedShape::*)(  const TopoDS_Shape &  ) ) static_cast<void (LocOpe_GluedShape::*)(  const TopoDS_Shape &  ) >(&LocOpe_GluedShape::Init),
             R"#()#"  , py::arg("S")
          )
        .def("GlueOnFace",
             (void (LocOpe_GluedShape::*)(  const TopoDS_Face &  ) ) static_cast<void (LocOpe_GluedShape::*)(  const TopoDS_Face &  ) >(&LocOpe_GluedShape::GlueOnFace),
             R"#()#"  , py::arg("F")
          )
        .def("Generated",
             (TopoDS_Edge (LocOpe_GluedShape::*)(  const TopoDS_Vertex &  ) ) static_cast<TopoDS_Edge (LocOpe_GluedShape::*)(  const TopoDS_Vertex &  ) >(&LocOpe_GluedShape::Generated),
             R"#(Returns the edge created by the vertex <V>. If none, must return a null shape.)#"  , py::arg("V")
          )
        .def("Generated",
             (TopoDS_Face (LocOpe_GluedShape::*)(  const TopoDS_Edge &  ) ) static_cast<TopoDS_Face (LocOpe_GluedShape::*)(  const TopoDS_Edge &  ) >(&LocOpe_GluedShape::Generated),
             R"#(Returns the face created by the edge <E>. If none, must return a null shape.)#"  , py::arg("E")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&LocOpe_GluedShape::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&LocOpe_GluedShape::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GeneratingEdges",
             ( const TopTools_ListOfShape & (LocOpe_GluedShape::*)() ) static_cast< const TopTools_ListOfShape & (LocOpe_GluedShape::*)() >(&LocOpe_GluedShape::GeneratingEdges),
             R"#()#"
             
         )
       .def("OrientedFaces",
             ( const TopTools_ListOfShape & (LocOpe_GluedShape::*)() ) static_cast< const TopTools_ListOfShape & (LocOpe_GluedShape::*)() >(&LocOpe_GluedShape::OrientedFaces),
             R"#(Returns the list of correctly oriented generated faces.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (LocOpe_GluedShape::*)() const) static_cast< const handle<Standard_Type> & (LocOpe_GluedShape::*)() const>(&LocOpe_GluedShape::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/LocOpe.hxx
// ./opencascade/LocOpe_BuildShape.hxx
// ./opencascade/LocOpe_BuildWires.hxx
// ./opencascade/LocOpe_CSIntersector.hxx
// ./opencascade/LocOpe_CurveShapeIntersector.hxx
// ./opencascade/LocOpe_DPrism.hxx
// ./opencascade/LocOpe_DataMapIteratorOfDataMapOfShapePnt.hxx
// ./opencascade/LocOpe_DataMapOfShapePnt.hxx
// ./opencascade/LocOpe_FindEdges.hxx
// ./opencascade/LocOpe_FindEdgesInFace.hxx
// ./opencascade/LocOpe_GeneratedShape.hxx
// ./opencascade/LocOpe_Generator.hxx
// ./opencascade/LocOpe_GluedShape.hxx
// ./opencascade/LocOpe_Gluer.hxx
// ./opencascade/LocOpe_LinearForm.hxx
// ./opencascade/LocOpe_Operation.hxx
// ./opencascade/LocOpe_Pipe.hxx
// ./opencascade/LocOpe_PntFace.hxx
// ./opencascade/LocOpe_Prism.hxx
// ./opencascade/LocOpe_Revol.hxx
// ./opencascade/LocOpe_RevolutionForm.hxx
// ./opencascade/LocOpe_SequenceOfCirc.hxx
// ./opencascade/LocOpe_SequenceOfLin.hxx
// ./opencascade/LocOpe_SequenceOfPntFace.hxx
// ./opencascade/LocOpe_SplitDrafts.hxx
// ./opencascade/LocOpe_SplitShape.hxx
// ./opencascade/LocOpe_Spliter.hxx
// ./opencascade/LocOpe_WiresOnShape.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_DataMap<TopoDS_Shape, gp_Pnt, TopTools_ShapeMapHasher>(m,"LocOpe_DataMapOfShapePnt");
    register_template_NCollection_Sequence<gp_Circ>(m,"LocOpe_SequenceOfCirc");
    register_template_NCollection_Sequence<gp_Lin>(m,"LocOpe_SequenceOfLin");
    register_template_NCollection_Sequence<LocOpe_PntFace>(m,"LocOpe_SequenceOfPntFace");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
