
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDimTolObjects_DatumObject.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDimTolObjects_DimensionObject.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XCAFDimTolObjects_GeomToleranceObject.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <XCAFDimTolObjects_AngularQualifier.hxx>
#include <XCAFDimTolObjects_DataMapOfToleranceDatum.hxx>
#include <XCAFDimTolObjects_DatumModifiersSequence.hxx>
#include <XCAFDimTolObjects_DatumModifWithValue.hxx>
#include <XCAFDimTolObjects_DatumObject.hxx>
#include <XCAFDimTolObjects_DatumObjectSequence.hxx>
#include <XCAFDimTolObjects_DatumSingleModif.hxx>
#include <XCAFDimTolObjects_DatumTargetType.hxx>
#include <XCAFDimTolObjects_DimensionFormVariance.hxx>
#include <XCAFDimTolObjects_DimensionGrade.hxx>
#include <XCAFDimTolObjects_DimensionModif.hxx>
#include <XCAFDimTolObjects_DimensionModifiersSequence.hxx>
#include <XCAFDimTolObjects_DimensionObject.hxx>
#include <XCAFDimTolObjects_DimensionObjectSequence.hxx>
#include <XCAFDimTolObjects_DimensionQualifier.hxx>
#include <XCAFDimTolObjects_DimensionType.hxx>
#include <XCAFDimTolObjects_GeomToleranceMatReqModif.hxx>
#include <XCAFDimTolObjects_GeomToleranceModif.hxx>
#include <XCAFDimTolObjects_GeomToleranceModifiersSequence.hxx>
#include <XCAFDimTolObjects_GeomToleranceObject.hxx>
#include <XCAFDimTolObjects_GeomToleranceObjectSequence.hxx>
#include <XCAFDimTolObjects_GeomToleranceType.hxx>
#include <XCAFDimTolObjects_GeomToleranceTypeValue.hxx>
#include <XCAFDimTolObjects_GeomToleranceZoneModif.hxx>
#include <XCAFDimTolObjects_ToleranceZoneAffectedPlane.hxx>
#include <XCAFDimTolObjects_Tool.hxx>

// template related includes

// ./opencascade/XCAFDimTolObjects_DatumModifiersSequence.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFDimTolObjects_DatumObjectSequence.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFDimTolObjects_DimensionModifiersSequence.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFDimTolObjects_DimensionObjectSequence.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFDimTolObjects_GeomToleranceModifiersSequence.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/XCAFDimTolObjects_GeomToleranceObjectSequence.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XCAFDimTolObjects(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XCAFDimTolObjects"));
py::object klass;

//Python trampoline classes

// classes

    // Class XCAFDimTolObjects_DatumObject from ./opencascade/XCAFDimTolObjects_DatumObject.hxx
    klass = m.attr("XCAFDimTolObjects_DatumObject");


    // nested enums

    static_cast<py::class_<XCAFDimTolObjects_DatumObject ,opencascade::handle<XCAFDimTolObjects_DatumObject>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XCAFDimTolObjects_DatumObject> & >()  , py::arg("theObj") )
    // custom constructors
    // methods
        .def("GetSemanticName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_DatumObject::*)() const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetSemanticName),
             R"#(Returns semantic name)#" 
          )
        .def("SetSemanticName",
             (void (XCAFDimTolObjects_DatumObject::*)(  const handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const handle<TCollection_HAsciiString> &  ) >(&XCAFDimTolObjects_DatumObject::SetSemanticName),
             R"#(Sets semantic name)#"  , py::arg("theName")
          )
        .def("GetName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_DatumObject::*)() const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetName),
             R"#(Returns datum name.)#" 
          )
        .def("SetName",
             (void (XCAFDimTolObjects_DatumObject::*)(  const handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const handle<TCollection_HAsciiString> &  ) >(&XCAFDimTolObjects_DatumObject::SetName),
             R"#(Sets datum name.)#"  , py::arg("theTag")
          )
        .def("GetModifiers",
             (XCAFDimTolObjects_DatumModifiersSequence (XCAFDimTolObjects_DatumObject::*)() const) static_cast<XCAFDimTolObjects_DatumModifiersSequence (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetModifiers),
             R"#(Returns a sequence of modifiers of the datum.)#" 
          )
        .def("SetModifiers",
             (void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumModifiersSequence &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumModifiersSequence &  ) >(&XCAFDimTolObjects_DatumObject::SetModifiers),
             R"#(Sets new sequence of datum modifiers.)#"  , py::arg("theModifiers")
          )
        .def("SetModifierWithValue",
             (void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumModifWithValue ,   const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumModifWithValue ,   const Standard_Real  ) >(&XCAFDimTolObjects_DatumObject::SetModifierWithValue),
             R"#(Sets datum modifier with value.)#"  , py::arg("theModifier"),  py::arg("theValue")
          )
        .def("AddModifier",
             (void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumSingleModif  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumSingleModif  ) >(&XCAFDimTolObjects_DatumObject::AddModifier),
             R"#(Adds a modifier to the datum sequence of modifiers.)#"  , py::arg("theModifier")
          )
        .def("GetDatumTarget",
             (TopoDS_Shape (XCAFDimTolObjects_DatumObject::*)() const) static_cast<TopoDS_Shape (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetDatumTarget),
             R"#(Returns datum target shape.)#" 
          )
        .def("SetDatumTarget",
             (void (XCAFDimTolObjects_DatumObject::*)(  const TopoDS_Shape &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const TopoDS_Shape &  ) >(&XCAFDimTolObjects_DatumObject::SetDatumTarget),
             R"#(Sets datum target shape.)#"  , py::arg("theShape")
          )
        .def("GetPosition",
             (Standard_Integer (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Integer (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetPosition),
             R"#(Returns datum position in the related geometric tolerance object.)#" 
          )
        .def("SetPosition",
             (void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Integer  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Integer  ) >(&XCAFDimTolObjects_DatumObject::SetPosition),
             R"#(Sets datum position in the related geometric tolerance object.)#"  , py::arg("thePosition")
          )
        .def("IsDatumTarget",
             (Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::IsDatumTarget),
             R"#(Returns True if the datum target is specified.)#" 
          )
        .def("IsDatumTarget",
             (void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Boolean  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Boolean  ) >(&XCAFDimTolObjects_DatumObject::IsDatumTarget),
             R"#(Sets or drops the datum target indicator.)#"  , py::arg("theIsDT")
          )
        .def("GetDatumTargetType",
             (XCAFDimTolObjects_DatumTargetType (XCAFDimTolObjects_DatumObject::*)() const) static_cast<XCAFDimTolObjects_DatumTargetType (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetDatumTargetType),
             R"#(Returns datum target type)#" 
          )
        .def("SetDatumTargetType",
             (void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumTargetType  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const XCAFDimTolObjects_DatumTargetType  ) >(&XCAFDimTolObjects_DatumObject::SetDatumTargetType),
             R"#(Sets datum target to point, line, rectangle, circle or area type.)#"  , py::arg("theType")
          )
        .def("GetDatumTargetAxis",
             (gp_Ax2 (XCAFDimTolObjects_DatumObject::*)() const) static_cast<gp_Ax2 (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetDatumTargetAxis),
             R"#(Returns datum target axis. The Z axis of the datum placement denotes the normal of the surface pointing away from the material.)#" 
          )
        .def("SetDatumTargetAxis",
             (void (XCAFDimTolObjects_DatumObject::*)(  const gp_Ax2 &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const gp_Ax2 &  ) >(&XCAFDimTolObjects_DatumObject::SetDatumTargetAxis),
             R"#(Sets datum target axis.)#"  , py::arg("theAxis")
          )
        .def("GetDatumTargetLength",
             (Standard_Real (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetDatumTargetLength),
             R"#(Returns datum target length for line and rectangle types. The length along the X axis of the datum placement.)#" 
          )
        .def("SetDatumTargetLength",
             (void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_DatumObject::SetDatumTargetLength),
             R"#(Sets datum target length.)#"  , py::arg("theLength")
          )
        .def("GetDatumTargetWidth",
             (Standard_Real (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetDatumTargetWidth),
             R"#(Returns datum target width for rectangle type. The width along the derived Y axis, with the placement itself positioned at the centre of the rectangle.)#" 
          )
        .def("SetDatumTargetWidth",
             (void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_DatumObject::SetDatumTargetWidth),
             R"#(Sets datum target width.)#"  , py::arg("theWidth")
          )
        .def("GetDatumTargetNumber",
             (Standard_Integer (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Integer (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetDatumTargetNumber),
             R"#(Returns datum target number.)#" 
          )
        .def("SetDatumTargetNumber",
             (void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Integer  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const Standard_Integer  ) >(&XCAFDimTolObjects_DatumObject::SetDatumTargetNumber),
             R"#(Sets datum target number.)#"  , py::arg("theNumber")
          )
        .def("SetPlane",
             (void (XCAFDimTolObjects_DatumObject::*)(  const gp_Ax2 &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const gp_Ax2 &  ) >(&XCAFDimTolObjects_DatumObject::SetPlane),
             R"#(Sets annotation plane.)#"  , py::arg("thePlane")
          )
        .def("SetPoint",
             (void (XCAFDimTolObjects_DatumObject::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const gp_Pnt &  ) >(&XCAFDimTolObjects_DatumObject::SetPoint),
             R"#(Sets a point on the datum target shape.)#"  , py::arg("thePnt")
          )
        .def("SetPointTextAttach",
             (void (XCAFDimTolObjects_DatumObject::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const gp_Pnt &  ) >(&XCAFDimTolObjects_DatumObject::SetPointTextAttach),
             R"#(Sets a position of the datum text.)#"  , py::arg("thePntText")
          )
        .def("HasPlane",
             (Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::HasPlane),
             R"#(Returns True if the datum has annotation plane.)#" 
          )
        .def("HasPoint",
             (Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::HasPoint),
             R"#(Returns True if point on the datum target is specified.)#" 
          )
        .def("HasPointText",
             (Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::HasPointText),
             R"#(Returns True if the datum text position is specified.)#" 
          )
        .def("SetPresentation",
             (void (XCAFDimTolObjects_DatumObject::*)(  const TopoDS_Shape & ,   const handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDimTolObjects_DatumObject::*)(  const TopoDS_Shape & ,   const handle<TCollection_HAsciiString> &  ) >(&XCAFDimTolObjects_DatumObject::SetPresentation),
             R"#(Set graphical presentation for object.)#"  , py::arg("thePresentation"),  py::arg("thePresentationName")
          )
        .def("GetPresentation",
             (TopoDS_Shape (XCAFDimTolObjects_DatumObject::*)() const) static_cast<TopoDS_Shape (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetPresentation),
             R"#(Returns graphical presentation of the object.)#" 
          )
        .def("GetPresentationName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_DatumObject::*)() const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetPresentationName),
             R"#(Returns graphical presentation of the object.)#" 
          )
        .def("HasDatumTargetParams",
             (Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() ) static_cast<Standard_Boolean (XCAFDimTolObjects_DatumObject::*)() >(&XCAFDimTolObjects_DatumObject::HasDatumTargetParams),
             R"#(Returns True if the datum has valid parameters for datum target (width, length, circle radius etc))#" 
          )
        .def("DumpJson",
             (void (XCAFDimTolObjects_DatumObject::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (XCAFDimTolObjects_DatumObject::*)( Standard_OStream & ,  Standard_Integer  ) const>(&XCAFDimTolObjects_DatumObject::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
        .def("GetModifierWithValue",
             []( XCAFDimTolObjects_DatumObject &self , XCAFDimTolObjects_DatumModifWithValue & theModifier ){
                 Standard_Real  theValue;

                 self.GetModifierWithValue(theModifier,theValue);
                 
                 return std::make_tuple(theValue); },
             R"#(Retrieves datum modifier with value.)#"  , py::arg("theModifier")
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XCAFDimTolObjects_DatumObject::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XCAFDimTolObjects_DatumObject::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetPlane",
             ( const gp_Ax2 & (XCAFDimTolObjects_DatumObject::*)() const) static_cast< const gp_Ax2 & (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetPlane),
             R"#(Returns annotation plane.)#"
             
         )
       .def("GetPoint",
             ( const gp_Pnt & (XCAFDimTolObjects_DatumObject::*)() const) static_cast< const gp_Pnt & (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetPoint),
             R"#(Gets point on the datum shape.)#"
             
         )
       .def("GetPointTextAttach",
             ( const gp_Pnt & (XCAFDimTolObjects_DatumObject::*)() const) static_cast< const gp_Pnt & (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::GetPointTextAttach),
             R"#(Gets datum text position.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (XCAFDimTolObjects_DatumObject::*)() const) static_cast< const handle<Standard_Type> & (XCAFDimTolObjects_DatumObject::*)() const>(&XCAFDimTolObjects_DatumObject::DynamicType),
             R"#()#"
             
         )
;

    // Class XCAFDimTolObjects_DimensionObject from ./opencascade/XCAFDimTolObjects_DimensionObject.hxx
    klass = m.attr("XCAFDimTolObjects_DimensionObject");


    // nested enums

    static_cast<py::class_<XCAFDimTolObjects_DimensionObject ,opencascade::handle<XCAFDimTolObjects_DimensionObject>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XCAFDimTolObjects_DimensionObject> & >()  , py::arg("theObj") )
    // custom constructors
    // methods
        .def("GetSemanticName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetSemanticName),
             R"#(Returns semantic name)#" 
          )
        .def("SetSemanticName",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const handle<TCollection_HAsciiString> &  ) >(&XCAFDimTolObjects_DimensionObject::SetSemanticName),
             R"#(Sets semantic name)#"  , py::arg("theName")
          )
        .def("SetQualifier",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionQualifier  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionQualifier  ) >(&XCAFDimTolObjects_DimensionObject::SetQualifier),
             R"#(Sets dimension qualifier as min., max. or average.)#"  , py::arg("theQualifier")
          )
        .def("GetQualifier",
             (XCAFDimTolObjects_DimensionQualifier (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<XCAFDimTolObjects_DimensionQualifier (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetQualifier),
             R"#(Returns dimension qualifier.)#" 
          )
        .def("HasQualifier",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::HasQualifier),
             R"#(Returns True if the object has dimension qualifier.)#" 
          )
        .def("SetAngularQualifier",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_AngularQualifier  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_AngularQualifier  ) >(&XCAFDimTolObjects_DimensionObject::SetAngularQualifier),
             R"#(Sets angular qualifier as small, large or equal.)#"  , py::arg("theAngularQualifier")
          )
        .def("GetAngularQualifier",
             (XCAFDimTolObjects_AngularQualifier (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<XCAFDimTolObjects_AngularQualifier (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetAngularQualifier),
             R"#(Returns angular qualifier.)#" 
          )
        .def("HasAngularQualifier",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::HasAngularQualifier),
             R"#(Returns True if the object has angular qualifier.)#" 
          )
        .def("SetType",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionType  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionType  ) >(&XCAFDimTolObjects_DimensionObject::SetType),
             R"#(Sets a specific type of dimension.)#"  , py::arg("theTyupe")
          )
        .def("GetType",
             (XCAFDimTolObjects_DimensionType (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<XCAFDimTolObjects_DimensionType (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetType),
             R"#(Returns dimension type.)#" 
          )
        .def("GetValue",
             (Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetValue),
             R"#(Returns the main dimension value. It will be the middle value in case of range dimension.)#" 
          )
        .def("GetValues",
             (handle<TColStd_HArray1OfReal> (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<handle<TColStd_HArray1OfReal> (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetValues),
             R"#(Returns raw array of dimension values)#" 
          )
        .def("SetValue",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_DimensionObject::SetValue),
             R"#(Sets the main dimension value. Overwrites previous values.)#"  , py::arg("theValue")
          )
        .def("SetValues",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const handle<TColStd_HArray1OfReal> &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const handle<TColStd_HArray1OfReal> &  ) >(&XCAFDimTolObjects_DimensionObject::SetValues),
             R"#(Replaces current raw array of dimension values with theValues array.)#"  , py::arg("theValue")
          )
        .def("IsDimWithRange",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::IsDimWithRange),
             R"#(Returns True if the dimension is of range kind. Dimension is of range kind if its values array contains two elements defining lower and upper bounds.)#" 
          )
        .def("SetUpperBound",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_DimensionObject::SetUpperBound),
             R"#(Sets the upper bound of the range dimension, otherwise resets it to an empty range with the specified upper bound.)#"  , py::arg("theUpperBound")
          )
        .def("SetLowerBound",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_DimensionObject::SetLowerBound),
             R"#(Sets the lower bound of the range dimension, otherwise resets it to an empty range with the specified lower bound.)#"  , py::arg("theLowerBound")
          )
        .def("GetUpperBound",
             (Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetUpperBound),
             R"#(Returns the upper bound of the range dimension, otherwise - zero.)#" 
          )
        .def("GetLowerBound",
             (Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetLowerBound),
             R"#(Returns the lower bound of the range dimension, otherwise - zero.)#" 
          )
        .def("IsDimWithPlusMinusTolerance",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::IsDimWithPlusMinusTolerance),
             R"#(Returns True if the dimension is of +/- tolerance kind. Dimension is of +/- tolerance kind if its values array contains three elements defining the main value and the lower/upper tolerances.)#" 
          )
        .def("SetUpperTolValue",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) ) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_DimensionObject::SetUpperTolValue),
             R"#(Sets the upper value of the toleranced dimension, otherwise resets a simple dimension to toleranced one with the specified lower/upper tolerances. Returns False in case of range dimension.)#"  , py::arg("theUperTolValue")
          )
        .def("SetLowerTolValue",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) ) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_DimensionObject::SetLowerTolValue),
             R"#(Sets the lower value of the toleranced dimension, otherwise resets a simple dimension to toleranced one with the specified lower/upper tolerances. Returns False in case of range dimension.)#"  , py::arg("theLowerTolValue")
          )
        .def("GetUpperTolValue",
             (Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetUpperTolValue),
             R"#(Returns the lower value of the toleranced dimension, otherwise - zero.)#" 
          )
        .def("GetLowerTolValue",
             (Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetLowerTolValue),
             R"#(Returns the upper value of the toleranced dimension, otherwise - zero.)#" 
          )
        .def("IsDimWithClassOfTolerance",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::IsDimWithClassOfTolerance),
             R"#(Returns True if the form variance was set to not XCAFDimTolObjects_DimensionFormVariance_None value.)#" 
          )
        .def("SetClassOfTolerance",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Boolean ,   const XCAFDimTolObjects_DimensionFormVariance ,   const XCAFDimTolObjects_DimensionGrade  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Boolean ,   const XCAFDimTolObjects_DimensionFormVariance ,   const XCAFDimTolObjects_DimensionGrade  ) >(&XCAFDimTolObjects_DimensionObject::SetClassOfTolerance),
             R"#(Sets tolerance class of the dimension.)#"  , py::arg("theHole"),  py::arg("theFormVariance"),  py::arg("theGrade")
          )
        .def("GetClassOfTolerance",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)( Standard_Boolean & ,  XCAFDimTolObjects_DimensionFormVariance & ,  XCAFDimTolObjects_DimensionGrade &  ) const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)( Standard_Boolean & ,  XCAFDimTolObjects_DimensionFormVariance & ,  XCAFDimTolObjects_DimensionGrade &  ) const>(&XCAFDimTolObjects_DimensionObject::GetClassOfTolerance),
             R"#(Retrieves tolerance class parameters of the dimension. Returns True if the dimension is toleranced.)#"  , py::arg("theHole"),  py::arg("theFormVariance"),  py::arg("theGrade")
          )
        .def("SetNbOfDecimalPlaces",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer ,   const Standard_Integer  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer ,   const Standard_Integer  ) >(&XCAFDimTolObjects_DimensionObject::SetNbOfDecimalPlaces),
             R"#(Sets the number of places to the left and right of the decimal point respectively.)#"  , py::arg("theL"),  py::arg("theR")
          )
        .def("GetModifiers",
             (XCAFDimTolObjects_DimensionModifiersSequence (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<XCAFDimTolObjects_DimensionModifiersSequence (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetModifiers),
             R"#(Returns a sequence of modifiers of the dimension.)#" 
          )
        .def("SetModifiers",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionModifiersSequence &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionModifiersSequence &  ) >(&XCAFDimTolObjects_DimensionObject::SetModifiers),
             R"#(Sets new sequence of dimension modifiers.)#"  , py::arg("theModifiers")
          )
        .def("AddModifier",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionModif  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const XCAFDimTolObjects_DimensionModif  ) >(&XCAFDimTolObjects_DimensionObject::AddModifier),
             R"#(Adds a modifier to the dimension sequence of modifiers.)#"  , py::arg("theModifier")
          )
        .def("GetPath",
             (TopoDS_Edge (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<TopoDS_Edge (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetPath),
             R"#(Returns a 'curve' along which the dimension is measured.)#" 
          )
        .def("SetPath",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const TopoDS_Edge &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const TopoDS_Edge &  ) >(&XCAFDimTolObjects_DimensionObject::SetPath),
             R"#(Sets a 'curve' along which the dimension is measured.)#"  , py::arg("thePath")
          )
        .def("GetDirection",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)( gp_Dir &  ) const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)( gp_Dir &  ) const>(&XCAFDimTolObjects_DimensionObject::GetDirection),
             R"#(Returns the orientation of the dimension in annotation plane.)#"  , py::arg("theDir")
          )
        .def("SetDirection",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)(  const gp_Dir &  ) ) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)(  const gp_Dir &  ) >(&XCAFDimTolObjects_DimensionObject::SetDirection),
             R"#(Sets an orientation of the dimension in annotation plane.)#"  , py::arg("theDir")
          )
        .def("SetPointTextAttach",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Pnt &  ) >(&XCAFDimTolObjects_DimensionObject::SetPointTextAttach),
             R"#(Sets position of the dimension text.)#"  , py::arg("thePntText")
          )
        .def("HasTextPoint",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::HasTextPoint),
             R"#(Returns True if the position of dimension text is specified.)#" 
          )
        .def("SetPlane",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Ax2 &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Ax2 &  ) >(&XCAFDimTolObjects_DimensionObject::SetPlane),
             R"#(Sets annotation plane.)#"  , py::arg("thePlane")
          )
        .def("HasPlane",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::HasPlane),
             R"#(Returns True if the object has annotation plane.)#" 
          )
        .def("HasPoint",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::HasPoint),
             R"#(Returns true, if connection point exists (for dimensional_size), if connection point for the first shape exists (for dimensional_location).)#" 
          )
        .def("HasPoint2",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::HasPoint2),
             R"#()#" 
          )
        .def("SetPoint",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Pnt &  ) >(&XCAFDimTolObjects_DimensionObject::SetPoint),
             R"#(Set connection point (for dimensional_size), Set connection point for the first shape (for dimensional_location).)#"  , py::arg("thePnt")
          )
        .def("SetPoint2",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const gp_Pnt &  ) >(&XCAFDimTolObjects_DimensionObject::SetPoint2),
             R"#()#"  , py::arg("thePnt")
          )
        .def("GetPoint",
             (gp_Pnt (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<gp_Pnt (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetPoint),
             R"#(Get connection point (for dimensional_size), Get connection point for the first shape (for dimensional_location).)#" 
          )
        .def("GetPoint2",
             (gp_Pnt (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<gp_Pnt (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetPoint2),
             R"#()#" 
          )
        .def("SetPresentation",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const TopoDS_Shape & ,   const handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const TopoDS_Shape & ,   const handle<TCollection_HAsciiString> &  ) >(&XCAFDimTolObjects_DimensionObject::SetPresentation),
             R"#(Set graphical presentation for the object.)#"  , py::arg("thePresentation"),  py::arg("thePresentationName")
          )
        .def("GetPresentation",
             (TopoDS_Shape (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<TopoDS_Shape (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetPresentation),
             R"#(Returns graphical presentation of the object.)#" 
          )
        .def("GetPresentationName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetPresentationName),
             R"#(Returns graphical presentation of the object)#" 
          )
        .def("HasDescriptions",
             (Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::HasDescriptions),
             R"#(Returns true, if the object has descriptions.)#" 
          )
        .def("NbDescriptions",
             (Standard_Integer (XCAFDimTolObjects_DimensionObject::*)() const) static_cast<Standard_Integer (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::NbDescriptions),
             R"#(Returns number of descriptions.)#" 
          )
        .def("GetDescription",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer  ) const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer  ) const>(&XCAFDimTolObjects_DimensionObject::GetDescription),
             R"#(Returns description with the given number.)#"  , py::arg("theNumber")
          )
        .def("GetDescriptionName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer  ) const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer  ) const>(&XCAFDimTolObjects_DimensionObject::GetDescriptionName),
             R"#(Returns name of description with the given number.)#"  , py::arg("theNumber")
          )
        .def("RemoveDescription",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const Standard_Integer  ) >(&XCAFDimTolObjects_DimensionObject::RemoveDescription),
             R"#(Remove description with the given number.)#"  , py::arg("theNumber")
          )
        .def("AddDescription",
             (void (XCAFDimTolObjects_DimensionObject::*)(  const handle<TCollection_HAsciiString> ,   const handle<TCollection_HAsciiString>  ) ) static_cast<void (XCAFDimTolObjects_DimensionObject::*)(  const handle<TCollection_HAsciiString> ,   const handle<TCollection_HAsciiString>  ) >(&XCAFDimTolObjects_DimensionObject::AddDescription),
             R"#(Add new description.)#"  , py::arg("theDescription"),  py::arg("theName")
          )
        .def("DumpJson",
             (void (XCAFDimTolObjects_DimensionObject::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (XCAFDimTolObjects_DimensionObject::*)( Standard_OStream & ,  Standard_Integer  ) const>(&XCAFDimTolObjects_DimensionObject::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
        .def("GetNbOfDecimalPlaces",
             []( XCAFDimTolObjects_DimensionObject &self   ){
                 Standard_Integer  theL;
                Standard_Integer  theR;

                 self.GetNbOfDecimalPlaces(theL,theR);
                 
                 return std::make_tuple(theL,theR); },
             R"#(Returns the number of places to the left and right of the decimal point respectively.)#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XCAFDimTolObjects_DimensionObject::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XCAFDimTolObjects_DimensionObject::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetPointTextAttach",
             ( const gp_Pnt & (XCAFDimTolObjects_DimensionObject::*)() const) static_cast< const gp_Pnt & (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetPointTextAttach),
             R"#(Returns position of the dimension text.)#"
             
         )
       .def("GetPlane",
             ( const gp_Ax2 & (XCAFDimTolObjects_DimensionObject::*)() const) static_cast< const gp_Ax2 & (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::GetPlane),
             R"#(Returns annotation plane.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (XCAFDimTolObjects_DimensionObject::*)() const) static_cast< const handle<Standard_Type> & (XCAFDimTolObjects_DimensionObject::*)() const>(&XCAFDimTolObjects_DimensionObject::DynamicType),
             R"#()#"
             
         )
;

    // Class XCAFDimTolObjects_GeomToleranceObject from ./opencascade/XCAFDimTolObjects_GeomToleranceObject.hxx
    klass = m.attr("XCAFDimTolObjects_GeomToleranceObject");


    // nested enums

    static_cast<py::class_<XCAFDimTolObjects_GeomToleranceObject ,opencascade::handle<XCAFDimTolObjects_GeomToleranceObject>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init<  const handle<XCAFDimTolObjects_GeomToleranceObject> & >()  , py::arg("theObj") )
    // custom constructors
    // methods
        .def("GetSemanticName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetSemanticName),
             R"#(Returns semantic name)#" 
          )
        .def("SetSemanticName",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const handle<TCollection_HAsciiString> &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetSemanticName),
             R"#(Sets semantic name)#"  , py::arg("theName")
          )
        .def("SetType",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceType  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceType  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetType),
             R"#(Sets type of the object.)#"  , py::arg("theType")
          )
        .def("GetType",
             (XCAFDimTolObjects_GeomToleranceType (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<XCAFDimTolObjects_GeomToleranceType (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetType),
             R"#(Returns type of the object.)#" 
          )
        .def("SetTypeOfValue",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceTypeValue  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceTypeValue  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetTypeOfValue),
             R"#(Sets type of tolerance value.)#"  , py::arg("theTypeOfValue")
          )
        .def("GetTypeOfValue",
             (XCAFDimTolObjects_GeomToleranceTypeValue (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<XCAFDimTolObjects_GeomToleranceTypeValue (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetTypeOfValue),
             R"#(Returns type of tolerance value.)#" 
          )
        .def("SetValue",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetValue),
             R"#(Sets tolerance value.)#"  , py::arg("theValue")
          )
        .def("GetValue",
             (Standard_Real (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetValue),
             R"#(Returns tolerance value.)#" 
          )
        .def("SetMaterialRequirementModifier",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceMatReqModif  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceMatReqModif  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetMaterialRequirementModifier),
             R"#(Sets material requirement of the tolerance.)#"  , py::arg("theMatReqModif")
          )
        .def("GetMaterialRequirementModifier",
             (XCAFDimTolObjects_GeomToleranceMatReqModif (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<XCAFDimTolObjects_GeomToleranceMatReqModif (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetMaterialRequirementModifier),
             R"#(Returns material requirement of the tolerance.)#" 
          )
        .def("SetZoneModifier",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceZoneModif  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceZoneModif  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetZoneModifier),
             R"#(Sets tolerance zone.)#"  , py::arg("theZoneModif")
          )
        .def("GetZoneModifier",
             (XCAFDimTolObjects_GeomToleranceZoneModif (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<XCAFDimTolObjects_GeomToleranceZoneModif (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetZoneModifier),
             R"#(Returns tolerance zone.)#" 
          )
        .def("SetValueOfZoneModifier",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetValueOfZoneModifier),
             R"#(Sets value associated with tolerance zone.)#"  , py::arg("theValue")
          )
        .def("GetValueOfZoneModifier",
             (Standard_Real (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetValueOfZoneModifier),
             R"#(Returns value associated with tolerance zone.)#" 
          )
        .def("SetModifiers",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceModifiersSequence &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceModifiersSequence &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetModifiers),
             R"#(Sets new sequence of tolerance modifiers.)#"  , py::arg("theModifiers")
          )
        .def("AddModifier",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceModif  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_GeomToleranceModif  ) >(&XCAFDimTolObjects_GeomToleranceObject::AddModifier),
             R"#(Adds a tolerance modifier to the sequence of modifiers.)#"  , py::arg("theModifier")
          )
        .def("GetModifiers",
             (XCAFDimTolObjects_GeomToleranceModifiersSequence (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<XCAFDimTolObjects_GeomToleranceModifiersSequence (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetModifiers),
             R"#(Returns a sequence of modifiers of the tolerance.)#" 
          )
        .def("SetMaxValueModifier",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const Standard_Real  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const Standard_Real  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetMaxValueModifier),
             R"#(Sets the maximal upper tolerance value for tolerance with modifiers.)#"  , py::arg("theModifier")
          )
        .def("GetMaxValueModifier",
             (Standard_Real (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<Standard_Real (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetMaxValueModifier),
             R"#(Returns the maximal upper tolerance.)#" 
          )
        .def("SetAxis",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Ax2 &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Ax2 &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetAxis),
             R"#()#"  , py::arg("theAxis")
          )
        .def("GetAxis",
             (gp_Ax2 (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<gp_Ax2 (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetAxis),
             R"#()#" 
          )
        .def("HasAxis",
             (Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::HasAxis),
             R"#()#" 
          )
        .def("SetPlane",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Ax2 &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Ax2 &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetPlane),
             R"#(Sets annotation plane.)#"  , py::arg("thePlane")
          )
        .def("SetPoint",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pnt &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetPoint),
             R"#(Sets reference point.)#"  , py::arg("thePnt")
          )
        .def("SetPointTextAttach",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pnt &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pnt &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetPointTextAttach),
             R"#(Sets text position.)#"  , py::arg("thePntText")
          )
        .def("HasPlane",
             (Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::HasPlane),
             R"#(Returns True if the object has annotation plane.)#" 
          )
        .def("HasPoint",
             (Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::HasPoint),
             R"#(Returns True if reference point is specified.)#" 
          )
        .def("HasPointText",
             (Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<Standard_Boolean (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::HasPointText),
             R"#(Returns True if text position is specified.)#" 
          )
        .def("SetPresentation",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const TopoDS_Shape & ,   const handle<TCollection_HAsciiString> &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const TopoDS_Shape & ,   const handle<TCollection_HAsciiString> &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetPresentation),
             R"#(Set graphical presentation for object.)#"  , py::arg("thePresentation"),  py::arg("thePresentationName")
          )
        .def("GetPresentation",
             (TopoDS_Shape (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<TopoDS_Shape (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetPresentation),
             R"#(Returns graphical presentation of the object.)#" 
          )
        .def("GetPresentationName",
             (handle<TCollection_HAsciiString> (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<handle<TCollection_HAsciiString> (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetPresentationName),
             R"#(Returns graphical presentation of the object.)#" 
          )
        .def("HasAffectedPlane",
             (bool (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<bool (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::HasAffectedPlane),
             R"#()#" 
          )
        .def("GetAffectedPlaneType",
             (XCAFDimTolObjects_ToleranceZoneAffectedPlane (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast<XCAFDimTolObjects_ToleranceZoneAffectedPlane (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetAffectedPlaneType),
             R"#()#" 
          )
        .def("SetAffectedPlaneType",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_ToleranceZoneAffectedPlane  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const XCAFDimTolObjects_ToleranceZoneAffectedPlane  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetAffectedPlaneType),
             R"#()#"  , py::arg("theType")
          )
        .def("SetAffectedPlane",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pln &  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pln &  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetAffectedPlane),
             R"#(Sets affected plane.)#"  , py::arg("thePlane")
          )
        .def("SetAffectedPlane",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pln & ,   const XCAFDimTolObjects_ToleranceZoneAffectedPlane  ) ) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)(  const gp_Pln & ,   const XCAFDimTolObjects_ToleranceZoneAffectedPlane  ) >(&XCAFDimTolObjects_GeomToleranceObject::SetAffectedPlane),
             R"#(Sets affected plane.)#"  , py::arg("thePlane"),  py::arg("theType")
          )
        .def("DumpJson",
             (void (XCAFDimTolObjects_GeomToleranceObject::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (XCAFDimTolObjects_GeomToleranceObject::*)( Standard_OStream & ,  Standard_Integer  ) const>(&XCAFDimTolObjects_GeomToleranceObject::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&XCAFDimTolObjects_GeomToleranceObject::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&XCAFDimTolObjects_GeomToleranceObject::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetPlane",
             ( const gp_Ax2 & (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast< const gp_Ax2 & (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetPlane),
             R"#(Returns annotation plane.)#"
             
         )
       .def("GetPoint",
             ( const gp_Pnt & (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast< const gp_Pnt & (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetPoint),
             R"#(Returns reference point.)#"
             
         )
       .def("GetPointTextAttach",
             ( const gp_Pnt & (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast< const gp_Pnt & (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetPointTextAttach),
             R"#(Returns the text position.)#"
             
         )
       .def("GetAffectedPlane",
             ( const gp_Pln & (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast< const gp_Pln & (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::GetAffectedPlane),
             R"#(Returns affected plane.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (XCAFDimTolObjects_GeomToleranceObject::*)() const) static_cast< const handle<Standard_Type> & (XCAFDimTolObjects_GeomToleranceObject::*)() const>(&XCAFDimTolObjects_GeomToleranceObject::DynamicType),
             R"#()#"
             
         )
;

    // Class XCAFDimTolObjects_Tool from ./opencascade/XCAFDimTolObjects_Tool.hxx
    klass = m.attr("XCAFDimTolObjects_Tool");


    // nested enums

    static_cast<py::class_<XCAFDimTolObjects_Tool , shared_ptr<XCAFDimTolObjects_Tool>  >>(klass)
    // constructors
        .def(py::init<  const handle<TDocStd_Document> & >()  , py::arg("theDoc") )
    // custom constructors
    // methods
        .def("GetDimensions",
             (void (XCAFDimTolObjects_Tool::*)( XCAFDimTolObjects_DimensionObjectSequence &  ) const) static_cast<void (XCAFDimTolObjects_Tool::*)( XCAFDimTolObjects_DimensionObjectSequence &  ) const>(&XCAFDimTolObjects_Tool::GetDimensions),
             R"#(Returns a sequence of Dimensions currently stored in the GD&T table)#"  , py::arg("theDimensionObjectSequence")
          )
        .def("GetRefDimensions",
             (Standard_Boolean (XCAFDimTolObjects_Tool::*)(  const TopoDS_Shape & ,  XCAFDimTolObjects_DimensionObjectSequence &  ) const) static_cast<Standard_Boolean (XCAFDimTolObjects_Tool::*)(  const TopoDS_Shape & ,  XCAFDimTolObjects_DimensionObjectSequence &  ) const>(&XCAFDimTolObjects_Tool::GetRefDimensions),
             R"#(Returns all Dimensions defined for Shape)#"  , py::arg("theShape"),  py::arg("theDimensions")
          )
        .def("GetGeomTolerances",
             (void (XCAFDimTolObjects_Tool::*)( XCAFDimTolObjects_GeomToleranceObjectSequence & ,  XCAFDimTolObjects_DatumObjectSequence & ,  XCAFDimTolObjects_DataMapOfToleranceDatum &  ) const) static_cast<void (XCAFDimTolObjects_Tool::*)( XCAFDimTolObjects_GeomToleranceObjectSequence & ,  XCAFDimTolObjects_DatumObjectSequence & ,  XCAFDimTolObjects_DataMapOfToleranceDatum &  ) const>(&XCAFDimTolObjects_Tool::GetGeomTolerances),
             R"#(Returns a sequence of Tolerances currently stored in the GD&T table)#"  , py::arg("theGeomToleranceObjectSequence"),  py::arg("theDatumObjectSequence"),  py::arg("theMap")
          )
        .def("GetRefGeomTolerances",
             (Standard_Boolean (XCAFDimTolObjects_Tool::*)(  const TopoDS_Shape & ,  XCAFDimTolObjects_GeomToleranceObjectSequence & ,  XCAFDimTolObjects_DatumObjectSequence & ,  XCAFDimTolObjects_DataMapOfToleranceDatum &  ) const) static_cast<Standard_Boolean (XCAFDimTolObjects_Tool::*)(  const TopoDS_Shape & ,  XCAFDimTolObjects_GeomToleranceObjectSequence & ,  XCAFDimTolObjects_DatumObjectSequence & ,  XCAFDimTolObjects_DataMapOfToleranceDatum &  ) const>(&XCAFDimTolObjects_Tool::GetRefGeomTolerances),
             R"#(Returns all GeomTolerances defined for Shape)#"  , py::arg("theShape"),  py::arg("theGeomToleranceObjectSequence"),  py::arg("theDatumObjectSequence"),  py::arg("theMap")
          )
        .def("GetRefDatum",
             (Standard_Boolean (XCAFDimTolObjects_Tool::*)(  const TopoDS_Shape & ,  handle<XCAFDimTolObjects_DatumObject> &  ) const) static_cast<Standard_Boolean (XCAFDimTolObjects_Tool::*)(  const TopoDS_Shape & ,  handle<XCAFDimTolObjects_DatumObject> &  ) const>(&XCAFDimTolObjects_Tool::GetRefDatum),
             R"#(Returns DatumObject defined for Shape)#"  , py::arg("theShape"),  py::arg("theDatum")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/XCAFDimTolObjects_AngularQualifier.hxx
// ./opencascade/XCAFDimTolObjects_DataMapOfToleranceDatum.hxx
// ./opencascade/XCAFDimTolObjects_DatumModifWithValue.hxx
// ./opencascade/XCAFDimTolObjects_DatumModifiersSequence.hxx
// ./opencascade/XCAFDimTolObjects_DatumObject.hxx
// ./opencascade/XCAFDimTolObjects_DatumObjectSequence.hxx
// ./opencascade/XCAFDimTolObjects_DatumSingleModif.hxx
// ./opencascade/XCAFDimTolObjects_DatumTargetType.hxx
// ./opencascade/XCAFDimTolObjects_DimensionFormVariance.hxx
// ./opencascade/XCAFDimTolObjects_DimensionGrade.hxx
// ./opencascade/XCAFDimTolObjects_DimensionModif.hxx
// ./opencascade/XCAFDimTolObjects_DimensionModifiersSequence.hxx
// ./opencascade/XCAFDimTolObjects_DimensionObject.hxx
// ./opencascade/XCAFDimTolObjects_DimensionObjectSequence.hxx
// ./opencascade/XCAFDimTolObjects_DimensionQualifier.hxx
// ./opencascade/XCAFDimTolObjects_DimensionType.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceMatReqModif.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceModif.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceModifiersSequence.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceObject.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceObjectSequence.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceType.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceTypeValue.hxx
// ./opencascade/XCAFDimTolObjects_GeomToleranceZoneModif.hxx
// ./opencascade/XCAFDimTolObjects_ToleranceZoneAffectedPlane.hxx
// ./opencascade/XCAFDimTolObjects_Tool.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_Sequence<XCAFDimTolObjects_DatumSingleModif>(m,"XCAFDimTolObjects_DatumModifiersSequence");
    register_template_NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DatumObject>>(m,"XCAFDimTolObjects_DatumObjectSequence");
    register_template_NCollection_Sequence<XCAFDimTolObjects_DimensionModif>(m,"XCAFDimTolObjects_DimensionModifiersSequence");
    register_template_NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_DimensionObject>>(m,"XCAFDimTolObjects_DimensionObjectSequence");
    register_template_NCollection_Sequence<XCAFDimTolObjects_GeomToleranceModif>(m,"XCAFDimTolObjects_GeomToleranceModifiersSequence");
    register_template_NCollection_Sequence<opencascade::handle<XCAFDimTolObjects_GeomToleranceObject>>(m,"XCAFDimTolObjects_GeomToleranceObjectSequence");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
