# frozen_string_literal: true

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/dsl.rb.erb
if you are looking to modify the template
=end

module Prism
  # The DSL module provides a set of methods that can be used to create prism
  # nodes in a more concise manner. For example, instead of writing:
  #
  #     source = Prism::Source.for("[1]")
  #
  #     Prism::ArrayNode.new(
  #       source,
  #       0,
  #       Prism::Location.new(source, 0, 3),
  #       0,
  #       [
  #         Prism::IntegerNode.new(
  #           source,
  #           0,
  #           Prism::Location.new(source, 1, 1),
  #           Prism::IntegerBaseFlags::DECIMAL,
  #           1
  #         )
  #       ],
  #       Prism::Location.new(source, 0, 1),
  #       Prism::Location.new(source, 2, 1)
  #     )
  #
  # you could instead write:
  #
  #     class Builder
  #       include Prism::DSL
  #
  #       attr_reader :default_source
  #
  #       def initialize
  #         @default_source = source("[1]")
  #       end
  #
  #       def build
  #         array_node(
  #           location: location(start_offset: 0, length: 3),
  #           elements: [
  #             integer_node(
  #               location: location(start_offset: 1, length: 1),
  #               flags: integer_base_flag(:decimal),
  #               value: 1
  #             )
  #           ],
  #           opening_loc: location(start_offset: 0, length: 1),
  #           closing_loc: location(start_offset: 2, length: 1)
  #         )
  #       end
  #     end
  #
  # This is mostly helpful in the context of generating trees programmatically.
  module DSL
    # Provide all of these methods as module methods as well, to allow for
    # building nodes like Prism::DSL.nil_node.
    extend self

    # Create a new Source object.
    def source(string)
      Source.for(string)
    end

    # Create a new Location object.
    def location(source: default_source, start_offset: 0, length: 0)
      Location.new(source, start_offset, length)
    end

    # Create a new AliasGlobalVariableNode node.
    def alias_global_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, new_name: global_variable_read_node(source: source), old_name: global_variable_read_node(source: source), keyword_loc: location)
      AliasGlobalVariableNode.new(source, node_id, location, flags, new_name, old_name, keyword_loc)
    end

    # Create a new AliasMethodNode node.
    def alias_method_node(source: default_source, node_id: 0, location: default_location, flags: 0, new_name: symbol_node(source: source), old_name: symbol_node(source: source), keyword_loc: location)
      AliasMethodNode.new(source, node_id, location, flags, new_name, old_name, keyword_loc)
    end

    # Create a new AlternationPatternNode node.
    def alternation_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: default_node(source, location), right: default_node(source, location), operator_loc: location)
      AlternationPatternNode.new(source, node_id, location, flags, left, right, operator_loc)
    end

    # Create a new AndNode node.
    def and_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: default_node(source, location), right: default_node(source, location), operator_loc: location)
      AndNode.new(source, node_id, location, flags, left, right, operator_loc)
    end

    # Create a new ArgumentsNode node.
    def arguments_node(source: default_source, node_id: 0, location: default_location, flags: 0, arguments: [])
      ArgumentsNode.new(source, node_id, location, flags, arguments)
    end

    # Create a new ArrayNode node.
    def array_node(source: default_source, node_id: 0, location: default_location, flags: 0, elements: [], opening_loc: nil, closing_loc: nil)
      ArrayNode.new(source, node_id, location, flags, elements, opening_loc, closing_loc)
    end

    # Create a new ArrayPatternNode node.
    def array_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, constant: nil, requireds: [], rest: nil, posts: [], opening_loc: nil, closing_loc: nil)
      ArrayPatternNode.new(source, node_id, location, flags, constant, requireds, rest, posts, opening_loc, closing_loc)
    end

    # Create a new AssocNode node.
    def assoc_node(source: default_source, node_id: 0, location: default_location, flags: 0, key: default_node(source, location), value: default_node(source, location), operator_loc: nil)
      AssocNode.new(source, node_id, location, flags, key, value, operator_loc)
    end

    # Create a new AssocSplatNode node.
    def assoc_splat_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: nil, operator_loc: location)
      AssocSplatNode.new(source, node_id, location, flags, value, operator_loc)
    end

    # Create a new BackReferenceReadNode node.
    def back_reference_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      BackReferenceReadNode.new(source, node_id, location, flags, name)
    end

    # Create a new BeginNode node.
    def begin_node(source: default_source, node_id: 0, location: default_location, flags: 0, begin_keyword_loc: nil, statements: nil, rescue_clause: nil, else_clause: nil, ensure_clause: nil, end_keyword_loc: nil)
      BeginNode.new(source, node_id, location, flags, begin_keyword_loc, statements, rescue_clause, else_clause, ensure_clause, end_keyword_loc)
    end

    # Create a new BlockArgumentNode node.
    def block_argument_node(source: default_source, node_id: 0, location: default_location, flags: 0, expression: nil, operator_loc: location)
      BlockArgumentNode.new(source, node_id, location, flags, expression, operator_loc)
    end

    # Create a new BlockLocalVariableNode node.
    def block_local_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      BlockLocalVariableNode.new(source, node_id, location, flags, name)
    end

    # Create a new BlockNode node.
    def block_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], parameters: nil, body: nil, opening_loc: location, closing_loc: location)
      BlockNode.new(source, node_id, location, flags, locals, parameters, body, opening_loc, closing_loc)
    end

    # Create a new BlockParameterNode node.
    def block_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: nil, name_loc: nil, operator_loc: location)
      BlockParameterNode.new(source, node_id, location, flags, name, name_loc, operator_loc)
    end

    # Create a new BlockParametersNode node.
    def block_parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0, parameters: nil, locals: [], opening_loc: nil, closing_loc: nil)
      BlockParametersNode.new(source, node_id, location, flags, parameters, locals, opening_loc, closing_loc)
    end

    # Create a new BreakNode node.
    def break_node(source: default_source, node_id: 0, location: default_location, flags: 0, arguments: nil, keyword_loc: location)
      BreakNode.new(source, node_id, location, flags, arguments, keyword_loc)
    end

    # Create a new CallAndWriteNode node.
    def call_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, message_loc: nil, read_name: :"", write_name: :"", operator_loc: location, value: default_node(source, location))
      CallAndWriteNode.new(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value)
    end

    # Create a new CallNode node.
    def call_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, name: :"", message_loc: nil, opening_loc: nil, arguments: nil, closing_loc: nil, block: nil)
      CallNode.new(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc, opening_loc, arguments, closing_loc, block)
    end

    # Create a new CallOperatorWriteNode node.
    def call_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, message_loc: nil, read_name: :"", write_name: :"", binary_operator: :"", binary_operator_loc: location, value: default_node(source, location))
      CallOperatorWriteNode.new(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, binary_operator, binary_operator_loc, value)
    end

    # Create a new CallOrWriteNode node.
    def call_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, message_loc: nil, read_name: :"", write_name: :"", operator_loc: location, value: default_node(source, location))
      CallOrWriteNode.new(source, node_id, location, flags, receiver, call_operator_loc, message_loc, read_name, write_name, operator_loc, value)
    end

    # Create a new CallTargetNode node.
    def call_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: default_node(source, location), call_operator_loc: location, name: :"", message_loc: location)
      CallTargetNode.new(source, node_id, location, flags, receiver, call_operator_loc, name, message_loc)
    end

    # Create a new CapturePatternNode node.
    def capture_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: default_node(source, location), target: local_variable_target_node(source: source), operator_loc: location)
      CapturePatternNode.new(source, node_id, location, flags, value, target, operator_loc)
    end

    # Create a new CaseMatchNode node.
    def case_match_node(source: default_source, node_id: 0, location: default_location, flags: 0, predicate: nil, conditions: [], else_clause: nil, case_keyword_loc: location, end_keyword_loc: location)
      CaseMatchNode.new(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc)
    end

    # Create a new CaseNode node.
    def case_node(source: default_source, node_id: 0, location: default_location, flags: 0, predicate: nil, conditions: [], else_clause: nil, case_keyword_loc: location, end_keyword_loc: location)
      CaseNode.new(source, node_id, location, flags, predicate, conditions, else_clause, case_keyword_loc, end_keyword_loc)
    end

    # Create a new ClassNode node.
    def class_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], class_keyword_loc: location, constant_path: constant_read_node(source: source), inheritance_operator_loc: nil, superclass: nil, body: nil, end_keyword_loc: location, name: :"")
      ClassNode.new(source, node_id, location, flags, locals, class_keyword_loc, constant_path, inheritance_operator_loc, superclass, body, end_keyword_loc, name)
    end

    # Create a new ClassVariableAndWriteNode node.
    def class_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      ClassVariableAndWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new ClassVariableOperatorWriteNode node.
    def class_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :"")
      ClassVariableOperatorWriteNode.new(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator)
    end

    # Create a new ClassVariableOrWriteNode node.
    def class_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      ClassVariableOrWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new ClassVariableReadNode node.
    def class_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      ClassVariableReadNode.new(source, node_id, location, flags, name)
    end

    # Create a new ClassVariableTargetNode node.
    def class_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      ClassVariableTargetNode.new(source, node_id, location, flags, name)
    end

    # Create a new ClassVariableWriteNode node.
    def class_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location)
      ClassVariableWriteNode.new(source, node_id, location, flags, name, name_loc, value, operator_loc)
    end

    # Create a new ConstantAndWriteNode node.
    def constant_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      ConstantAndWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new ConstantOperatorWriteNode node.
    def constant_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :"")
      ConstantOperatorWriteNode.new(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator)
    end

    # Create a new ConstantOrWriteNode node.
    def constant_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      ConstantOrWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new ConstantPathAndWriteNode node.
    def constant_path_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), operator_loc: location, value: default_node(source, location))
      ConstantPathAndWriteNode.new(source, node_id, location, flags, target, operator_loc, value)
    end

    # Create a new ConstantPathNode node.
    def constant_path_node(source: default_source, node_id: 0, location: default_location, flags: 0, parent: nil, name: nil, delimiter_loc: location, name_loc: location)
      ConstantPathNode.new(source, node_id, location, flags, parent, name, delimiter_loc, name_loc)
    end

    # Create a new ConstantPathOperatorWriteNode node.
    def constant_path_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), binary_operator_loc: location, value: default_node(source, location), binary_operator: :"")
      ConstantPathOperatorWriteNode.new(source, node_id, location, flags, target, binary_operator_loc, value, binary_operator)
    end

    # Create a new ConstantPathOrWriteNode node.
    def constant_path_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), operator_loc: location, value: default_node(source, location))
      ConstantPathOrWriteNode.new(source, node_id, location, flags, target, operator_loc, value)
    end

    # Create a new ConstantPathTargetNode node.
    def constant_path_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, parent: nil, name: nil, delimiter_loc: location, name_loc: location)
      ConstantPathTargetNode.new(source, node_id, location, flags, parent, name, delimiter_loc, name_loc)
    end

    # Create a new ConstantPathWriteNode node.
    def constant_path_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), operator_loc: location, value: default_node(source, location))
      ConstantPathWriteNode.new(source, node_id, location, flags, target, operator_loc, value)
    end

    # Create a new ConstantReadNode node.
    def constant_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      ConstantReadNode.new(source, node_id, location, flags, name)
    end

    # Create a new ConstantTargetNode node.
    def constant_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      ConstantTargetNode.new(source, node_id, location, flags, name)
    end

    # Create a new ConstantWriteNode node.
    def constant_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location)
      ConstantWriteNode.new(source, node_id, location, flags, name, name_loc, value, operator_loc)
    end

    # Create a new DefNode node.
    def def_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, receiver: nil, parameters: nil, body: nil, locals: [], def_keyword_loc: location, operator_loc: nil, lparen_loc: nil, rparen_loc: nil, equal_loc: nil, end_keyword_loc: nil)
      DefNode.new(source, node_id, location, flags, name, name_loc, receiver, parameters, body, locals, def_keyword_loc, operator_loc, lparen_loc, rparen_loc, equal_loc, end_keyword_loc)
    end

    # Create a new DefinedNode node.
    def defined_node(source: default_source, node_id: 0, location: default_location, flags: 0, lparen_loc: nil, value: default_node(source, location), rparen_loc: nil, keyword_loc: location)
      DefinedNode.new(source, node_id, location, flags, lparen_loc, value, rparen_loc, keyword_loc)
    end

    # Create a new ElseNode node.
    def else_node(source: default_source, node_id: 0, location: default_location, flags: 0, else_keyword_loc: location, statements: nil, end_keyword_loc: nil)
      ElseNode.new(source, node_id, location, flags, else_keyword_loc, statements, end_keyword_loc)
    end

    # Create a new EmbeddedStatementsNode node.
    def embedded_statements_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, statements: nil, closing_loc: location)
      EmbeddedStatementsNode.new(source, node_id, location, flags, opening_loc, statements, closing_loc)
    end

    # Create a new EmbeddedVariableNode node.
    def embedded_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, operator_loc: location, variable: instance_variable_read_node(source: source))
      EmbeddedVariableNode.new(source, node_id, location, flags, operator_loc, variable)
    end

    # Create a new EnsureNode node.
    def ensure_node(source: default_source, node_id: 0, location: default_location, flags: 0, ensure_keyword_loc: location, statements: nil, end_keyword_loc: location)
      EnsureNode.new(source, node_id, location, flags, ensure_keyword_loc, statements, end_keyword_loc)
    end

    # Create a new FalseNode node.
    def false_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      FalseNode.new(source, node_id, location, flags)
    end

    # Create a new FindPatternNode node.
    def find_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, constant: nil, left: splat_node(source: source), requireds: [], right: splat_node(source: source), opening_loc: nil, closing_loc: nil)
      FindPatternNode.new(source, node_id, location, flags, constant, left, requireds, right, opening_loc, closing_loc)
    end

    # Create a new FlipFlopNode node.
    def flip_flop_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: nil, right: nil, operator_loc: location)
      FlipFlopNode.new(source, node_id, location, flags, left, right, operator_loc)
    end

    # Create a new FloatNode node.
    def float_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: 0.0)
      FloatNode.new(source, node_id, location, flags, value)
    end

    # Create a new ForNode node.
    def for_node(source: default_source, node_id: 0, location: default_location, flags: 0, index: local_variable_target_node(source: source), collection: default_node(source, location), statements: nil, for_keyword_loc: location, in_keyword_loc: location, do_keyword_loc: nil, end_keyword_loc: location)
      ForNode.new(source, node_id, location, flags, index, collection, statements, for_keyword_loc, in_keyword_loc, do_keyword_loc, end_keyword_loc)
    end

    # Create a new ForwardingArgumentsNode node.
    def forwarding_arguments_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      ForwardingArgumentsNode.new(source, node_id, location, flags)
    end

    # Create a new ForwardingParameterNode node.
    def forwarding_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      ForwardingParameterNode.new(source, node_id, location, flags)
    end

    # Create a new ForwardingSuperNode node.
    def forwarding_super_node(source: default_source, node_id: 0, location: default_location, flags: 0, block: nil)
      ForwardingSuperNode.new(source, node_id, location, flags, block)
    end

    # Create a new GlobalVariableAndWriteNode node.
    def global_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      GlobalVariableAndWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new GlobalVariableOperatorWriteNode node.
    def global_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :"")
      GlobalVariableOperatorWriteNode.new(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator)
    end

    # Create a new GlobalVariableOrWriteNode node.
    def global_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      GlobalVariableOrWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new GlobalVariableReadNode node.
    def global_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      GlobalVariableReadNode.new(source, node_id, location, flags, name)
    end

    # Create a new GlobalVariableTargetNode node.
    def global_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      GlobalVariableTargetNode.new(source, node_id, location, flags, name)
    end

    # Create a new GlobalVariableWriteNode node.
    def global_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location)
      GlobalVariableWriteNode.new(source, node_id, location, flags, name, name_loc, value, operator_loc)
    end

    # Create a new HashNode node.
    def hash_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, elements: [], closing_loc: location)
      HashNode.new(source, node_id, location, flags, opening_loc, elements, closing_loc)
    end

    # Create a new HashPatternNode node.
    def hash_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, constant: nil, elements: [], rest: nil, opening_loc: nil, closing_loc: nil)
      HashPatternNode.new(source, node_id, location, flags, constant, elements, rest, opening_loc, closing_loc)
    end

    # Create a new IfNode node.
    def if_node(source: default_source, node_id: 0, location: default_location, flags: 0, if_keyword_loc: nil, predicate: default_node(source, location), then_keyword_loc: nil, statements: nil, subsequent: nil, end_keyword_loc: nil)
      IfNode.new(source, node_id, location, flags, if_keyword_loc, predicate, then_keyword_loc, statements, subsequent, end_keyword_loc)
    end

    # Create a new ImaginaryNode node.
    def imaginary_node(source: default_source, node_id: 0, location: default_location, flags: 0, numeric: float_node(source: source))
      ImaginaryNode.new(source, node_id, location, flags, numeric)
    end

    # Create a new ImplicitNode node.
    def implicit_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: local_variable_read_node(source: source))
      ImplicitNode.new(source, node_id, location, flags, value)
    end

    # Create a new ImplicitRestNode node.
    def implicit_rest_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      ImplicitRestNode.new(source, node_id, location, flags)
    end

    # Create a new InNode node.
    def in_node(source: default_source, node_id: 0, location: default_location, flags: 0, pattern: default_node(source, location), statements: nil, in_loc: location, then_loc: nil)
      InNode.new(source, node_id, location, flags, pattern, statements, in_loc, then_loc)
    end

    # Create a new IndexAndWriteNode node.
    def index_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, opening_loc: location, arguments: nil, closing_loc: location, block: nil, operator_loc: location, value: default_node(source, location))
      IndexAndWriteNode.new(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value)
    end

    # Create a new IndexOperatorWriteNode node.
    def index_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, opening_loc: location, arguments: nil, closing_loc: location, block: nil, binary_operator: :"", binary_operator_loc: location, value: default_node(source, location))
      IndexOperatorWriteNode.new(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, binary_operator, binary_operator_loc, value)
    end

    # Create a new IndexOrWriteNode node.
    def index_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, opening_loc: location, arguments: nil, closing_loc: location, block: nil, operator_loc: location, value: default_node(source, location))
      IndexOrWriteNode.new(source, node_id, location, flags, receiver, call_operator_loc, opening_loc, arguments, closing_loc, block, operator_loc, value)
    end

    # Create a new IndexTargetNode node.
    def index_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: default_node(source, location), opening_loc: location, arguments: nil, closing_loc: location, block: nil)
      IndexTargetNode.new(source, node_id, location, flags, receiver, opening_loc, arguments, closing_loc, block)
    end

    # Create a new InstanceVariableAndWriteNode node.
    def instance_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      InstanceVariableAndWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new InstanceVariableOperatorWriteNode node.
    def instance_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :"")
      InstanceVariableOperatorWriteNode.new(source, node_id, location, flags, name, name_loc, binary_operator_loc, value, binary_operator)
    end

    # Create a new InstanceVariableOrWriteNode node.
    def instance_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      InstanceVariableOrWriteNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new InstanceVariableReadNode node.
    def instance_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      InstanceVariableReadNode.new(source, node_id, location, flags, name)
    end

    # Create a new InstanceVariableTargetNode node.
    def instance_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      InstanceVariableTargetNode.new(source, node_id, location, flags, name)
    end

    # Create a new InstanceVariableWriteNode node.
    def instance_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location)
      InstanceVariableWriteNode.new(source, node_id, location, flags, name, name_loc, value, operator_loc)
    end

    # Create a new IntegerNode node.
    def integer_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: 0)
      IntegerNode.new(source, node_id, location, flags, value)
    end

    # Create a new InterpolatedMatchLastLineNode node.
    def interpolated_match_last_line_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, parts: [], closing_loc: location)
      InterpolatedMatchLastLineNode.new(source, node_id, location, flags, opening_loc, parts, closing_loc)
    end

    # Create a new InterpolatedRegularExpressionNode node.
    def interpolated_regular_expression_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, parts: [], closing_loc: location)
      InterpolatedRegularExpressionNode.new(source, node_id, location, flags, opening_loc, parts, closing_loc)
    end

    # Create a new InterpolatedStringNode node.
    def interpolated_string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, parts: [], closing_loc: nil)
      InterpolatedStringNode.new(source, node_id, location, flags, opening_loc, parts, closing_loc)
    end

    # Create a new InterpolatedSymbolNode node.
    def interpolated_symbol_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, parts: [], closing_loc: nil)
      InterpolatedSymbolNode.new(source, node_id, location, flags, opening_loc, parts, closing_loc)
    end

    # Create a new InterpolatedXStringNode node.
    def interpolated_x_string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, parts: [], closing_loc: location)
      InterpolatedXStringNode.new(source, node_id, location, flags, opening_loc, parts, closing_loc)
    end

    # Create a new ItLocalVariableReadNode node.
    def it_local_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      ItLocalVariableReadNode.new(source, node_id, location, flags)
    end

    # Create a new ItParametersNode node.
    def it_parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      ItParametersNode.new(source, node_id, location, flags)
    end

    # Create a new KeywordHashNode node.
    def keyword_hash_node(source: default_source, node_id: 0, location: default_location, flags: 0, elements: [])
      KeywordHashNode.new(source, node_id, location, flags, elements)
    end

    # Create a new KeywordRestParameterNode node.
    def keyword_rest_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: nil, name_loc: nil, operator_loc: location)
      KeywordRestParameterNode.new(source, node_id, location, flags, name, name_loc, operator_loc)
    end

    # Create a new LambdaNode node.
    def lambda_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], operator_loc: location, opening_loc: location, closing_loc: location, parameters: nil, body: nil)
      LambdaNode.new(source, node_id, location, flags, locals, operator_loc, opening_loc, closing_loc, parameters, body)
    end

    # Create a new LocalVariableAndWriteNode node.
    def local_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name_loc: location, operator_loc: location, value: default_node(source, location), name: :"", depth: 0)
      LocalVariableAndWriteNode.new(source, node_id, location, flags, name_loc, operator_loc, value, name, depth)
    end

    # Create a new LocalVariableOperatorWriteNode node.
    def local_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name_loc: location, binary_operator_loc: location, value: default_node(source, location), name: :"", binary_operator: :"", depth: 0)
      LocalVariableOperatorWriteNode.new(source, node_id, location, flags, name_loc, binary_operator_loc, value, name, binary_operator, depth)
    end

    # Create a new LocalVariableOrWriteNode node.
    def local_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name_loc: location, operator_loc: location, value: default_node(source, location), name: :"", depth: 0)
      LocalVariableOrWriteNode.new(source, node_id, location, flags, name_loc, operator_loc, value, name, depth)
    end

    # Create a new LocalVariableReadNode node.
    def local_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", depth: 0)
      LocalVariableReadNode.new(source, node_id, location, flags, name, depth)
    end

    # Create a new LocalVariableTargetNode node.
    def local_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", depth: 0)
      LocalVariableTargetNode.new(source, node_id, location, flags, name, depth)
    end

    # Create a new LocalVariableWriteNode node.
    def local_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", depth: 0, name_loc: location, value: default_node(source, location), operator_loc: location)
      LocalVariableWriteNode.new(source, node_id, location, flags, name, depth, name_loc, value, operator_loc)
    end

    # Create a new MatchLastLineNode node.
    def match_last_line_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, content_loc: location, closing_loc: location, unescaped: "")
      MatchLastLineNode.new(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped)
    end

    # Create a new MatchPredicateNode node.
    def match_predicate_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: default_node(source, location), pattern: default_node(source, location), operator_loc: location)
      MatchPredicateNode.new(source, node_id, location, flags, value, pattern, operator_loc)
    end

    # Create a new MatchRequiredNode node.
    def match_required_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: default_node(source, location), pattern: default_node(source, location), operator_loc: location)
      MatchRequiredNode.new(source, node_id, location, flags, value, pattern, operator_loc)
    end

    # Create a new MatchWriteNode node.
    def match_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, call: call_node(source: source), targets: [])
      MatchWriteNode.new(source, node_id, location, flags, call, targets)
    end

    # Create a new MissingNode node.
    def missing_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      MissingNode.new(source, node_id, location, flags)
    end

    # Create a new ModuleNode node.
    def module_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], module_keyword_loc: location, constant_path: constant_read_node(source: source), body: nil, end_keyword_loc: location, name: :"")
      ModuleNode.new(source, node_id, location, flags, locals, module_keyword_loc, constant_path, body, end_keyword_loc, name)
    end

    # Create a new MultiTargetNode node.
    def multi_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, lefts: [], rest: nil, rights: [], lparen_loc: nil, rparen_loc: nil)
      MultiTargetNode.new(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc)
    end

    # Create a new MultiWriteNode node.
    def multi_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, lefts: [], rest: nil, rights: [], lparen_loc: nil, rparen_loc: nil, operator_loc: location, value: default_node(source, location))
      MultiWriteNode.new(source, node_id, location, flags, lefts, rest, rights, lparen_loc, rparen_loc, operator_loc, value)
    end

    # Create a new NextNode node.
    def next_node(source: default_source, node_id: 0, location: default_location, flags: 0, arguments: nil, keyword_loc: location)
      NextNode.new(source, node_id, location, flags, arguments, keyword_loc)
    end

    # Create a new NilNode node.
    def nil_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      NilNode.new(source, node_id, location, flags)
    end

    # Create a new NoKeywordsParameterNode node.
    def no_keywords_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, operator_loc: location, keyword_loc: location)
      NoKeywordsParameterNode.new(source, node_id, location, flags, operator_loc, keyword_loc)
    end

    # Create a new NumberedParametersNode node.
    def numbered_parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0, maximum: 0)
      NumberedParametersNode.new(source, node_id, location, flags, maximum)
    end

    # Create a new NumberedReferenceReadNode node.
    def numbered_reference_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, number: 0)
      NumberedReferenceReadNode.new(source, node_id, location, flags, number)
    end

    # Create a new OptionalKeywordParameterNode node.
    def optional_keyword_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location))
      OptionalKeywordParameterNode.new(source, node_id, location, flags, name, name_loc, value)
    end

    # Create a new OptionalParameterNode node.
    def optional_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location))
      OptionalParameterNode.new(source, node_id, location, flags, name, name_loc, operator_loc, value)
    end

    # Create a new OrNode node.
    def or_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: default_node(source, location), right: default_node(source, location), operator_loc: location)
      OrNode.new(source, node_id, location, flags, left, right, operator_loc)
    end

    # Create a new ParametersNode node.
    def parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0, requireds: [], optionals: [], rest: nil, posts: [], keywords: [], keyword_rest: nil, block: nil)
      ParametersNode.new(source, node_id, location, flags, requireds, optionals, rest, posts, keywords, keyword_rest, block)
    end

    # Create a new ParenthesesNode node.
    def parentheses_node(source: default_source, node_id: 0, location: default_location, flags: 0, body: nil, opening_loc: location, closing_loc: location)
      ParenthesesNode.new(source, node_id, location, flags, body, opening_loc, closing_loc)
    end

    # Create a new PinnedExpressionNode node.
    def pinned_expression_node(source: default_source, node_id: 0, location: default_location, flags: 0, expression: default_node(source, location), operator_loc: location, lparen_loc: location, rparen_loc: location)
      PinnedExpressionNode.new(source, node_id, location, flags, expression, operator_loc, lparen_loc, rparen_loc)
    end

    # Create a new PinnedVariableNode node.
    def pinned_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, variable: local_variable_read_node(source: source), operator_loc: location)
      PinnedVariableNode.new(source, node_id, location, flags, variable, operator_loc)
    end

    # Create a new PostExecutionNode node.
    def post_execution_node(source: default_source, node_id: 0, location: default_location, flags: 0, statements: nil, keyword_loc: location, opening_loc: location, closing_loc: location)
      PostExecutionNode.new(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc)
    end

    # Create a new PreExecutionNode node.
    def pre_execution_node(source: default_source, node_id: 0, location: default_location, flags: 0, statements: nil, keyword_loc: location, opening_loc: location, closing_loc: location)
      PreExecutionNode.new(source, node_id, location, flags, statements, keyword_loc, opening_loc, closing_loc)
    end

    # Create a new ProgramNode node.
    def program_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], statements: statements_node(source: source))
      ProgramNode.new(source, node_id, location, flags, locals, statements)
    end

    # Create a new RangeNode node.
    def range_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: nil, right: nil, operator_loc: location)
      RangeNode.new(source, node_id, location, flags, left, right, operator_loc)
    end

    # Create a new RationalNode node.
    def rational_node(source: default_source, node_id: 0, location: default_location, flags: 0, numerator: 0, denominator: 0)
      RationalNode.new(source, node_id, location, flags, numerator, denominator)
    end

    # Create a new RedoNode node.
    def redo_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      RedoNode.new(source, node_id, location, flags)
    end

    # Create a new RegularExpressionNode node.
    def regular_expression_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, content_loc: location, closing_loc: location, unescaped: "")
      RegularExpressionNode.new(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped)
    end

    # Create a new RequiredKeywordParameterNode node.
    def required_keyword_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location)
      RequiredKeywordParameterNode.new(source, node_id, location, flags, name, name_loc)
    end

    # Create a new RequiredParameterNode node.
    def required_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"")
      RequiredParameterNode.new(source, node_id, location, flags, name)
    end

    # Create a new RescueModifierNode node.
    def rescue_modifier_node(source: default_source, node_id: 0, location: default_location, flags: 0, expression: default_node(source, location), keyword_loc: location, rescue_expression: default_node(source, location))
      RescueModifierNode.new(source, node_id, location, flags, expression, keyword_loc, rescue_expression)
    end

    # Create a new RescueNode node.
    def rescue_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, exceptions: [], operator_loc: nil, reference: nil, statements: nil, subsequent: nil)
      RescueNode.new(source, node_id, location, flags, keyword_loc, exceptions, operator_loc, reference, statements, subsequent)
    end

    # Create a new RestParameterNode node.
    def rest_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: nil, name_loc: nil, operator_loc: location)
      RestParameterNode.new(source, node_id, location, flags, name, name_loc, operator_loc)
    end

    # Create a new RetryNode node.
    def retry_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      RetryNode.new(source, node_id, location, flags)
    end

    # Create a new ReturnNode node.
    def return_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, arguments: nil)
      ReturnNode.new(source, node_id, location, flags, keyword_loc, arguments)
    end

    # Create a new SelfNode node.
    def self_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      SelfNode.new(source, node_id, location, flags)
    end

    # Create a new ShareableConstantNode node.
    def shareable_constant_node(source: default_source, node_id: 0, location: default_location, flags: 0, write: constant_write_node(source: source))
      ShareableConstantNode.new(source, node_id, location, flags, write)
    end

    # Create a new SingletonClassNode node.
    def singleton_class_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], class_keyword_loc: location, operator_loc: location, expression: default_node(source, location), body: nil, end_keyword_loc: location)
      SingletonClassNode.new(source, node_id, location, flags, locals, class_keyword_loc, operator_loc, expression, body, end_keyword_loc)
    end

    # Create a new SourceEncodingNode node.
    def source_encoding_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      SourceEncodingNode.new(source, node_id, location, flags)
    end

    # Create a new SourceFileNode node.
    def source_file_node(source: default_source, node_id: 0, location: default_location, flags: 0, filepath: "")
      SourceFileNode.new(source, node_id, location, flags, filepath)
    end

    # Create a new SourceLineNode node.
    def source_line_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      SourceLineNode.new(source, node_id, location, flags)
    end

    # Create a new SplatNode node.
    def splat_node(source: default_source, node_id: 0, location: default_location, flags: 0, operator_loc: location, expression: nil)
      SplatNode.new(source, node_id, location, flags, operator_loc, expression)
    end

    # Create a new StatementsNode node.
    def statements_node(source: default_source, node_id: 0, location: default_location, flags: 0, body: [])
      StatementsNode.new(source, node_id, location, flags, body)
    end

    # Create a new StringNode node.
    def string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, content_loc: location, closing_loc: nil, unescaped: "")
      StringNode.new(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped)
    end

    # Create a new SuperNode node.
    def super_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, lparen_loc: nil, arguments: nil, rparen_loc: nil, block: nil)
      SuperNode.new(source, node_id, location, flags, keyword_loc, lparen_loc, arguments, rparen_loc, block)
    end

    # Create a new SymbolNode node.
    def symbol_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, value_loc: nil, closing_loc: nil, unescaped: "")
      SymbolNode.new(source, node_id, location, flags, opening_loc, value_loc, closing_loc, unescaped)
    end

    # Create a new TrueNode node.
    def true_node(source: default_source, node_id: 0, location: default_location, flags: 0)
      TrueNode.new(source, node_id, location, flags)
    end

    # Create a new UndefNode node.
    def undef_node(source: default_source, node_id: 0, location: default_location, flags: 0, names: [], keyword_loc: location)
      UndefNode.new(source, node_id, location, flags, names, keyword_loc)
    end

    # Create a new UnlessNode node.
    def unless_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, predicate: default_node(source, location), then_keyword_loc: nil, statements: nil, else_clause: nil, end_keyword_loc: nil)
      UnlessNode.new(source, node_id, location, flags, keyword_loc, predicate, then_keyword_loc, statements, else_clause, end_keyword_loc)
    end

    # Create a new UntilNode node.
    def until_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, do_keyword_loc: nil, closing_loc: nil, predicate: default_node(source, location), statements: nil)
      UntilNode.new(source, node_id, location, flags, keyword_loc, do_keyword_loc, closing_loc, predicate, statements)
    end

    # Create a new WhenNode node.
    def when_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, conditions: [], then_keyword_loc: nil, statements: nil)
      WhenNode.new(source, node_id, location, flags, keyword_loc, conditions, then_keyword_loc, statements)
    end

    # Create a new WhileNode node.
    def while_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, do_keyword_loc: nil, closing_loc: nil, predicate: default_node(source, location), statements: nil)
      WhileNode.new(source, node_id, location, flags, keyword_loc, do_keyword_loc, closing_loc, predicate, statements)
    end

    # Create a new XStringNode node.
    def x_string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, content_loc: location, closing_loc: location, unescaped: "")
      XStringNode.new(source, node_id, location, flags, opening_loc, content_loc, closing_loc, unescaped)
    end

    # Create a new YieldNode node.
    def yield_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, lparen_loc: nil, arguments: nil, rparen_loc: nil)
      YieldNode.new(source, node_id, location, flags, keyword_loc, lparen_loc, arguments, rparen_loc)
    end

    # Retrieve the value of one of the ArgumentsNodeFlags flags.
    def arguments_node_flag(name)
      case name
      when :contains_forwarding then ArgumentsNodeFlags::CONTAINS_FORWARDING
      when :contains_keywords then ArgumentsNodeFlags::CONTAINS_KEYWORDS
      when :contains_keyword_splat then ArgumentsNodeFlags::CONTAINS_KEYWORD_SPLAT
      when :contains_splat then ArgumentsNodeFlags::CONTAINS_SPLAT
      when :contains_multiple_splats then ArgumentsNodeFlags::CONTAINS_MULTIPLE_SPLATS
      else Kernel.raise ArgumentError, "invalid ArgumentsNodeFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the ArrayNodeFlags flags.
    def array_node_flag(name)
      case name
      when :contains_splat then ArrayNodeFlags::CONTAINS_SPLAT
      else Kernel.raise ArgumentError, "invalid ArrayNodeFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the CallNodeFlags flags.
    def call_node_flag(name)
      case name
      when :safe_navigation then CallNodeFlags::SAFE_NAVIGATION
      when :variable_call then CallNodeFlags::VARIABLE_CALL
      when :attribute_write then CallNodeFlags::ATTRIBUTE_WRITE
      when :ignore_visibility then CallNodeFlags::IGNORE_VISIBILITY
      else Kernel.raise ArgumentError, "invalid CallNodeFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the EncodingFlags flags.
    def encoding_flag(name)
      case name
      when :forced_utf8_encoding then EncodingFlags::FORCED_UTF8_ENCODING
      when :forced_binary_encoding then EncodingFlags::FORCED_BINARY_ENCODING
      else Kernel.raise ArgumentError, "invalid EncodingFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the IntegerBaseFlags flags.
    def integer_base_flag(name)
      case name
      when :binary then IntegerBaseFlags::BINARY
      when :decimal then IntegerBaseFlags::DECIMAL
      when :octal then IntegerBaseFlags::OCTAL
      when :hexadecimal then IntegerBaseFlags::HEXADECIMAL
      else Kernel.raise ArgumentError, "invalid IntegerBaseFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the InterpolatedStringNodeFlags flags.
    def interpolated_string_node_flag(name)
      case name
      when :frozen then InterpolatedStringNodeFlags::FROZEN
      when :mutable then InterpolatedStringNodeFlags::MUTABLE
      else Kernel.raise ArgumentError, "invalid InterpolatedStringNodeFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the KeywordHashNodeFlags flags.
    def keyword_hash_node_flag(name)
      case name
      when :symbol_keys then KeywordHashNodeFlags::SYMBOL_KEYS
      else Kernel.raise ArgumentError, "invalid KeywordHashNodeFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the LoopFlags flags.
    def loop_flag(name)
      case name
      when :begin_modifier then LoopFlags::BEGIN_MODIFIER
      else Kernel.raise ArgumentError, "invalid LoopFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the ParameterFlags flags.
    def parameter_flag(name)
      case name
      when :repeated_parameter then ParameterFlags::REPEATED_PARAMETER
      else Kernel.raise ArgumentError, "invalid ParameterFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the RangeFlags flags.
    def range_flag(name)
      case name
      when :exclude_end then RangeFlags::EXCLUDE_END
      else Kernel.raise ArgumentError, "invalid RangeFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the RegularExpressionFlags flags.
    def regular_expression_flag(name)
      case name
      when :ignore_case then RegularExpressionFlags::IGNORE_CASE
      when :extended then RegularExpressionFlags::EXTENDED
      when :multi_line then RegularExpressionFlags::MULTI_LINE
      when :once then RegularExpressionFlags::ONCE
      when :euc_jp then RegularExpressionFlags::EUC_JP
      when :ascii_8bit then RegularExpressionFlags::ASCII_8BIT
      when :windows_31j then RegularExpressionFlags::WINDOWS_31J
      when :utf_8 then RegularExpressionFlags::UTF_8
      when :forced_utf8_encoding then RegularExpressionFlags::FORCED_UTF8_ENCODING
      when :forced_binary_encoding then RegularExpressionFlags::FORCED_BINARY_ENCODING
      when :forced_us_ascii_encoding then RegularExpressionFlags::FORCED_US_ASCII_ENCODING
      else Kernel.raise ArgumentError, "invalid RegularExpressionFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the ShareableConstantNodeFlags flags.
    def shareable_constant_node_flag(name)
      case name
      when :literal then ShareableConstantNodeFlags::LITERAL
      when :experimental_everything then ShareableConstantNodeFlags::EXPERIMENTAL_EVERYTHING
      when :experimental_copy then ShareableConstantNodeFlags::EXPERIMENTAL_COPY
      else Kernel.raise ArgumentError, "invalid ShareableConstantNodeFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the StringFlags flags.
    def string_flag(name)
      case name
      when :forced_utf8_encoding then StringFlags::FORCED_UTF8_ENCODING
      when :forced_binary_encoding then StringFlags::FORCED_BINARY_ENCODING
      when :frozen then StringFlags::FROZEN
      when :mutable then StringFlags::MUTABLE
      else Kernel.raise ArgumentError, "invalid StringFlags flag: #{name.inspect}"
      end
    end

    # Retrieve the value of one of the SymbolFlags flags.
    def symbol_flag(name)
      case name
      when :forced_utf8_encoding then SymbolFlags::FORCED_UTF8_ENCODING
      when :forced_binary_encoding then SymbolFlags::FORCED_BINARY_ENCODING
      when :forced_us_ascii_encoding then SymbolFlags::FORCED_US_ASCII_ENCODING
      else Kernel.raise ArgumentError, "invalid SymbolFlags flag: #{name.inspect}"
      end
    end

    private

    # The default source object that gets attached to nodes and locations if no
    # source is specified.
    def default_source
      Source.for("")
    end

    # The default location object that gets attached to nodes if no location is
    # specified, which uses the given source.
    def default_location
      Location.new(default_source, 0, 0)
    end

    # The default node that gets attached to nodes if no node is specified for a
    # required node field.
    def default_node(source, location)
      MissingNode.new(source, -1, location, 0)
    end
  end
end
