#include <stdio.h>
#include <time.h>
#include <grp.h>
#include <pwd.h>
#include <unistd.h>

#define bin_to_ascii(c) ((c)>=38?((c)-38+'a'):(c)>=12?((c)-12+'A'):(c)+'.')

void main (int argc, char **argv)
{
	FILE *fp,*ftpp;
	char *cryptstr, salt[2], ftp_path[MAXPATHLEN];
	time_t tm;
	struct group *grp;
	struct passwd *pwd;

	/* check for errors */
	if (argc!=4)
	{
		printf("Usage: mkgroup group pass real_group\n");
		exit(1);
	}
	if ((pwd=getpwnam("ftp"))==NULL)
	{
		printf("Can't find `ftp' group entry in /etc/passwd\n");
		exit(1);
	}
	strcat(ftp_path,pwd->pw_dir);
	strcat(ftp_path,"/etc/group");
	ftpp=fopen(ftp_path,"r");
	while ((grp=fgetgrent(ftpp)) && strcmp(argv[3],grp->gr_name));
	if (!grp)
	{
		printf("Can't find `%s' group entry in %s\n",argv[3],ftp_path);
		exit(1);
	}
	if ((fp=fopen("groupaccess","r"))==NULL)
	{
		printf("You must be in the same directory as the groupaccess file\n");
		exit(1);
	}
	if (!getgrnam(argv[3]))
	{
		printf("Can't find `%s' group entry in /etc/group\n",argv[3]);
		exit(1);
	}
	freopen("groupaccess","a",fp);
	time(&tm);
	salt[0] = bin_to_ascii(tm & 0x3f);
	salt[1] = bin_to_ascii((tm >> 5) & 0x3f);
	cryptstr = crypt(argv[2], salt);
	fprintf(fp,"%s:%s:%s\n",argv[1],cryptstr,argv[3]);

	fclose(fp);
	fclose(ftpp);
}
