/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#ifndef FILETYPES_H
#define	FILETYPES_H

#ifdef HAVE_XPM
Suffix_Glyph	default_filetypes[] = {
	{"xv %s&",	".gif,.jpg,.GIF,.JPG,.pbm,.xbm,.ppm,.pgm,.XBM,.BM,.bm,.PBM,.PPM,.PGM",
		0,	"file_pix.xpm",		NULL,	"Picture"},
	{"groff -man %s > /tmp/tt.man&",	".1,.2,.3,.4,.5,.6,.7,.8,.1x,.man,.ms",
		1,	"file_text.xpm",	NULL,	"Rofffile"},
	{"putimage -i %s&",	".vff,.VFF,.viff,.VIFF",
		2,	"file_pix.xpm",		NULL,	"Viff Image"},
	{"ghostview %s&",	".ps",
		3,	"file_dvi.xpm",	NULL,	"Postscriptfile"},
	{"xmore %s&",	".doc,.txt",
		4,	"file_text.xpm",	NULL,	"Plain Text"},
	{"xdvi %s&",	".dvi",
		5,	"file_dvi.xpm",	NULL,	"DVI File"},
	{"xmore %s&",	".tar",
		6,	"file_tar.xpm",		NULL,	"Tape Archive"},
	{"xmore %s&",	".tpz,.taz,.tgz,.tar.z,.tar.Z",
		7,	"file_ctar.xpm",	NULL,	"Compressed Tape Archive"},
	{"xmore %s&",	".z,.Z,.gz",
		8,	"file_compressed.xpm",	NULL,	"Compressed File"},
	{"xmore %s&",	".F",
		9,	"file_compressed.xpm",	NULL,	"Compressed File"},
	{"sxpm %s&",	".xpm",
		10,	"file_pix.xpm",		NULL,	"XPM-Icon"},
	{"xmore %s&",	".tex",
		11,	"file_text.xpm",	NULL,	"TeX Document"},
	{"xmore %s&",	".c,.cc,.c++",
		12,	"file_source.xpm",	NULL,	"C Source"},
	{"xmore %s&",	".h",
		13,	"file_source.xpm",	NULL,	"Include File"},
	{"xmore %s&",	".f",
		14,	"file_source.xpm",	NULL,	"F77 Source"},
	{"xmore %s&",	".o",
		15,	"file_bin.xpm"	,	NULL,	"Object File"},
	{"xmore %s&",	".a",
		16,	"file_bin.xpm"	,	NULL,	"Library"},
	{"xterm -geometry 40x25 -e xdl -r 6 %s&",	".dl",
		17,	"file_movie.xpm",	NULL,	"DL Animation"},
	{"xflick %s&",	".fli",
		18,	"file_movie.xpm",	NULL,	"FLI Animation"},
	{"mpeg_play %s&",".mpg",
		19,	"file_movie.xpm",	NULL,	"MPEG Animation"},
	{"xgrasp %s&",	".gl",
		20,	"file_movie.xpm",	NULL,	"GL Animation"},
	{"xfig %s&",	".fig",
		21,	"file_graph.xpm",	NULL,	"XFig Graphic"},
	{NULL,	NULL,
		FILE_PLAIN},
};
Dimension	default_maxfiletypes = 22;
#else
Suffix_Glyph	default_filetypes[] = {
	{"xv %s&",	".gif,.jpg,.GIF,.JPG,.pbm,.xbm,.ppm,.pgm,.XBM,.BM,.bm,.PBM,.PPM,.PGM",
		0,	"file_pix.xbm",		NULL,	"Picture"},
	{"groff -man %s > /tmp/tt.man&",	".1,.2,.3,.4,.5,.6,.7,.8,.1x,.man,.ms",
		1,	"file_text.xbm",	NULL,	"Rofffile"},
	{"putimage -i %s&",	".vff,.VFF,.viff,.VIFF",
		2,	"file_pix.xbm",		NULL,	"Viff Image"},
	{"ghostview %s&",	".ps",
		3,	"file_dvi.xbm",	NULL,	"Postscriptfile"},
	{"xmore %s&",	".doc,.txt",
		4,	"file_text.xbm",	NULL,	"Plain Text"},
	{"xdvi %s&",	".dvi",
		5,	"file_dvi.xbm",	NULL,	"DVI File"},
	{"xmore %s&",	".tar",
		6,	"file_tar.xbm",		NULL,	"Tape Archive"},
	{"xmore %s&",	".tpz,.taz,.tgz,.tar.z,.tar.Z",
		7,	"file_ctar.xbm",	NULL,	"Compressed Tape Archive"},
	{"xmore %s&",	".z,.Z,.gz",
		8,	"file_compressed.xbm",	NULL,	"Compressed File"},
	{"xmore %s&",	".F",
		9,	"file_compressed.xbm",	NULL,	"Compressed File"},
	{"xmore %s&",	".tex",
		10,	"file_text.xbm",	NULL,	"TeX Document"},
	{"xmore %s&",	".c,.cc,.c++",
		11,	"file_source.xbm",	NULL,	"C Source"},
	{"xmore %s&",	".h",
		12,	"file_source.xbm",	NULL,	"Include File"},
	{"xmore %s&",	".f",
		13,	"file_source.xbm",	NULL,	"F77 Source"},
	{"xmore %s&",	".o",
		14,	"file_bin.xbm"	,	NULL,	"Object File"},
	{"xmore %s&",	".a",
		15,	"file_bin.xbm"	,	NULL,	"Library"},
	{"xterm -geometry 40x25 -e xdl -r 6 %s&",	".dl",
		16,	"file_movie.xbm",	NULL,	"DL Animation"},
	{"xflick %s&",	".fli",
		17,	"file_movie.xbm",	NULL,	"FLI Animation"},
	{"mpeg_play %s&",".mpg",
		18,	"file_movie.xbm",	NULL,	"MPEG Animation"},
	{"xgrasp %s&",	".gl",
		19,	"file_movie.xbm",	NULL,	"GL Animation"},
	{"xfig %s&",	".fig",
		20,	"file_graph.xbm",	NULL,	"XFig Graphic"},
	{NULL,	NULL,
		FILE_PLAIN},
};
Dimension	default_maxfiletypes = 21;
#endif
#endif
