/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>


#include <X11/Shell.h>

#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Form.h>

#include "struct.h"
#include "config.h"

#include "cursor.h"
#include "cursorm.h"
#include "fcursor.h"
#include "fcursorm.h"
#include "wcursor.h"
#include "wcursorm.h"


/*
 * Global variables
 */
extern GC	line_gc;		/* GC zum Zeichnen von Linien */
extern GC	back_gc;		/* GC zum Loeschen des Hintergrundes */
extern GC	selc_gc;		/* GC fuer selected Files */
extern GC	white_gc;		/* GC fuer selected Files */

extern	Pixmap		Icon_Move_PM;	/* Icon der Verschiebeoperation */
extern	Pixmap		Icon_Copy_PM;	/* Icon fuer Kopierfunktion */
extern	Pixmap		Icon_Delete_PM;	/* Icon fuer Loeschfunktion */
extern	Pixmap		Icon_Warning_PM;/* Icon fuer die Hinweisbox */
extern	Pixmap		Icon_Newdir_PM;	/* Icon fuer das NewdirCommand */
extern	Pixmap		Icon_Info_PM;	/* Icon fuer das Info-File */
extern	Pixmap		Icon_Hide_PM;	/* Icon fuer das Info-File */
extern	Pixmap		Icon_Help_PM;	/* Icon fuer das Info-File */
extern	Pixmap		Icon_Filter_PM;	/* Icon fuer das Info-File */
extern	Pixmap		Icon_WSE_PM;	/* Icon fuer das Info-File */
extern	Pixmap		Icon_WSD_PM;	/* Icon fuer das Info-File */

extern	Boolean		GRAB;
extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Dir_Glyph	*selc_g;

extern	WS_Glyph	*selc_ws;
extern	Dimension	selc_w;

extern	xfm_struct	defaults;

extern	Folder_Glyph	*folders[];
extern	Dimension	folder_count;
extern	WS_Glyph	workspace;
extern	Widget		dir_area;

extern	Cursor		def_cursor;

extern	Widget		ws_move_shell;

/*
 * Function Prototypes
 */
void		makeIconBar (Widget parent, Widget left, Boolean HIDE);
XtActionProc	leaveButton    (Widget w, XLeaveWindowEvent *e, 
				String *s, Cardinal *c);
XtActionProc	enterButton    (Widget w, XEnterWindowEvent *e, 
				String *s, Cardinal *c);
XtActionProc	refreshButton  (Widget w, XEvent *e, 
				String *s, Cardinal *c);
XtActionProc	endButton      (Widget w, XEvent *e, 
				String *s, Cardinal *c);
XtActionProc	startButton    (Widget w, XEvent *e, 
				String *s, Cardinal *c);
extern	char	*getString     (void);
extern	char	*getMulti      (void);
extern	void	getFilter      (Folder_Glyph *folder);
extern	void	PlaceWorkspaceIcons (void);

XtTranslations	but_trans[] = {NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};


/*********************************************************
 * name:	makeIconBar
 * description:	erzeugt eine Liste mit Iconbuttons, die
 *		entweder angeklick oder
 *		auf die Programme mittels Graboperation
 *		gezogen werden koennen
 * input:	Widget	parent	- Zeiger auf die Menuleiste
 * output:	none
 * author:	Ove Kalkan
 * date:	24.6.93
 *********************************************************/
void	makeIconBar(Widget parent, Widget left, Boolean HIDE)
{
	Arg	args[10];
	Widget	b;

	b = left;
	XtSetArg(args[0],XtNleft, XawChainLeft);
	XtSetArg(args[1],XtNright, XawChainLeft);
	XtSetArg(args[2],XtNbottom, XawChainTop);
	XtSetArg(args[3],XtNtop, XawChainTop);
	XtSetArg(args[4],XtNfromHoriz, left);
	XtSetArg(args[5],XtNwidth, 32);
	XtSetArg(args[6],XtNheight, 32);
	if (!but_trans[0]) {
		but_trans[0] = 	XtParseTranslationTable("<Leave>: leave-button(0)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(0)\n\
							 <Btn1Down>: start-button(0)\n\
							 <Expose>: refresh-button(0)");
		but_trans[1] = 	XtParseTranslationTable("<Leave>: leave-button(1)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(1)\n\
							 <Btn1Down>: start-button(1)\n\
							 <Expose>: refresh-button(1)");
		but_trans[2] = 	XtParseTranslationTable("<Leave>: leave-button(2)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(2)\n\
							 <Btn1Down>: start-button(2)\n\
							 <Expose>: refresh-button(2)");
		but_trans[3] = 	XtParseTranslationTable("<Leave>: leave-button(3)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(3)\n\
							 <Btn1Down>: start-button(3)\n\
							 <Expose>: refresh-button(3)");
		but_trans[4] = 	XtParseTranslationTable("<Leave>: leave-button(4)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(4)\n\
							 <Btn1Down>: start-button(4)\n\
							 <Expose>: refresh-button(4)");
		but_trans[5] = 	XtParseTranslationTable("<Leave>: leave-button(5)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(5)\n\
							 <Btn1Down>: start-button(5)\n\
							 <Expose>: refresh-button(5)");
		but_trans[6] = XtParseTranslationTable("<Leave>: leave-button(10)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(10)\n\
							 <Btn1Down>: start-button(10)\n\
							 <Expose>: refresh-button(10)");
		but_trans[7] = XtParseTranslationTable("<Leave>: leave-button(11)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(11)\n\
							 <Btn1Down>: start-button(11)\n\
							 <Expose>: refresh-button(11)");
		but_trans[8] = XtParseTranslationTable("<Leave>: leave-button(12)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(12)\n\
							 <Btn1Down>: start-button(12)\n\
							 <Expose>: refresh-button(12)");
		but_trans[9] = XtParseTranslationTable("<Leave>: leave-button(13)\n\
							 <Enter>: enter-button()\n\
							 <Btn1Up>: end-button(13)\n\
							 <Btn1Down>: start-button(13)\n\
							 <Expose>: refresh-button(13)");
	}
	if (HIDE) {
		b = XtCreateManagedWidget("hide_but", simpleWidgetClass, parent,
					  args,7);
		XtOverrideTranslations(b, but_trans[1]);
	}

	XtSetArg(args[7],XtNhorizDistance,10);
	XtSetArg(args[4],XtNfromHoriz, b);
	b = XtCreateManagedWidget("move_but", simpleWidgetClass, parent,
				  args,8);
	XtOverrideTranslations(b, but_trans[3]);

	XtSetArg(args[4],XtNfromHoriz, b);
	b = XtCreateManagedWidget("copy_but", simpleWidgetClass, parent,
				  args,7);
	XtOverrideTranslations(b, but_trans[4]);

	XtSetArg(args[4],XtNfromHoriz, b);
	b = XtCreateManagedWidget("del_but", simpleWidgetClass, parent,
				  args,7);
	XtOverrideTranslations(b, but_trans[0]);

	XtSetArg(args[4],XtNfromHoriz, b);
	b = XtCreateManagedWidget("dir_but", simpleWidgetClass, parent,
				  args,7);
	XtOverrideTranslations(b, but_trans[5]);

	XtSetArg(args[4],XtNfromHoriz, b);
	XtSetArg(args[7],XtNhorizDistance, 10);
	b = XtCreateManagedWidget("info_but", simpleWidgetClass, parent,
				  args,8);
	XtOverrideTranslations(b, but_trans[6]);

	if (HIDE || !defaults.multi_window) {
		XtSetArg(args[4],XtNfromHoriz, b);
		b = XtCreateManagedWidget("help_but", simpleWidgetClass, parent,
					  args,7);
		XtOverrideTranslations(b, but_trans[2]);
	}
}



/*********************************************************
 * name:	leaveButton
 * description:	Unhighlighten eines IconButtons
 * input:	Widget w - der Button
 * output:	none
 * author:	Ove Kalkan
 * date:	30.6.93
 *********************************************************/
XtActionProc		leaveButton    (Widget w, XLeaveWindowEvent *e, 
					String *s, Cardinal *c)
{
	Pixmap	pmap;
	int	i = atol(s[0]);
	
	/*
	 * einfach nur die mit icon_pixmap spezifizierte Pixmap in das Simplewidget
	 * kopieren. Die gewuenschte Pixmap wird diesem Zeiger vorher zugewiesen
	 */
	switch (i) {
		case 0:
			pmap = Icon_Delete_PM;
			break;
		case 1:
			pmap = Icon_Hide_PM;
			break;
		case 2:
			pmap = Icon_Filter_PM;
			break;
		case 3:
			pmap = Icon_Move_PM;
			break;
		case 4:
			pmap = Icon_Copy_PM;
			break;
		case 5:
			pmap = Icon_Newdir_PM;
			break;
		case 10:
			pmap = Icon_Info_PM;
			break;
		case 11:	/* WS Edit */
			pmap = Icon_WSE_PM;
			break;
		case 12:	/* WS Delete */
			pmap = Icon_WSD_PM;
			break;
		case 13:	/* WS Delete */
			pmap = Icon_Help_PM;
			break;
	}
	XDrawRectangle(XtDisplay(w),XtWindow(w),back_gc,0,0,31,31);
	XDrawRectangle(XtDisplay(w),XtWindow(w),back_gc,1,1,29,29);
	XCopyArea (XtDisplay(w),pmap, XtWindow(w), line_gc,
			0,0,32,32,0,0);
}


/*********************************************************
 * name:	enterButton
 * description:	Highlighten eines IconButtons
 * input:	Widget w - der Button
 * output:	none
 * author:	Ove Kalkan
 * date:	30.6.93
 *********************************************************/
XtActionProc		enterButton    (Widget w, XEnterWindowEvent *e, 
					String *s, Cardinal *c)
{
	XDrawRectangle(XtDisplay(w),XtWindow(w),line_gc,0,0,31,31);
	XDrawRectangle(XtDisplay(w),XtWindow(w),line_gc,1,1,29,29);
}


/*********************************************************
 * name:	refresh_dialog_icon
 * description:	Wenn das Icon im Dialog-Fenster uebermalt
 *		wurde, dann wird es hiermit wieder neu
 *		gezeichnet.
 *		In icon_pixmap ist der Zeiger auf die
 *		Pixmap zu finden.
 * input:	none
 * output:	none
 * date:	14.6.93
 *********************************************************/
XtActionProc	refreshButton(Widget w, XEvent *e, String *s, Cardinal *c)
{
	Pixmap	pmap;
	int	i = atol(s[0]);
	
	/*
	 * einfach nur die mit icon_pixmap spezifizierte Pixmap in das Simplewidget
	 * kopieren. Die gewuenschte Pixmap wird diesem Zeiger vorher zugewiesen
	 */
	switch (i) {
		case 0:
			pmap = Icon_Delete_PM;
			break;
		case 1:
			pmap = Icon_Hide_PM;
			break;
		case 2:
			pmap = Icon_Filter_PM;
			break;
		case 3:
			pmap = Icon_Move_PM;
			break;
		case 4:
			pmap = Icon_Copy_PM;
			break;
		case 5:
			pmap = Icon_Newdir_PM;
			break;
		case 10:
			pmap = Icon_Info_PM;
			break;
		case 11:	/* WS Edit */
			pmap = Icon_WSE_PM;
			break;
		case 12:	/* WS Delete */
			pmap = Icon_WSD_PM;
			break;
		case 13:	/* WS Delete */
			pmap = Icon_Help_PM;
			break;
	}
	XCopyArea (XtDisplay(w),pmap, XtWindow(w), line_gc,
			0,0,32,32,0,0);
}



/*********************************************************
 * name:	endButton
 * description:	Ein IconButton war Endpunkt einer Graboperation
 *		Je nach Identifier eine Aktion ausfuehren
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	30.6.93
 *********************************************************/
XtActionProc	endButton      (Widget w, XEvent *e, 
				String *s, Cardinal *c)
{
	int	i;

	if (GRAB && (selc_g || (selc_fo && selc_f < 16000) || (selc_ws && selc_w < 16000))) {
		char	*d;

		/*
		 * Cursor ruecksetzen
		 */
		XDefineCursor (XtDisplay(dir_area), XtWindow(dir_area),
				def_cursor);
		XDefineCursor (XtDisplay(workspace.window), 
				XtWindow(workspace.window), def_cursor);
		for (i = 0; i < folder_count; i++)
			XDefineCursor (XtDisplay(folders[i]->window),
					XtWindow(folders[i]->window),
					def_cursor);
		XUngrabPointer(XtDisplay(w),CurrentTime);

		i = atol(s[0]);
		switch(i) {
			case 0:	/* Delete */
				d = getString();
				if (defaults.drag_delete)
					init_delete(d);
				else
					exec_delete(d);
				free(d);
				break;
			case 3:	/* Move */
				d = getString();
				init_move(d,NULL);
				free(d);
				break;
			case 4:	/* Copy */
				d = getString();
				init_copy(d,NULL);
				free(d);
				break;
			case 5:	/* Newdir */
				d = getString();
				init_newdir(d);
				free(d);
				break;
			case 10:	/* Info */
				init_info();
				break;
			case 11:	/* Edit WSE */
				if (ws_move_shell)
					XtDestroyWidget(ws_move_shell);
				ws_move_shell = NULL;
				init_editWSE();
				break;
			case 12:	/* Delete WSE */
				if (ws_move_shell)
					XtDestroyWidget(ws_move_shell);
				ws_move_shell = NULL;
				init_deleteWSE();
				break;
			default:
				break;
		}
		GRAB = FALSE;
	}
}



/*********************************************************
 * name:	startButton
 * description:	Ein Button wurde gedrueckt. Wenn etwas
 *		selectiert ist, dann Aktion ausfuehren
 * input:	none
 * output:	none
 * author:	Ove Kalkan
 * date:	30.6.93
 *********************************************************/
XtActionProc	startButton    (Widget w, XEvent *e, 
				String *s, Cardinal *c)
{
	int	i;
	char	*d = NULL;

	/*
	 * Set & Unset
	 */

	/*
	 * Auswerten des Buttons
	 */
	i = atol(s[0]);
	switch(i) {
		case 0:	/* Delete */
			d = getString();
			if (!d)
				d = getMulti();
			if (defaults.drag_delete || !d)
				init_delete(d);
			else
				exec_delete(d);
			free(d);
			break;
		case 1:	{	/* Hide */
				int	l;
				Widget	f;

				f = XtParent(w);	/* Steht in folder->label */
				l = 0;
				while (l < folder_count && f != folders[l]->label)
				l++;
				if (l < folder_count) {
					/*
					 * Fenster loeschen
					 */
				
					hideFolder(w,folders[l],NULL);
				}
			} break;
		case 2: {	/* get filter for this folder */
				int	l;
				Widget	f;

				if (defaults.multi_window) {
					f = XtParent(w);	/* Steht in folder->label */
					l = 0;
					while (l < folder_count && f != folders[l]->label)
					l++;
					if (l < folder_count) {
						/*
						 * Fenster loeschen
						 */
						getFilter(folders[l]);
					}
				}
				else {	/* Single Window mode -> nur ein Fenster */
					getFilter(folders[0]);
				}
			} break;
		case 3:	/* Move */
			d = getString();
			init_move(d,NULL);
			free(d);
			break;
		case 4:	/* Copy */
			d = getString();
			init_copy(d,NULL);
			free(d);
			break;
		case 5:	/* Newdir */
			d = getString();
			init_newdir(d);
			free(d);
			break;
		case 10:	/* Info */
			d = getString();
			if (d) {
				free(d);
				init_info();
			}
			break;
		case 11:	/* edit wse */
			init_editWSE();
			break;
		case 12:
			if (selc_ws && selc_w < 16000)
				init_deleteWSE();
			break;
		case 13:
			PlaceWorkspaceIcons();
			break;
		default:
			break;
	}
}

