/*
 * Copyright 1992 by Kevin E. Martin, Chapel Hill, North Carolina.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Kevin E. Martin not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Kevin E. Martin makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * KEVIN E. MARTIN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEVIN E. MARTIN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
#include "scrnintstr.h"

#include "gcstruct.h"
#include "cfb.h"
#include "mistruct.h"
#include "regionstr.h"
#include "cfbmskbits.h"
#include "x386.h"
#include "reg8514.h"
#include "ibm8514im.h"

#define	reorder(a,b)	b = \
	(a & 0x80) >> 7 | \
	(a & 0x40) >> 5 | \
	(a & 0x20) >> 3 | \
	(a & 0x10) >> 1 | \
	(a & 0x08) << 1 | \
	(a & 0x04) << 3 | \
	(a & 0x02) << 5 | \
	(a & 0x01) << 7;

static unsigned char swapbits[256];

void
ibm8514ImageInit()
{
    int i;

    for (i = 0; i < 256; i++) {
	reorder(i,swapbits[i]);
    }
}

void
ibm8514ImageWrite(x, y, w, h, psrc, pwidth, px, py, alu, planemask)
    int			x;
    int			y;
    int			w;
    int			h;
    unsigned char	*psrc;
    int			pwidth;
    int			px;
    int			py;
    short		alu;
    short		planemask;
{
    int i,j;

    WaitQueue(2);
    outpw(FRGD_MIX, FSS_PCDATA | alu);
    outpw(WRT_MASK, planemask);

    WaitQueue(5);
    outpw(CUR_X, (short)x);
    outpw(CUR_Y, (short)y);
    outpw(MAJ_AXIS_PCNT, (short)w-1);
    outpw(MULTIFUNC_CNTL, MIN_AXIS_PCNT | (h-1));
    outpw(CMD, CMD_RECT | INC_Y | INC_X | DRAW | PCDATA | WRTDATA);

    WaitQueue(8);

    w += px;
    psrc += pwidth * py;

    for (j = 0; j < h; j++) {
	for (i = px; i < w; i++)
	    outpw(PIX_TRANS, (short)psrc[i]);
	psrc += pwidth;
    }

    WaitQueue(1);
    outpw(FRGD_MIX, FSS_FRGDCOL | MIX_SRC);
}

void
ibm8514ImageRead(x, y, w, h, psrc, pwidth, px, py)
    int			x;
    int			y;
    int			w;
    int			h;
    unsigned char	*psrc;
    int			pwidth;
    int			px;
    int			py;
{
    int i,j;
    short pix;

    WaitIdleEmpty();
    outpw(FRGD_MIX, FSS_PCDATA | MIX_SRC);
    outpw(CUR_X, (short)x);
    outpw(CUR_Y, (short)y);
    outpw(MAJ_AXIS_PCNT, (short)w-1);
    outpw(MULTIFUNC_CNTL, MIN_AXIS_PCNT | (h-1));
    outpw(CMD, CMD_RECT | INC_Y | INC_X | DRAW | PCDATA);

    WaitQueue(8);

    w += px;
    psrc += pwidth * py;

    for (j = 0; j < h; j++) {
	for (i = px; i < w; i++) {
	    pix = inpw(PIX_TRANS);
	    psrc[i] = (char)pix;
	}
	psrc += pwidth;
    }

    WaitQueue(1);
    outpw(FRGD_MIX, FSS_FRGDCOL | MIX_SRC);
}

void
ibm8514ImageFill(x, y, w, h, psrc, pwidth, pw, ph, pox, poy, alu, planemask)
    int			x;
    int			y;
    int			w;
    int			h;
	int pw, ph, pox, poy;
    unsigned char	*psrc;
    int			pwidth;
    short		alu;
    short		planemask;
{
    int i,j;
    unsigned char	*pline;
    int mod;

    WaitQueue(7);
    outpw(FRGD_MIX, FSS_PCDATA | alu);
    outpw(WRT_MASK, planemask);
    outpw(CUR_X, (short)x);
    outpw(CUR_Y, (short)y);
    outpw(MAJ_AXIS_PCNT, (short)w-1);
    outpw(MULTIFUNC_CNTL, MIN_AXIS_PCNT | (h-1));
    outpw(CMD, CMD_RECT | INC_Y | INC_X | DRAW | PCDATA | WRTDATA);

    for (j = 0; j < h; j++) {
	modulus(y+j-poy,ph,mod);
	pline = psrc + pwidth*mod;
	for (i = 0; i < w; i++) {
	    modulus(x+i-pox,pw,mod);
	    outpw(PIX_TRANS, (short)pline[mod]);
	}
    }

    WaitQueue(1);
    outpw(FRGD_MIX, FSS_FRGDCOL | MIX_SRC);
}

void
ibm8514ImageStipple(x, y, w, h, psrc, pwidth, pw, ph, pox, poy, fgPixel, alu, planemask)
    int			x;
    int			y;
    int			w;
    int			h;
    unsigned char	*psrc;
	int pw, ph, pox, poy;
    int			pwidth;
    int			fgPixel;
    short		alu;
    short		planemask;
{
    int 		i,j;
    unsigned char	*pline;
    int			x1, x2, y1, y2, width, pix, need;
    short		data;
    unsigned char	*newsrc = NULL, *newline;

    x1 = x & ~0x7;
    x2 = (x+w+7) & ~0x7;
    y1 = y;
    y2 = y+h;

    width = x2 - x1;

    if (pw <= 8) {
	newsrc = (unsigned char *)malloc(2*ph*sizeof(char));
	if (!newsrc) {
	    return;
	}

	while (pw <= 8) {
	    pline = psrc;
	    newline = newsrc;
	    for (i = 0; i < ph; i++) {
		newline[0] = (pline[0] & (0xff >> (8-pw))) | pline[0] << pw;
		if (pw > 4)
		    newline[1] = pline[0] >> (8-pw);

		pline += pwidth;
		newline += 2;
	    }
	    pw *= 2;
	    pwidth = 2;
	    psrc = newsrc;
	}
    }

    WaitQueue(3);
    outpw(MULTIFUNC_CNTL, SCISSORS_L | x);
    outpw(MULTIFUNC_CNTL, SCISSORS_R | (x+w-1));
    outpw(WRT_MASK, planemask);

    WaitQueue(5);
    outpw(FRGD_MIX, FSS_FRGDCOL | alu);
    outpw(BKGD_MIX, BSS_BKGDCOL | MIX_DST);
    outpw(FRGD_COLOR, (short)fgPixel);
    outpw(MULTIFUNC_CNTL, PIX_CNTL | MIXSEL_EXPPC | COLCMPOP_F);
    outpw(MAJ_AXIS_PCNT, (short)(width-1));

    for (j = y1; j < y2; j++) {
	WaitQueue(3);
	outpw(CUR_X, (short)x1);
	outpw(CUR_Y, (short)j);
	outpw(CMD, CMD_LINE | PCDATA | LINETYPE | DRAW | PLANAR | WRTDATA);

	modulus(j-poy,ph,pix);
	pline = psrc + pwidth*pix;
	for (i = 0; i < width; i += 8) {
	    modulus(i+x1-pox,pw,pix);
	    data = swapbits[pline[pix/8]];
	    if (pix+8 > pw) {
		if (pix % 8 != 0)
		    data <<= pix % 8;
		if (((pw % 8) != 0) && ((pix % 8) > (pw % 8))) {
		    data &= 0xff << (pix % 8);
		    data |= swapbits[pline[pix/8+1]] >> (8 - (pix % 8));
		}
		need = pix+8 - pw;
		data &= 0xff << need;
		data |= swapbits[pline[0]] >> (8 - need);
	    } else if (pix % 8 != 0) {
		data <<= pix % 8;
		data |= swapbits[pline[pix/8+1]] >> (8 - (pix % 8));
	    }
	    outpw(PIX_TRANS, (short)data);
/*was 	    outpw(PIX_TRANS, (short)data>>3);
	    outpw(PIX_TRANS, (short)data<<1); Jon */	    
	}
    }

    WaitQueue(5);
    outpw(FRGD_MIX, FSS_FRGDCOL | MIX_SRC);
    outpw(BKGD_MIX, BSS_BKGDCOL | MIX_SRC);
    outpw(MULTIFUNC_CNTL, SCISSORS_L | 0);
    outpw(MULTIFUNC_CNTL, SCISSORS_R | 1023);
    outpw(MULTIFUNC_CNTL, PIX_CNTL | MIXSEL_FRGDMIX | COLCMPOP_F);

    if (newsrc)
	free(newsrc);
}

void
ibm8514ImageOpStipple(x, y, w, h, psrc, pwidth, pw, ph, pox, poy, fgPixel, bgPixel, alu, planemask)
    int			x;
    int			y;
    int			w;
    int			h;
    unsigned char	*psrc;
	int pw, ph, pox, poy;
    int			pwidth;
    int			fgPixel;
    int			bgPixel;
    short		alu;
    short		planemask;
{
    int 		i,j;
    unsigned char	*pline;
    int			x1, x2, y1, y2, width, pix, need;
    short		data;
    unsigned char	*newsrc = NULL, *newline;

    x1 = x & ~0x7;
    x2 = (x+w+7) & ~0x7;
    y1 = y;
    y2 = y+h;

    width = x2 - x1;

    if (pw <= 8) {
	newsrc = (unsigned char *)malloc(2*ph*sizeof(char));
	if (!newsrc) {
	    return;
	}

	while (pw <= 8) {
	    pline = psrc;
	    newline = newsrc;
	    for (i = 0; i < ph; i++) {
		newline[0] = (pline[0] & (0xff >> (8-pw))) | pline[0] << pw;
		if (pw > 4)
		    newline[1] = pline[0] >> (8-pw);

		pline += pwidth;
		newline += 2;
	    }
	    pw *= 2;
	    pwidth = 2;
	    psrc = newsrc;
	}
    }

    WaitQueue(3);
    outpw(MULTIFUNC_CNTL, SCISSORS_L | x);
    outpw(MULTIFUNC_CNTL, SCISSORS_R | (x+w-1));
    outpw(WRT_MASK, planemask);

    WaitQueue(5);
    outpw(FRGD_MIX, FSS_FRGDCOL | alu);
    outpw(BKGD_MIX, BSS_BKGDCOL | alu);
    outpw(FRGD_COLOR, (short)fgPixel);
    outpw(MULTIFUNC_CNTL, PIX_CNTL | MIXSEL_EXPPC | COLCMPOP_F);
    outpw(MAJ_AXIS_PCNT, (short)(width-1));

    for (j = y1; j < y2; j++) {
	WaitQueue(4);
	outpw(BKGD_COLOR, (short)bgPixel);
	outpw(CUR_X, (short)x1);
	outpw(CUR_Y, (short)j);
	outpw(CMD, CMD_LINE | PCDATA | LINETYPE | DRAW | PLANAR | WRTDATA);

	modulus(j-poy,ph,pix);
	pline = psrc + pwidth*pix;
	for (i = 0; i < width; i += 8) {
	    modulus(i+x1-pox,pw,pix);
	    data = swapbits[pline[pix/8]];
	    if (pix+8 > pw) {
		if (pix % 8 != 0)
		    data <<= pix % 8;
		if (((pw % 8) != 0) && ((pix % 8) > (pw % 8))) {
		    data &= 0xff << (pix % 8);
		    data |= swapbits[pline[pix/8+1]] >> (8 - (pix % 8));
		}
		need = pix+8 - pw;
		data &= 0xff << need;
		data |= swapbits[pline[0]] >> (8 - need);
	    } else if (pix % 8 != 0) {
		data <<= pix % 8;
		data |= swapbits[pline[pix/8+1]] >> (8 - (pix % 8));
	    }
	    outpw(PIX_TRANS, (short)data); 
/*was 	    outpw(PIX_TRANS, (short)data>>3);
	    outpw(PIX_TRANS, (short)data<<1); Jon */

	}
    }

    WaitQueue(5);
    outpw(FRGD_MIX, FSS_FRGDCOL | MIX_SRC);
    outpw(BKGD_MIX, BSS_BKGDCOL | MIX_SRC);
    outpw(MULTIFUNC_CNTL, SCISSORS_L | 0);
    outpw(MULTIFUNC_CNTL, SCISSORS_R | 1023);
    outpw(MULTIFUNC_CNTL, PIX_CNTL | MIXSEL_FRGDMIX | COLCMPOP_F);

    if (newsrc)
	free(newsrc);
}
