/* database_search.c */

/* clearButtonCB() - clears all search fields on search form
 * modifyButtonCB() - allows user to change which fields are searched
 *                    by keyword
 * searchMaskOk() - called when user clicks "Ok" on modify search popup
 * searchToggle() -
 * searchhelpButtonCB() - called when user clicks "Help" on main
 *                        conference database form
 */

#include "database.h"

void
clearButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    XtVaSetValues(fromText, XtNstring, "", NULL);
    XtVaSetValues(toText, XtNstring, "", NULL);
    XtVaSetValues(locationText, XtNstring, "", NULL);
    XtVaSetValues(enterText, XtNstring, "", NULL);
}


void
modifyButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Widget popup_widg, form, button, radio, last;
    Arg args[20];
    register int n, i;

    /* set the proposed mask to what we actually have */
    search_mask[P_SEARCH][TITLE] = search_mask[SEARCH][TITLE];
    search_mask[P_SEARCH][DESCRIPTION] = search_mask[SEARCH][DESCRIPTION];
  
    n = 0;
    XtSetArg(args[n], XtNx, 50);                         n++;
    XtSetArg(args[n], XtNy, 150);                        n++;
    XtSetArg(args[n], XtNallowShellResize, True);        n++;
    XtSetArg(args[n], XtNtitle, "Modify the keyword search");        n++;
    popup_widg = XtCreatePopupShell("ModifySearch",
        topLevelShellWidgetClass, toplevel, args, n);

    n = 0;
    XtSetArg(args[n], XtNresizable, True);               n++;
    form = XtCreateManagedWidget("searchPopupForm", formWidgetClass,
        popup_widg, args, n);

    /* the top label */
    n = 0;
    XtSetArg(args[n], XtNborderWidth, 0);  n++;
    XtSetArg(args[n], XtNlabel, "mark which fields to search");   n++;
    last = XtCreateManagedWidget("headLabel",
        labelWidgetClass, form,args,n);

    /* now the toggles */
    /* the bitmap for the toggle widget is set as a fallback rcrc
        in main.c */
#define TOGGLE(part, label_label) \
    n = 0; \
    XtSetArg(args[n], XtNborderWidth, 0);  n++; \
    XtSetArg(args[n], XtNinternalHeight, 0); n++; \
    XtSetArg(args[n], XtNinternalWidth, 0); n++; \
    XtSetArg(args[n], XtNfromVert, last);               n++; \
    XtSetArg(args[n], XtNstate, search_mask[P_SEARCH][part]);  n++; \
    XtSetArg(args[n], XtNbitmap, checkPix); n++; \
    searchToggles[part] = radio = XtCreateManagedWidget("searchToggle",  \
        toggleWidgetClass, form, args, n); \
    XtAddCallback(radio, XtNcallback, searchToggle,  \
        (XtPointer) ((P_SEARCH * 100) + part)); \
    n = 0; \
    XtSetArg(args[n], XtNborderWidth, 0);  n++; \
    XtSetArg(args[n], XtNfromVert, last);               n++; \
    XtSetArg(args[n], XtNfromHoriz, radio);             n++; \
    button = XtCreateManagedWidget(label_label,  \
        labelWidgetClass, form, args, n); \
    last = radio;

    TOGGLE(TITLE, "title")
    TOGGLE(DESCRIPTION, "description")

    n = 0;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    button = XtCreateManagedWidget("ok", commandWidgetClass,
        form, args, n);
    XtAddCallback(button, XtNcallback, searchMaskOk, (XtPointer)SEARCH);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);

    n = 0;
    XtSetArg(args[n], XtNfromHoriz, button);             n++;
    XtSetArg(args[n], XtNfromVert, last);               n++;
    button = XtCreateManagedWidget("cancel", commandWidgetClass,
        form, args, n);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)form);

    XtPopup(popup_widg, XtGrabExclusive);
}

void
searchMaskOk(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    /* copy proposed mask to mask */
    search_mask[SEARCH][TITLE] = search_mask[P_SEARCH][TITLE];
    search_mask[SEARCH][DESCRIPTION] = search_mask[P_SEARCH][DESCRIPTION];
}

void
searchToggle(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    int ret = (int) call_data;
    Boolean state = (int) client_data;
    int mask_set, mask_part;

    mask_set = ret / 100;
    mask_part = ret % 100;
    
    search_mask[mask_set][mask_part] = state;
}

void
searchhelpButtonCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg     args[20];
    Widget  popup, button, form, pane;
    register int n;
        XtTranslations translations;
    static char text_translations[] = "<Key>Return: "; /* nothing */

    translations = XtParseTranslationTable(text_translations);

    n=0;
    XtSetArg(args[n], XtNtitle, "Search Instructions");      n++;
    popup = XtCreatePopupShell("Search_Instructions",
        topLevelShellWidgetClass, toplevel, args, n);

    pane = XtVaCreateManagedWidget("popupPane", panedWidgetClass,
        popup, XtNresize, True, NULL);

    form = XtVaCreateManagedWidget("popupForm", formWidgetClass,
        pane, XtNresize, True, NULL);

    n = 0;
    button = XtCreateManagedWidget("cancel", commandWidgetClass,form, args,
 n);
    XtAddCallback(button, XtNcallback, Destroy_form, (XtPointer)pane);

    n = 0;
    XtSetArg(args[n], XtNallowResize, True);               n++;
    XtSetArg(args[n], XtNwidth, 510);               n++;
    XtSetArg(args[n], XtNheight, 400);               n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNsensitive, True); n++;
    XtSetArg(args[n], XtNstring, SEARCH_HELP); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
    XtSetArg(args[n], XtNdisplayNonprinting, False); n++;

    XtCreateManagedWidget("searchhelptext", utkasciiTextWidgetClass,
        pane, args, n);


    XtPopup(popup, XtGrabNone);
}


