#include <stdio.h>
#include "terminal.h"


#define START		 0
#define STOP			256

#define HANDSHAKE				'A'
#define HANDSHAKE_ACK		'B'
#define START_INT				'C'
#define STOP_INT				'D'
#define START_CHAR			'E'
#define STOP_CHAR				'F'
#define STOP_CHAR_XON		'G'
#define START_ACK				'H'
#define STOP_ACK				'I'
#define START_REPLY			'J'
#define STOP_REPLY			'K'
#define STOP_REPLY_XON	'L'
#define INT_ACK					'M'
#define ACK							'1'
#define NAK							'0'
#define XON							'\021'

char buff[200];

void debug(void)
{
	char *s;
	s = buff;
	fprintf(stderr, "\tpacket:");
	while (*s != '\0')
	{
		fprintf(stderr, " %d", (int) *(s++));
	}
	fprintf(stderr, "\n");
}

void main(void)
{
	int i, j, k, valid;
	char c;

	terminal_save(0);
	terminal_raw(0);

	fprintf(stderr, "Handshaking\n");

	printf("\n%c\n", HANDSHAKE);
	
	i = 0;

	while ( ! i )
	{
		gets(buff);
		if ( ( buff[0] == HANDSHAKE ) && ( buff[1] == '\0' ) )
		{
			i = 1;
			printf("\n%c\n", HANDSHAKE_ACK);
		}
		if ( ( buff[0] == HANDSHAKE_ACK ) && ( buff[1] == '\0' ) )
			i = 1;
	}

	fprintf(stderr, "Handshaking sucessful\n");

	/* rec all the chars */
	for (i = START, c=(char)START; i < STOP; i++, c++ )
	{

		if ( c == '\n' )
		{
			fprintf(stderr, "10 Known to be valid,Skipping\n");
			continue;
		}

		valid = 0;
		while ( ! valid )
		{
			fprintf(stderr, "Should be receiving char %d\n", i );

			j=strlen(gets(buff));

			/* munch a stray ack from the handshake */
			if ( (i == 0) && ( buff[0] == HANDSHAKE_ACK ) && ( buff[1] == '\0' ) )
			{
				fprintf (stderr,"\tmunched stray handshake packet\n");
				debug();
				j=strlen(gets(buff));
			}	 
			
			/* get the int rep */		
			if ( buff[0] != START_INT )
			{
				fprintf(stderr, "\tskipping - INT packet start header incorrect\n");
				debug();
			}
			else
				if ( buff[j-1] != STOP_INT )
				{
					fprintf(stderr, "\tskipping - INT packet end header incorrect\n");
					debug();
				}
				else
				{
					buff[j-1] = '\0';
					k = atoi(buff+1);
					if ( i != k )
					{
						fprintf ( stderr, "\ttold to receive char %d, believing this", k );
						i = k;
						valid = 1;
						debug();
					}
					else
					{
						valid = 1;
						fprintf ( stderr, "\ttold to receive char %d\n", k );
					}
				}
		}

		printf("%c\n", INT_ACK);		

		/* get the char packet */
		j = strlen(gets(buff));
		
		if ( buff[0] != START_CHAR )
		{
			fprintf(stderr, "\tescape - CHAR packet start header incorrect\n");
			debug();
			printf("%c%c%c\n", START_ACK, NAK, STOP_ACK );
		}
		else
			if ( buff[j-1] != STOP_CHAR_XON )
			{
				fprintf(stderr, "\tescape - CHAR packet end header incorrect\n");
				debug();
				printf("%c%c%c\n", START_ACK, NAK, STOP_ACK );
			}
			else
			  if ( buff[1] != c )
				{
				  fprintf(stderr, "\tescape - CHAR incorrect - got %d\n", i );
					debug();
					printf("%c%c%c\n", START_ACK, NAK, STOP_ACK );
				}
				else
				{
					fprintf(stderr, "\treceived okay\n" );
					printf("%c%c%c\n", START_ACK, ACK, STOP_ACK );
				}

		printf("%c%c%c%c%c\n", START_REPLY, c, STOP_REPLY, XON, STOP_REPLY_XON );
	}

	terminal_restore(0);
}

