from textwrap import dedent
from generate_statuscode import status_codes
from string import Template

if __name__ == "__main__":
    codes = status_codes()

    with open("../opcua/ua/uaerrors/_auto.py", "w") as f:
        preamble = """\
        #AUTOGENERATED!!!

        from opcua.ua.uaerrors import UaStatusCodeError
        

        """

        f.write(dedent(preamble))

        for name, code, _ in codes:
            # skip non-bad because they should not be thrown as exceptions
            if not name.startswith("Bad"):
                continue

            template = Template(dedent("""\
            class $name(UaStatusCodeError):
                code = $code
            """))
            print(template.safe_substitute(name=name, code=code), file=f)
