/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.util.ArrayList;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/**
 * This class is for unit testing the ElementToSAX class.
 *
 * @see ElementToSAX
 * @author Elias Ross
 * @version 1.0
 */
public class ElementToSAXTest
	extends junit.framework.TestCase
{
	public ElementToSAXTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ElementToSAXTest.class);
	}

	public void testInit() {

	}

	class TestHandler extends DefaultHandler {
		StringBuffer sb = new StringBuffer();
		public void startElement(String uri, String localName, String qName, Attributes a) {
			sb.append('<').append(localName).append(a).append('>');
		}
		public void endElement(String uri, String localName, String qName) {
			sb.append("</").append(localName).append(">");
		}
		public void characters(char cbuf[], int off, int len) {
			sb.append(cbuf, off, len);
		}
		public String toString() {
			return sb.toString();
		}
	}

	public void testEasy()
		throws Exception
	{
		Element a = new Element("a");
		TestHandler handler = new TestHandler();
		ElementToSAX.pipe(a, handler);
		assertEquals("handler data and element", a.toString(), handler.toString());
	}

	public void testHarder()
		throws Exception
	{
		ArrayList al = new ArrayList();
		al.add(new Attribute("name", "value"));
		al.add(new Attribute("name2", "value2"));
		Element a = new Element("a", al, true);
		Element b = new Element("b");
		CharacterData data = new CharacterData();
		data.getWriter().write("hello");
		a.appendChild(b);
		a.appendChild(data);
		a.appendChild(b);
		b.appendChild(data);
		TestHandler handler = new TestHandler();
		ElementToSAX.pipe(a, handler);
		// Note:  XmlWriter uses \n at the end of lines, but
		// if this changes, change TestHandler code too
		assertEquals("handler data and element", a.toString(), handler.toString());
	}
}
