; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -constraint-elimination -S %s | FileCheck %s

declare void @use(i1)

define void @loop_pointer_iv(i8* %start, i8* %end, i8* %upper) {
; CHECK-LABEL: @loop_pointer_iv(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[END_LT_UPPER:%.*]] = icmp ult i8* [[END:%.*]], [[UPPER:%.*]]
; CHECK-NEXT:    br i1 [[END_LT_UPPER]], label [[LOOP_HEADER:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8* [ [[START:%.*]], [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C_2:%.*]] = icmp ule i8* [[IV]], [[END]]
; CHECK-NEXT:    call void @use(i1 [[C_2]])
; CHECK-NEXT:    [[T_2:%.*]] = icmp uge i8* [[IV]], [[START]]
; CHECK-NEXT:    call void @use(i1 [[T_2]])
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i8* [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i8* [[IV]], [[UPPER]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[IV_NEXT]] = getelementptr inbounds i8, i8* [[IV]], i8 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %end.lt.upper = icmp ult i8* %end, %upper
  br i1 %end.lt.upper, label %loop.header, label %exit

loop.header:
  %iv = phi i8* [ %start, %entry ], [ %iv.next, %loop.latch ]
  %c.2 = icmp ule i8* %iv, %end
  call void @use(i1 %c.2)

  %t.2 = icmp uge i8* %iv, %start
  call void @use(i1 %t.2)

  %c.1 = icmp ule i8* %iv, %end
  br i1 %c.1, label %loop.latch, label %exit

loop.latch:
  %t.1 = icmp ult i8* %iv, %upper
  call void @use(i1 %t.1)

  %iv.next = getelementptr inbounds i8, i8* %iv, i8 1
  br label %loop.header

exit:
  ret void
}

define void @loop_pointer_iv_null_start(i8* %end, i8* %upper) {
; CHECK-LABEL: @loop_pointer_iv_null_start(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[END_LT_UPPER:%.*]] = icmp ult i8* [[END:%.*]], [[UPPER:%.*]]
; CHECK-NEXT:    br i1 [[END_LT_UPPER]], label [[LOOP_HEADER:%.*]], label [[EXIT:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8* [ null, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i8* [[IV]], [[END]]
; CHECK-NEXT:    call void @use(i1 [[C_1]])
; CHECK-NEXT:    [[C_2:%.*]] = icmp uge i8* [[IV]], null
; CHECK-NEXT:    call void @use(i1 [[C_2]])
; CHECK-NEXT:    [[C_3:%.*]] = icmp ule i8* [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[C_3]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[C_4:%.*]] = icmp ult i8* [[IV]], [[UPPER]]
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[IV_NEXT]] = getelementptr inbounds i8, i8* [[IV]], i8 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %end.lt.upper = icmp ult i8* %end, %upper
  br i1 %end.lt.upper, label %loop.header, label %exit

loop.header:
  %iv = phi i8* [ null, %entry ], [ %iv.next, %loop.latch ]
  %c.1 = icmp ule i8* %iv, %end
  call void @use(i1 %c.1)

  %c.2 = icmp uge i8* %iv, null
  call void @use(i1 %c.2)

  %c.3 = icmp ule i8* %iv, %end
  br i1 %c.3, label %loop.latch, label %exit

loop.latch:
  %c.4 = icmp ult i8* %iv, %upper
  call void @use(i1 %c.4)

  %iv.next = getelementptr inbounds i8, i8* %iv, i8 1
  br label %loop.header

exit:
  ret void
}

define void @test_start_null_cmp_null(i8* %start) {
; CHECK-LABEL: @test_start_null_cmp_null(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[IV:%.*]] = phi i8* [ null, [[ENTRY:%.*]] ], [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP_I_I122:%.*]] = icmp eq i8* [[IV]], null
; CHECK-NEXT:    br i1 [[CMP_I_I122]], label [[LOOP_LATCH]], label [[EXIT:%.*]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[IV_NEXT]] = getelementptr inbounds i8, i8* [[IV]], i64 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i8* [ null, %entry ], [ %iv.next, %loop.latch ]
  %cmp.i.i122 = icmp eq i8* %iv, null
  br i1 %cmp.i.i122, label %loop.latch, label %exit

loop.latch:
  %iv.next = getelementptr inbounds i8, i8* %iv, i64 1
  br label %loop.header

exit:
  ret void
}
