/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.UtilString;
import com.sqlmagic.tinysql.Utils;
import com.sqlmagic.tinysql.tinySQLPreparedStatement;
import com.sqlmagic.tinysql.tinySQLResultSetMetaData;
import com.sqlmagic.tinysql.tinySQLStatement;
import com.sqlmagic.tinysql.tsColumn;
import com.sqlmagic.tinysql.tsResultSet;
import com.sqlmagic.tinysql.tsRow;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class tinySQLResultSet
implements ResultSet {
    private tinySQLStatement statement = null;
    private tinySQLPreparedStatement preparedStatement = null;
    private tsResultSet result;
    private tsRow current_row;
    private int current_row_index = 0;
    private tinySQLResultSetMetaData meta;
    private Hashtable column_map = null;
    int FETCH_FORWARD = 1000;
    int FETCH_REVERSE = 1001;
    int FETCH_UNKNOWN = 1002;
    int TYPE_FORWARD_ONLY = 1003;
    int TYPE_SCROLL_INSENSITIVE = 1004;
    int TYPE_SCROLL_SENSITIVE = 1005;
    int CONCUR_READ_ONLY = 1007;
    int CONCUR_UPDATABLE = 1008;

    public tinySQLResultSet(tsResultSet tsResultSet2, tinySQLStatement tinySQLStatement2) {
        this.result = tsResultSet2;
        this.statement = tinySQLStatement2;
    }

    public tinySQLResultSet(tsResultSet tsResultSet2, tinySQLPreparedStatement tinySQLPreparedStatement2) {
        this.result = tsResultSet2;
        this.preparedStatement = tinySQLPreparedStatement2;
    }

    public synchronized boolean next() throws SQLException {
        try {
            if (this.result.size() < 1) {
                return false;
            }
            ++this.current_row_index;
            this.current_row = this.result.rowAt(this.current_row_index - 1);
            return this.current_row != null;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public String getString(int n) throws SQLException {
        if (this.current_row == (tsRow)null) {
            return null;
        }
        tsColumn tsColumn2 = this.result.columnAtIndex(n - 1);
        String string = this.current_row.columnAsString(tsColumn2);
        if (Utils.isDateColumn(tsColumn2.type)) {
            string = UtilString.toStandardDate(string);
        }
        return string;
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        if (string.equals("")) {
            return 0;
        }
        return (byte)string.charAt(0);
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            String string = this.getString(n);
            if (string.equals("")) {
                return false;
            }
            return !string.equals("0");
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return (short)Integer.valueOf(string.trim()).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("tinySQL invalid short Number: " + numberFormatException.getMessage());
        }
    }

    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return Integer.MIN_VALUE;
        }
        int n2 = string.indexOf(".");
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        try {
            return Integer.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("tinySQL invalid Long Number: " + numberFormatException.getMessage());
        }
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(string.trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Invalid Number: " + numberFormatException.getMessage());
        }
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("tinySQL invalid double Number: " + numberFormatException.getMessage());
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
        return new BigDecimal(new BigInteger(string.trim()), n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Bad bytes!: " + unsupportedEncodingException.getMessage());
        }
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            java.util.Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            return new Date(date.getTime());
        }
        catch (Exception exception) {
            throw new SQLException("Date format error: " + exception.getMessage());
        }
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
            java.util.Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            return new Time(date.getTime());
        }
        catch (Exception exception) {
            throw new SQLException("Data format error: " + exception.getMessage());
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
            java.util.Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            return new Timestamp(date.getTime());
        }
        catch (Exception exception) {
            throw new SQLException("Data format error: " + exception.getMessage());
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return null;
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.meta == null) {
            this.meta = new tinySQLResultSetMetaData(this.result);
        }
        return this.meta;
    }

    public Object getObject(int n, int n2, int n3) throws SQLException {
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Character((char)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, n3);
            }
            case 3: {
                return this.getBigDecimal(n, n3);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
        }
        return null;
    }

    public Object getObject(int n, int n2) throws SQLException {
        return this.getObject(n, n2, 0);
    }

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        return this.getObject(n, n2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(String string, int n, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n, n2);
    }

    public Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n, 0);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this.column_map == null) {
            int n2 = this.result.numcols();
            this.column_map = new Hashtable(n2);
            int n3 = 0;
            while (n3 < n2) {
                tsColumn tsColumn2 = this.result.columnAtIndex(n3);
                String string2 = tsColumn2.name;
                if (tsColumn2.alias != (String)null) {
                    string2 = tsColumn2.alias;
                }
                this.column_map.put(string2, new Integer(n3));
                ++n3;
            }
        }
        if ((n = (Integer)this.column_map.get(string)) == null) {
            throw new SQLException("Invalid column name: " + string);
        }
        return n + 1;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return null;
    }

    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    public boolean isAfterLast() throws SQLException {
        return false;
    }

    public boolean isFirst() throws SQLException {
        return false;
    }

    public boolean isLast() throws SQLException {
        return false;
    }

    public void beforeFirst() throws SQLException {
    }

    public void afterLast() throws SQLException {
    }

    public boolean first() throws SQLException {
        return false;
    }

    public boolean last() throws SQLException {
        return false;
    }

    public int getRow() throws SQLException {
        return 0;
    }

    public boolean absolute(int n) throws SQLException {
        return false;
    }

    public boolean relative(int n) throws SQLException {
        return false;
    }

    public boolean previous() throws SQLException {
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return this.FETCH_FORWARD;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("Condition 0 <= rows <= this.getMaxRows() is not satisfied");
        }
        this.result.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.result.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.result.getType();
    }

    public int getConcurrency() throws SQLException {
        return this.CONCUR_READ_ONLY;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("tinySQL does not support updateNull.");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("tinySQL does not support updateBoolean.");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("tinySQL does not support updateByte.");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("tinySQL does not support updateShort.");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("tinySQL does not support updateInt.");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("tinySQL does not support updateLong.");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("tinySQL does not support updateFloat.");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("tinySQL does not support updateDouble.");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("tinySQL does not support updateBigDecimal.");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("tinySQL does not support updateString.");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("tinySQL does not support updateBytes.");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("tinySQL does not support updateDate.");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("tinySQL does not support updateTime.");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("tinySQL does not support updateTimestamp.");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("tinySQL does not support updateAsciiStream.");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("tinySQL does not support updateBinaryStream.");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("tinySQL does not support updateCharacterStream.");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("tinySQL does not support updateNull.");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("tinySQL does not support updateBoolean.");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("tinySQL does not support updateByte.");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("tinySQL does not support updateShort.");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("tinySQL does not support updateInt.");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("tinySQL does not support updateLong.");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("tinySQL does not support updateFloat.");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("tinySQL does not support updateDouble.");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("tinySQL does not support updateDecimal.");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("tinySQL does not support updateString.");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("tinySQL does not support updateBytes.");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("tinySQL does not support updateDate.");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("tinySQL does not support updateTime.");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("tinySQL does not support updateTimestamp.");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("tinySQL does not support updateAsciiStream.");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("tinySQL does not support updateBinaryStream.");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("tinySQL does not support updateCharacter.");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("tinySQL does not support updateObject.");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("tinySQL does not support insertRow.");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("tinySQL does not support updateRow.");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("tinySQL does not support deleteRow.");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("tinySQL does not support RefreshRow.");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("tinySQL does not support cancelRowUpdate.");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("tinySQL does not support moveToInsertRow.");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("tinySQL does not support moveToCurrentRow.");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("tinySQL does not support getObject.");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("tinySQL does not support getRef.");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("tinySQL does not support getBlob.");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("tinySQL does not support getClob.");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("tinySQL does not support getArray.");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("tinySQL does not support getObject.");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("tinySQL does not support getRef.");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("tinySQL does not support getBlob.");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("tinySQL does not support getClob.");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("tinySQL does not support getArray.");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("tinySQL does not support getDate.");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException("tinySQL does not support getDate.");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("tinySQL does not support getTime.");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException("tinySQL does not support getTime.");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException("tinySQL does not support getTimestamp.");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException("tinySQL does not support getTimestamp.");
    }
}

