// Copyright (c) 2001 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#include <kcolorbutton.h>
#include <kconfig.h>
#include <kfontdialog.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include "cmodule.h"
#include "jefferson.h"

JeffersonModule::JeffersonModule(QObject *parent)
	: CModule(i18n("Jefferson"), i18n("On-screen Display"), "noatun", parent)
{
	color = new KColorButton(this);
	font = new QLabel(i18n("Text font"), this);
	time = new QSpinBox(0, 15, 1, this);
	QPushButton *fontButton = new QPushButton(i18n("Change Font..."), this);
	connect(fontButton, SIGNAL(clicked()), this, SLOT(selectFont()));
	position = new QButtonGroup(3, Horizontal, i18n("Position"), this);

	position->insert(new QRadioButton(i18n("Top left"), position), (int)KOSD::Top | (int)KOSD::Left);
	position->insert(new QRadioButton(i18n("Top center"), position), (int)KOSD::Top | (int)KOSD::Center);
	position->insert(new QRadioButton(i18n("Top right"), position), (int)KOSD::Top | (int)KOSD::Right);
	position->insert(new QRadioButton(i18n("Center left"), position), (int)KOSD::VerticalCenter | (int)KOSD::Left);
	position->insert(new QRadioButton(i18n("Center"), position), (int)KOSD::VerticalCenter | (int)KOSD::Center);
	position->insert(new QRadioButton(i18n("Center right"), position), (int)KOSD::VerticalCenter | (int)KOSD::Right);
	position->insert(new QRadioButton(i18n("Bottom left"), position), (int)KOSD::Bottom | (int)KOSD::Left);
	position->insert(new QRadioButton(i18n("Bottom center"), position), (int)KOSD::Bottom | (int)KOSD::Center);
	position->insert(new QRadioButton(i18n("Bottom right"), position), (int)KOSD::Bottom | (int)KOSD::Right);
	position->setExclusive(true);

	QVBoxLayout *layout = new QVBoxLayout(this, 0, KDialog::spacingHint());
	QHBoxLayout *colorLayout = new QHBoxLayout(0, 0, KDialog::spacingHint());
	QHBoxLayout *fontLayout = new QHBoxLayout(0, 0, KDialog::spacingHint());
	QHBoxLayout *timeLayout = new QHBoxLayout(0, 0, KDialog::spacingHint());

	timeLayout->addWidget(new QLabel(i18n("Seconds to display"), this));
	timeLayout->addWidget(time);

	colorLayout->addWidget(new QLabel(i18n("Text color"), this));
	colorLayout->addWidget(color);
	fontLayout->addWidget(font);
	fontLayout->addWidget(fontButton);
	layout->addLayout(colorLayout);
	layout->addLayout(fontLayout);
	layout->addLayout(timeLayout);
	layout->addWidget(position);
	layout->addStretch();
}

void JeffersonModule::save(void)
{
	KConfig &config = *KGlobal::config();
	config.setGroup("Jefferson");
	config.writeEntry("color", color->color());
	config.writeEntry("font", font->font());
	config.writeEntry("position", position->id(position->selected()));
	config.writeEntry("time", time->text());
	config.sync();

	Jefferson *tommy = Jefferson::tommy;
	if(tommy)
	{
		tommy->setColor(color->color());
		tommy->setFont(font->font());
		tommy->setPosition(position->id(position->selected()));
		tommy->setTimeout(time->text().toUInt() * 1000);
	}
}

void JeffersonModule::reopen(void)
{
	KConfig &config = *KGlobal::config();
	config.setGroup("Jefferson");
	QColor r(255, 0, 0);
	color->setColor(config.readColorEntry("color", &r));
	QFont f = KGlobalSettings::generalFont();
	font->setFont(config.readFontEntry("font", &f));
	position->setButton(config.readNumEntry("position", (int)KOSD::Top | (int)KOSD::Left));
	if(!position->selected())
		position->setButton((int)KOSD::Top | (int)KOSD::Left);
	time->setValue(config.readNumEntry("time", 5));
}

void JeffersonModule::selectFont(void)
{
	QFont newFont = font->font();
	if(KFontDialog::getFont(newFont, false, this))
		font->setFont(newFont);
}

#include "cmodule.moc"
