/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

public final class TextHitInfo {
    private int charIndex;
    private boolean leadingEdge;

    TextHitInfo(int charIndex, boolean leadingEdge) {
        this.charIndex = charIndex;
        this.leadingEdge = leadingEdge;
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public boolean isLeadingEdge() {
        return this.leadingEdge;
    }

    public int getInsertionIndex() {
        if (this.leadingEdge) {
            return this.charIndex;
        }
        return this.charIndex + 1;
    }

    public int hashCode() {
        return this.charIndex;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextHitInfo) {
            return this.equals((TextHitInfo)obj);
        }
        return false;
    }

    public boolean equals(TextHitInfo hitInfo) {
        return this.charIndex == hitInfo.getCharIndex() && this.leadingEdge == hitInfo.isLeadingEdge();
    }

    public static TextHitInfo leading(int charIndex) {
        return new TextHitInfo(charIndex, true);
    }

    public static TextHitInfo trailing(int charIndex) {
        return new TextHitInfo(charIndex, false);
    }

    public static TextHitInfo beforeOffset(int offset) {
        return new TextHitInfo(offset, false);
    }

    public static TextHitInfo afterOffset(int offset) {
        return new TextHitInfo(offset, true);
    }

    public TextHitInfo getOtherHit() {
        if (this.leadingEdge) {
            return TextHitInfo.trailing(this.charIndex - 1);
        }
        return TextHitInfo.leading(this.charIndex + 1);
    }

    public TextHitInfo getOffsetHit(int offset) {
        return new TextHitInfo(this.charIndex + offset, this.leadingEdge);
    }

    public String toString() {
        return "TextHitInfo[" + this.charIndex + (this.leadingEdge ? "L" : "T") + "]";
    }
}

