/***************************************************************************
                          kwifimanager.cpp  -  description
                             -------------------
    begin                : Sam Apr  7 11:44:20 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for C++
#include <iostream>
#include <fstream>

// include files for QT
#include <qdatetime.h>
#include <qdir.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qimage.h>

// include files for KDE
#include <kmenubar.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kprocess.h>
#include <kstandarddirs.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <kdebug.h>
#include <kstdguiitem.h>
#include <kmessagebox.h>
#include <dcopclient.h>

// application specific includes
#include "asusled.h"
#include "kwifimanager.h"
#include "interface_wireless.h"
#include "interface_wireless_wirelessextensions.h"

#define ID_STATUS_MSG 1

QStringList APs;
bool useAlternateStrengthCalc;

KWiFiManagerApp::KWiFiManagerApp (QWidget *, const char *name, QStringList * ignoreInterfaces):
DCOPObject("dcop_interface"), KMainWindow (0, name)
{
  statistik = 0;
  useAlternateStrengthCalc = false;
  init_whois_db ();

  // substitute the following line with a different interface if required

  device = new Interface_wireless_wirelessextensions (ignoreInterfaces);

  initActions ();

  led = new Led ();

  trayicon = new KSystemTray (this);
  trayicon->show ();

  // initView updates the main widget, system tray icon and the ASUS led if applicable

  initView ();

  fileDisableRadio->setEnabled (true);

  counter = new QTimer (this);
  connect (counter, SIGNAL (timeout ()), device, SLOT (poll_device_info()));
  counter->start (1000);

  tricorder_trigger = new QTimer ();
  connect (tricorder_trigger, SIGNAL (timeout ()), this,
	   SLOT (tricorder_beep ()));
  connect (trayicon, SIGNAL (quitSelected ()), this, SLOT (slotFileQuit ()));
}

void
KWiFiManagerApp::slotChangeWindowCaption ()
{
  if (device->get_interface_name () == "")
    {
      this->setCaption (i18n ("No Interface"));
    }
  else
    {
      this->setCaption (i18n ("Interface %1").
			arg (device->get_interface_name ()));
    }
}

KWiFiManagerApp::~KWiFiManagerApp ()
{
  kdDebug () <<
    "Thank you for using KWiFiManager. You have made a simple program very happy.\n";
  delete statistik;
  delete tricorder_trigger;
}

void
KWiFiManagerApp::init_whois_db ()
{
  KStandardDirs finder;
  QString kdedir =
    finder.findResourceDir ("data", "kwifimanager/locations/NOWHERE.loc");
  kdedir += "kwifimanager/locations/";
  QDir *locations = new QDir (kdedir);
  if (!locations->exists ())
    kdDebug () <<
      "A grave error occurred while searching for files with AccessPoint information.\n";
  QStringList *entries = new QStringList (locations->entryList ());
  QString content;
  QString content2;
  for (QStringList::Iterator it = entries->begin (); it != entries->end ();
       it++)
    {
      if ((*it) != "." && (*it) != "..")
	{
	  QFile datei (kdedir + (*it));
	  datei.open (IO_ReadOnly);
	  while (datei.readLine (content, 255) != -1)
	    {
	      QString temp (content);
	      content.truncate (content.find (' '));
	      content = content.upper ();
	      content2 = temp.right (temp.length () - temp.find (' ') - 1);
	      content2.truncate (content2.length () - 1);
	      APs << content << content2;
	    }
	  datei.close ();
	}
    }
  delete entries;
  delete locations;
}

void
KWiFiManagerApp::slotLogESSID (QString essid)
{
  QFile ausgabe2 (QDir::homeDirPath () + "/wireless.log");
  if (!ausgabe2.open (IO_WriteOnly | IO_Append))
    kdDebug () << "Logging failed!\n";
  QDateTime zeit = QDateTime::currentDateTime ();
  QTextStream stream (&ausgabe2);
  stream << zeit.toString ().latin1 ();
  stream << " Entering network: ";
  stream << essid.latin1 ();
  stream << "\n";
  ausgabe2.close ();
}

void
KWiFiManagerApp::slotChangeTrayIcon ()
{
  QPixmap temp (30, 30);
  QPainter bla (&temp);
  if (paletteBackgroundPixmap () == 0)
    {
      bla.fillRect (0, 0, 30, 30, backgroundBrush ());
    }
  else
    {
      bla.drawPixmap (0, 0, *paletteBackgroundPixmap ());
    }
  QPixmap* ICON;
  int sig, noi, str;
  double freq;
  bool validdata = device->get_current_quality (sig, noi, str);
  if (useAlternateStrengthCalc) str = sig - noi;
  int mode;
  QString sstrength1 = "%1";
  QString sstrength2 = "%1";
  if (!device->get_device_freq (freq))
    {
      sstrength1 = sstrength1.arg (i18n ("NOT CONNECTED"));
      sstrength2 = sstrength2.arg (i18n ("N/A"));
      ICON = strength->NOT_CON_OFFLINE_ADHOC;
      if (led->state == true)
	led->Off ();
    }
  else if (device->get_mode(mode) && mode == 1)
    {
      sstrength1 = sstrength1.arg (i18n ("AD-HOC MODE"));
      sstrength2 = sstrength2.arg (i18n ("N/A"));
      ICON = strength->NOT_CON_OFFLINE_ADHOC;
      if (led->state == true)
	led->Off ();
    }
  else if (validdata && (str > 45))
    {
      sstrength1 = sstrength1.arg (i18n ("ULTIMATE"));
      sstrength2 = sstrength2.arg (str);
      ICON = strength->EXCELLENT;
      if (led->state == false)
	led->On ();
    }
  else if (validdata && (str > 35))
    {
      sstrength1 = sstrength1.arg (i18n ("TOP"));
      sstrength2 = sstrength2.arg (str);
      ICON = strength->EXCELLENT;
      if (led->state == false)
	led->On ();
    }
  else if (validdata && (str > 25))
    {
      sstrength1 = sstrength1.arg (i18n ("EXCELLENT"));
      sstrength2 = sstrength2.arg (str);
      ICON = strength->EXCELLENT;
      if (led->state == false)
	led->On ();
    }
  else if (validdata && (str > 15))
    {
      sstrength1 = sstrength1.arg (i18n ("GOOD"));
      sstrength2 = sstrength2.arg (str);
      ICON = strength->GOOD;
      if (led->state == false)
	led->On ();
    }
  else if (validdata && (str > 5))
    {
      sstrength1 = sstrength1.arg (i18n ("WEAK"));
      sstrength2 = sstrength2.arg (str);
      ICON = strength->MARGINAL;
      if (led->state == false)
	led->On ();
    }
  else if (validdata && (str > 0))
    {
      sstrength1 = sstrength1.arg (i18n ("MINIMUM"));
      sstrength2 = sstrength2.arg (str);
      ICON = strength->OOR_MINIMUM;
      if (led->state == true)
	led->Off ();
    }
  else if (((str == 0) && (mode == 2)) || (!validdata))
    {
      sstrength1 = sstrength1.arg (i18n ("OUT OF RANGE"));
      sstrength2 = sstrength2.arg ("0");
      ICON = strength->OOR_DOWN;
      if (led->state == true)
	led->Off ();
    }
  else
    {
      sstrength1 = sstrength1.arg (i18n ("N/A"));
      sstrength2 = sstrength2.arg ("N/A");
      ICON = strength->NOT_CON_OFFLINE_ADHOC;
      if (led->state == true)
	led->Off ();
    }
  
  bla.drawText (0, 0, 15, 15, 0, sstrength2);
  bla.drawPixmap (1, 4, *ICON);
  trayicon->setPixmap (temp);
  this->setIcon (temp);
}

void
KWiFiManagerApp::initActions ()
{
  fileDisableRadio =
    new KToggleAction (i18n ("&Disable Radio"), 0, this,
		       SLOT (slotDisableRadio ()), actionCollection ());
  fileDisableRadio->setChecked( false);
  fileUseAlternateCalc =
    new KToggleAction (i18n ("&Use Alternate Strength Calculation"), 0, this,
		       SLOT (slotToggleStrengthCalc ()), actionCollection ());
  fileQuit =
    KStdAction::quit (this, SLOT (slotFileQuit ()), actionCollection ());
  KAction *conf = new KAction (i18n ("Configuration &Editor"), 0, this,
			       SLOT (slotStartConfigEditor ()), this);
  KAction *stat = new KAction (i18n ("Connection &Statistics"), 0, this,
			       SLOT (slotStartStatViewer ()), this);
  KAction *tric = new KToggleAction (i18n ("&Acoustic Scanning"), 0, this,
				     SLOT (slotToggleTric ()),
				     actionCollection ());
				     
#ifdef WITHOUT_ARTS
  tric->setEnabled(false);
#endif

  KPopupMenu *help = helpMenu (QString::null, false);
  QPopupMenu *filemenu = new QPopupMenu;
  QPopupMenu *editmenu = new QPopupMenu;
  conf->plug (editmenu);
  tric->plug (editmenu);
  fileDisableRadio->plug (filemenu);
  fileUseAlternateCalc->plug (filemenu);
  stat->plug (filemenu);
  fileQuit->plug (filemenu);
  menuBar ()->insertItem (i18n ("&File"), filemenu);
  menuBar ()->insertItem (i18n ("&Config"), editmenu);
  menuBar ()->insertItem (KStdGuiItem::help ().text (), help);
}


void
KWiFiManagerApp::initView ()
{
  view = new QWidget (this, "mainwidget");
  view->setBackgroundMode (PaletteBackground);
  setCentralWidget (view);
  QGridLayout *zentrallayout = new QGridLayout (view);
  speedmeter = new Speed (view, device);
  status = new Status (view, device);
  location = new Locator (view, device);
  strength = new Strength (view, device);
  pictogram = new Picture (view, device);
  scan = new QPushButton (i18n("Scan for Networks..."),view);
  slotChangeTrayIcon ();
  slotChangeWindowCaption ();
  QToolTip::add (strength, i18n ("The current signal strength"));
  QToolTip::add (speedmeter, i18n ("The speed at which the wireless LAN card is operating"));
  QToolTip::add (status, i18n ("Detailed connection status"));
  QToolTip::add (scan, i18n ("Performs a scan to discover the networks you can log into"));
  pictogram->setMinimumSize (pictogram->sizeHint());
  strength->setMinimumSize (strength->sizeHint());
  speedmeter->setMinimumHeight (60);
  status->setMinimumHeight (60);
  zentrallayout->addWidget (pictogram, 0, 0);
  zentrallayout->addWidget (strength, 1, 0);
  zentrallayout->addWidget (speedmeter, 0, 1);
  zentrallayout->addMultiCellWidget (status, 1, 2, 1, 1);
  zentrallayout->addWidget (scan, 2, 0);
  zentrallayout->addMultiCellWidget (location, 3, 3, 0, 1, Qt::AlignLeft);
  connect (device, SIGNAL (interfaceChanged ()), this, SLOT (slotChangeWindowCaption ()));
  connect (device, SIGNAL (strengthChanged ()), this, SLOT (slotChangeTrayIcon ()));
  connect (device, SIGNAL (strengthChanged ()), strength, SLOT (repaint ()));
  connect (device, SIGNAL (statusChanged ()), status, SLOT (repaint ()));
  connect (device, SIGNAL (speedChanged ()), speedmeter, SLOT (repaint ()));
  connect (device, SIGNAL (modeChanged ()), pictogram, SLOT (repaint ()));
  connect (device, SIGNAL (essidChanged (QString)), this, SLOT (slotLogESSID (QString)));
  connect (scan ,  SIGNAL (clicked()), this, SLOT (slotNetworkScan()));
}

void
KWiFiManagerApp::slotStartStatViewer ()
{
  delete statistik;
  statistik = new Statistics (device);
  statistik->setFixedSize (590, 300);
  connect(device,SIGNAL(statsUpdated()),statistik,SLOT(repaint()));
  statistik->show ();
}

void
KWiFiManagerApp::slotDisableRadio ()
{
  kdDebug () << "Later, this will deactivate the card's radio.\n";
}

void
KWiFiManagerApp::slotToggleTric ()
{
  if (tricorder_trigger->isActive ())
    {
      tricorder_trigger->stop ();
    }
  else
    {
      tricorder_trigger->start (250);
    }
}

void KWiFiManagerApp::slotToggleStrengthCalc ()
{
  useAlternateStrengthCalc = fileUseAlternateCalc->isChecked();
}

void
KWiFiManagerApp::tricorder_beep ()
{
  int sig, noi, qual;
  device->get_current_quality (sig, noi, qual);
#ifndef WITHOUT_ARTS
  sinus_wave (150.0 + qual * 20);
#endif
  if (qual == 0)
    {
      tricorder_trigger->changeInterval (2000);
    }
  else if (qual < 10)
    {
      tricorder_trigger->changeInterval (1000);
    }
  else
    {
      tricorder_trigger->changeInterval (500);
    }
}

void
KWiFiManagerApp::slotFileQuit ()
{
  KMainWindow::closeEvent (new QCloseEvent ());
}

void
KWiFiManagerApp::slotStartConfigEditor ()
{
  KProcess startConf;
  startConf << "kdesu" << "kcmshell" << "kcmwifi";
  startConf.start (KProcess::DontCare);
}

void
KWiFiManagerApp::closeEvent (QCloseEvent *)
{
  hide ();
}

void
KWiFiManagerApp::slotNetworkScan ()
{
  QLabel waitMessage(i18n("Scan in progress..."),0);
  waitMessage.setFixedSize(waitMessage.sizeHint());
  waitMessage.show();
  QStringList networks = device->get_available_networks ();
  waitMessage.hide();
  if (!networks.isEmpty()) {
    KMessageBox::informationList(0,i18n("Available networks:"),networks);
    } else
    {
    KMessageBox::sorry(0,i18n("The scan is complete, but no networks have been found."),i18n("No Network Available"));
    }
}

#include "kwifimanager.moc"
