/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_8
extends Charset {
    UTF_8() {
        super("UTF-8", null);
    }

    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII || cs instanceof ISO_8859_1 || cs instanceof UTF_8 || cs instanceof UTF_16BE || cs instanceof UTF_16LE || cs instanceof UTF_16;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        private Encoder(Charset cs) {
            super(cs, 1.1f, 4.0f);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            CoderResult coderResult;
            int inPos;
            block22: {
                CoderResult coderResult2;
                block21: {
                    CoderResult coderResult3;
                    block20: {
                        CoderResult coderResult4;
                        block19: {
                            CoderResult coderResult5;
                            block18: {
                                CoderResult coderResult6;
                                block17: {
                                    CoderResult coderResult7;
                                    block16: {
                                        inPos = 0;
                                        try {
                                            while (in.hasRemaining()) {
                                                int remaining = out.remaining();
                                                char c = in.get();
                                                if (c <= '\u007f') {
                                                    if (remaining < 1) {
                                                        CoderResult coderResult8 = CoderResult.OVERFLOW;
                                                        Object var8_8 = null;
                                                        in.position(inPos);
                                                        return coderResult8;
                                                    } else {
                                                        out.put((byte)c);
                                                        ++inPos;
                                                        continue;
                                                    }
                                                }
                                                if (c <= '\u07ff') {
                                                    if (remaining < 2) {
                                                        coderResult7 = CoderResult.OVERFLOW;
                                                        break block16;
                                                    } else {
                                                        out.put((byte)((byte)(c >> 6) | 0xFFFFFFC0));
                                                        out.put((byte)((byte)c & 0x3F | 0xFFFFFF80));
                                                        ++inPos;
                                                        continue;
                                                    }
                                                }
                                                if ('\ud800' <= c && c <= '\udfff') {
                                                    if (remaining < 4) {
                                                        coderResult6 = CoderResult.OVERFLOW;
                                                        break block17;
                                                    }
                                                    if (c > '\udbff') {
                                                        coderResult5 = CoderResult.malformedForLength(1);
                                                        break block18;
                                                    }
                                                    if (!in.hasRemaining()) {
                                                        coderResult4 = CoderResult.UNDERFLOW;
                                                        break block19;
                                                    }
                                                    char d = in.get();
                                                    if (d < '\udc00' || d > '\udfff') {
                                                        coderResult3 = CoderResult.malformedForLength(1);
                                                        break block20;
                                                    } else {
                                                        int value = ((c & 0x3FF) << 10 | d & 0x3FF) + 65536;
                                                        out.put((byte)((byte)(value >> 18) | 0xFFFFFFF0));
                                                        out.put((byte)((byte)(value >> 12) & 0x3F | 0xFFFFFF80));
                                                        out.put((byte)((byte)(value >> 6) & 0x3F | 0xFFFFFF80));
                                                        out.put((byte)((byte)value & 0x3F | 0xFFFFFF80));
                                                        inPos += 2;
                                                        continue;
                                                    }
                                                }
                                                if (remaining < 3) {
                                                    coderResult2 = CoderResult.OVERFLOW;
                                                    break block21;
                                                }
                                                out.put((byte)((byte)(c >> 12) | 0xFFFFFFE0));
                                                out.put((byte)((byte)(c >> 6) & 0x3F | 0xFFFFFF80));
                                                out.put((byte)((byte)c & 0x3F | 0xFFFFFF80));
                                                ++inPos;
                                            }
                                            coderResult = CoderResult.UNDERFLOW;
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            Object var8_16 = null;
                                            in.position(inPos);
                                            throw throwable;
                                        }
                                    }
                                    Object var8_9 = null;
                                    in.position(inPos);
                                    return coderResult7;
                                }
                                Object var8_10 = null;
                                in.position(inPos);
                                return coderResult6;
                            }
                            Object var8_11 = null;
                            in.position(inPos);
                            return coderResult5;
                        }
                        Object var8_12 = null;
                        in.position(inPos);
                        return coderResult4;
                    }
                    Object var8_13 = null;
                    in.position(inPos);
                    return coderResult3;
                }
                Object var8_14 = null;
                in.position(inPos);
                return coderResult2;
            }
            Object var8_15 = null;
            in.position(inPos);
            return coderResult;
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            CoderResult coderResult;
            int inPos;
            block31: {
                CoderResult coderResult2;
                block30: {
                    CoderResult coderResult3;
                    block29: {
                        CoderResult coderResult4;
                        block28: {
                            CoderResult coderResult5;
                            block27: {
                                CoderResult coderResult6;
                                block26: {
                                    CoderResult coderResult7;
                                    block25: {
                                        CoderResult coderResult8;
                                        block24: {
                                            CoderResult coderResult9;
                                            block23: {
                                                CoderResult coderResult10;
                                                block22: {
                                                    CoderResult coderResult11;
                                                    block21: {
                                                        inPos = 0;
                                                        try {
                                                            block7: while (in.hasRemaining()) {
                                                                byte b1 = in.get();
                                                                int highNibble = b1 >> 4 & 0xF;
                                                                switch (highNibble) {
                                                                    case 0: 
                                                                    case 1: 
                                                                    case 2: 
                                                                    case 3: 
                                                                    case 4: 
                                                                    case 5: 
                                                                    case 6: 
                                                                    case 7: {
                                                                        if (out.remaining() < 1) {
                                                                            CoderResult coderResult12 = CoderResult.OVERFLOW;
                                                                            Object var10_21 = null;
                                                                            in.position(inPos);
                                                                            return coderResult12;
                                                                        } else {
                                                                            out.put((char)b1);
                                                                            ++inPos;
                                                                            continue block7;
                                                                        }
                                                                    }
                                                                    case 12: 
                                                                    case 13: {
                                                                        if (in.remaining() < 1) {
                                                                            coderResult11 = CoderResult.UNDERFLOW;
                                                                            break block21;
                                                                        }
                                                                        if (out.remaining() < 1) {
                                                                            coderResult10 = CoderResult.OVERFLOW;
                                                                            break block22;
                                                                        }
                                                                        byte b2 = in.get();
                                                                        if (!Decoder.isContinuation(b2)) {
                                                                            coderResult9 = CoderResult.malformedForLength(1);
                                                                            break block23;
                                                                        }
                                                                        char c = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                                                                        if (c <= '\u007f') {
                                                                            coderResult8 = CoderResult.malformedForLength(2);
                                                                            break block24;
                                                                        } else {
                                                                            out.put(c);
                                                                            inPos += 2;
                                                                            continue block7;
                                                                        }
                                                                    }
                                                                    case 14: {
                                                                        if (in.remaining() < 2) {
                                                                            coderResult7 = CoderResult.UNDERFLOW;
                                                                            break block25;
                                                                        }
                                                                        if (out.remaining() < 1) {
                                                                            coderResult6 = CoderResult.OVERFLOW;
                                                                            break block26;
                                                                        }
                                                                        byte b2 = in.get();
                                                                        if (!Decoder.isContinuation(b2)) {
                                                                            coderResult5 = CoderResult.malformedForLength(1);
                                                                            break block27;
                                                                        }
                                                                        byte b3 = in.get();
                                                                        if (!Decoder.isContinuation(b3)) {
                                                                            coderResult4 = CoderResult.malformedForLength(1);
                                                                            break block28;
                                                                        }
                                                                        char c = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                                                                        if (c <= '\u07ff') {
                                                                            coderResult3 = CoderResult.malformedForLength(3);
                                                                            break block29;
                                                                        } else {
                                                                            out.put(c);
                                                                            inPos += 3;
                                                                            continue block7;
                                                                        }
                                                                    }
                                                                    default: {
                                                                        coderResult2 = CoderResult.malformedForLength(1);
                                                                        break;
                                                                    }
                                                                }
                                                                break block30;
                                                            }
                                                            coderResult = CoderResult.UNDERFLOW;
                                                            break block31;
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var10_33 = null;
                                                            in.position(inPos);
                                                            throw throwable;
                                                        }
                                                    }
                                                    Object var10_22 = null;
                                                    in.position(inPos);
                                                    return coderResult11;
                                                }
                                                Object var10_23 = null;
                                                in.position(inPos);
                                                return coderResult10;
                                            }
                                            Object var10_24 = null;
                                            in.position(inPos);
                                            return coderResult9;
                                        }
                                        Object var10_25 = null;
                                        in.position(inPos);
                                        return coderResult8;
                                    }
                                    Object var10_26 = null;
                                    in.position(inPos);
                                    return coderResult7;
                                }
                                Object var10_27 = null;
                                in.position(inPos);
                                return coderResult6;
                            }
                            Object var10_28 = null;
                            in.position(inPos);
                            return coderResult5;
                        }
                        Object var10_29 = null;
                        in.position(inPos);
                        return coderResult4;
                    }
                    Object var10_30 = null;
                    in.position(inPos);
                    return coderResult3;
                }
                Object var10_31 = null;
                in.position(inPos);
                return coderResult2;
            }
            Object var10_32 = null;
            in.position(inPos);
            return coderResult;
        }

        private static boolean isContinuation(byte b) {
            return (b & 0xC0) == 128;
        }
    }
}

