/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicButtonUI
extends ButtonUI {
    int gap;
    Color textColor;
    Color disabledTextColor;
    Color pressedBackgroundColor;
    Color normalBackgroundColor;

    private /* synthetic */ void finit$() {
        this.gap = 3;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicButtonUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.textColor = new Color(0, 0, 0);
        this.disabledTextColor = new Color(130, 130, 130);
        this.pressedBackgroundColor = new Color(150, 150, 150);
        this.pressedBackgroundColor = new Color(150, 150, 150);
        this.normalBackgroundColor = new Color(192, 192, 192);
    }

    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(b, this.gap);
        return d;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Rectangle tr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle vr = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        Insets i = c.getInsets();
        vr.x = i.left;
        vr.y = i.top;
        vr.width = b.getWidth() - (i.right + vr.x);
        vr.height = b.getHeight() - (i.bottom + vr.y);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), vr, ir, tr, this.gap);
        if (b.getModel().isPressed() || b.getModel().isSelected()) {
            this.paintButtonPressed(g, c);
        } else {
            this.paintButtonNormal(g, c);
        }
        this.paintIcon(g, c, ir);
        this.paintText(g, c, tr, b.getText());
        this.paintFocus(g, c, vr, tr, ir);
    }

    protected void paintFocus(Graphics g, JComponent c, Rectangle vr, Rectangle tr, Rectangle ir) {
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        if (b.getIcon() != null) {
            int x = iconRect.x;
            int y = iconRect.y;
            System.out.println("WE HAVE AN ICON: " + b.getIcon());
            b.getIcon().paintIcon(c, g, x, y);
        }
    }

    protected void paintButtonPressed(Graphics g, JComponent b) {
        Dimension size = b.getSize();
        g.setColor(this.pressedBackgroundColor);
        g.fillRect(1, 1, size.width - 2, size.height - 2);
    }

    protected void paintButtonNormal(Graphics g, JComponent b) {
        Dimension size = b.getSize();
        g.setColor(this.normalBackgroundColor);
        g.fillRect(1, 1, size.width - 2, size.height - 2);
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        g.setColor(c.isEnabled() ? this.textColor : this.disabledTextColor);
        BasicGraphicsUtils.drawString(g, text, 0, textRect.x, textRect.y + fm.getAscent() / 2);
    }

    public BasicButtonUI() {
        this.finit$();
    }
}

