/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBufferImpl;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

public abstract class ByteBuffer
extends Buffer
implements Comparable {
    private ByteOrder endian;
    int array_offset;
    byte[] backing_buffer;

    private /* synthetic */ void finit$() {
        this.endian = ByteOrder.BIG_ENDIAN;
    }

    ByteBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
        this.finit$();
        this.array_offset = 0;
    }

    ByteBuffer(byte[] buffer, int offset, int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
        this.finit$();
        this.backing_buffer = buffer;
        this.array_offset = offset;
    }

    public static ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocate(capacity);
    }

    public static ByteBuffer allocate(int capacity) {
        return new ByteBufferImpl(capacity);
    }

    public static final ByteBuffer wrap(byte[] array, int offset, int length) {
        return new ByteBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array, 0, array.length);
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        if (offset < 0 || offset > dst.length || length < 0 || length > dst.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer put(ByteBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (src.remaining() > 0) {
            byte[] toPut = new byte[src.remaining()];
            src.get(toPut);
            src.put(toPut);
        }
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        if (offset < 0 || offset > src.length || length < 0 || length > src.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final byte[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object obj) {
        ByteBuffer a = (ByteBuffer)obj;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = this.get(i1) - a.get(i2);
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public final ByteOrder order() {
        return this.endian;
    }

    public final ByteBuffer order(ByteOrder endian) {
        this.endian = endian;
        return this;
    }

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer compact();

    void shiftDown(int dst_offset, int src_offset, int count) {
        for (int i = 0; i < count; ++i) {
            this.put(dst_offset + i, this.get(src_offset + i));
        }
    }

    public abstract boolean isDirect();

    public abstract ByteBuffer slice();

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract ShortBuffer asShortBuffer();

    public abstract CharBuffer asCharBuffer();

    public abstract IntBuffer asIntBuffer();

    public abstract LongBuffer asLongBuffer();

    public abstract FloatBuffer asFloatBuffer();

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }
}

