import SCons.Tool
import SCons.Defaults
import SCons.Util
CSuffixes=['.c']
if not SCons.Util.case_sensitive_suffixes('.c', '.C'):
    CSuffixes.append('.C')
def generate(env):
    static_obj, shared_obj=SCons.Tool.createObjBuilders(env)
    for suffix in CSuffixes:
        static_obj.add_action(suffix, SCons.Defaults.CAction)
        shared_obj.add_action(suffix, SCons.Defaults.ShCAction)
        static_obj.add_emitter(suffix, SCons.Defaults.StaticObjectEmitter)
        shared_obj.add_emitter(suffix, SCons.Defaults.SharedObjectEmitter)
    env['CC']       ='cc'
    env['CCFLAGS']  =SCons.Util.CLVar('')
    env['CCCOM']    ='$CC $CCFLAGS $CPPFLAGS $_CPPDEFFLAGS $_CPPINCFLAGS -c -o $TARGET $SOURCES'
    env['SHCC']     ='$CC'
    env['SHCCFLAGS']=SCons.Util.CLVar('$CCFLAGS')
    env['SHCCCOM']  ='$SHCC $SHCCFLAGS $CPPFLAGS $_CPPDEFFLAGS $_CPPINCFLAGS -c -o $TARGET $SOURCES'
    env['CPPDEFPREFIX'] ='-D'
    env['CPPDEFSUFFIX'] =''
    env['INCPREFIX'] ='-I'
    env['INCSUFFIX'] =''
    env['SHOBJSUFFIX']='.os'
    env['STATIC_AND_SHARED_OBJECTS_ARE_THE_SAME']=0
    env['CFILESUFFIX']='.c'
def exists(env):
    return env.Detect('cc')
