/* Generated by re2c 0.11.0 on Fri Apr 13 10:06:46 2007 */
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.c,v 1.29.2.30.2.13 2007/04/13 08:10:55 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { add_warning(s, "Double timezone specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->special.type = relunit->multiplier;
			s->time->special.amount = amount;
	}
}

const static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;


{
	static unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 200,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		200,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,  32, 128,  96, 192,   0, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  16,  16,  16, 144,  16,  16,  16, 
		144,  16,  16,  16,  16,  16, 144,  16, 
		 16,  16, 144, 144, 144,  16,  16,  16, 
		 16,  16,  16,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;

		YYDEBUG(0, *YYCURSOR);
		if((YYLIMIT - YYCURSOR) < 29) YYFILL(29);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x00:
		case 0x0A:	goto yy48;
		case 0x09:
		case ' ':	goto yy45;
		case '(':	goto yy42;
		case '+':
		case '-':	goto yy41;
		case ',':
		case '.':	goto yy47;
		case '0':	goto yy13;
		case '1':	goto yy14;
		case '2':	goto yy15;
		case '3':	goto yy16;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy17;
		case '@':	goto yy11;
		case 'A':	goto yy25;
		case 'B':
		case 'C':
		case 'G':
		case 'H':
		case 'K':
		case 'Q':
		case 'R':
		case 'U':
		case 'Z':	goto yy43;
		case 'D':	goto yy31;
		case 'E':	goto yy35;
		case 'F':	goto yy23;
		case 'I':	goto yy18;
		case 'J':	goto yy21;
		case 'L':	goto yy37;
		case 'M':	goto yy7;
		case 'N':	goto yy5;
		case 'O':	goto yy29;
		case 'P':	goto yy39;
		case 'S':	goto yy27;
		case 'T':	goto yy9;
		case 'V':	goto yy19;
		case 'W':	goto yy33;
		case 'X':	goto yy20;
		case 'Y':	goto yy2;
		case 'a':	goto yy26;
		case 'b':
		case 'c':
		case 'g':
		case 'h':
		case 'i':
		case 'k':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z':	goto yy44;
		case 'd':	goto yy32;
		case 'e':	goto yy36;
		case 'f':	goto yy24;
		case 'j':	goto yy22;
		case 'l':	goto yy38;
		case 'm':	goto yy8;
		case 'n':	goto yy6;
		case 'o':	goto yy30;
		case 'p':	goto yy40;
		case 's':	goto yy28;
		case 't':	goto yy10;
		case 'w':	goto yy34;
		case 'y':	goto yy4;
		default:	goto yy50;
		}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= 'E') {
			if(yych <= ')') {
				if(yych >= ')') goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy137;
				goto yy1375;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy137;
				if(yych >= 'a') goto yy142;
			} else {
				if(yych <= 'e') goto yy1384;
				if(yych <= 'z') goto yy142;
			}
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
		YYDEBUG(4, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy137;
				goto yy1375;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'e') goto yy1375;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy5:
		YYDEBUG(5, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'D') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'H') {
					if(yych <= 'E') goto yy1346;
					goto yy137;
				} else {
					if(yych <= 'I') goto yy1347;
					if(yych <= 'N') goto yy137;
					goto yy1345;
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= '`') {
					if(yych <= 'Z') goto yy137;
					goto yy3;
				} else {
					if(yych == 'e') goto yy1362;
					goto yy142;
				}
			} else {
				if(yych <= 'n') {
					if(yych <= 'i') goto yy1363;
					goto yy142;
				} else {
					if(yych <= 'o') goto yy1361;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy6:
		YYDEBUG(6, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'D') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'H') {
					if(yych <= 'E') goto yy1346;
					goto yy137;
				} else {
					if(yych <= 'I') goto yy1347;
					if(yych <= 'N') goto yy137;
					goto yy1345;
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= '`') {
					if(yych <= 'Z') goto yy137;
					goto yy3;
				} else {
					if(yych == 'e') goto yy1346;
					goto yy137;
				}
			} else {
				if(yych <= 'n') {
					if(yych <= 'i') goto yy1347;
					goto yy137;
				} else {
					if(yych <= 'o') goto yy1345;
					if(yych <= 'z') goto yy137;
					goto yy3;
				}
			}
		}
yy7:
		YYDEBUG(7, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'A') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy1315;
			} else {
				if(yych == 'I') goto yy1316;
				if(yych <= 'N') goto yy137;
				goto yy1317;
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy1330;
				goto yy142;
			} else {
				if(yych <= 'n') {
					if(yych <= 'i') goto yy1331;
					goto yy142;
				} else {
					if(yych <= 'o') goto yy1332;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'A') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy1315;
			} else {
				if(yych == 'I') goto yy1316;
				if(yych <= 'N') goto yy137;
				goto yy1317;
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy1315;
				goto yy137;
			} else {
				if(yych <= 'n') {
					if(yych <= 'i') goto yy1316;
					goto yy137;
				} else {
					if(yych <= 'o') goto yy1317;
					if(yych <= 'z') goto yy137;
					goto yy3;
				}
			}
		}
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case ')':	goto yy136;
		case '0':
		case '1':	goto yy1247;
		case '2':	goto yy1248;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy1249;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':	goto yy137;
		case 'E':	goto yy1242;
		case 'H':	goto yy1243;
		case 'O':	goto yy1244;
		case 'U':	goto yy1245;
		case 'W':	goto yy1246;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z':	goto yy142;
		case 'e':	goto yy1284;
		case 'h':	goto yy1285;
		case 'o':	goto yy1286;
		case 'u':	goto yy1287;
		case 'w':	goto yy1288;
		default:	goto yy3;
		}
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case ')':	goto yy136;
		case '0':
		case '1':	goto yy1247;
		case '2':	goto yy1248;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy1249;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z':	goto yy137;
		case 'E':
		case 'e':	goto yy1242;
		case 'H':
		case 'h':	goto yy1243;
		case 'O':
		case 'o':	goto yy1244;
		case 'U':
		case 'u':	goto yy1245;
		case 'W':
		case 'w':	goto yy1246;
		default:	goto yy3;
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '-') goto yy1238;
		if(yych <= '/') goto yy12;
		if(yych <= '9') goto yy1239;
yy12:
		YYDEBUG(12, *YYCURSOR);
		{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:	goto yy1200;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'w':
		case 'y':	goto yy1202;
		case '-':	goto yy662;
		case '.':	goto yy1204;
		case '/':	goto yy661;
		case '0':	goto yy1237;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy1236;
		case ':':	goto yy1205;
		case 'n':	goto yy659;
		case 'r':	goto yy660;
		case 's':	goto yy653;
		case 't':	goto yy657;
		default:	goto yy12;
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:	goto yy649;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y':	goto yy651;
		case '-':	goto yy662;
		case '.':	goto yy663;
		case '/':	goto yy661;
		case '0':
		case '1':
		case '2':	goto yy1236;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy1203;
		case ':':	goto yy672;
		case 'n':	goto yy659;
		case 'r':	goto yy660;
		case 's':	goto yy653;
		case 't':	goto yy657;
		default:	goto yy12;
		}
yy15:
		YYDEBUG(15, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:	goto yy649;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y':	goto yy651;
		case '-':	goto yy662;
		case '.':	goto yy663;
		case '/':	goto yy661;
		case '0':
		case '1':
		case '2':
		case '3':	goto yy1203;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy1199;
		case ':':	goto yy672;
		case 'n':	goto yy659;
		case 'r':	goto yy660;
		case 's':	goto yy653;
		case 't':	goto yy657;
		default:	goto yy12;
		}
yy16:
		YYDEBUG(16, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:	goto yy649;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y':	goto yy651;
		case '-':	goto yy662;
		case '.':	goto yy663;
		case '/':	goto yy661;
		case '0':
		case '1':	goto yy1199;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy658;
		case ':':	goto yy672;
		case 'n':	goto yy659;
		case 'r':	goto yy660;
		case 's':	goto yy653;
		case 't':	goto yy657;
		default:	goto yy12;
		}
yy17:
		YYDEBUG(17, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:	goto yy649;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y':	goto yy651;
		case '-':	goto yy662;
		case '.':	goto yy663;
		case '/':	goto yy661;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy658;
		case ':':	goto yy672;
		case 'n':	goto yy659;
		case 'r':	goto yy660;
		case 's':	goto yy653;
		case 't':	goto yy657;
		default:	goto yy12;
		}
yy18:
		YYDEBUG(18, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy3;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy3;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy3;
				} else {
					if(yych == '/') goto yy3;
					goto yy314;
				}
			}
		} else {
			if(yych <= 'V') {
				if(yych <= 'H') {
					if(yych <= '@') goto yy3;
					goto yy137;
				} else {
					if(yych <= 'I') goto yy648;
					if(yych <= 'U') goto yy137;
					goto yy647;
				}
			} else {
				if(yych <= 'Z') {
					if(yych == 'X') goto yy647;
					goto yy137;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy3;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy3;
				goto yy314;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'Z') {
					if(yych <= 'I') goto yy644;
					goto yy137;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy3;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy3;
				goto yy314;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'Z') {
					if(yych <= 'I') goto yy642;
					goto yy137;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= 'A') goto yy625;
				if(yych <= 'T') goto yy137;
				goto yy624;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy634;
			} else {
				if(yych == 'u') goto yy633;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= 'A') goto yy625;
				if(yych <= 'T') goto yy137;
				goto yy624;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy625;
			} else {
				if(yych == 'u') goto yy624;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= 'E') {
				if(yych <= ')') {
					if(yych <= '(') goto yy3;
					goto yy136;
				} else {
					if(yych <= '@') goto yy3;
					if(yych <= 'D') goto yy137;
					goto yy586;
				}
			} else {
				if(yych <= 'N') {
					if(yych == 'I') goto yy587;
					goto yy137;
				} else {
					if(yych <= 'O') goto yy588;
					if(yych <= 'Q') goto yy137;
					goto yy589;
				}
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'd') {
					if(yych <= 'Z') goto yy137;
					if(yych <= '`') goto yy3;
					goto yy142;
				} else {
					if(yych <= 'e') goto yy605;
					if(yych <= 'h') goto yy142;
					goto yy606;
				}
			} else {
				if(yych <= 'q') {
					if(yych == 'o') goto yy607;
					goto yy142;
				} else {
					if(yych <= 'r') goto yy608;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= 'E') {
				if(yych <= ')') {
					if(yych <= '(') goto yy3;
					goto yy136;
				} else {
					if(yych <= '@') goto yy3;
					if(yych <= 'D') goto yy137;
					goto yy586;
				}
			} else {
				if(yych <= 'N') {
					if(yych == 'I') goto yy587;
					goto yy137;
				} else {
					if(yych <= 'O') goto yy588;
					if(yych <= 'Q') goto yy137;
					goto yy589;
				}
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'd') {
					if(yych <= 'Z') goto yy137;
					if(yych <= '`') goto yy3;
					goto yy137;
				} else {
					if(yych <= 'e') goto yy586;
					if(yych <= 'h') goto yy137;
					goto yy587;
				}
			} else {
				if(yych <= 'q') {
					if(yych == 'o') goto yy588;
					goto yy137;
				} else {
					if(yych <= 'r') goto yy589;
					if(yych <= 'z') goto yy137;
					goto yy3;
				}
			}
		}
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'F') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'O') {
					if(yych <= 'G') goto yy565;
					goto yy137;
				} else {
					if(yych <= 'P') goto yy564;
					if(yych <= 'T') goto yy137;
					goto yy563;
				}
			}
		} else {
			if(yych <= 'o') {
				if(yych <= '`') {
					if(yych <= 'Z') goto yy137;
					goto yy3;
				} else {
					if(yych == 'g') goto yy577;
					goto yy142;
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'p') goto yy576;
					goto yy142;
				} else {
					if(yych <= 'u') goto yy575;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'F') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'O') {
					if(yych <= 'G') goto yy565;
					goto yy137;
				} else {
					if(yych <= 'P') goto yy564;
					if(yych <= 'T') goto yy137;
					goto yy563;
				}
			}
		} else {
			if(yych <= 'o') {
				if(yych <= '`') {
					if(yych <= 'Z') goto yy137;
					goto yy3;
				} else {
					if(yych == 'g') goto yy565;
					goto yy137;
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'p') goto yy564;
					goto yy137;
				} else {
					if(yych <= 'u') goto yy563;
					if(yych <= 'z') goto yy137;
					goto yy3;
				}
			}
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych <= ')') {
					if(yych <= '(') goto yy3;
					goto yy136;
				} else {
					if(yych <= '@') goto yy3;
					if(yych <= 'A') goto yy506;
					goto yy137;
				}
			} else {
				if(yych <= 'H') {
					if(yych <= 'E') goto yy505;
					goto yy137;
				} else {
					if(yych <= 'I') goto yy507;
					if(yych <= 'T') goto yy137;
					goto yy508;
				}
			}
		} else {
			if(yych <= 'e') {
				if(yych <= '`') {
					if(yych <= 'Z') goto yy137;
					goto yy3;
				} else {
					if(yych <= 'a') goto yy535;
					if(yych <= 'd') goto yy142;
					goto yy534;
				}
			} else {
				if(yych <= 't') {
					if(yych == 'i') goto yy536;
					goto yy142;
				} else {
					if(yych <= 'u') goto yy537;
					if(yych <= 'z') goto yy142;
					goto yy3;
				}
			}
		}
yy28:
		YYDEBUG(28, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych <= ')') {
					if(yych <= '(') goto yy3;
					goto yy136;
				} else {
					if(yych <= '@') goto yy3;
					if(yych <= 'A') goto yy506;
					goto yy137;
				}
			} else {
				if(yych <= 'H') {
					if(yych <= 'E') goto yy505;
					goto yy137;
				} else {
					if(yych <= 'I') goto yy507;
					if(yych <= 'T') goto yy137;
					goto yy508;
				}
			}
		} else {
			if(yych <= 'e') {
				if(yych <= '`') {
					if(yych <= 'Z') goto yy137;
					goto yy3;
				} else {
					if(yych <= 'a') goto yy506;
					if(yych <= 'd') goto yy137;
					goto yy505;
				}
			} else {
				if(yych <= 't') {
					if(yych == 'i') goto yy507;
					goto yy137;
				} else {
					if(yych <= 'u') goto yy508;
					if(yych <= 'z') goto yy137;
					goto yy3;
				}
			}
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'C') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy137;
				goto yy495;
			}
		} else {
			if(yych <= 'b') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy142;
			} else {
				if(yych <= 'c') goto yy500;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'C') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy137;
				goto yy495;
			}
		} else {
			if(yych <= 'b') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'c') goto yy495;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy137;
				goto yy310;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy142;
			} else {
				if(yych <= 'e') goto yy488;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy137;
				goto yy310;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'e') goto yy310;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy137;
				goto yy283;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy142;
			} else {
				if(yych <= 'e') goto yy297;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy137;
				goto yy283;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'e') goto yy283;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych == 'I') goto yy263;
				if(yych <= 'K') goto yy137;
				goto yy264;
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				if(yych <= 'h') goto yy142;
				goto yy273;
			} else {
				if(yych == 'l') goto yy274;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych == 'I') goto yy263;
				if(yych <= 'K') goto yy137;
				goto yy264;
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				if(yych <= 'h') goto yy137;
				goto yy263;
			} else {
				if(yych == 'l') goto yy264;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
			goto yy257;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy260;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
			goto yy257;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy137;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy257;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy137;
				goto yy163;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy142;
			} else {
				if(yych <= 'r') goto yy250;
				if(yych <= 'z') goto yy142;
				goto yy3;
			}
		}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy137;
				goto yy163;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy137;
				if(yych <= '`') goto yy3;
				goto yy137;
			} else {
				if(yych <= 'r') goto yy163;
				if(yych <= 'z') goto yy137;
				goto yy3;
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 8) {
			goto yy54;
		}
		YYDEBUG(-1, yych);
		switch(yych) {
		case '+':
		case '-':	goto yy157;
		case '0':
		case '1':	goto yy154;
		case '2':	goto yy155;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy156;
		default:	goto yy12;
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') goto yy12;
		if(yych <= 'Z') goto yy153;
		if(yych <= '`') goto yy12;
		if(yych <= 'z') goto yy153;
		goto yy12;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy137;
			if(yych <= '`') goto yy3;
			if(yych <= 'z') goto yy142;
			goto yy3;
		}
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy137;
			if(yych <= '`') goto yy3;
			if(yych <= 'z') goto yy137;
			goto yy3;
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 8) {
			goto yy54;
		}
		if(yych <= '/') goto yy46;
		if(yych <= '9') goto yy51;
yy46:
		YYDEBUG(46, *YYCURSOR);
		{
		goto std;
	}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy46;
yy48:
		YYDEBUG(48, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(49, *YYCURSOR);
		{
		s->pos = cursor; s->line++;
		goto std;
	}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy12;
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
		YYDEBUG(52, *YYCURSOR);
		if(yybm[0+yych] & 4) {
			goto yy51;
		}
		if(yych <= 'W') {
			if(yych <= 'F') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy56;
					if(yych >= ' ') goto yy56;
				} else {
					if(yych == 'D') goto yy61;
					if(yych >= 'F') goto yy63;
				}
			} else {
				if(yych <= 'M') {
					if(yych == 'H') goto yy60;
					if(yych >= 'M') goto yy59;
				} else {
					if(yych <= 'S') {
						if(yych >= 'S') goto yy58;
					} else {
						if(yych <= 'T') goto yy65;
						if(yych >= 'W') goto yy62;
					}
				}
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'd') {
					if(yych == 'Y') goto yy64;
					if(yych >= 'd') goto yy61;
				} else {
					if(yych <= 'f') {
						if(yych >= 'f') goto yy63;
					} else {
						if(yych == 'h') goto yy60;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'm') goto yy59;
					if(yych <= 'r') goto yy53;
					if(yych <= 's') goto yy58;
					goto yy65;
				} else {
					if(yych <= 'w') {
						if(yych >= 'w') goto yy62;
					} else {
						if(yych == 'y') goto yy64;
					}
				}
			}
		}
yy53:
		YYDEBUG(53, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if(yyaccept <= 14) {
			if(yyaccept <= 7) {
				if(yyaccept <= 3) {
					if(yyaccept <= 1) {
						if(yyaccept <= 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						if(yyaccept <= 2) {
							goto yy46;
						} else {
							goto yy69;
						}
					}
				} else {
					if(yyaccept <= 5) {
						if(yyaccept <= 4) {
							goto yy183;
						} else {
							goto yy285;
						}
					} else {
						if(yyaccept <= 6) {
							goto yy312;
						} else {
							goto yy317;
						}
					}
				}
			} else {
				if(yyaccept <= 11) {
					if(yyaccept <= 9) {
						if(yyaccept <= 8) {
							goto yy341;
						} else {
							goto yy411;
						}
					} else {
						if(yyaccept <= 10) {
							goto yy567;
						} else {
							goto yy665;
						}
					}
				} else {
					if(yyaccept <= 13) {
						if(yyaccept <= 12) {
							goto yy680;
						} else {
							goto yy827;
						}
					} else {
						goto yy837;
					}
				}
			}
		} else {
			if(yyaccept <= 22) {
				if(yyaccept <= 18) {
					if(yyaccept <= 16) {
						if(yyaccept <= 15) {
							goto yy938;
						} else {
							goto yy966;
						}
					} else {
						if(yyaccept <= 17) {
							goto yy973;
						} else {
							goto yy1000;
						}
					}
				} else {
					if(yyaccept <= 20) {
						if(yyaccept <= 19) {
							goto yy945;
						} else {
							goto yy1102;
						}
					} else {
						if(yyaccept <= 21) {
							goto yy1126;
						} else {
							goto yy994;
						}
					}
				}
			} else {
				if(yyaccept <= 26) {
					if(yyaccept <= 24) {
						if(yyaccept <= 23) {
							goto yy1208;
						} else {
							goto yy1216;
						}
					} else {
						if(yyaccept <= 25) {
							goto yy1271;
						} else {
							goto yy1274;
						}
					}
				} else {
					if(yyaccept <= 28) {
						if(yyaccept <= 27) {
							goto yy1352;
						} else {
							goto yy1360;
						}
					} else {
						goto yy1383;
					}
				}
			}
		}
yy54:
		YYDEBUG(54, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(55, *YYCURSOR);
		if(yybm[0+yych] & 8) {
			goto yy54;
		}
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy51;
		goto yy53;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
yy57:
		YYDEBUG(57, *YYCURSOR);
		if(yych <= 'W') {
			if(yych <= 'F') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy56;
					if(yych <= 0x1F) goto yy53;
					goto yy56;
				} else {
					if(yych == 'D') goto yy61;
					if(yych <= 'E') goto yy53;
					goto yy63;
				}
			} else {
				if(yych <= 'M') {
					if(yych == 'H') goto yy60;
					if(yych <= 'L') goto yy53;
					goto yy59;
				} else {
					if(yych <= 'S') {
						if(yych <= 'R') goto yy53;
					} else {
						if(yych <= 'T') goto yy65;
						if(yych <= 'V') goto yy53;
						goto yy62;
					}
				}
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'd') {
					if(yych == 'Y') goto yy64;
					if(yych <= 'c') goto yy53;
					goto yy61;
				} else {
					if(yych <= 'f') {
						if(yych <= 'e') goto yy53;
						goto yy63;
					} else {
						if(yych == 'h') goto yy60;
						goto yy53;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'm') goto yy59;
					if(yych <= 'r') goto yy53;
					if(yych >= 't') goto yy65;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy53;
						goto yy62;
					} else {
						if(yych == 'y') goto yy64;
						goto yy53;
					}
				}
			}
		}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy123;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy124;
				if(yych <= 'T') goto yy53;
				goto yy122;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy123;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy124;
				if(yych == 'u') goto yy122;
				goto yy53;
			}
		}
yy59:
		YYDEBUG(59, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych == 'I') goto yy114;
			if(yych <= 'N') goto yy53;
			goto yy113;
		} else {
			if(yych <= 'i') {
				if(yych <= 'h') goto yy53;
				goto yy114;
			} else {
				if(yych == 'o') goto yy113;
				goto yy53;
			}
		}
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy111;
		if(yych == 'o') goto yy111;
		goto yy53;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy110;
		if(yych == 'a') goto yy110;
		goto yy53;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy98;
		if(yych == 'e') goto yy98;
		goto yy53;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych == 'O') goto yy83;
			if(yych <= 'Q') goto yy53;
			goto yy82;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy53;
				goto yy83;
			} else {
				if(yych == 'r') goto yy82;
				goto yy53;
			}
		}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy79;
		if(yych == 'e') goto yy79;
		goto yy53;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'H') goto yy66;
			if(yych <= 'T') goto yy53;
			goto yy67;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
			} else {
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
yy66:
		YYDEBUG(66, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy74;
		if(yych == 'u') goto yy74;
		goto yy53;
yy67:
		YYDEBUG(67, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy68;
		if(yych != 'e') goto yy53;
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'S') goto yy70;
		if(yych == 's') goto yy70;
yy69:
		YYDEBUG(69, *YYCURSOR);
		{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy71;
		if(yych != 'd') goto yy53;
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy72;
		if(yych != 'a') goto yy53;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych != 'y') goto yy53;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy69;
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'R') goto yy75;
		if(yych != 'r') goto yy69;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy76;
		if(yych != 's') goto yy53;
yy76:
		YYDEBUG(76, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy77;
		if(yych != 'd') goto yy53;
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy78;
		if(yych != 'a') goto yy53;
yy78:
		YYDEBUG(78, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy79:
		YYDEBUG(79, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy80;
		if(yych != 'a') goto yy53;
yy80:
		YYDEBUG(80, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy81;
		if(yych != 'r') goto yy53;
yy81:
		YYDEBUG(81, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy73;
		if(yych == 's') goto yy73;
		goto yy69;
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy95;
		if(yych == 'i') goto yy95;
		goto yy53;
yy83:
		YYDEBUG(83, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy84;
		if(yych != 'r') goto yy53;
yy84:
		YYDEBUG(84, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy85;
		if(yych != 't') goto yy53;
yy85:
		YYDEBUG(85, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'H') goto yy87;
			if(yych <= 'M') goto yy53;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
				goto yy87;
			} else {
				if(yych != 'n') goto yy53;
			}
		}
		YYDEBUG(86, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy92;
		if(yych == 'i') goto yy92;
		goto yy53;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy88;
		if(yych != 'n') goto yy53;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy89;
		if(yych != 'i') goto yy53;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy90;
		if(yych != 'g') goto yy53;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy91;
		if(yych != 'h') goto yy53;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy81;
		if(yych == 't') goto yy81;
		goto yy53;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy93;
		if(yych != 'g') goto yy53;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy94;
		if(yych != 'h') goto yy53;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy81;
		if(yych == 't') goto yy81;
		goto yy53;
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy96;
		if(yych != 'd') goto yy69;
yy96:
		YYDEBUG(96, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy97;
		if(yych != 'a') goto yy53;
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= 'C') goto yy53;
			if(yych <= 'D') goto yy100;
		} else {
			if(yych <= 'c') goto yy53;
			if(yych <= 'd') goto yy100;
			if(yych >= 'f') goto yy53;
		}
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'K') goto yy106;
		if(yych == 'k') goto yy106;
		goto yy53;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'N') goto yy101;
		if(yych != 'n') goto yy69;
yy101:
		YYDEBUG(101, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy102;
		if(yych != 'e') goto yy53;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy103;
		if(yych != 's') goto yy53;
yy103:
		YYDEBUG(103, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy104;
		if(yych != 'd') goto yy53;
yy104:
		YYDEBUG(104, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy105;
		if(yych != 'a') goto yy53;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == 'D') goto yy107;
			if(yych <= 'R') goto yy69;
			goto yy73;
		} else {
			if(yych <= 'd') {
				if(yych <= 'c') goto yy69;
			} else {
				if(yych == 's') goto yy73;
				goto yy69;
			}
		}
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy108;
		if(yych != 'a') goto yy53;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy109;
		if(yych != 'y') goto yy53;
yy109:
		YYDEBUG(109, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy73;
		if(yych == 's') goto yy73;
		goto yy69;
yy110:
		YYDEBUG(110, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy81;
		if(yych == 'y') goto yy81;
		goto yy53;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy112;
		if(yych != 'u') goto yy53;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy81;
		if(yych == 'r') goto yy81;
		goto yy53;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy118;
		if(yych == 'n') goto yy118;
		goto yy53;
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy115;
		if(yych != 'n') goto yy53;
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych == 'S') goto yy73;
			if(yych <= 'T') goto yy69;
		} else {
			if(yych <= 's') {
				if(yych <= 'r') goto yy69;
				goto yy73;
			} else {
				if(yych != 'u') goto yy69;
			}
		}
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy117;
		if(yych != 't') goto yy53;
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy81;
		if(yych == 'e') goto yy81;
		goto yy53;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == 'D') goto yy119;
			if(yych <= 'S') goto yy69;
			goto yy120;
		} else {
			if(yych <= 'd') {
				if(yych <= 'c') goto yy69;
			} else {
				if(yych == 't') goto yy120;
				goto yy69;
			}
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy121;
		if(yych == 'a') goto yy121;
		goto yy53;
yy120:
		YYDEBUG(120, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy81;
		if(yych == 'h') goto yy81;
		goto yy53;
yy121:
		YYDEBUG(121, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy133;
		if(yych == 'n') goto yy133;
		goto yy53;
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy128;
		if(yych == 't') goto yy128;
		goto yy53;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy125;
		if(yych != 'c') goto yy53;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == 'O') goto yy126;
			if(yych <= 'R') goto yy69;
			goto yy73;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy69;
			} else {
				if(yych == 's') goto yy73;
				goto yy69;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy127;
		if(yych != 'n') goto yy53;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy81;
		if(yych == 'd') goto yy81;
		goto yy53;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy129;
		if(yych != 'u') goto yy69;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy130;
		if(yych != 'r') goto yy53;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy131;
		if(yych != 'd') goto yy53;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy132;
		if(yych != 'a') goto yy53;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy133:
		YYDEBUG(133, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy134;
		if(yych != 'd') goto yy69;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy135;
		if(yych != 'a') goto yy53;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy73;
		if(yych == 'y') goto yy73;
		goto yy53;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy138;
			if(yych <= '`') goto yy3;
			if(yych >= '{') goto yy3;
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy139;
			if(yych <= '`') goto yy3;
			if(yych >= '{') goto yy3;
		}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy140;
			if(yych <= '`') goto yy3;
			if(yych >= '{') goto yy3;
		}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy141;
			if(yych <= '`') goto yy3;
			if(yych >= '{') goto yy3;
		}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == ')') goto yy136;
		goto yy3;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych == '/') goto yy144;
				goto yy3;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych >= '{') goto yy3;
			}
		}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych != '/') goto yy3;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '^') goto yy3;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '@') goto yy53;
		if(yych >= '[') goto yy53;
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yybm[0+yych] & 16) {
			goto yy146;
		}
		goto yy53;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(147, *YYCURSOR);
		if(yybm[0+yych] & 16) {
			goto yy146;
		}
		if(yych == '/') goto yy144;
		if(yych == '_') goto yy144;
		goto yy3;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych == '/') goto yy144;
				goto yy3;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych >= '{') goto yy3;
			}
		}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych == '/') goto yy144;
				goto yy3;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych >= '{') goto yy3;
			}
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == ')') goto yy136;
			if(yych <= '.') goto yy3;
			goto yy144;
		} else {
			if(yych <= '_') {
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych >= '{') goto yy3;
			}
		}
yy151:
		YYDEBUG(151, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
yy152:
		YYDEBUG(152, *YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy144;
			goto yy53;
		} else {
			if(yych <= '_') goto yy144;
			if(yych <= '`') goto yy53;
			if(yych <= 'z') goto yy151;
			goto yy53;
		}
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Z') goto yy137;
			if(yych <= '`') goto yy3;
			if(yych <= 'z') goto yy137;
			goto yy3;
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy3;
					goto yy57;
				} else {
					if(yych <= '9') {
						if(yych <= '/') goto yy3;
						goto yy156;
					} else {
						if(yych <= ':') goto yy159;
						if(yych <= 'C') goto yy3;
						goto yy57;
					}
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy3;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy3;
						if(yych <= 'T') goto yy57;
						goto yy3;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy3;
					if(yych <= 'Y') goto yy57;
					goto yy3;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy3;
					} else {
						if(yych == 'g') goto yy3;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy3;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy3;
					}
				}
			}
		}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= ':') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy3;
					goto yy57;
				} else {
					if(yych <= '3') {
						if(yych <= '/') goto yy3;
					} else {
						if(yych <= '5') goto yy160;
						if(yych <= '9') goto yy161;
						goto yy159;
					}
				}
			} else {
				if(yych <= 'G') {
					if(yych <= 'D') {
						if(yych <= 'C') goto yy3;
						goto yy57;
					} else {
						if(yych == 'F') goto yy57;
						goto yy3;
					}
				} else {
					if(yych <= 'L') {
						if(yych <= 'H') goto yy57;
						goto yy3;
					} else {
						if(yych <= 'M') goto yy57;
						if(yych <= 'R') goto yy3;
						goto yy57;
					}
				}
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Y') {
					if(yych == 'W') goto yy57;
					if(yych <= 'X') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'd') {
						if(yych <= 'c') goto yy3;
						goto yy57;
					} else {
						if(yych == 'f') goto yy57;
						goto yy3;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'l') {
						if(yych <= 'h') goto yy57;
						goto yy3;
					} else {
						if(yych <= 'm') goto yy57;
						if(yych <= 'r') goto yy3;
						goto yy57;
					}
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy3;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy3;
					}
				}
			}
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= 'C') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy3;
					goto yy57;
				} else {
					if(yych <= '5') {
						if(yych <= '/') goto yy3;
						goto yy160;
					} else {
						if(yych <= '9') goto yy161;
						if(yych <= ':') goto yy159;
						goto yy3;
					}
				}
			} else {
				if(yych <= 'G') {
					if(yych == 'E') goto yy3;
					if(yych <= 'F') goto yy57;
					goto yy3;
				} else {
					if(yych <= 'L') {
						if(yych <= 'H') goto yy57;
						goto yy3;
					} else {
						if(yych <= 'M') goto yy57;
						if(yych <= 'R') goto yy3;
						goto yy57;
					}
				}
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Y') {
					if(yych == 'W') goto yy57;
					if(yych <= 'X') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'd') {
						if(yych <= 'c') goto yy3;
						goto yy57;
					} else {
						if(yych == 'f') goto yy57;
						goto yy3;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'l') {
						if(yych <= 'h') goto yy57;
						goto yy3;
					} else {
						if(yych <= 'm') goto yy57;
						if(yych <= 'r') goto yy3;
						goto yy57;
					}
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy3;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy3;
					}
				}
			}
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(158, *YYCURSOR);
		if(yybm[0+yych] & 8) {
			goto yy54;
		}
		if(yych <= ',') {
			if(yych == '+') goto yy157;
			goto yy53;
		} else {
			if(yych <= '-') goto yy157;
			if(yych <= '/') goto yy53;
			if(yych <= '9') goto yy51;
			goto yy53;
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy3;
		if(yych <= '5') goto yy162;
		if(yych <= '9') goto yy136;
		goto yy3;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy3;
					goto yy57;
				} else {
					if(yych <= '/') goto yy3;
					if(yych <= '9') goto yy161;
					if(yych <= 'C') goto yy3;
					goto yy57;
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy3;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy3;
						if(yych <= 'T') goto yy57;
						goto yy3;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy3;
					if(yych <= 'Y') goto yy57;
					goto yy3;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy3;
					} else {
						if(yych == 'g') goto yy3;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy3;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy3;
					}
				}
			}
		}
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 4) {
			goto yy51;
		}
		if(yych <= 'W') {
			if(yych <= 'F') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy3;
					goto yy57;
				} else {
					if(yych == 'D') goto yy57;
					if(yych <= 'E') goto yy3;
					goto yy57;
				}
			} else {
				if(yych <= 'M') {
					if(yych == 'H') goto yy57;
					if(yych <= 'L') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'R') goto yy3;
					if(yych <= 'T') goto yy57;
					if(yych <= 'V') goto yy3;
					goto yy57;
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'd') {
					if(yych == 'Y') goto yy57;
					if(yych <= 'c') goto yy3;
					goto yy57;
				} else {
					if(yych == 'f') goto yy57;
					if(yych <= 'g') goto yy3;
					goto yy57;
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy3;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy3;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy3;
					}
				}
			}
		}
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy3;
		if(yych <= '9') goto yy136;
		goto yy3;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'e') goto yy164;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'V') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy139;
			}
		} else {
			if(yych <= 'u') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'v') goto yy165;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'I') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy140;
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'i') goto yy166;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy141;
			}
		} else {
			if(yych <= 'n') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'o') goto yy167;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'U') goto yy168;
			if(yych != 'u') goto yy3;
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy169;
		if(yych != 's') goto yy53;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 0x09) goto yy170;
		if(yych != ' ') goto yy53;
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		if(yych <= 'W') {
			if(yych <= 'F') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy170;
					if(yych <= 0x1F) goto yy53;
					goto yy170;
				} else {
					if(yych == 'D') goto yy175;
					if(yych <= 'E') goto yy53;
					goto yy177;
				}
			} else {
				if(yych <= 'M') {
					if(yych == 'H') goto yy174;
					if(yych <= 'L') goto yy53;
					goto yy173;
				} else {
					if(yych <= 'S') {
						if(yych <= 'R') goto yy53;
					} else {
						if(yych <= 'T') goto yy179;
						if(yych <= 'V') goto yy53;
						goto yy176;
					}
				}
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'd') {
					if(yych == 'Y') goto yy178;
					if(yych <= 'c') goto yy53;
					goto yy175;
				} else {
					if(yych <= 'f') {
						if(yych <= 'e') goto yy53;
						goto yy177;
					} else {
						if(yych == 'h') goto yy174;
						goto yy53;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'm') goto yy173;
					if(yych <= 'r') goto yy53;
					if(yych >= 't') goto yy179;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy53;
						goto yy176;
					} else {
						if(yych == 'y') goto yy178;
						goto yy53;
					}
				}
			}
		}
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy237;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy238;
				if(yych <= 'T') goto yy53;
				goto yy236;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy237;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy238;
				if(yych == 'u') goto yy236;
				goto yy53;
			}
		}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych == 'I') goto yy228;
			if(yych <= 'N') goto yy53;
			goto yy227;
		} else {
			if(yych <= 'i') {
				if(yych <= 'h') goto yy53;
				goto yy228;
			} else {
				if(yych == 'o') goto yy227;
				goto yy53;
			}
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy225;
		if(yych == 'o') goto yy225;
		goto yy53;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy224;
		if(yych == 'a') goto yy224;
		goto yy53;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy212;
		if(yych == 'e') goto yy212;
		goto yy53;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych == 'O') goto yy197;
			if(yych <= 'Q') goto yy53;
			goto yy196;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy53;
				goto yy197;
			} else {
				if(yych == 'r') goto yy196;
				goto yy53;
			}
		}
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy193;
		if(yych == 'e') goto yy193;
		goto yy53;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'H') goto yy180;
			if(yych <= 'T') goto yy53;
			goto yy181;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
			} else {
				if(yych == 'u') goto yy181;
				goto yy53;
			}
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy188;
		if(yych == 'u') goto yy188;
		goto yy53;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy182;
		if(yych != 'e') goto yy53;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'S') goto yy184;
		if(yych == 's') goto yy184;
yy183:
		YYDEBUG(183, *YYCURSOR);
		{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy185;
		if(yych != 'd') goto yy53;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy186;
		if(yych != 'a') goto yy53;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy187;
		if(yych != 'y') goto yy53;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy183;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'R') goto yy189;
		if(yych != 'r') goto yy183;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy190;
		if(yych != 's') goto yy53;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy191;
		if(yych != 'd') goto yy53;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy192;
		if(yych != 'a') goto yy53;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy187;
		if(yych == 'y') goto yy187;
		goto yy53;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy194;
		if(yych != 'a') goto yy53;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy195;
		if(yych != 'r') goto yy53;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy187;
		if(yych == 's') goto yy187;
		goto yy183;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy209;
		if(yych == 'i') goto yy209;
		goto yy53;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy198;
		if(yych != 'r') goto yy53;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy199;
		if(yych != 't') goto yy53;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'H') goto yy201;
			if(yych <= 'M') goto yy53;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
				goto yy201;
			} else {
				if(yych != 'n') goto yy53;
			}
		}
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy206;
		if(yych == 'i') goto yy206;
		goto yy53;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy202;
		if(yych != 'n') goto yy53;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy203;
		if(yych != 'i') goto yy53;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy204;
		if(yych != 'g') goto yy53;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy205;
		if(yych != 'h') goto yy53;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy195;
		if(yych == 't') goto yy195;
		goto yy53;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy207;
		if(yych != 'g') goto yy53;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy208;
		if(yych != 'h') goto yy53;
yy208:
		YYDEBUG(208, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy195;
		if(yych == 't') goto yy195;
		goto yy53;
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy210;
		if(yych != 'd') goto yy183;
yy210:
		YYDEBUG(210, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy211;
		if(yych != 'a') goto yy53;
yy211:
		YYDEBUG(211, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy187;
		if(yych == 'y') goto yy187;
		goto yy53;
yy212:
		YYDEBUG(212, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= 'C') goto yy53;
			if(yych <= 'D') goto yy214;
		} else {
			if(yych <= 'c') goto yy53;
			if(yych <= 'd') goto yy214;
			if(yych >= 'f') goto yy53;
		}
		YYDEBUG(213, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'K') goto yy220;
		if(yych == 'k') goto yy220;
		goto yy53;
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'N') goto yy215;
		if(yych != 'n') goto yy183;
yy215:
		YYDEBUG(215, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy216;
		if(yych != 'e') goto yy53;
yy216:
		YYDEBUG(216, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy217;
		if(yych != 's') goto yy53;
yy217:
		YYDEBUG(217, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy218;
		if(yych != 'd') goto yy53;
yy218:
		YYDEBUG(218, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy219;
		if(yych != 'a') goto yy53;
yy219:
		YYDEBUG(219, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy187;
		if(yych == 'y') goto yy187;
		goto yy53;
yy220:
		YYDEBUG(220, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == 'D') goto yy221;
			if(yych <= 'R') goto yy183;
			goto yy187;
		} else {
			if(yych <= 'd') {
				if(yych <= 'c') goto yy183;
			} else {
				if(yych == 's') goto yy187;
				goto yy183;
			}
		}
yy221:
		YYDEBUG(221, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy222;
		if(yych != 'a') goto yy53;
yy222:
		YYDEBUG(222, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy223;
		if(yych != 'y') goto yy53;
yy223:
		YYDEBUG(223, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy187;
		if(yych == 's') goto yy187;
		goto yy183;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy195;
		if(yych == 'y') goto yy195;
		goto yy53;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy226;
		if(yych != 'u') goto yy53;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy195;
		if(yych == 'r') goto yy195;
		goto yy53;
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy232;
		if(yych == 'n') goto yy232;
		goto yy53;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy229;
		if(yych != 'n') goto yy53;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych == 'S') goto yy187;
			if(yych <= 'T') goto yy183;
		} else {
			if(yych <= 's') {
				if(yych <= 'r') goto yy183;
				goto yy187;
			} else {
				if(yych != 'u') goto yy183;
			}
		}
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy231;
		if(yych != 't') goto yy53;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy195;
		if(yych == 'e') goto yy195;
		goto yy53;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == 'D') goto yy233;
			if(yych <= 'S') goto yy183;
			goto yy234;
		} else {
			if(yych <= 'd') {
				if(yych <= 'c') goto yy183;
			} else {
				if(yych == 't') goto yy234;
				goto yy183;
			}
		}
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy235;
		if(yych == 'a') goto yy235;
		goto yy53;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy195;
		if(yych == 'h') goto yy195;
		goto yy53;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy187;
		if(yych == 'y') goto yy187;
		goto yy53;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy247;
		if(yych == 'n') goto yy247;
		goto yy53;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy242;
		if(yych == 't') goto yy242;
		goto yy53;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy239;
		if(yych != 'c') goto yy53;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == 'O') goto yy240;
			if(yych <= 'R') goto yy183;
			goto yy187;
		} else {
			if(yych <= 'o') {
				if(yych <= 'n') goto yy183;
			} else {
				if(yych == 's') goto yy187;
				goto yy183;
			}
		}
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy241;
		if(yych != 'n') goto yy53;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy195;
		if(yych == 'd') goto yy195;
		goto yy53;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy243;
		if(yych != 'u') goto yy183;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy244;
		if(yych != 'r') goto yy53;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'D') goto yy245;
		if(yych != 'd') goto yy53;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy246;
		if(yych != 'a') goto yy53;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy187;
		if(yych == 'y') goto yy187;
		goto yy53;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'D') goto yy248;
		if(yych != 'd') goto yy183;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy249;
		if(yych != 'a') goto yy53;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy187;
		if(yych == 'y') goto yy187;
		goto yy53;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
				goto yy164;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy251;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy139;
				goto yy165;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'v') goto yy252;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'I') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy140;
				goto yy166;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'i') goto yy253;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy141;
				goto yy167;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'o') goto yy254;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'T') goto yy3;
				goto yy168;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'u') goto yy255;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy169;
		if(yych != 's') goto yy152;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '.') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy53;
				goto yy170;
			} else {
				if(yych == ' ') goto yy170;
				goto yy53;
			}
		} else {
			if(yych <= '_') {
				if(yych <= '/') goto yy144;
				if(yych <= '^') goto yy53;
				goto yy144;
			} else {
				if(yych <= '`') goto yy53;
				if(yych <= 'z') goto yy151;
				goto yy53;
			}
		}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy138;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 's') goto yy258;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 't') goto yy259;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '(') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy3;
				goto yy170;
			} else {
				if(yych == ' ') goto yy170;
				goto yy3;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy140;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy138;
				goto yy258;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 's') goto yy261;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy259;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy262;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy170;
				goto yy3;
			} else {
				if(yych <= ' ') goto yy170;
				if(yych == ')') goto yy136;
				goto yy3;
			}
		} else {
			if(yych <= '^') {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if(yych <= '_') goto yy144;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'G') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy138;
				goto yy270;
			}
		} else {
			if(yych <= 'f') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'g') goto yy270;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'e') goto yy265;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'V') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy139;
			}
		} else {
			if(yych <= 'u') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'v') goto yy266;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy140;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'e') goto yy267;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy141;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'n') goto yy268;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'T') goto yy269;
			if(yych != 't') goto yy3;
		}
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy169;
		if(yych == 'h') goto yy169;
		goto yy53;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy139;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'h') goto yy271;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy140;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 't') goto yy272;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '(') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy3;
				goto yy170;
			} else {
				if(yych == ' ') goto yy170;
				goto yy3;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy141;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy138;
				goto yy270;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'g') goto yy280;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
				goto yy265;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy275;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'U') goto yy139;
				goto yy266;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'v') goto yy276;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy140;
				goto yy267;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy277;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy141;
				goto yy268;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy278;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'S') goto yy3;
				goto yy269;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy279;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy169;
		if(yych == 'h') goto yy256;
		goto yy152;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy139;
				goto yy271;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy281;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy282;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy170;
				goto yy3;
			} else {
				if(yych <= ' ') goto yy170;
				if(yych == ')') goto yy136;
				goto yy3;
			}
		} else {
			if(yych <= '^') {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if(yych <= '_') goto yy144;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= 'C') goto yy138;
				if(yych >= 'E') goto yy286;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'd') goto yy284;
				if(yych <= 'e') goto yy286;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy284:
		YYDEBUG(284, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= 'N') {
			if(yych <= ')') {
				if(yych >= ')') goto yy136;
			} else {
				if(yych <= '@') goto yy285;
				if(yych <= 'M') goto yy139;
				goto yy292;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy139;
				if(yych >= 'a') goto yy139;
			} else {
				if(yych <= 'n') goto yy292;
				if(yych <= 'z') goto yy139;
			}
		}
yy285:
		YYDEBUG(285, *YYCURSOR);
		{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'K') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'J') goto yy139;
			}
		} else {
			if(yych <= 'j') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'k') goto yy287;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy140;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'd') goto yy288;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy288:
		YYDEBUG(288, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy289;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Y') goto yy290;
			if(yych != 'y') goto yy3;
		}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy291;
		if(yych != 's') goto yy285;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy285;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy140;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'e') goto yy293;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy141;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 's') goto yy294;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'C') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'D') goto yy295;
			if(yych != 'd') goto yy3;
		}
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy296;
		if(yych != 'a') goto yy53;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy291;
		if(yych == 'y') goto yy291;
		goto yy53;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '/') {
				if(yych == ')') goto yy136;
				if(yych <= '.') goto yy3;
				goto yy144;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy138;
				if(yych <= 'D') goto yy284;
				goto yy286;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych <= 'd') {
					if(yych <= 'c') goto yy143;
				} else {
					if(yych <= 'e') goto yy299;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
		YYDEBUG(298, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy285;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy285;
				if(yych <= 'M') goto yy139;
				goto yy292;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy285;
			} else {
				if(yych == 'n') goto yy305;
				if(yych <= 'z') goto yy148;
				goto yy285;
			}
		}
yy299:
		YYDEBUG(299, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'K') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'J') goto yy139;
				goto yy287;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'k') goto yy300;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy300:
		YYDEBUG(300, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy140;
				goto yy288;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy301;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy301:
		YYDEBUG(301, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy289;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy302;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy302:
		YYDEBUG(302, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'X') goto yy3;
				goto yy290;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'y') goto yy303;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy303:
		YYDEBUG(303, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych <= '/') {
				if(yych <= '.') goto yy285;
				goto yy144;
			} else {
				if(yych == 'S') goto yy291;
				goto yy285;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= '_') goto yy144;
				if(yych <= '`') goto yy285;
				goto yy151;
			} else {
				if(yych <= 's') goto yy304;
				if(yych <= 'z') goto yy151;
				goto yy285;
			}
		}
yy304:
		YYDEBUG(304, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy144;
			goto yy285;
		} else {
			if(yych <= '_') goto yy144;
			if(yych <= '`') goto yy285;
			if(yych <= 'z') goto yy151;
			goto yy285;
		}
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy140;
				goto yy293;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy306;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy306:
		YYDEBUG(306, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy141;
				goto yy294;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 's') goto yy307;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy307:
		YYDEBUG(307, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'C') goto yy3;
				goto yy295;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy308;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy296;
		if(yych != 'a') goto yy152;
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy291;
		if(yych == 'y') goto yy304;
		goto yy152;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'C') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy138;
			}
		} else {
			if(yych <= 'b') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'c') goto yy311;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy311:
		YYDEBUG(311, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych >= 0x09) goto yy314;
				} else {
					if(yych == ' ') goto yy314;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
				} else {
					if(yych == 'E') goto yy320;
					goto yy139;
				}
			} else {
				if(yych <= 'd') {
					if(yych >= 'a') goto yy139;
				} else {
					if(yych <= 'e') goto yy320;
					if(yych <= 'z') goto yy139;
				}
			}
		}
yy312:
		YYDEBUG(312, *YYCURSOR);
		{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy313:
		YYDEBUG(313, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 20) YYFILL(20);
		yych = *YYCURSOR;
yy314:
		YYDEBUG(314, *YYCURSOR);
		if(yybm[0+yych] & 64) {
			goto yy313;
		}
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy316;
		if(yych <= '3') goto yy318;
		if(yych <= '9') goto yy319;
		goto yy53;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy314;
		if(yych <= '0') goto yy475;
		if(yych <= '2') goto yy476;
		if(yych <= '3') goto yy477;
		goto yy314;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy334;
				if(yych <= '0') goto yy414;
				goto yy415;
			} else {
				if(yych <= '2') goto yy473;
				if(yych <= '9') goto yy474;
				goto yy334;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy330;
				if(yych <= 'q') goto yy334;
				goto yy331;
			} else {
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy317:
		YYDEBUG(317, *YYCURSOR);
		{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy318:
		YYDEBUG(318, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy334;
				if(yych <= '0') goto yy414;
				goto yy415;
			} else {
				if(yych <= '2') goto yy327;
				if(yych <= '9') goto yy328;
				goto yy334;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy330;
				if(yych <= 'q') goto yy334;
				goto yy331;
			} else {
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy319:
		YYDEBUG(319, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy334;
				if(yych <= '0') goto yy325;
				goto yy326;
			} else {
				if(yych <= '2') goto yy327;
				if(yych <= '9') goto yy328;
				goto yy334;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy330;
				if(yych <= 'q') goto yy334;
				goto yy331;
			} else {
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'M') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'L') goto yy140;
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'm') goto yy321;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'B') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy141;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'b') goto yy322;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'E') goto yy323;
			if(yych != 'e') goto yy3;
		}
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy324;
		if(yych != 'r') goto yy53;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ' ') {
			if(yych == 0x09) goto yy314;
			if(yych <= 0x1F) goto yy312;
			goto yy314;
		} else {
			if(yych <= '.') {
				if(yych <= ',') goto yy312;
				goto yy314;
			} else {
				if(yych <= '/') goto yy312;
				if(yych <= '9') goto yy314;
				goto yy312;
			}
		}
yy325:
		YYDEBUG(325, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy317;
		} else {
			if(yych <= '0') goto yy412;
			if(yych <= '9') goto yy413;
			if(yych <= ':') goto yy339;
			goto yy317;
		}
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '2') goto yy413;
			if(yych <= '9') goto yy412;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy327:
		YYDEBUG(327, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '3') goto yy412;
			if(yych <= '9') goto yy409;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy328:
		YYDEBUG(328, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '9') goto yy409;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy329:
		YYDEBUG(329, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy334;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy334;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy334;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy334;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yyaccept = 7;
		YYMARKER = ++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
		yych = *YYCURSOR;
yy334:
		YYDEBUG(334, *YYCURSOR);
		if(yybm[0+yych] & 128) {
			goto yy333;
		}
		if(yych <= '2') {
			if(yych <= '/') goto yy317;
			if(yych <= '0') goto yy375;
			if(yych <= '1') goto yy376;
			goto yy377;
		} else {
			if(yych <= '9') goto yy378;
			if(yych != 'T') goto yy317;
		}
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy336;
		if(yych <= '2') goto yy337;
		if(yych <= '9') goto yy338;
		goto yy53;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy53;
		} else {
			if(yych <= '9') goto yy338;
			if(yych <= ':') goto yy339;
			goto yy53;
		}
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy53;
		} else {
			if(yych <= '3') goto yy338;
			if(yych == ':') goto yy339;
			goto yy53;
		}
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '.') goto yy339;
		if(yych != ':') goto yy53;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy340;
		if(yych <= '9') goto yy342;
		goto yy53;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy343;
		} else {
			if(yych <= '9') goto yy342;
			if(yych <= ':') goto yy343;
		}
yy341:
		YYDEBUG(341, *YYCURSOR);
		{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy342:
		YYDEBUG(342, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy343;
		if(yych != ':') goto yy341;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy344;
		if(yych <= '6') goto yy345;
		if(yych <= '9') goto yy346;
		goto yy53;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy341;
		if(yych <= '9') goto yy347;
		goto yy341;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '0') goto yy347;
		goto yy341;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy341;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '*') {
			if(yych <= 0x1F) {
				if(yych != 0x09) goto yy341;
			} else {
				if(yych <= ' ') goto yy348;
				if(yych == '(') goto yy351;
				goto yy341;
			}
		} else {
			if(yych <= '@') {
				if(yych == ',') goto yy341;
				if(yych <= '-') goto yy350;
				goto yy341;
			} else {
				if(yych <= 'Z') goto yy352;
				if(yych <= '`') goto yy341;
				if(yych <= 'z') goto yy353;
				goto yy341;
			}
		}
yy348:
		YYDEBUG(348, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
		yych = *YYCURSOR;
		YYDEBUG(349, *YYCURSOR);
		if(yych <= '*') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy348;
				goto yy53;
			} else {
				if(yych <= ' ') goto yy348;
				if(yych == '(') goto yy351;
				goto yy53;
			}
		} else {
			if(yych <= '@') {
				if(yych == ',') goto yy53;
				if(yych >= '.') goto yy53;
			} else {
				if(yych <= 'Z') goto yy352;
				if(yych <= '`') goto yy53;
				if(yych <= 'z') goto yy353;
				goto yy53;
			}
		}
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy370;
		if(yych <= '2') goto yy371;
		if(yych <= '9') goto yy372;
		goto yy53;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') goto yy53;
		if(yych <= 'Z') goto yy353;
		if(yych <= '`') goto yy53;
		if(yych <= 'z') goto yy353;
		goto yy53;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy346;
			goto yy341;
		} else {
			if(yych <= 'Z') goto yy354;
			if(yych <= '`') goto yy341;
			if(yych <= 'z') goto yy359;
			goto yy341;
		}
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy346;
			goto yy341;
		} else {
			if(yych <= 'Z') goto yy354;
			if(yych <= '`') goto yy341;
			if(yych >= '{') goto yy341;
		}
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy346;
			goto yy341;
		} else {
			if(yych <= 'Z') goto yy355;
			if(yych <= '`') goto yy341;
			if(yych >= '{') goto yy341;
		}
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy346;
			goto yy341;
		} else {
			if(yych <= 'Z') goto yy356;
			if(yych <= '`') goto yy341;
			if(yych >= '{') goto yy341;
		}
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy346;
			goto yy341;
		} else {
			if(yych <= 'Z') goto yy357;
			if(yych <= '`') goto yy341;
			if(yych >= '{') goto yy341;
		}
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '@') {
			if(yych == ')') goto yy346;
			goto yy341;
		} else {
			if(yych <= 'Z') goto yy358;
			if(yych <= '`') goto yy341;
			if(yych >= '{') goto yy341;
		}
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == ')') goto yy346;
		goto yy341;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy346;
			} else {
				if(yych == '/') goto yy361;
				goto yy341;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy355;
				if(yych <= '^') goto yy341;
				goto yy361;
			} else {
				if(yych <= '`') goto yy341;
				if(yych >= '{') goto yy341;
			}
		}
yy360:
		YYDEBUG(360, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy346;
			} else {
				if(yych != '/') goto yy341;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy356;
				if(yych <= '^') goto yy341;
			} else {
				if(yych <= '`') goto yy341;
				if(yych <= 'z') goto yy365;
				goto yy341;
			}
		}
yy361:
		YYDEBUG(361, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '@') goto yy53;
		if(yych >= '[') goto yy53;
		YYDEBUG(362, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		if(yych <= '`') goto yy53;
		if(yych >= '{') goto yy53;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yyaccept = 8;
		YYMARKER = ++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(364, *YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy361;
			goto yy341;
		} else {
			if(yych <= '_') goto yy361;
			if(yych <= '`') goto yy341;
			if(yych <= 'z') goto yy363;
			goto yy341;
		}
yy365:
		YYDEBUG(365, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy346;
			} else {
				if(yych == '/') goto yy361;
				goto yy341;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy357;
				if(yych <= '^') goto yy341;
				goto yy361;
			} else {
				if(yych <= '`') goto yy341;
				if(yych >= '{') goto yy341;
			}
		}
		YYDEBUG(366, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy341;
				goto yy346;
			} else {
				if(yych == '/') goto yy361;
				goto yy341;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy358;
				if(yych <= '^') goto yy341;
				goto yy361;
			} else {
				if(yych <= '`') goto yy341;
				if(yych >= '{') goto yy341;
			}
		}
		YYDEBUG(367, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == ')') goto yy346;
			if(yych <= '.') goto yy341;
			goto yy361;
		} else {
			if(yych <= '_') {
				if(yych <= '^') goto yy341;
				goto yy361;
			} else {
				if(yych <= '`') goto yy341;
				if(yych >= '{') goto yy341;
			}
		}
yy368:
		YYDEBUG(368, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(369, *YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy361;
			goto yy53;
		} else {
			if(yych <= '_') goto yy361;
			if(yych <= '`') goto yy53;
			if(yych <= 'z') goto yy368;
			goto yy53;
		}
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy341;
		if(yych <= '9') goto yy372;
		if(yych <= ':') goto yy373;
		goto yy341;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy341;
			if(yych >= '4') goto yy374;
		} else {
			if(yych <= '9') goto yy346;
			if(yych <= ':') goto yy373;
			goto yy341;
		}
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy341;
		if(yych <= '5') goto yy374;
		if(yych <= '9') goto yy346;
		if(yych >= ';') goto yy341;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy341;
		if(yych <= '5') goto yy374;
		if(yych <= '9') goto yy346;
		goto yy341;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy341;
		if(yych <= '9') goto yy346;
		goto yy341;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy317;
		} else {
			if(yych <= '0') goto yy407;
			if(yych <= '9') goto yy408;
			if(yych <= ':') goto yy339;
			goto yy317;
		}
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '2') goto yy408;
			if(yych <= '9') goto yy407;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '3') goto yy407;
			if(yych <= '9') goto yy379;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '9') goto yy379;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy379:
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy317;
		if(yych <= '9') goto yy405;
		goto yy317;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy381;
		if(yych <= '9') goto yy382;
		goto yy53;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy341;
		} else {
			if(yych <= '9') goto yy398;
			if(yych <= ':') goto yy383;
			goto yy341;
		}
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy383;
		if(yych != ':') goto yy341;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy384;
		if(yych <= '6') goto yy385;
		if(yych <= '9') goto yy346;
		goto yy53;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy341;
		if(yych <= '9') goto yy386;
		goto yy341;
yy385:
		YYDEBUG(385, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '0') goto yy341;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '*') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy388;
				goto yy341;
			} else {
				if(yych <= ' ') goto yy388;
				if(yych == '(') goto yy388;
				goto yy341;
			}
		} else {
			if(yych <= '@') {
				if(yych == ',') goto yy341;
				if(yych <= '-') goto yy388;
				goto yy341;
			} else {
				if(yych <= 'Z') goto yy388;
				if(yych <= '`') goto yy341;
				if(yych <= 'z') goto yy388;
				goto yy341;
			}
		}
yy387:
		YYDEBUG(387, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
		yych = *YYCURSOR;
yy388:
		YYDEBUG(388, *YYCURSOR);
		if(yych <= '-') {
			if(yych <= '\'') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy53;
					goto yy387;
				} else {
					if(yych == ' ') goto yy387;
					goto yy53;
				}
			} else {
				if(yych <= '*') {
					if(yych <= '(') goto yy351;
					goto yy53;
				} else {
					if(yych == ',') goto yy53;
					goto yy350;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= 'A') {
					if(yych <= '@') goto yy53;
				} else {
					if(yych != 'P') goto yy352;
				}
			} else {
				if(yych <= 'o') {
					if(yych <= '`') goto yy53;
					if(yych <= 'a') goto yy390;
					goto yy353;
				} else {
					if(yych <= 'p') goto yy390;
					if(yych <= 'z') goto yy353;
					goto yy53;
				}
			}
		}
		YYDEBUG(389, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '-') {
				if(yych == ')') goto yy346;
				goto yy341;
			} else {
				if(yych <= '.') goto yy391;
				if(yych <= '@') goto yy341;
				goto yy354;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'M') goto yy392;
				if(yych <= 'Z') goto yy354;
				goto yy341;
			} else {
				if(yych == 'm') goto yy397;
				if(yych <= 'z') goto yy359;
				goto yy341;
			}
		}
yy390:
		YYDEBUG(390, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '-') {
				if(yych == ')') goto yy346;
				goto yy341;
			} else {
				if(yych <= '.') goto yy391;
				if(yych <= '@') goto yy341;
				goto yy354;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'M') goto yy392;
				if(yych <= 'Z') goto yy354;
				goto yy341;
			} else {
				if(yych == 'm') goto yy392;
				if(yych <= 'z') goto yy354;
				goto yy341;
			}
		}
yy391:
		YYDEBUG(391, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy396;
		if(yych == 'm') goto yy396;
		goto yy53;
yy392:
		YYDEBUG(392, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ')') {
			if(yych <= 0x09) {
				if(yych <= 0x00) goto yy394;
				if(yych <= 0x08) goto yy341;
				goto yy394;
			} else {
				if(yych == ' ') goto yy394;
				if(yych <= '(') goto yy341;
				goto yy346;
			}
		} else {
			if(yych <= '@') {
				if(yych != '.') goto yy341;
			} else {
				if(yych <= 'Z') goto yy355;
				if(yych <= '`') goto yy341;
				if(yych <= 'z') goto yy355;
				goto yy341;
			}
		}
yy393:
		YYDEBUG(393, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x09) {
			if(yych <= 0x00) goto yy394;
			if(yych <= 0x08) goto yy53;
		} else {
			if(yych != ' ') goto yy53;
		}
yy394:
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(395, *YYCURSOR);
		{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x1F) {
			if(yych <= 0x00) goto yy394;
			if(yych == 0x09) goto yy394;
			goto yy53;
		} else {
			if(yych <= ' ') goto yy394;
			if(yych == '.') goto yy393;
			goto yy53;
		}
yy397:
		YYDEBUG(397, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '-') {
			if(yych <= 0x1F) {
				if(yych <= 0x00) goto yy394;
				if(yych == 0x09) goto yy394;
				goto yy341;
			} else {
				if(yych <= ' ') goto yy394;
				if(yych == ')') goto yy346;
				goto yy341;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '.') goto yy393;
				if(yych <= '/') goto yy361;
				if(yych <= '@') goto yy341;
				goto yy355;
			} else {
				if(yych <= '_') {
					if(yych <= '^') goto yy341;
					goto yy361;
				} else {
					if(yych <= '`') goto yy341;
					if(yych <= 'z') goto yy360;
					goto yy341;
				}
			}
		}
yy398:
		YYDEBUG(398, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy399;
				if(yych <= 0x1F) goto yy341;
			} else {
				if(yych == '.') goto yy383;
				if(yych <= '9') goto yy341;
				goto yy383;
			}
		} else {
			if(yych <= 'P') {
				if(yych == 'A') goto yy401;
				if(yych <= 'O') goto yy341;
				goto yy401;
			} else {
				if(yych <= 'a') {
					if(yych <= '`') goto yy341;
					goto yy401;
				} else {
					if(yych == 'p') goto yy401;
					goto yy341;
				}
			}
		}
yy399:
		YYDEBUG(399, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(400, *YYCURSOR);
		if(yych <= 'A') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy399;
				goto yy53;
			} else {
				if(yych <= ' ') goto yy399;
				if(yych <= '@') goto yy53;
			}
		} else {
			if(yych <= '`') {
				if(yych != 'P') goto yy53;
			} else {
				if(yych <= 'a') goto yy401;
				if(yych != 'p') goto yy53;
			}
		}
yy401:
		YYDEBUG(401, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych != '.') goto yy53;
		} else {
			if(yych <= 'M') goto yy403;
			if(yych == 'm') goto yy403;
			goto yy53;
		}
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy403;
		if(yych != 'm') goto yy53;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x1F) {
			if(yych <= 0x00) goto yy394;
			if(yych == 0x09) goto yy394;
			goto yy53;
		} else {
			if(yych <= ' ') goto yy394;
			if(yych != '.') goto yy53;
		}
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x09) {
			if(yych <= 0x00) goto yy394;
			if(yych <= 0x08) goto yy53;
			goto yy394;
		} else {
			if(yych == ' ') goto yy394;
			goto yy53;
		}
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy317;
		if(yych >= ':') goto yy317;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy317;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy317;
		} else {
			if(yych <= '9') goto yy405;
			if(yych <= ':') goto yy339;
			goto yy317;
		}
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '9') goto yy405;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy317;
		if(yych >= ':') goto yy317;
yy410:
		YYDEBUG(410, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy411;
		if(yych <= '9') goto yy406;
yy411:
		YYDEBUG(411, *YYCURSOR);
		{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy412:
		YYDEBUG(412, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy317;
		} else {
			if(yych <= '9') goto yy410;
			if(yych <= ':') goto yy339;
			goto yy317;
		}
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '9') goto yy410;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy414:
		YYDEBUG(414, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych == '.') goto yy449;
				goto yy334;
			} else {
				if(yych <= '0') goto yy450;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy339;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy415:
		YYDEBUG(415, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych != '.') goto yy334;
			} else {
				if(yych <= '0') goto yy417;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy380;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy416:
		YYDEBUG(416, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '1') {
			if(yych <= '/') goto yy334;
			if(yych <= '0') goto yy424;
			goto yy425;
		} else {
			if(yych <= '2') goto yy426;
			if(yych <= '5') goto yy427;
			if(yych <= '9') goto yy428;
			goto yy334;
		}
yy417:
		YYDEBUG(417, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '0') goto yy422;
			if(yych <= '9') goto yy423;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy418:
		YYDEBUG(418, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '2') goto yy423;
			if(yych <= '9') goto yy422;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy419:
		YYDEBUG(419, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '3') goto yy422;
			if(yych <= '9') goto yy421;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy420:
		YYDEBUG(420, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy317;
		} else {
			if(yych <= '9') goto yy421;
			if(yych <= ':') goto yy380;
			goto yy317;
		}
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy411;
		if(yych <= '9') goto yy405;
		goto yy411;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy411;
		} else {
			if(yych <= '9') goto yy405;
			if(yych <= ':') goto yy339;
			goto yy411;
		}
yy423:
		YYDEBUG(423, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy380;
			goto yy411;
		} else {
			if(yych <= '9') goto yy405;
			if(yych <= ':') goto yy380;
			goto yy411;
		}
yy424:
		YYDEBUG(424, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy444;
			goto yy317;
		} else {
			if(yych <= '0') goto yy443;
			if(yych <= '9') goto yy448;
			if(yych <= ':') goto yy444;
			goto yy317;
		}
yy425:
		YYDEBUG(425, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy429;
			goto yy317;
		} else {
			if(yych <= '2') goto yy448;
			if(yych <= '9') goto yy443;
			if(yych <= ':') goto yy429;
			goto yy317;
		}
yy426:
		YYDEBUG(426, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy429;
			goto yy317;
		} else {
			if(yych <= '3') goto yy443;
			if(yych <= '9') goto yy442;
			if(yych <= ':') goto yy429;
			goto yy317;
		}
yy427:
		YYDEBUG(427, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy429;
			goto yy317;
		} else {
			if(yych <= '9') goto yy442;
			if(yych <= ':') goto yy429;
			goto yy317;
		}
yy428:
		YYDEBUG(428, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych != '.') goto yy317;
		} else {
			if(yych <= '9') goto yy379;
			if(yych >= ';') goto yy317;
		}
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy430;
		if(yych <= '6') goto yy431;
		if(yych <= '9') goto yy382;
		goto yy53;
yy430:
		YYDEBUG(430, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy341;
		} else {
			if(yych <= '9') goto yy432;
			if(yych <= ':') goto yy383;
			goto yy341;
		}
yy431:
		YYDEBUG(431, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy341;
		} else {
			if(yych <= '0') goto yy386;
			if(yych == ':') goto yy383;
			goto yy341;
		}
yy432:
		YYDEBUG(432, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy434;
				if(yych <= 0x1F) goto yy341;
				goto yy434;
			} else {
				if(yych <= '(') {
					if(yych <= '\'') goto yy341;
					goto yy434;
				} else {
					if(yych == '+') goto yy434;
					goto yy341;
				}
			}
		} else {
			if(yych <= ':') {
				if(yych <= '-') goto yy434;
				if(yych <= '.') goto yy383;
				if(yych <= '9') goto yy341;
				goto yy383;
			} else {
				if(yych <= 'Z') {
					if(yych <= '@') goto yy341;
					goto yy434;
				} else {
					if(yych <= '`') goto yy341;
					if(yych <= 'z') goto yy434;
					goto yy341;
				}
			}
		}
yy433:
		YYDEBUG(433, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
		yych = *YYCURSOR;
yy434:
		YYDEBUG(434, *YYCURSOR);
		if(yych <= '-') {
			if(yych <= '\'') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy53;
					goto yy433;
				} else {
					if(yych == ' ') goto yy433;
					goto yy53;
				}
			} else {
				if(yych <= '*') {
					if(yych <= '(') goto yy351;
					goto yy53;
				} else {
					if(yych == ',') goto yy53;
					goto yy350;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= 'A') {
					if(yych <= '@') goto yy53;
				} else {
					if(yych != 'P') goto yy352;
				}
			} else {
				if(yych <= 'o') {
					if(yych <= '`') goto yy53;
					if(yych <= 'a') goto yy436;
					goto yy353;
				} else {
					if(yych <= 'p') goto yy436;
					if(yych <= 'z') goto yy353;
					goto yy53;
				}
			}
		}
		YYDEBUG(435, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '-') {
				if(yych == ')') goto yy346;
				goto yy341;
			} else {
				if(yych <= '.') goto yy438;
				if(yych <= '@') goto yy341;
				goto yy354;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'M') goto yy437;
				if(yych <= 'Z') goto yy354;
				goto yy341;
			} else {
				if(yych == 'm') goto yy441;
				if(yych <= 'z') goto yy359;
				goto yy341;
			}
		}
yy436:
		YYDEBUG(436, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '-') {
				if(yych == ')') goto yy346;
				goto yy341;
			} else {
				if(yych <= '.') goto yy438;
				if(yych <= '@') goto yy341;
				goto yy354;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'M') goto yy437;
				if(yych <= 'Z') goto yy354;
				goto yy341;
			} else {
				if(yych == 'm') goto yy437;
				if(yych <= 'z') goto yy354;
				goto yy341;
			}
		}
yy437:
		YYDEBUG(437, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ')') {
			if(yych <= 0x09) {
				if(yych <= 0x00) goto yy394;
				if(yych <= 0x08) goto yy341;
				goto yy394;
			} else {
				if(yych == ' ') goto yy394;
				if(yych <= '(') goto yy341;
				goto yy346;
			}
		} else {
			if(yych <= '@') {
				if(yych == '.') goto yy440;
				goto yy341;
			} else {
				if(yych <= 'Z') goto yy355;
				if(yych <= '`') goto yy341;
				if(yych <= 'z') goto yy355;
				goto yy341;
			}
		}
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy439;
		if(yych != 'm') goto yy53;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x1F) {
			if(yych <= 0x00) goto yy394;
			if(yych == 0x09) goto yy394;
			goto yy53;
		} else {
			if(yych <= ' ') goto yy394;
			if(yych != '.') goto yy53;
		}
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x09) {
			if(yych <= 0x00) goto yy394;
			if(yych <= 0x08) goto yy53;
			goto yy394;
		} else {
			if(yych == ' ') goto yy394;
			goto yy53;
		}
yy441:
		YYDEBUG(441, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '-') {
			if(yych <= 0x1F) {
				if(yych <= 0x00) goto yy394;
				if(yych == 0x09) goto yy394;
				goto yy341;
			} else {
				if(yych <= ' ') goto yy394;
				if(yych == ')') goto yy346;
				goto yy341;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '.') goto yy440;
				if(yych <= '/') goto yy361;
				if(yych <= '@') goto yy341;
				goto yy355;
			} else {
				if(yych <= '_') {
					if(yych <= '^') goto yy341;
					goto yy361;
				} else {
					if(yych <= '`') goto yy341;
					if(yych <= 'z') goto yy360;
					goto yy341;
				}
			}
		}
yy442:
		YYDEBUG(442, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy399;
				if(yych <= 0x1F) goto yy317;
				goto yy399;
			} else {
				if(yych <= '.') {
					if(yych <= '-') goto yy317;
					goto yy383;
				} else {
					if(yych <= '/') goto yy317;
					if(yych <= '9') goto yy405;
					goto yy383;
				}
			}
		} else {
			if(yych <= 'P') {
				if(yych == 'A') goto yy401;
				if(yych <= 'O') goto yy317;
				goto yy401;
			} else {
				if(yych <= 'a') {
					if(yych <= '`') goto yy317;
					goto yy401;
				} else {
					if(yych == 'p') goto yy401;
					goto yy317;
				}
			}
		}
yy443:
		YYDEBUG(443, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy399;
				if(yych <= 0x1F) goto yy317;
				goto yy399;
			} else {
				if(yych <= '.') {
					if(yych <= '-') goto yy317;
				} else {
					if(yych <= '/') goto yy317;
					if(yych <= '9') goto yy405;
				}
			}
		} else {
			if(yych <= 'P') {
				if(yych == 'A') goto yy401;
				if(yych <= 'O') goto yy317;
				goto yy401;
			} else {
				if(yych <= 'a') {
					if(yych <= '`') goto yy317;
					goto yy401;
				} else {
					if(yych == 'p') goto yy401;
					goto yy317;
				}
			}
		}
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy445;
		if(yych <= '6') goto yy446;
		if(yych <= '9') goto yy342;
		goto yy53;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy343;
			goto yy341;
		} else {
			if(yych <= '9') goto yy447;
			if(yych <= ':') goto yy343;
			goto yy341;
		}
yy446:
		YYDEBUG(446, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy343;
			goto yy341;
		} else {
			if(yych <= '0') goto yy386;
			if(yych == ':') goto yy343;
			goto yy341;
		}
yy447:
		YYDEBUG(447, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy388;
				if(yych <= 0x1F) goto yy341;
				goto yy388;
			} else {
				if(yych <= '(') {
					if(yych <= '\'') goto yy341;
					goto yy388;
				} else {
					if(yych == '+') goto yy388;
					goto yy341;
				}
			}
		} else {
			if(yych <= ':') {
				if(yych <= '-') goto yy388;
				if(yych <= '.') goto yy343;
				if(yych <= '9') goto yy341;
				goto yy343;
			} else {
				if(yych <= 'Z') {
					if(yych <= '@') goto yy341;
					goto yy388;
				} else {
					if(yych <= '`') goto yy341;
					if(yych <= 'z') goto yy388;
					goto yy341;
				}
			}
		}
yy448:
		YYDEBUG(448, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy399;
				if(yych <= 0x1F) goto yy317;
				goto yy399;
			} else {
				if(yych <= '.') {
					if(yych <= '-') goto yy317;
					goto yy429;
				} else {
					if(yych <= '/') goto yy317;
					if(yych <= '9') goto yy405;
					goto yy429;
				}
			}
		} else {
			if(yych <= 'P') {
				if(yych == 'A') goto yy401;
				if(yych <= 'O') goto yy317;
				goto yy401;
			} else {
				if(yych <= 'a') {
					if(yych <= '`') goto yy317;
					goto yy401;
				} else {
					if(yych == 'p') goto yy401;
					goto yy317;
				}
			}
		}
yy449:
		YYDEBUG(449, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '1') {
			if(yych <= '/') goto yy334;
			if(yych <= '0') goto yy451;
			goto yy452;
		} else {
			if(yych <= '2') goto yy453;
			if(yych <= '5') goto yy454;
			if(yych <= '9') goto yy455;
			goto yy334;
		}
yy450:
		YYDEBUG(450, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy339;
			goto yy317;
		} else {
			if(yych <= '0') goto yy422;
			if(yych <= '9') goto yy423;
			if(yych <= ':') goto yy339;
			goto yy317;
		}
yy451:
		YYDEBUG(451, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy468;
			goto yy317;
		} else {
			if(yych <= '0') goto yy467;
			if(yych <= '9') goto yy472;
			if(yych <= ':') goto yy468;
			goto yy317;
		}
yy452:
		YYDEBUG(452, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy456;
			goto yy317;
		} else {
			if(yych <= '2') goto yy472;
			if(yych <= '9') goto yy467;
			if(yych <= ':') goto yy456;
			goto yy317;
		}
yy453:
		YYDEBUG(453, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy456;
			goto yy317;
		} else {
			if(yych <= '3') goto yy467;
			if(yych <= '9') goto yy466;
			if(yych <= ':') goto yy456;
			goto yy317;
		}
yy454:
		YYDEBUG(454, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy456;
			goto yy317;
		} else {
			if(yych <= '9') goto yy466;
			if(yych <= ':') goto yy456;
			goto yy317;
		}
yy455:
		YYDEBUG(455, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych != '.') goto yy317;
		} else {
			if(yych <= '9') goto yy379;
			if(yych >= ';') goto yy317;
		}
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy457;
		if(yych <= '6') goto yy458;
		if(yych <= '9') goto yy382;
		goto yy53;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy341;
		} else {
			if(yych <= '9') goto yy459;
			if(yych <= ':') goto yy383;
			goto yy341;
		}
yy458:
		YYDEBUG(458, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy383;
			goto yy341;
		} else {
			if(yych <= '0') goto yy347;
			if(yych == ':') goto yy383;
			goto yy341;
		}
yy459:
		YYDEBUG(459, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy461;
				if(yych <= 0x1F) goto yy341;
				goto yy461;
			} else {
				if(yych <= '(') {
					if(yych <= '\'') goto yy341;
					goto yy461;
				} else {
					if(yych == '+') goto yy461;
					goto yy341;
				}
			}
		} else {
			if(yych <= ':') {
				if(yych <= '-') goto yy461;
				if(yych <= '.') goto yy383;
				if(yych <= '9') goto yy341;
				goto yy383;
			} else {
				if(yych <= 'Z') {
					if(yych <= '@') goto yy341;
					goto yy461;
				} else {
					if(yych <= '`') goto yy341;
					if(yych <= 'z') goto yy461;
					goto yy341;
				}
			}
		}
yy460:
		YYDEBUG(460, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
		yych = *YYCURSOR;
yy461:
		YYDEBUG(461, *YYCURSOR);
		if(yych <= '-') {
			if(yych <= '\'') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy53;
					goto yy460;
				} else {
					if(yych == ' ') goto yy460;
					goto yy53;
				}
			} else {
				if(yych <= '*') {
					if(yych <= '(') goto yy351;
					goto yy53;
				} else {
					if(yych == ',') goto yy53;
					goto yy350;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= 'A') {
					if(yych <= '@') goto yy53;
				} else {
					if(yych != 'P') goto yy352;
				}
			} else {
				if(yych <= 'o') {
					if(yych <= '`') goto yy53;
					if(yych <= 'a') goto yy463;
					goto yy353;
				} else {
					if(yych <= 'p') goto yy463;
					if(yych <= 'z') goto yy353;
					goto yy53;
				}
			}
		}
		YYDEBUG(462, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '-') {
				if(yych == ')') goto yy346;
				goto yy341;
			} else {
				if(yych <= '.') goto yy402;
				if(yych <= '@') goto yy341;
				goto yy354;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'M') goto yy464;
				if(yych <= 'Z') goto yy354;
				goto yy341;
			} else {
				if(yych == 'm') goto yy465;
				if(yych <= 'z') goto yy359;
				goto yy341;
			}
		}
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '-') {
				if(yych == ')') goto yy346;
				goto yy341;
			} else {
				if(yych <= '.') goto yy402;
				if(yych <= '@') goto yy341;
				goto yy354;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'M') goto yy464;
				if(yych <= 'Z') goto yy354;
				goto yy341;
			} else {
				if(yych == 'm') goto yy464;
				if(yych <= 'z') goto yy354;
				goto yy341;
			}
		}
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ')') {
			if(yych <= 0x09) {
				if(yych <= 0x00) goto yy394;
				if(yych <= 0x08) goto yy341;
				goto yy394;
			} else {
				if(yych == ' ') goto yy394;
				if(yych <= '(') goto yy341;
				goto yy346;
			}
		} else {
			if(yych <= '@') {
				if(yych == '.') goto yy404;
				goto yy341;
			} else {
				if(yych <= 'Z') goto yy355;
				if(yych <= '`') goto yy341;
				if(yych <= 'z') goto yy355;
				goto yy341;
			}
		}
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '-') {
			if(yych <= 0x1F) {
				if(yych <= 0x00) goto yy394;
				if(yych == 0x09) goto yy394;
				goto yy341;
			} else {
				if(yych <= ' ') goto yy394;
				if(yych == ')') goto yy346;
				goto yy341;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '.') goto yy404;
				if(yych <= '/') goto yy361;
				if(yych <= '@') goto yy341;
				goto yy355;
			} else {
				if(yych <= '_') {
					if(yych <= '^') goto yy341;
					goto yy361;
				} else {
					if(yych <= '`') goto yy341;
					if(yych <= 'z') goto yy360;
					goto yy341;
				}
			}
		}
yy466:
		YYDEBUG(466, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy343;
			goto yy317;
		} else {
			if(yych <= '9') goto yy405;
			if(yych <= ':') goto yy343;
			goto yy317;
		}
yy467:
		YYDEBUG(467, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych != '.') goto yy317;
		} else {
			if(yych <= '9') goto yy405;
			if(yych >= ';') goto yy317;
		}
yy468:
		YYDEBUG(468, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy469;
		if(yych <= '6') goto yy470;
		if(yych <= '9') goto yy342;
		goto yy53;
yy469:
		YYDEBUG(469, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy343;
			goto yy341;
		} else {
			if(yych <= '9') goto yy471;
			if(yych <= ':') goto yy343;
			goto yy341;
		}
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy343;
			goto yy341;
		} else {
			if(yych <= '0') goto yy347;
			if(yych == ':') goto yy343;
			goto yy341;
		}
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy348;
				if(yych <= 0x1F) goto yy341;
				goto yy348;
			} else {
				if(yych <= '(') {
					if(yych <= '\'') goto yy341;
					goto yy351;
				} else {
					if(yych == '+') goto yy350;
					goto yy341;
				}
			}
		} else {
			if(yych <= ':') {
				if(yych <= '-') goto yy350;
				if(yych <= '.') goto yy343;
				if(yych <= '9') goto yy341;
				goto yy343;
			} else {
				if(yych <= 'Z') {
					if(yych <= '@') goto yy341;
					goto yy352;
				} else {
					if(yych <= '`') goto yy341;
					if(yych <= 'z') goto yy353;
					goto yy341;
				}
			}
		}
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy456;
			goto yy317;
		} else {
			if(yych <= '9') goto yy405;
			if(yych <= ':') goto yy456;
			goto yy317;
		}
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych == '.') goto yy416;
				goto yy334;
			} else {
				if(yych <= '0') goto yy450;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy380;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych == '.') goto yy416;
				goto yy334;
			} else {
				if(yych <= '0') goto yy450;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy380;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy334;
				if(yych <= '0') goto yy414;
				goto yy479;
			} else {
				if(yych <= '2') goto yy486;
				if(yych <= '9') goto yy487;
				goto yy334;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy330;
				if(yych <= 'q') goto yy334;
				goto yy331;
			} else {
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy334;
				if(yych <= '0') goto yy478;
				goto yy479;
			} else {
				if(yych <= '2') goto yy486;
				if(yych <= '9') goto yy487;
				goto yy334;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy330;
				if(yych <= 'q') goto yy334;
				goto yy331;
			} else {
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy334;
				if(yych >= '1') goto yy479;
			} else {
				if(yych <= '2') goto yy327;
				if(yych <= '9') goto yy328;
				goto yy334;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy330;
				if(yych <= 'q') goto yy334;
				goto yy331;
			} else {
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych <= ',') goto yy334;
				if(yych <= '-') goto yy480;
				if(yych <= '.') goto yy449;
				goto yy334;
			} else {
				if(yych <= '0') goto yy450;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy339;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych <= ',') goto yy334;
				if(yych <= '-') goto yy480;
				if(yych <= '.') goto yy416;
				goto yy334;
			} else {
				if(yych <= '0') goto yy417;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy380;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy480:
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy482;
		if(yych <= '9') goto yy483;
yy482:
		YYDEBUG(482, *YYCURSOR);
		{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy482;
		if(yych >= ':') goto yy482;
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy482;
		if(yych >= ':') goto yy482;
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy482;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych <= ',') goto yy334;
				if(yych <= '-') goto yy480;
				if(yych <= '.') goto yy416;
				goto yy334;
			} else {
				if(yych <= '0') goto yy450;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy380;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy487:
		YYDEBUG(487, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '/') {
				if(yych <= ',') goto yy334;
				if(yych <= '-') goto yy480;
				if(yych <= '.') goto yy416;
				goto yy334;
			} else {
				if(yych <= '0') goto yy450;
				if(yych <= '1') goto yy418;
				if(yych <= '2') goto yy419;
				goto yy420;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy380;
				if(yych == 'n') goto yy330;
				goto yy334;
			} else {
				if(yych <= 'r') goto yy331;
				if(yych <= 's') goto yy329;
				if(yych <= 't') goto yy332;
				goto yy334;
			}
		}
yy488:
		YYDEBUG(488, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'C') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'B') goto yy138;
				goto yy311;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'c') goto yy489;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy489:
		YYDEBUG(489, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'D') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'E') goto yy320;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'd') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'e') goto yy490;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy490:
		YYDEBUG(490, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'L') goto yy140;
				goto yy321;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'm') goto yy491;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy491:
		YYDEBUG(491, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy141;
				goto yy322;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'b') goto yy492;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy492:
		YYDEBUG(492, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'D') goto yy3;
				goto yy323;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy493;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy324;
		if(yych != 'r') goto yy152;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy314;
				goto yy312;
			} else {
				if(yych <= ' ') goto yy314;
				if(yych <= ',') goto yy312;
				goto yy314;
			}
		} else {
			if(yych <= '^') {
				if(yych <= '/') goto yy144;
				if(yych <= '9') goto yy314;
				goto yy312;
			} else {
				if(yych <= '_') goto yy144;
				if(yych <= '`') goto yy312;
				if(yych <= 'z') goto yy151;
				goto yy312;
			}
		}
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy138;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 't') goto yy496;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy496:
		YYDEBUG(496, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'O') goto yy139;
				}
			} else {
				if(yych <= 'n') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'o') goto yy497;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'B') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy140;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'b') goto yy498;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy141;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'e') goto yy499;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Q') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'R') goto yy324;
			if(yych == 'r') goto yy324;
			goto yy3;
		}
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy138;
				goto yy496;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy501;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'N') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'O') goto yy497;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'n') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'o') goto yy502;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy502:
		YYDEBUG(502, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy140;
				goto yy498;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'b') goto yy503;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy503:
		YYDEBUG(503, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy141;
				goto yy499;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy504;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy504:
		YYDEBUG(504, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'Q') goto yy3;
				goto yy324;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy494;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'V') {
			if(yych <= 'B') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'O') {
					if(yych <= 'C') goto yy521;
					goto yy138;
				} else {
					if(yych <= 'P') goto yy520;
					if(yych <= 'U') goto yy138;
					goto yy522;
				}
			}
		} else {
			if(yych <= 'o') {
				if(yych <= '`') {
					if(yych <= 'Z') goto yy138;
					goto yy3;
				} else {
					if(yych == 'c') goto yy521;
					goto yy138;
				}
			} else {
				if(yych <= 'u') {
					if(yych <= 'p') goto yy520;
					goto yy138;
				} else {
					if(yych <= 'v') goto yy522;
					if(yych <= 'z') goto yy138;
					goto yy3;
				}
			}
		}
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy138;
				goto yy515;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 't') goto yy515;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy138;
				goto yy513;
			}
		} else {
			if(yych <= 'w') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'x') goto yy513;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'n') goto yy509;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy285;
				goto yy136;
			} else {
				if(yych <= '@') goto yy285;
				if(yych <= 'C') goto yy139;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy285;
				goto yy139;
			} else {
				if(yych <= 'd') goto yy510;
				if(yych <= 'z') goto yy139;
				goto yy285;
			}
		}
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy511;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy141;
			}
		} else {
			if(yych <= 'x') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'y') goto yy512;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == ')') goto yy136;
		goto yy285;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 't') goto yy514;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'h') goto yy272;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= ')') {
				if(yych <= '(') goto yy285;
				goto yy136;
			} else {
				if(yych <= '@') goto yy285;
				if(yych <= 'T') goto yy139;
			}
		} else {
			if(yych <= 't') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy285;
				goto yy139;
			} else {
				if(yych <= 'u') goto yy516;
				if(yych <= 'z') goto yy139;
				goto yy285;
			}
		}
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy140;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'r') goto yy517;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy141;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'd') goto yy518;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy518:
		YYDEBUG(518, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'A') goto yy519;
			if(yych != 'a') goto yy3;
		}
yy519:
		YYDEBUG(519, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy291;
		if(yych == 'y') goto yy291;
		goto yy53;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych == 'T') goto yy529;
					goto yy139;
				}
			} else {
				if(yych <= 's') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 't') goto yy529;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy139;
				goto yy526;
			}
		} else {
			if(yych <= 'n') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'o') goto yy526;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy139;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'e') goto yy523;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy140;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'n') goto yy524;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy141;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 't') goto yy525;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy525:
		YYDEBUG(525, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy169;
			if(yych == 'h') goto yy169;
			goto yy3;
		}
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy140;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'n') goto yy527;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy141;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'd') goto yy528;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy528:
		YYDEBUG(528, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 0x1F) {
			if(yych == 0x09) goto yy170;
			goto yy3;
		} else {
			if(yych <= ' ') goto yy170;
			if(yych == ')') goto yy136;
			goto yy3;
		}
yy529:
		YYDEBUG(529, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'E') goto yy140;
				}
			} else {
				if(yych <= 'd') {
					if(yych <= '`') goto yy312;
					goto yy140;
				} else {
					if(yych <= 'e') goto yy530;
					if(yych <= 'z') goto yy140;
					goto yy312;
				}
			}
		}
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'M') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'L') goto yy141;
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'm') goto yy531;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy531:
		YYDEBUG(531, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'B') goto yy532;
			if(yych != 'b') goto yy3;
		}
yy532:
		YYDEBUG(532, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy533;
		if(yych != 'e') goto yy53;
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy324;
		if(yych == 'r') goto yy324;
		goto yy53;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= '@') {
				if(yych <= ')') {
					if(yych <= '(') goto yy3;
					goto yy136;
				} else {
					if(yych == '/') goto yy144;
					goto yy3;
				}
			} else {
				if(yych <= 'O') {
					if(yych == 'C') goto yy521;
					goto yy138;
				} else {
					if(yych <= 'P') goto yy520;
					if(yych <= 'U') goto yy138;
					goto yy522;
				}
			}
		} else {
			if(yych <= 'c') {
				if(yych <= '_') {
					if(yych <= 'Z') goto yy138;
					if(yych <= '^') goto yy3;
					goto yy144;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'b') goto yy143;
					goto yy550;
				}
			} else {
				if(yych <= 'u') {
					if(yych == 'p') goto yy549;
					goto yy143;
				} else {
					if(yych <= 'v') goto yy551;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
yy535:
		YYDEBUG(535, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy138;
				goto yy515;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy544;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy536:
		YYDEBUG(536, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'X') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy138;
				goto yy513;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'x') goto yy542;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy537:
		YYDEBUG(537, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
				goto yy509;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy538;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy538:
		YYDEBUG(538, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy285;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy285;
				if(yych <= 'C') goto yy139;
				goto yy510;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy285;
			} else {
				if(yych == 'd') goto yy539;
				if(yych <= 'z') goto yy148;
				goto yy285;
			}
		}
yy539:
		YYDEBUG(539, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy511;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy540;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy540:
		YYDEBUG(540, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy141;
				goto yy512;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'y') goto yy541;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy541:
		YYDEBUG(541, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == ')') goto yy136;
			if(yych <= '.') goto yy285;
			goto yy144;
		} else {
			if(yych <= '_') {
				if(yych <= '^') goto yy285;
				goto yy144;
			} else {
				if(yych <= '`') goto yy285;
				if(yych <= 'z') goto yy151;
				goto yy285;
			}
		}
yy542:
		YYDEBUG(542, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy514;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy543;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy543:
		YYDEBUG(543, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy282;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy544:
		YYDEBUG(544, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy285;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy285;
				if(yych <= 'T') goto yy139;
				goto yy516;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy285;
			} else {
				if(yych == 'u') goto yy545;
				if(yych <= 'z') goto yy148;
				goto yy285;
			}
		}
yy545:
		YYDEBUG(545, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy140;
				goto yy517;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy546;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy546:
		YYDEBUG(546, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy141;
				goto yy518;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy547;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy519;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy548;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy291;
		if(yych == 'y') goto yy304;
		goto yy152;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'S') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'T') goto yy529;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 's') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 't') goto yy558;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy550:
		YYDEBUG(550, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy139;
				goto yy526;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'o') goto yy555;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy551:
		YYDEBUG(551, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy139;
				goto yy523;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy552;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy552:
		YYDEBUG(552, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy140;
				goto yy524;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy553;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy141;
				goto yy525;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy554;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy554:
		YYDEBUG(554, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'G') goto yy3;
				goto yy169;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy256;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy555:
		YYDEBUG(555, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy140;
				goto yy527;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy556;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy556:
		YYDEBUG(556, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy141;
				goto yy528;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy557;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy557:
		YYDEBUG(557, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ')') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy170;
				goto yy3;
			} else {
				if(yych <= ' ') goto yy170;
				if(yych <= '(') goto yy3;
				goto yy136;
			}
		} else {
			if(yych <= '^') {
				if(yych == '/') goto yy144;
				goto yy3;
			} else {
				if(yych <= '_') goto yy144;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy558:
		YYDEBUG(558, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'D') {
					if(yych <= '@') goto yy312;
					goto yy140;
				} else {
					if(yych <= 'E') goto yy530;
					if(yych <= 'Z') goto yy140;
					goto yy312;
				}
			} else {
				if(yych <= 'd') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy149;
				} else {
					if(yych <= 'e') goto yy559;
					if(yych <= 'z') goto yy149;
					goto yy312;
				}
			}
		}
yy559:
		YYDEBUG(559, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'L') goto yy141;
				goto yy531;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'm') goto yy560;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy560:
		YYDEBUG(560, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'A') goto yy3;
				goto yy532;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'b') goto yy561;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy533;
		if(yych != 'e') goto yy152;
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy324;
		if(yych == 'r') goto yy494;
		goto yy152;
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'G') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy138;
				goto yy571;
			}
		} else {
			if(yych <= 'f') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'g') goto yy571;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy138;
				goto yy568;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'r') goto yy568;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy138;
			}
		} else {
			if(yych <= 'n') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'o') goto yy566;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy566:
		YYDEBUG(566, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '@') {
			if(yych == ')') goto yy136;
		} else {
			if(yych <= 'Z') goto yy139;
			if(yych <= '`') goto yy567;
			if(yych <= 'z') goto yy139;
		}
yy567:
		YYDEBUG(567, *YYCURSOR);
		{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->have_special_relative && s->time->special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->special.amount = 0 - s->time->special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'I') goto yy139;
				}
			} else {
				if(yych <= 'h') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'i') goto yy569;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'K') goto yy140;
			}
		} else {
			if(yych <= 'k') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'l') goto yy570;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy570:
		YYDEBUG(570, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy314;
				goto yy312;
			} else {
				if(yych <= ' ') goto yy314;
				if(yych == ')') goto yy136;
				goto yy312;
			}
		} else {
			if(yych <= '@') {
				if(yych == '/') goto yy312;
				if(yych <= '9') goto yy314;
				goto yy312;
			} else {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy312;
				if(yych <= 'z') goto yy141;
				goto yy312;
			}
		}
yy571:
		YYDEBUG(571, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'U') goto yy139;
				}
			} else {
				if(yych <= 't') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'u') goto yy572;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy140;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 's') goto yy573;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy141;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 't') goto yy574;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy574:
		YYDEBUG(574, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '(') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy312;
				goto yy314;
			} else {
				if(yych == ' ') goto yy314;
				goto yy312;
			}
		} else {
			if(yych <= '.') {
				if(yych <= ')') goto yy136;
				if(yych <= ',') goto yy312;
				goto yy314;
			} else {
				if(yych <= '/') goto yy312;
				if(yych <= '9') goto yy314;
				goto yy312;
			}
		}
yy575:
		YYDEBUG(575, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy138;
				goto yy571;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'g') goto yy582;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy576:
		YYDEBUG(576, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy138;
				goto yy568;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy579;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy138;
				goto yy566;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'o') goto yy578;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy578:
		YYDEBUG(578, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy567;
				goto yy136;
			} else {
				if(yych == '/') goto yy144;
				goto yy567;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '^') goto yy567;
				goto yy144;
			} else {
				if(yych <= '`') goto yy567;
				if(yych <= 'z') goto yy148;
				goto yy567;
			}
		}
yy579:
		YYDEBUG(579, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'H') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'I') goto yy569;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'h') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'i') goto yy580;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy580:
		YYDEBUG(580, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'K') goto yy140;
				goto yy570;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'l') goto yy581;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy581:
		YYDEBUG(581, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy312;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy312;
				goto yy314;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '/') goto yy144;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy312;
				goto yy141;
			} else {
				if(yych <= '_') {
					if(yych <= '^') goto yy312;
					goto yy144;
				} else {
					if(yych <= '`') goto yy312;
					if(yych <= 'z') goto yy150;
					goto yy312;
				}
			}
		}
yy582:
		YYDEBUG(582, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'T') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'U') goto yy572;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 't') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'u') goto yy583;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy583:
		YYDEBUG(583, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy140;
				goto yy573;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 's') goto yy584;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy584:
		YYDEBUG(584, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy141;
				goto yy574;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy585;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy585:
		YYDEBUG(585, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy314;
				goto yy312;
			} else {
				if(yych <= ' ') goto yy314;
				if(yych == ')') goto yy136;
				goto yy312;
			}
		} else {
			if(yych <= '^') {
				if(yych == '/') goto yy144;
				if(yych <= '9') goto yy314;
				goto yy312;
			} else {
				if(yych <= '_') goto yy144;
				if(yych <= '`') goto yy312;
				if(yych <= 'z') goto yy151;
				goto yy312;
			}
		}
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'B') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy138;
				goto yy600;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'b') goto yy600;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych == 'F') goto yy597;
				if(yych <= 'Q') goto yy138;
				goto yy596;
			}
		} else {
			if(yych <= 'f') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'e') goto yy138;
				goto yy597;
			} else {
				if(yych == 'r') goto yy596;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'T') goto yy138;
				goto yy593;
			}
		} else {
			if(yych <= 't') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'u') goto yy593;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'I') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy138;
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'i') goto yy590;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy285;
				goto yy136;
			} else {
				if(yych <= '@') goto yy285;
				if(yych <= 'C') goto yy139;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy285;
				goto yy139;
			} else {
				if(yych <= 'd') goto yy591;
				if(yych <= 'z') goto yy139;
				goto yy285;
			}
		}
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy592;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy141;
				goto yy512;
			}
		} else {
			if(yych <= 'x') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'y') goto yy512;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy139;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'r') goto yy594;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy140;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 't') goto yy595;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy141;
				goto yy528;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'h') goto yy528;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy139;
				goto yy599;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 's') goto yy599;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 't') goto yy598;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'h') goto yy272;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 't') goto yy272;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy600:
		YYDEBUG(600, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'R') goto yy139;
				}
			} else {
				if(yych <= 'q') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'r') goto yy601;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'T') goto yy140;
			}
		} else {
			if(yych <= 't') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'u') goto yy602;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy603;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Q') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'R') goto yy604;
			if(yych != 'r') goto yy3;
		}
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy324;
		if(yych == 'y') goto yy324;
		goto yy53;
yy605:
		YYDEBUG(605, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy138;
				goto yy600;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'b') goto yy619;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy606:
		YYDEBUG(606, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '/') {
				if(yych == ')') goto yy136;
				if(yych <= '.') goto yy3;
				goto yy144;
			} else {
				if(yych <= 'E') {
					if(yych <= '@') goto yy3;
					goto yy138;
				} else {
					if(yych <= 'F') goto yy597;
					if(yych <= 'Q') goto yy138;
					goto yy596;
				}
			}
		} else {
			if(yych <= 'e') {
				if(yych <= '^') {
					if(yych <= 'Z') goto yy138;
					goto yy3;
				} else {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy3;
					goto yy143;
				}
			} else {
				if(yych <= 'q') {
					if(yych <= 'f') goto yy616;
					goto yy143;
				} else {
					if(yych <= 'r') goto yy615;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
yy607:
		YYDEBUG(607, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'T') goto yy138;
				goto yy593;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'u') goto yy612;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'I') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy138;
				goto yy590;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'i') goto yy609;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy609:
		YYDEBUG(609, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy285;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy285;
				if(yych <= 'C') goto yy139;
				goto yy591;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy285;
			} else {
				if(yych == 'd') goto yy610;
				if(yych <= 'z') goto yy148;
				goto yy285;
			}
		}
yy610:
		YYDEBUG(610, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy592;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy611;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy611:
		YYDEBUG(611, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy141;
				goto yy512;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'y') goto yy541;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy612:
		YYDEBUG(612, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy139;
				goto yy594;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy613;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy613:
		YYDEBUG(613, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy140;
				goto yy595;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy614;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy614:
		YYDEBUG(614, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy141;
				goto yy528;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy557;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy615:
		YYDEBUG(615, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy139;
				goto yy599;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 's') goto yy618;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy616:
		YYDEBUG(616, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy598;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy617;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy617:
		YYDEBUG(617, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy282;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy618:
		YYDEBUG(618, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy282;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy619:
		YYDEBUG(619, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'Q') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'R') goto yy601;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'q') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'r') goto yy620;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy620:
		YYDEBUG(620, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'T') goto yy140;
				goto yy602;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'u') goto yy621;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy621:
		YYDEBUG(621, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy603;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy622;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy622:
		YYDEBUG(622, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'Q') goto yy3;
				goto yy604;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy623;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy324;
		if(yych == 'y') goto yy494;
		goto yy152;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych == 'L') goto yy631;
				if(yych <= 'M') goto yy138;
				goto yy630;
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'k') goto yy138;
				goto yy631;
			} else {
				if(yych == 'n') goto yy630;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'n') goto yy626;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy626:
		YYDEBUG(626, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'U') goto yy139;
				}
			} else {
				if(yych <= 't') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'u') goto yy627;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy628;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy628:
		YYDEBUG(628, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy141;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'r') goto yy629;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Y') goto yy324;
			if(yych == 'y') goto yy324;
			goto yy3;
		}
yy630:
		YYDEBUG(630, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych == 'E') goto yy632;
					goto yy139;
				}
			} else {
				if(yych <= 'd') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'e') goto yy632;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy631:
		YYDEBUG(631, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'Y') goto yy139;
				}
			} else {
				if(yych <= 'x') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'y') goto yy632;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy632:
		YYDEBUG(632, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy314;
				goto yy312;
			} else {
				if(yych <= ' ') goto yy314;
				if(yych == ')') goto yy136;
				goto yy312;
			}
		} else {
			if(yych <= '@') {
				if(yych == '/') goto yy312;
				if(yych <= '9') goto yy314;
				goto yy312;
			} else {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy312;
				if(yych <= 'z') goto yy140;
				goto yy312;
			}
		}
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '/') {
				if(yych == ')') goto yy136;
				if(yych <= '.') goto yy3;
				goto yy144;
			} else {
				if(yych <= 'K') {
					if(yych <= '@') goto yy3;
					goto yy138;
				} else {
					if(yych <= 'L') goto yy631;
					if(yych <= 'M') goto yy138;
					goto yy630;
				}
			}
		} else {
			if(yych <= 'k') {
				if(yych <= '^') {
					if(yych <= 'Z') goto yy138;
					goto yy3;
				} else {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy3;
					goto yy143;
				}
			} else {
				if(yych <= 'm') {
					if(yych <= 'l') goto yy640;
					goto yy143;
				} else {
					if(yych <= 'n') goto yy639;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
				goto yy626;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy635;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'T') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'U') goto yy627;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 't') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'u') goto yy636;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy636:
		YYDEBUG(636, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy628;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy637;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy141;
				goto yy629;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy638;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy638:
		YYDEBUG(638, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'X') goto yy3;
				goto yy324;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'y') goto yy494;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy639:
		YYDEBUG(639, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'D') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'E') goto yy632;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'd') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'e') goto yy641;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'X') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'Y') goto yy632;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'x') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'y') goto yy641;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy312;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy312;
				goto yy314;
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '/') goto yy144;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy312;
				goto yy140;
			} else {
				if(yych <= '_') {
					if(yych <= '^') goto yy312;
					goto yy144;
				} else {
					if(yych <= '`') goto yy312;
					if(yych <= 'z') goto yy149;
					goto yy312;
				}
			}
		}
yy642:
		YYDEBUG(642, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy3;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy3;
				goto yy314;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'Z') {
					if(yych >= 'J') goto yy138;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'z') goto yy138;
					goto yy3;
				}
			}
		}
yy643:
		YYDEBUG(643, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy314;
				goto yy3;
			} else {
				if(yych <= ' ') goto yy314;
				if(yych == ')') goto yy136;
				goto yy3;
			}
		} else {
			if(yych <= '@') {
				if(yych == '/') goto yy3;
				if(yych <= '9') goto yy314;
				goto yy3;
			} else {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy644:
		YYDEBUG(644, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy3;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy3;
				goto yy314;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'Z') {
					if(yych >= 'J') goto yy138;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'z') goto yy138;
					goto yy3;
				}
			}
		}
		YYDEBUG(645, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy3;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy3;
				goto yy314;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'Z') {
					if(yych >= 'J') goto yy139;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'z') goto yy139;
					goto yy3;
				}
			}
		}
		YYDEBUG(646, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy314;
				goto yy3;
			} else {
				if(yych <= ' ') goto yy314;
				if(yych == ')') goto yy136;
				goto yy3;
			}
		} else {
			if(yych <= '@') {
				if(yych == '/') goto yy3;
				if(yych <= '9') goto yy314;
				goto yy3;
			} else {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy647:
		YYDEBUG(647, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy314;
				goto yy3;
			} else {
				if(yych <= ' ') goto yy314;
				if(yych == ')') goto yy136;
				goto yy3;
			}
		} else {
			if(yych <= '@') {
				if(yych == '/') goto yy3;
				if(yych <= '9') goto yy314;
				goto yy3;
			} else {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy648:
		YYDEBUG(648, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy3;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy3;
				goto yy314;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy3;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'Z') {
					if(yych <= 'I') goto yy643;
					goto yy138;
				} else {
					if(yych <= '`') goto yy3;
					if(yych <= 'z') goto yy138;
					goto yy3;
				}
			}
		}
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy651;
		if(yych <= '0') goto yy899;
		if(yych <= '1') goto yy900;
		if(yych <= '9') goto yy901;
		goto yy651;
yy650:
		YYDEBUG(650, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
		yych = *YYCURSOR;
yy651:
		YYDEBUG(651, *YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:
		case ' ':	goto yy650;
		case '-':
		case '.':	goto yy750;
		case 'A':
		case 'a':	goto yy669;
		case 'D':
		case 'd':	goto yy655;
		case 'F':
		case 'f':	goto yy656;
		case 'H':
		case 'h':	goto yy60;
		case 'I':	goto yy664;
		case 'J':
		case 'j':	goto yy668;
		case 'M':
		case 'm':	goto yy654;
		case 'N':
		case 'n':	goto yy671;
		case 'O':
		case 'o':	goto yy670;
		case 'P':
		case 'p':	goto yy673;
		case 'S':
		case 's':	goto yy652;
		case 'T':
		case 't':	goto yy65;
		case 'V':	goto yy666;
		case 'W':
		case 'w':	goto yy62;
		case 'X':	goto yy667;
		case 'Y':
		case 'y':	goto yy64;
		default:	goto yy53;
		}
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy123;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy1198;
				if(yych <= 'T') goto yy53;
				goto yy122;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy123;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy1198;
				if(yych == 'u') goto yy122;
				goto yy53;
			}
		}
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '`') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy123;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy1198;
				if(yych == 'U') goto yy122;
				goto yy53;
			}
		} else {
			if(yych <= 'e') {
				if(yych <= 'a') goto yy123;
				if(yych <= 'd') goto yy53;
				goto yy1198;
			} else {
				if(yych <= 's') goto yy53;
				if(yych <= 't') goto yy896;
				if(yych <= 'u') goto yy122;
				goto yy53;
			}
		}
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'H') {
				if(yych == 'A') goto yy765;
				goto yy53;
			} else {
				if(yych <= 'I') goto yy114;
				if(yych <= 'N') goto yy53;
				goto yy113;
			}
		} else {
			if(yych <= 'h') {
				if(yych == 'a') goto yy765;
				goto yy53;
			} else {
				if(yych <= 'i') goto yy114;
				if(yych == 'o') goto yy113;
				goto yy53;
			}
		}
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych == 'A') goto yy110;
			if(yych <= 'D') goto yy53;
			goto yy752;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy110;
			} else {
				if(yych == 'e') goto yy752;
				goto yy53;
			}
		}
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= 'N') {
				if(yych == 'E') goto yy768;
				goto yy53;
			} else {
				if(yych <= 'O') goto yy83;
				if(yych <= 'Q') goto yy53;
				goto yy82;
			}
		} else {
			if(yych <= 'n') {
				if(yych == 'e') goto yy768;
				goto yy53;
			} else {
				if(yych <= 'o') goto yy83;
				if(yych == 'r') goto yy82;
				goto yy53;
			}
		}
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'H') goto yy66;
			if(yych <= 'T') goto yy53;
			goto yy67;
		} else {
			if(yych <= 'h') {
				if(yych <= 'g') goto yy53;
				goto yy1197;
			} else {
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '-') goto yy903;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy902;
		goto yy57;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'c') {
			if(yych == 'O') goto yy703;
			goto yy53;
		} else {
			if(yych <= 'd') goto yy896;
			if(yych == 'o') goto yy703;
			goto yy53;
		}
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy896;
		goto yy53;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch(yych) {
		case '0':
		case '1':
		case '2':	goto yy836;
		case '3':	goto yy838;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy839;
		case 'A':
		case 'a':	goto yy843;
		case 'D':
		case 'd':	goto yy847;
		case 'F':
		case 'f':	goto yy841;
		case 'J':
		case 'j':	goto yy840;
		case 'M':
		case 'm':	goto yy842;
		case 'N':
		case 'n':	goto yy846;
		case 'O':
		case 'o':	goto yy845;
		case 'S':
		case 's':	goto yy844;
		default:	goto yy53;
		}
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch(yych) {
		case '0':	goto yy786;
		case '1':	goto yy787;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy788;
		case 'A':
		case 'a':	goto yy792;
		case 'D':
		case 'd':	goto yy796;
		case 'F':
		case 'f':	goto yy790;
		case 'J':
		case 'j':	goto yy789;
		case 'M':
		case 'm':	goto yy791;
		case 'N':
		case 'n':	goto yy795;
		case 'O':
		case 'o':	goto yy794;
		case 'S':
		case 's':	goto yy793;
		default:	goto yy751;
		}
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '1') {
			if(yych <= '/') goto yy751;
			if(yych <= '0') goto yy741;
			goto yy742;
		} else {
			if(yych <= '5') goto yy743;
			if(yych <= '9') goto yy744;
			goto yy751;
		}
yy664:
		YYDEBUG(664, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '.') goto yy705;
			}
		} else {
			if(yych <= 'U') {
				if(yych <= '9') goto yy707;
				if(yych == 'I') goto yy740;
			} else {
				if(yych == 'W') goto yy665;
				if(yych <= 'X') goto yy713;
			}
		}
yy665:
		YYDEBUG(665, *YYCURSOR);
		{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy666:
		YYDEBUG(666, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy665;
				goto yy705;
			} else {
				if(yych == ' ') goto yy705;
				goto yy665;
			}
		} else {
			if(yych <= '9') {
				if(yych <= '.') goto yy705;
				if(yych <= '/') goto yy665;
				goto yy707;
			} else {
				if(yych == 'I') goto yy738;
				goto yy665;
			}
		}
yy667:
		YYDEBUG(667, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy665;
				goto yy705;
			} else {
				if(yych == ' ') goto yy705;
				goto yy665;
			}
		} else {
			if(yych <= '9') {
				if(yych <= '.') goto yy705;
				if(yych <= '/') goto yy665;
				goto yy707;
			} else {
				if(yych == 'I') goto yy737;
				goto yy665;
			}
		}
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy730;
			if(yych <= 'T') goto yy53;
			goto yy729;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy730;
			} else {
				if(yych == 'u') goto yy729;
				goto yy53;
			}
		}
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= 'L') {
				if(yych == '.') goto yy674;
				goto yy53;
			} else {
				if(yych <= 'M') goto yy675;
				if(yych == 'P') goto yy723;
				goto yy53;
			}
		} else {
			if(yych <= 'o') {
				if(yych <= 'U') goto yy722;
				if(yych == 'm') goto yy675;
				goto yy53;
			} else {
				if(yych <= 'p') goto yy723;
				if(yych == 'u') goto yy722;
				goto yy53;
			}
		}
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy717;
		if(yych == 'c') goto yy717;
		goto yy53;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy703;
		if(yych == 'o') goto yy703;
		goto yy53;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy679;
		if(yych <= '9') goto yy681;
		goto yy53;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych != '.') goto yy53;
		} else {
			if(yych <= 'M') goto yy675;
			if(yych == 'm') goto yy675;
			goto yy53;
		}
yy674:
		YYDEBUG(674, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy675;
		if(yych != 'm') goto yy53;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x1F) {
			if(yych <= 0x00) goto yy677;
			if(yych == 0x09) goto yy677;
			goto yy53;
		} else {
			if(yych <= ' ') goto yy677;
			if(yych != '.') goto yy53;
		}
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x09) {
			if(yych <= 0x00) goto yy677;
			if(yych <= 0x08) goto yy53;
		} else {
			if(yych != ' ') goto yy53;
		}
yy677:
		YYDEBUG(677, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(678, *YYCURSOR);
		{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy679:
		YYDEBUG(679, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy682;
		} else {
			if(yych <= '9') goto yy696;
			if(yych <= ':') goto yy682;
		}
yy680:
		YYDEBUG(680, *YYCURSOR);
		{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy681:
		YYDEBUG(681, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy682;
		if(yych != ':') goto yy680;
yy682:
		YYDEBUG(682, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy683;
		if(yych <= '6') goto yy684;
		if(yych <= '9') goto yy685;
		goto yy53;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych <= '/') goto yy680;
		if(yych <= '9') goto yy689;
		goto yy680;
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych == '0') goto yy689;
		goto yy680;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != '.') goto yy680;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy687:
		YYDEBUG(687, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(688, *YYCURSOR);
		if(yych <= '/') goto yy680;
		if(yych <= '9') goto yy687;
		goto yy680;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= 0x1F) {
				if(yych != 0x09) goto yy680;
			} else {
				if(yych <= ' ') goto yy690;
				if(yych == '.') goto yy686;
				goto yy680;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'A') goto yy692;
				if(yych == 'P') goto yy692;
				goto yy680;
			} else {
				if(yych <= 'a') goto yy692;
				if(yych == 'p') goto yy692;
				goto yy680;
			}
		}
yy690:
		YYDEBUG(690, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(691, *YYCURSOR);
		if(yych <= 'A') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy690;
				goto yy53;
			} else {
				if(yych <= ' ') goto yy690;
				if(yych <= '@') goto yy53;
			}
		} else {
			if(yych <= '`') {
				if(yych != 'P') goto yy53;
			} else {
				if(yych <= 'a') goto yy692;
				if(yych != 'p') goto yy53;
			}
		}
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych != '.') goto yy53;
		} else {
			if(yych <= 'M') goto yy694;
			if(yych == 'm') goto yy694;
			goto yy53;
		}
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy694;
		if(yych != 'm') goto yy53;
yy694:
		YYDEBUG(694, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x1F) {
			if(yych <= 0x00) goto yy677;
			if(yych == 0x09) goto yy677;
			goto yy53;
		} else {
			if(yych <= ' ') goto yy677;
			if(yych != '.') goto yy53;
		}
		YYDEBUG(695, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x09) {
			if(yych <= 0x00) goto yy677;
			if(yych <= 0x08) goto yy53;
			goto yy677;
		} else {
			if(yych == ' ') goto yy677;
			goto yy53;
		}
yy696:
		YYDEBUG(696, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy697;
				if(yych <= 0x1F) goto yy680;
			} else {
				if(yych == '.') goto yy682;
				if(yych <= '9') goto yy680;
				goto yy682;
			}
		} else {
			if(yych <= 'P') {
				if(yych == 'A') goto yy699;
				if(yych <= 'O') goto yy680;
				goto yy699;
			} else {
				if(yych <= 'a') {
					if(yych <= '`') goto yy680;
					goto yy699;
				} else {
					if(yych == 'p') goto yy699;
					goto yy680;
				}
			}
		}
yy697:
		YYDEBUG(697, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(698, *YYCURSOR);
		if(yych <= 'A') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy697;
				goto yy53;
			} else {
				if(yych <= ' ') goto yy697;
				if(yych <= '@') goto yy53;
			}
		} else {
			if(yych <= '`') {
				if(yych != 'P') goto yy53;
			} else {
				if(yych <= 'a') goto yy699;
				if(yych != 'p') goto yy53;
			}
		}
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych != '.') goto yy53;
		} else {
			if(yych <= 'M') goto yy701;
			if(yych == 'm') goto yy701;
			goto yy53;
		}
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy701;
		if(yych != 'm') goto yy53;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x1F) {
			if(yych <= 0x00) goto yy677;
			if(yych == 0x09) goto yy677;
			goto yy53;
		} else {
			if(yych <= ' ') goto yy677;
			if(yych != '.') goto yy53;
		}
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 0x09) {
			if(yych <= 0x00) goto yy677;
			if(yych <= 0x08) goto yy53;
			goto yy677;
		} else {
			if(yych == ' ') goto yy677;
			goto yy53;
		}
yy703:
		YYDEBUG(703, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy704;
		if(yych != 'v') goto yy53;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych != 0x09) goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy709;
				if(yych == 'e') goto yy709;
				goto yy665;
			}
		}
yy705:
		YYDEBUG(705, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
		yych = *YYCURSOR;
yy706:
		YYDEBUG(706, *YYCURSOR);
		if(yych <= ' ') {
			if(yych == 0x09) goto yy705;
			if(yych <= 0x1F) goto yy53;
			goto yy705;
		} else {
			if(yych <= '.') {
				if(yych <= ',') goto yy53;
				goto yy705;
			} else {
				if(yych <= '/') goto yy53;
				if(yych >= ':') goto yy53;
			}
		}
yy707:
		YYDEBUG(707, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy708;
		if(yych <= '9') goto yy714;
yy708:
		YYDEBUG(708, *YYCURSOR);
		{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy710;
		if(yych != 'm') goto yy53;
yy710:
		YYDEBUG(710, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy711;
		if(yych != 'b') goto yy53;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy712;
		if(yych != 'e') goto yy53;
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy713;
		if(yych != 'r') goto yy53;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ' ') {
			if(yych == 0x09) goto yy705;
			if(yych <= 0x1F) goto yy665;
			goto yy705;
		} else {
			if(yych <= '.') {
				if(yych <= ',') goto yy665;
				goto yy705;
			} else {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			}
		}
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy708;
		if(yych >= ':') goto yy708;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy708;
		if(yych >= ':') goto yy708;
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy708;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy718;
		if(yych != 't') goto yy53;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'N') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'O') goto yy719;
				if(yych != 'o') goto yy665;
			}
		}
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy720;
		if(yych != 'b') goto yy53;
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy721;
		if(yych != 'e') goto yy53;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy713;
		if(yych == 'r') goto yy713;
		goto yy53;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy726;
		if(yych == 'g') goto yy726;
		goto yy53;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy724;
		if(yych != 'r') goto yy53;
yy724:
		YYDEBUG(724, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'I') goto yy725;
				if(yych != 'i') goto yy665;
			}
		}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy713;
		if(yych == 'l') goto yy713;
		goto yy53;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'T') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'U') goto yy727;
				if(yych != 'u') goto yy665;
			}
		}
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy728;
		if(yych != 's') goto yy53;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy713;
		if(yych == 't') goto yy713;
		goto yy53;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy736;
			if(yych <= 'M') goto yy53;
			goto yy735;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy736;
			} else {
				if(yych == 'n') goto yy735;
				goto yy53;
			}
		}
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy731;
		if(yych != 'n') goto yy53;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'T') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'U') goto yy732;
				if(yych != 'u') goto yy665;
			}
		}
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy733;
		if(yych != 'a') goto yy53;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy734;
		if(yych != 'r') goto yy53;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy713;
		if(yych == 'y') goto yy713;
		goto yy53;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy713;
				if(yych == 'e') goto yy713;
				goto yy665;
			}
		}
yy736:
		YYDEBUG(736, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'X') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'Y') goto yy713;
				if(yych == 'y') goto yy713;
				goto yy665;
			}
		}
yy737:
		YYDEBUG(737, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy665;
				goto yy705;
			} else {
				if(yych == ' ') goto yy705;
				goto yy665;
			}
		} else {
			if(yych <= '9') {
				if(yych <= '.') goto yy705;
				if(yych <= '/') goto yy665;
				goto yy707;
			} else {
				if(yych == 'I') goto yy713;
				goto yy665;
			}
		}
yy738:
		YYDEBUG(738, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy665;
				goto yy705;
			} else {
				if(yych == ' ') goto yy705;
				goto yy665;
			}
		} else {
			if(yych <= '9') {
				if(yych <= '.') goto yy705;
				if(yych <= '/') goto yy665;
				goto yy707;
			} else {
				if(yych != 'I') goto yy665;
			}
		}
		YYDEBUG(739, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy665;
				goto yy705;
			} else {
				if(yych == ' ') goto yy705;
				goto yy665;
			}
		} else {
			if(yych <= '9') {
				if(yych <= '.') goto yy705;
				if(yych <= '/') goto yy665;
				goto yy707;
			} else {
				if(yych == 'I') goto yy713;
				goto yy665;
			}
		}
yy740:
		YYDEBUG(740, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy665;
				goto yy705;
			} else {
				if(yych == ' ') goto yy705;
				goto yy665;
			}
		} else {
			if(yych <= '9') {
				if(yych <= '.') goto yy705;
				if(yych <= '/') goto yy665;
				goto yy707;
			} else {
				if(yych == 'I') goto yy713;
				goto yy665;
			}
		}
yy741:
		YYDEBUG(741, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
			goto yy775;
		} else {
			if(yych <= '/') goto yy680;
			if(yych <= '9') goto yy785;
			if(yych <= ':') goto yy682;
			goto yy680;
		}
yy742:
		YYDEBUG(742, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
			if(yych <= '.') goto yy775;
			goto yy680;
		} else {
			if(yych <= '2') goto yy785;
			if(yych <= '9') goto yy696;
			if(yych <= ':') goto yy682;
			goto yy680;
		}
yy743:
		YYDEBUG(743, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
			goto yy775;
		} else {
			if(yych <= '/') goto yy680;
			if(yych <= '9') goto yy696;
			if(yych <= ':') goto yy682;
			goto yy680;
		}
yy744:
		YYDEBUG(744, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
			goto yy775;
		} else {
			if(yych == ':') goto yy682;
			goto yy680;
		}
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy768;
		if(yych == 'e') goto yy768;
		goto yy53;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy765;
		if(yych == 'a') goto yy765;
		goto yy53;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy723;
			if(yych <= 'T') goto yy53;
			goto yy722;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy723;
			} else {
				if(yych == 'u') goto yy722;
				goto yy53;
			}
		}
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy758;
		if(yych == 'e') goto yy758;
		goto yy53;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy752;
		if(yych == 'e') goto yy752;
		goto yy53;
yy750:
		YYDEBUG(750, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
		yych = *YYCURSOR;
yy751:
		YYDEBUG(751, *YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:
		case ' ':
		case '-':
		case '.':	goto yy750;
		case 'A':
		case 'a':	goto yy747;
		case 'D':
		case 'd':	goto yy749;
		case 'F':
		case 'f':	goto yy745;
		case 'I':	goto yy664;
		case 'J':
		case 'j':	goto yy668;
		case 'M':
		case 'm':	goto yy746;
		case 'N':
		case 'n':	goto yy671;
		case 'O':
		case 'o':	goto yy670;
		case 'S':
		case 's':	goto yy748;
		case 'V':	goto yy666;
		case 'X':	goto yy667;
		default:	goto yy53;
		}
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy753;
		if(yych != 'c') goto yy53;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy754;
				if(yych != 'e') goto yy665;
			}
		}
yy754:
		YYDEBUG(754, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy755;
		if(yych != 'm') goto yy53;
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy756;
		if(yych != 'b') goto yy53;
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy757;
		if(yych != 'e') goto yy53;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy713;
		if(yych == 'r') goto yy713;
		goto yy53;
yy758:
		YYDEBUG(758, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy759;
		if(yych != 'p') goto yy53;
yy759:
		YYDEBUG(759, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'S') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'T') goto yy760;
				if(yych != 't') goto yy665;
			}
		}
yy760:
		YYDEBUG(760, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy761;
				if(yych != 'e') goto yy665;
			}
		}
yy761:
		YYDEBUG(761, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy762;
		if(yych != 'm') goto yy53;
yy762:
		YYDEBUG(762, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy763;
		if(yych != 'b') goto yy53;
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy764;
		if(yych != 'e') goto yy53;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy713;
		if(yych == 'r') goto yy713;
		goto yy53;
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy766;
			if(yych <= 'X') goto yy53;
			goto yy713;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy713;
				goto yy53;
			}
		}
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'B') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'C') goto yy767;
				if(yych != 'c') goto yy665;
			}
		}
yy767:
		YYDEBUG(767, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy713;
		if(yych == 'h') goto yy713;
		goto yy53;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy769;
		if(yych != 'b') goto yy53;
yy769:
		YYDEBUG(769, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				goto yy705;
			}
		} else {
			if(yych <= 'Q') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'R') goto yy770;
				if(yych != 'r') goto yy665;
			}
		}
yy770:
		YYDEBUG(770, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy771;
		if(yych != 'u') goto yy53;
yy771:
		YYDEBUG(771, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy772;
		if(yych != 'a') goto yy53;
yy772:
		YYDEBUG(772, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy773;
		if(yych != 'r') goto yy53;
yy773:
		YYDEBUG(773, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy713;
		if(yych == 'y') goto yy713;
		goto yy53;
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy784;
		goto yy53;
yy775:
		YYDEBUG(775, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy776;
		if(yych <= '6') goto yy777;
		if(yych <= '9') goto yy778;
		goto yy53;
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych <= '/') goto yy680;
		if(yych <= '9') goto yy783;
		goto yy680;
yy777:
		YYDEBUG(777, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy686;
			goto yy680;
		} else {
			if(yych <= '0') goto yy783;
			if(yych <= '9') goto yy779;
			goto yy680;
		}
yy778:
		YYDEBUG(778, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych <= '/') goto yy680;
		if(yych >= ':') goto yy680;
yy779:
		YYDEBUG(779, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy780;
		if(yych <= '9') goto yy781;
yy780:
		YYDEBUG(780, *YYCURSOR);
		{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy781:
		YYDEBUG(781, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy780;
		if(yych >= ':') goto yy780;
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy780;
yy783:
		YYDEBUG(783, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy690;
				if(yych <= 0x1F) goto yy680;
				goto yy690;
			} else {
				if(yych == '.') goto yy686;
				if(yych <= '/') goto yy680;
				goto yy781;
			}
		} else {
			if(yych <= 'P') {
				if(yych == 'A') goto yy692;
				if(yych <= 'O') goto yy680;
				goto yy692;
			} else {
				if(yych <= 'a') {
					if(yych <= '`') goto yy680;
					goto yy692;
				} else {
					if(yych == 'p') goto yy692;
					goto yy680;
				}
			}
		}
yy784:
		YYDEBUG(784, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy780;
		if(yych <= '9') goto yy779;
		goto yy780;
yy785:
		YYDEBUG(785, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ':') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy697;
				if(yych <= 0x1F) goto yy680;
				goto yy697;
			} else {
				if(yych <= '-') {
					if(yych <= ',') goto yy680;
					goto yy774;
				} else {
					if(yych <= '.') goto yy775;
					if(yych <= '9') goto yy680;
					goto yy682;
				}
			}
		} else {
			if(yych <= 'P') {
				if(yych == 'A') goto yy699;
				if(yych <= 'O') goto yy680;
				goto yy699;
			} else {
				if(yych <= 'a') {
					if(yych <= '`') goto yy680;
					goto yy699;
				} else {
					if(yych == 'p') goto yy699;
					goto yy680;
				}
			}
		}
yy786:
		YYDEBUG(786, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '.') {
			if(yych <= ',') goto yy53;
			if(yych <= '-') goto yy825;
			goto yy774;
		} else {
			if(yych <= '/') goto yy53;
			if(yych <= '9') goto yy788;
			goto yy53;
		}
yy787:
		YYDEBUG(787, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '.') {
			if(yych <= ',') goto yy53;
			if(yych <= '-') goto yy825;
			goto yy774;
		} else {
			if(yych <= '/') goto yy53;
			if(yych >= '3') goto yy53;
		}
yy788:
		YYDEBUG(788, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= ',') goto yy53;
		if(yych <= '-') goto yy825;
		if(yych <= '.') goto yy774;
		goto yy53;
yy789:
		YYDEBUG(789, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy821;
			if(yych <= 'T') goto yy53;
			goto yy820;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy821;
			} else {
				if(yych == 'u') goto yy820;
				goto yy53;
			}
		}
yy790:
		YYDEBUG(790, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy818;
		if(yych == 'e') goto yy818;
		goto yy53;
yy791:
		YYDEBUG(791, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy815;
		if(yych == 'a') goto yy815;
		goto yy53;
yy792:
		YYDEBUG(792, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy812;
			if(yych <= 'T') goto yy53;
			goto yy811;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy812;
			} else {
				if(yych == 'u') goto yy811;
				goto yy53;
			}
		}
yy793:
		YYDEBUG(793, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy808;
		if(yych == 'e') goto yy808;
		goto yy53;
yy794:
		YYDEBUG(794, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy806;
		if(yych == 'c') goto yy806;
		goto yy53;
yy795:
		YYDEBUG(795, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy804;
		if(yych == 'o') goto yy804;
		goto yy53;
yy796:
		YYDEBUG(796, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy797;
		if(yych != 'e') goto yy53;
yy797:
		YYDEBUG(797, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy798;
		if(yych != 'c') goto yy53;
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych >= '.') goto yy705;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy754;
				if(yych == 'e') goto yy754;
				goto yy665;
			}
		}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy706;
		if(yych <= '0') goto yy800;
		if(yych <= '2') goto yy801;
		if(yych <= '3') goto yy802;
		goto yy706;
yy800:
		YYDEBUG(800, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy708;
		if(yych <= '0') goto yy714;
		if(yych <= '9') goto yy803;
		goto yy708;
yy801:
		YYDEBUG(801, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy708;
		if(yych <= '9') goto yy803;
		goto yy708;
yy802:
		YYDEBUG(802, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy708;
		if(yych <= '1') goto yy803;
		if(yych <= '9') goto yy714;
		goto yy708;
yy803:
		YYDEBUG(803, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy708;
		if(yych <= '9') goto yy715;
		goto yy708;
yy804:
		YYDEBUG(804, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy805;
		if(yych != 'v') goto yy53;
yy805:
		YYDEBUG(805, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy709;
				if(yych == 'e') goto yy709;
				goto yy665;
			}
		}
yy806:
		YYDEBUG(806, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy807;
		if(yych != 't') goto yy53;
yy807:
		YYDEBUG(807, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'N') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'O') goto yy719;
				if(yych == 'o') goto yy719;
				goto yy665;
			}
		}
yy808:
		YYDEBUG(808, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy809;
		if(yych != 'p') goto yy53;
yy809:
		YYDEBUG(809, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'S') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'T') goto yy810;
				if(yych != 't') goto yy665;
			}
		}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy761;
				if(yych == 'e') goto yy761;
				goto yy665;
			}
		}
yy811:
		YYDEBUG(811, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy814;
		if(yych == 'g') goto yy814;
		goto yy53;
yy812:
		YYDEBUG(812, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy813;
		if(yych != 'r') goto yy53;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'H') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'I') goto yy725;
				if(yych == 'i') goto yy725;
				goto yy665;
			}
		}
yy814:
		YYDEBUG(814, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'T') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'U') goto yy727;
				if(yych == 'u') goto yy727;
				goto yy665;
			}
		}
yy815:
		YYDEBUG(815, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy816;
			if(yych <= 'X') goto yy53;
			goto yy817;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy817;
				goto yy53;
			}
		}
yy816:
		YYDEBUG(816, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'B') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'C') goto yy767;
				if(yych == 'c') goto yy767;
				goto yy665;
			}
		}
yy817:
		YYDEBUG(817, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= ',') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy665;
				goto yy705;
			} else {
				if(yych == ' ') goto yy705;
				goto yy665;
			}
		} else {
			if(yych <= '.') {
				if(yych <= '-') goto yy799;
				goto yy705;
			} else {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			}
		}
yy818:
		YYDEBUG(818, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy819;
		if(yych != 'b') goto yy53;
yy819:
		YYDEBUG(819, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'Q') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'R') goto yy770;
				if(yych == 'r') goto yy770;
				goto yy665;
			}
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy824;
			if(yych <= 'M') goto yy53;
			goto yy823;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy824;
			} else {
				if(yych == 'n') goto yy823;
				goto yy53;
			}
		}
yy821:
		YYDEBUG(821, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy822;
		if(yych != 'n') goto yy53;
yy822:
		YYDEBUG(822, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'T') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'U') goto yy732;
				if(yych == 'u') goto yy732;
				goto yy665;
			}
		}
yy823:
		YYDEBUG(823, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'D') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'E') goto yy713;
				if(yych == 'e') goto yy713;
				goto yy665;
			}
		}
yy824:
		YYDEBUG(824, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= 0x1F) {
				if(yych == 0x09) goto yy705;
				goto yy665;
			} else {
				if(yych <= ' ') goto yy705;
				if(yych <= ',') goto yy665;
				if(yych <= '-') goto yy799;
				goto yy705;
			}
		} else {
			if(yych <= 'X') {
				if(yych <= '/') goto yy665;
				if(yych <= '9') goto yy707;
				goto yy665;
			} else {
				if(yych <= 'Y') goto yy713;
				if(yych == 'y') goto yy713;
				goto yy665;
			}
		}
yy825:
		YYDEBUG(825, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy826;
		if(yych <= '3') goto yy828;
		if(yych <= '9') goto yy829;
		goto yy53;
yy826:
		YYDEBUG(826, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy827;
			if(yych <= '9') goto yy835;
			if(yych >= 'n') goto yy831;
		} else {
			if(yych <= 'r') {
				if(yych >= 'r') goto yy832;
			} else {
				if(yych <= 's') goto yy830;
				if(yych <= 't') goto yy833;
			}
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy828:
		YYDEBUG(828, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '1') {
				if(yych <= '/') goto yy827;
				goto yy835;
			} else {
				if(yych <= '9') goto yy779;
				if(yych <= 'm') goto yy827;
				goto yy831;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy827;
				goto yy832;
			} else {
				if(yych <= 's') goto yy830;
				if(yych <= 't') goto yy833;
				goto yy827;
			}
		}
yy829:
		YYDEBUG(829, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy827;
			if(yych <= '9') goto yy779;
			if(yych <= 'm') goto yy827;
			goto yy831;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy827;
				goto yy832;
			} else {
				if(yych <= 's') goto yy830;
				if(yych <= 't') goto yy833;
				goto yy827;
			}
		}
yy830:
		YYDEBUG(830, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 't') goto yy834;
		goto yy53;
yy831:
		YYDEBUG(831, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy834;
		goto yy53;
yy832:
		YYDEBUG(832, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy834;
		goto yy53;
yy833:
		YYDEBUG(833, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != 'h') goto yy53;
yy834:
		YYDEBUG(834, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy827;
yy835:
		YYDEBUG(835, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy827;
			if(yych <= '9') goto yy781;
			if(yych <= 'm') goto yy827;
			goto yy831;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy827;
				goto yy832;
			} else {
				if(yych <= 's') goto yy830;
				if(yych <= 't') goto yy833;
				goto yy827;
			}
		}
yy836:
		YYDEBUG(836, *YYCURSOR);
		yyaccept = 14;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') {
				if(yych >= '/') goto yy890;
			} else {
				if(yych <= '9') goto yy839;
				if(yych >= 'n') goto yy887;
			}
		} else {
			if(yych <= 'r') {
				if(yych >= 'r') goto yy888;
			} else {
				if(yych <= 's') goto yy886;
				if(yych <= 't') goto yy889;
			}
		}
yy837:
		YYDEBUG(837, *YYCURSOR);
		{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy838:
		YYDEBUG(838, *YYCURSOR);
		yyaccept = 14;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') {
				if(yych <= '.') goto yy837;
				goto yy890;
			} else {
				if(yych <= '1') goto yy839;
				if(yych <= 'm') goto yy837;
				goto yy887;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy837;
				goto yy888;
			} else {
				if(yych <= 's') goto yy886;
				if(yych <= 't') goto yy889;
				goto yy837;
			}
		}
yy839:
		YYDEBUG(839, *YYCURSOR);
		yyaccept = 14;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == '/') goto yy890;
			if(yych <= 'm') goto yy837;
			goto yy887;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy837;
				goto yy888;
			} else {
				if(yych <= 's') goto yy886;
				if(yych <= 't') goto yy889;
				goto yy837;
			}
		}
yy840:
		YYDEBUG(840, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy885;
			if(yych <= 'T') goto yy53;
			goto yy884;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy885;
			} else {
				if(yych == 'u') goto yy884;
				goto yy53;
			}
		}
yy841:
		YYDEBUG(841, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy883;
		if(yych == 'e') goto yy883;
		goto yy53;
yy842:
		YYDEBUG(842, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy882;
		if(yych == 'a') goto yy882;
		goto yy53;
yy843:
		YYDEBUG(843, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy881;
			if(yych <= 'T') goto yy53;
			goto yy880;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy881;
			} else {
				if(yych == 'u') goto yy880;
				goto yy53;
			}
		}
yy844:
		YYDEBUG(844, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy878;
		if(yych == 'e') goto yy878;
		goto yy53;
yy845:
		YYDEBUG(845, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy877;
		if(yych == 'c') goto yy877;
		goto yy53;
yy846:
		YYDEBUG(846, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy876;
		if(yych == 'o') goto yy876;
		goto yy53;
yy847:
		YYDEBUG(847, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy848;
		if(yych != 'e') goto yy53;
yy848:
		YYDEBUG(848, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy849;
		if(yych != 'c') goto yy53;
yy849:
		YYDEBUG(849, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '/') goto yy53;
yy850:
		YYDEBUG(850, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(851, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(852, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(853, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(854, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(855, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy856;
		if(yych <= '2') goto yy857;
		goto yy53;
yy856:
		YYDEBUG(856, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy858;
		goto yy53;
yy857:
		YYDEBUG(857, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '4') goto yy53;
yy858:
		YYDEBUG(858, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(859, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
		YYDEBUG(860, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(861, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(862, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy863;
		if(yych <= '6') goto yy864;
		goto yy53;
yy863:
		YYDEBUG(863, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy865;
		goto yy53;
yy864:
		YYDEBUG(864, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '0') goto yy53;
yy865:
		YYDEBUG(865, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 0x09) goto yy866;
		if(yych != ' ') goto yy53;
yy866:
		YYDEBUG(866, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(867, *YYCURSOR);
		if(yych <= ' ') {
			if(yych == 0x09) goto yy866;
			if(yych <= 0x1F) goto yy53;
			goto yy866;
		} else {
			if(yych <= '+') {
				if(yych <= '*') goto yy53;
			} else {
				if(yych != '-') goto yy53;
			}
		}
		YYDEBUG(868, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy869;
		if(yych <= '2') goto yy871;
		if(yych <= '9') goto yy872;
		goto yy53;
yy869:
		YYDEBUG(869, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '/') goto yy870;
		if(yych <= '9') goto yy872;
		if(yych <= ':') goto yy873;
yy870:
		YYDEBUG(870, *YYCURSOR);
		{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy871:
		YYDEBUG(871, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy870;
			if(yych >= '4') goto yy874;
		} else {
			if(yych <= '9') goto yy875;
			if(yych <= ':') goto yy873;
			goto yy870;
		}
yy872:
		YYDEBUG(872, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy870;
		if(yych <= '5') goto yy874;
		if(yych <= '9') goto yy875;
		if(yych >= ';') goto yy870;
yy873:
		YYDEBUG(873, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy870;
		if(yych <= '5') goto yy874;
		if(yych <= '9') goto yy875;
		goto yy870;
yy874:
		YYDEBUG(874, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy870;
		if(yych >= ':') goto yy870;
yy875:
		YYDEBUG(875, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy870;
yy876:
		YYDEBUG(876, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy849;
		if(yych == 'v') goto yy849;
		goto yy53;
yy877:
		YYDEBUG(877, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy849;
		if(yych == 't') goto yy849;
		goto yy53;
yy878:
		YYDEBUG(878, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy879;
		if(yych != 'p') goto yy53;
yy879:
		YYDEBUG(879, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych == '/') goto yy850;
			goto yy53;
		} else {
			if(yych <= 'T') goto yy849;
			if(yych == 't') goto yy849;
			goto yy53;
		}
yy880:
		YYDEBUG(880, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy849;
		if(yych == 'g') goto yy849;
		goto yy53;
yy881:
		YYDEBUG(881, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy849;
		if(yych == 'r') goto yy849;
		goto yy53;
yy882:
		YYDEBUG(882, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy849;
			if(yych <= 'X') goto yy53;
			goto yy849;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
				goto yy849;
			} else {
				if(yych == 'y') goto yy849;
				goto yy53;
			}
		}
yy883:
		YYDEBUG(883, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy849;
		if(yych == 'b') goto yy849;
		goto yy53;
yy884:
		YYDEBUG(884, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy849;
			if(yych <= 'M') goto yy53;
			goto yy849;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy849;
			} else {
				if(yych == 'n') goto yy849;
				goto yy53;
			}
		}
yy885:
		YYDEBUG(885, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy849;
		if(yych == 'n') goto yy849;
		goto yy53;
yy886:
		YYDEBUG(886, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 't') goto yy895;
		goto yy53;
yy887:
		YYDEBUG(887, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy895;
		goto yy53;
yy888:
		YYDEBUG(888, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy895;
		goto yy53;
yy889:
		YYDEBUG(889, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'h') goto yy895;
		goto yy53;
yy890:
		YYDEBUG(890, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(891, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy837;
		if(yych >= ':') goto yy837;
		YYDEBUG(892, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy837;
		if(yych >= ':') goto yy837;
		YYDEBUG(893, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy837;
		if(yych >= ':') goto yy837;
		YYDEBUG(894, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy837;
yy895:
		YYDEBUG(895, *YYCURSOR);
		yyaccept = 14;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '/') goto yy890;
		goto yy837;
yy896:
		YYDEBUG(896, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= ',') {
			if(yych == 0x09) goto yy898;
			goto yy751;
		} else {
			if(yych <= '.') goto yy898;
			if(yych >= '0') goto yy751;
		}
yy897:
		YYDEBUG(897, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch(yych) {
		case 'A':
		case 'a':	goto yy843;
		case 'D':
		case 'd':	goto yy847;
		case 'F':
		case 'f':	goto yy841;
		case 'J':
		case 'j':	goto yy840;
		case 'M':
		case 'm':	goto yy842;
		case 'N':
		case 'n':	goto yy846;
		case 'O':
		case 'o':	goto yy845;
		case 'S':
		case 's':	goto yy844;
		default:	goto yy53;
		}
yy898:
		YYDEBUG(898, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy751;
		if(yych <= '0') goto yy899;
		if(yych <= '1') goto yy900;
		if(yych <= '9') goto yy901;
		goto yy751;
yy899:
		YYDEBUG(899, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= ',') goto yy53;
		if(yych <= '.') goto yy774;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy901;
		goto yy53;
yy900:
		YYDEBUG(900, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= ',') goto yy53;
		if(yych <= '.') goto yy774;
		if(yych <= '/') goto yy53;
		if(yych >= '3') goto yy53;
yy901:
		YYDEBUG(901, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= ',') goto yy53;
		if(yych <= '.') goto yy774;
		goto yy53;
yy902:
		YYDEBUG(902, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '-') goto yy903;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy937;
		goto yy57;
yy903:
		YYDEBUG(903, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch(yych) {
		case '0':	goto yy912;
		case '1':	goto yy913;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy914;
		case 'A':
		case 'a':	goto yy907;
		case 'D':
		case 'd':	goto yy911;
		case 'F':
		case 'f':	goto yy905;
		case 'J':
		case 'j':	goto yy904;
		case 'M':
		case 'm':	goto yy906;
		case 'N':
		case 'n':	goto yy910;
		case 'O':
		case 'o':	goto yy909;
		case 'S':
		case 's':	goto yy908;
		default:	goto yy53;
		}
yy904:
		YYDEBUG(904, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy936;
			if(yych <= 'T') goto yy53;
			goto yy935;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy936;
			} else {
				if(yych == 'u') goto yy935;
				goto yy53;
			}
		}
yy905:
		YYDEBUG(905, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy934;
		if(yych == 'e') goto yy934;
		goto yy53;
yy906:
		YYDEBUG(906, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy933;
		if(yych == 'a') goto yy933;
		goto yy53;
yy907:
		YYDEBUG(907, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy932;
			if(yych <= 'T') goto yy53;
			goto yy931;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy932;
			} else {
				if(yych == 'u') goto yy931;
				goto yy53;
			}
		}
yy908:
		YYDEBUG(908, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy929;
		if(yych == 'e') goto yy929;
		goto yy53;
yy909:
		YYDEBUG(909, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy928;
		if(yych == 'c') goto yy928;
		goto yy53;
yy910:
		YYDEBUG(910, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy927;
		if(yych == 'o') goto yy927;
		goto yy53;
yy911:
		YYDEBUG(911, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy919;
		if(yych == 'e') goto yy919;
		goto yy53;
yy912:
		YYDEBUG(912, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '-') goto yy915;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy914;
		goto yy53;
yy913:
		YYDEBUG(913, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '-') goto yy915;
		if(yych <= '/') goto yy53;
		if(yych >= '3') goto yy53;
yy914:
		YYDEBUG(914, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '-') goto yy53;
yy915:
		YYDEBUG(915, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy916;
		if(yych <= '3') goto yy917;
		if(yych <= '9') goto yy918;
		goto yy53;
yy916:
		YYDEBUG(916, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy827;
			if(yych <= '9') goto yy918;
			if(yych <= 'm') goto yy827;
			goto yy831;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy827;
				goto yy832;
			} else {
				if(yych <= 's') goto yy830;
				if(yych <= 't') goto yy833;
				goto yy827;
			}
		}
yy917:
		YYDEBUG(917, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy827;
			if(yych <= '1') goto yy918;
			if(yych <= 'm') goto yy827;
			goto yy831;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy827;
				goto yy832;
			} else {
				if(yych <= 's') goto yy830;
				if(yych <= 't') goto yy833;
				goto yy827;
			}
		}
yy918:
		YYDEBUG(918, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'q') {
			if(yych == 'n') goto yy831;
			goto yy827;
		} else {
			if(yych <= 'r') goto yy832;
			if(yych <= 's') goto yy830;
			if(yych <= 't') goto yy833;
			goto yy827;
		}
yy919:
		YYDEBUG(919, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy920;
		if(yych != 'c') goto yy53;
yy920:
		YYDEBUG(920, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '-') goto yy53;
yy921:
		YYDEBUG(921, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy922;
		if(yych <= '2') goto yy923;
		if(yych <= '3') goto yy924;
		goto yy53;
yy922:
		YYDEBUG(922, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy925;
		goto yy53;
yy923:
		YYDEBUG(923, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy925;
		goto yy53;
yy924:
		YYDEBUG(924, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '2') goto yy53;
yy925:
		YYDEBUG(925, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(926, *YYCURSOR);
		{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy927:
		YYDEBUG(927, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy920;
		if(yych == 'v') goto yy920;
		goto yy53;
yy928:
		YYDEBUG(928, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy920;
		if(yych == 't') goto yy920;
		goto yy53;
yy929:
		YYDEBUG(929, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy930;
		if(yych != 'p') goto yy53;
yy930:
		YYDEBUG(930, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych == '-') goto yy921;
			goto yy53;
		} else {
			if(yych <= 'T') goto yy920;
			if(yych == 't') goto yy920;
			goto yy53;
		}
yy931:
		YYDEBUG(931, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy920;
		if(yych == 'g') goto yy920;
		goto yy53;
yy932:
		YYDEBUG(932, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy920;
		if(yych == 'r') goto yy920;
		goto yy53;
yy933:
		YYDEBUG(933, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy920;
			if(yych <= 'X') goto yy53;
			goto yy920;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
				goto yy920;
			} else {
				if(yych == 'y') goto yy920;
				goto yy53;
			}
		}
yy934:
		YYDEBUG(934, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy920;
		if(yych == 'b') goto yy920;
		goto yy53;
yy935:
		YYDEBUG(935, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy920;
			if(yych <= 'M') goto yy53;
			goto yy920;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy920;
			} else {
				if(yych == 'n') goto yy920;
				goto yy53;
			}
		}
yy936:
		YYDEBUG(936, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy920;
		if(yych == 'n') goto yy920;
		goto yy53;
yy937:
		YYDEBUG(937, *YYCURSOR);
		yyaccept = 15;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y':	goto yy942;
		case '-':	goto yy939;
		case '.':	goto yy943;
		case '/':	goto yy940;
		case '0':	goto yy956;
		case '1':	goto yy957;
		case '2':	goto yy959;
		case '3':	goto yy960;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy51;
		case ':':	goto yy958;
		case 'W':	goto yy961;
		default:	goto yy938;
		}
yy938:
		YYDEBUG(938, *YYCURSOR);
		{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy939:
		YYDEBUG(939, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch(yych) {
		case '0':	goto yy1125;
		case '1':	goto yy1127;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy1128;
		case 'A':
		case 'a':	goto yy1119;
		case 'D':
		case 'd':	goto yy1123;
		case 'F':
		case 'f':	goto yy1117;
		case 'J':
		case 'j':	goto yy1116;
		case 'M':
		case 'm':	goto yy1118;
		case 'N':
		case 'n':	goto yy1122;
		case 'O':
		case 'o':	goto yy1121;
		case 'S':
		case 's':	goto yy1120;
		case 'W':	goto yy1124;
		default:	goto yy1089;
		}
yy940:
		YYDEBUG(940, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy1097;
		if(yych <= '1') goto yy1098;
		if(yych <= '9') goto yy1099;
		goto yy53;
yy941:
		YYDEBUG(941, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
		yych = *YYCURSOR;
yy942:
		YYDEBUG(942, *YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:
		case ' ':	goto yy941;
		case '-':
		case '.':	goto yy1088;
		case 'A':
		case 'a':	goto yy951;
		case 'D':
		case 'd':	goto yy955;
		case 'F':
		case 'f':	goto yy949;
		case 'H':
		case 'h':	goto yy60;
		case 'I':	goto yy944;
		case 'J':
		case 'j':	goto yy948;
		case 'M':
		case 'm':	goto yy950;
		case 'N':
		case 'n':	goto yy954;
		case 'O':
		case 'o':	goto yy953;
		case 'S':
		case 's':	goto yy952;
		case 'T':
		case 't':	goto yy65;
		case 'V':	goto yy946;
		case 'W':
		case 'w':	goto yy62;
		case 'X':	goto yy947;
		case 'Y':
		case 'y':	goto yy64;
		default:	goto yy53;
		}
yy943:
		YYDEBUG(943, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy1089;
		if(yych <= '0') goto yy1081;
		if(yych <= '2') goto yy1082;
		if(yych <= '3') goto yy1083;
		goto yy1089;
yy944:
		YYDEBUG(944, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= 'U') {
			if(yych == 'I') goto yy1080;
		} else {
			if(yych == 'W') goto yy945;
			if(yych <= 'X') goto yy1034;
		}
yy945:
		YYDEBUG(945, *YYCURSOR);
		{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy946:
		YYDEBUG(946, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy1078;
		goto yy945;
yy947:
		YYDEBUG(947, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy1077;
		goto yy945;
yy948:
		YYDEBUG(948, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy1070;
			if(yych <= 'T') goto yy53;
			goto yy1069;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy1070;
			} else {
				if(yych == 'u') goto yy1069;
				goto yy53;
			}
		}
yy949:
		YYDEBUG(949, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= 'N') {
				if(yych == 'E') goto yy1063;
				goto yy53;
			} else {
				if(yych <= 'O') goto yy83;
				if(yych <= 'Q') goto yy53;
				goto yy82;
			}
		} else {
			if(yych <= 'n') {
				if(yych == 'e') goto yy1063;
				goto yy53;
			} else {
				if(yych <= 'o') goto yy83;
				if(yych == 'r') goto yy82;
				goto yy53;
			}
		}
yy950:
		YYDEBUG(950, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= 'H') {
				if(yych == 'A') goto yy1060;
				goto yy53;
			} else {
				if(yych <= 'I') goto yy114;
				if(yych <= 'N') goto yy53;
				goto yy113;
			}
		} else {
			if(yych <= 'h') {
				if(yych == 'a') goto yy1060;
				goto yy53;
			} else {
				if(yych <= 'i') goto yy114;
				if(yych == 'o') goto yy113;
				goto yy53;
			}
		}
yy951:
		YYDEBUG(951, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy1054;
			if(yych <= 'T') goto yy53;
			goto yy1053;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy1054;
			} else {
				if(yych == 'u') goto yy1053;
				goto yy53;
			}
		}
yy952:
		YYDEBUG(952, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= 'D') {
				if(yych == 'A') goto yy123;
				goto yy53;
			} else {
				if(yych <= 'E') goto yy1046;
				if(yych <= 'T') goto yy53;
				goto yy122;
			}
		} else {
			if(yych <= 'd') {
				if(yych == 'a') goto yy123;
				goto yy53;
			} else {
				if(yych <= 'e') goto yy1046;
				if(yych == 'u') goto yy122;
				goto yy53;
			}
		}
yy953:
		YYDEBUG(953, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy1041;
		if(yych == 'c') goto yy1041;
		goto yy53;
yy954:
		YYDEBUG(954, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy1035;
		if(yych == 'o') goto yy1035;
		goto yy53;
yy955:
		YYDEBUG(955, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych == 'A') goto yy110;
			if(yych <= 'D') goto yy53;
			goto yy1028;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy110;
			} else {
				if(yych == 'e') goto yy1028;
				goto yy53;
			}
		}
yy956:
		YYDEBUG(956, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy1026;
		if(yych <= '9') goto yy1027;
		goto yy57;
yy957:
		YYDEBUG(957, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '2') goto yy995;
		if(yych <= '9') goto yy974;
		goto yy57;
yy958:
		YYDEBUG(958, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy975;
		if(yych <= '1') goto yy976;
		goto yy53;
yy959:
		YYDEBUG(959, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy974;
		goto yy57;
yy960:
		YYDEBUG(960, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '5') goto yy970;
		if(yych <= '6') goto yy971;
		if(yych <= '9') goto yy51;
		goto yy57;
yy961:
		YYDEBUG(961, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy53;
			if(yych <= '0') goto yy962;
			if(yych <= '4') goto yy963;
			goto yy964;
		} else {
			if(yych <= 'E') {
				if(yych <= 'D') goto yy53;
				goto yy98;
			} else {
				if(yych == 'e') goto yy98;
				goto yy53;
			}
		}
yy962:
		YYDEBUG(962, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy965;
		goto yy53;
yy963:
		YYDEBUG(963, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy965;
		goto yy53;
yy964:
		YYDEBUG(964, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '4') goto yy53;
yy965:
		YYDEBUG(965, *YYCURSOR);
		yyaccept = 16;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '-') goto yy967;
		if(yych <= '/') goto yy966;
		if(yych <= '7') goto yy968;
yy966:
		YYDEBUG(966, *YYCURSOR);
		{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy967:
		YYDEBUG(967, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '8') goto yy53;
yy968:
		YYDEBUG(968, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(969, *YYCURSOR);
		{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy970:
		YYDEBUG(970, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy972;
		goto yy57;
yy971:
		YYDEBUG(971, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '6') goto yy972;
		if(yych <= '9') goto yy51;
		goto yy57;
yy972:
		YYDEBUG(972, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 4) {
			goto yy51;
		}
		if(yych <= 'W') {
			if(yych <= 'F') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych >= ' ') goto yy57;
				} else {
					if(yych == 'D') goto yy57;
					if(yych >= 'F') goto yy57;
				}
			} else {
				if(yych <= 'M') {
					if(yych == 'H') goto yy57;
					if(yych >= 'M') goto yy57;
				} else {
					if(yych <= 'R') goto yy973;
					if(yych <= 'T') goto yy57;
					if(yych >= 'W') goto yy57;
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'd') {
					if(yych == 'Y') goto yy57;
					if(yych >= 'd') goto yy57;
				} else {
					if(yych == 'f') goto yy57;
					if(yych >= 'h') goto yy57;
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych >= 's') goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych >= 'w') goto yy57;
					} else {
						if(yych == 'y') goto yy57;
					}
				}
			}
		}
yy973:
		YYDEBUG(973, *YYCURSOR);
		{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy974:
		YYDEBUG(974, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy972;
		goto yy57;
yy975:
		YYDEBUG(975, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy977;
		goto yy53;
yy976:
		YYDEBUG(976, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '3') goto yy53;
yy977:
		YYDEBUG(977, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(978, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy979;
		if(yych <= '2') goto yy980;
		if(yych <= '3') goto yy981;
		goto yy53;
yy979:
		YYDEBUG(979, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy982;
		goto yy53;
yy980:
		YYDEBUG(980, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy982;
		goto yy53;
yy981:
		YYDEBUG(981, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '2') goto yy53;
yy982:
		YYDEBUG(982, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ' ') goto yy53;
		YYDEBUG(983, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy984;
		if(yych <= '2') goto yy985;
		goto yy53;
yy984:
		YYDEBUG(984, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy986;
		goto yy53;
yy985:
		YYDEBUG(985, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '4') goto yy53;
yy986:
		YYDEBUG(986, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(987, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
		YYDEBUG(988, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(989, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(990, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy991;
		if(yych <= '6') goto yy992;
		goto yy53;
yy991:
		YYDEBUG(991, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy993;
		goto yy53;
yy992:
		YYDEBUG(992, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '0') goto yy53;
yy993:
		YYDEBUG(993, *YYCURSOR);
		++YYCURSOR;
yy994:
		YYDEBUG(994, *YYCURSOR);
		{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy995:
		YYDEBUG(995, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy57;
			if(yych >= '1') goto yy997;
		} else {
			if(yych <= '3') goto yy998;
			if(yych <= '9') goto yy972;
			goto yy57;
		}
yy996:
		YYDEBUG(996, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy973;
					goto yy57;
				} else {
					if(yych <= '0') {
						if(yych <= '/') goto yy973;
						goto yy51;
					} else {
						if(yych <= '9') goto yy999;
						if(yych <= 'C') goto yy973;
						goto yy57;
					}
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy973;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy973;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy973;
						if(yych <= 'T') goto yy57;
						goto yy973;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy973;
					if(yych <= 'Y') goto yy57;
					goto yy973;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy973;
					} else {
						if(yych == 'g') goto yy973;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy973;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy973;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy973;
					}
				}
			}
		}
yy997:
		YYDEBUG(997, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy973;
					goto yy57;
				} else {
					if(yych <= '/') goto yy973;
					if(yych <= '9') goto yy999;
					if(yych <= 'C') goto yy973;
					goto yy57;
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy973;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy973;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy973;
						if(yych <= 'T') goto yy57;
						goto yy973;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy973;
					if(yych <= 'Y') goto yy57;
					goto yy973;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy973;
					} else {
						if(yych == 'g') goto yy973;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy973;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy973;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy973;
					}
				}
			}
		}
yy998:
		YYDEBUG(998, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy973;
					goto yy57;
				} else {
					if(yych <= '1') {
						if(yych <= '/') goto yy973;
					} else {
						if(yych <= '9') goto yy51;
						if(yych <= 'C') goto yy973;
						goto yy57;
					}
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy973;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy973;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy973;
						if(yych <= 'T') goto yy57;
						goto yy973;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy973;
					if(yych <= 'Y') goto yy57;
					goto yy973;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy973;
					} else {
						if(yych == 'g') goto yy973;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy973;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy973;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy973;
					}
				}
			}
		}
yy999:
		YYDEBUG(999, *YYCURSOR);
		yyaccept = 18;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 4) {
			goto yy51;
		}
		if(yych <= 'W') {
			if(yych <= 'F') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy56;
					if(yych >= ' ') goto yy56;
				} else {
					if(yych == 'D') goto yy61;
					if(yych >= 'F') goto yy63;
				}
			} else {
				if(yych <= 'M') {
					if(yych == 'H') goto yy60;
					if(yych >= 'M') goto yy59;
				} else {
					if(yych <= 'S') {
						if(yych >= 'S') goto yy58;
					} else {
						if(yych <= 'T') goto yy1001;
						if(yych >= 'W') goto yy62;
					}
				}
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'd') {
					if(yych == 'Y') goto yy64;
					if(yych >= 'd') goto yy61;
				} else {
					if(yych <= 'f') {
						if(yych >= 'f') goto yy63;
					} else {
						if(yych == 'h') goto yy60;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'm') goto yy59;
					if(yych <= 'r') goto yy1000;
					if(yych <= 's') goto yy58;
					goto yy1002;
				} else {
					if(yych <= 'w') {
						if(yych >= 'w') goto yy62;
					} else {
						if(yych == 'y') goto yy64;
					}
				}
			}
		}
yy1000:
		YYDEBUG(1000, *YYCURSOR);
		{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy1001:
		YYDEBUG(1001, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= '2') {
				if(yych <= '/') goto yy53;
				if(yych <= '1') goto yy1016;
				goto yy1017;
			} else {
				if(yych <= '9') goto yy1018;
				if(yych <= 'G') goto yy53;
				goto yy66;
			}
		} else {
			if(yych <= 'g') {
				if(yych == 'U') goto yy67;
				goto yy53;
			} else {
				if(yych <= 'h') goto yy66;
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
yy1002:
		YYDEBUG(1002, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= '2') {
				if(yych <= '/') goto yy53;
				if(yych >= '2') goto yy1004;
			} else {
				if(yych <= '9') goto yy1005;
				if(yych <= 'G') goto yy53;
				goto yy66;
			}
		} else {
			if(yych <= 'g') {
				if(yych == 'U') goto yy67;
				goto yy53;
			} else {
				if(yych <= 'h') goto yy66;
				if(yych == 'u') goto yy67;
				goto yy53;
			}
		}
		YYDEBUG(1003, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1010;
		if(yych <= '9') goto yy1005;
		goto yy53;
yy1004:
		YYDEBUG(1004, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '3') goto yy1010;
		if(yych <= '5') goto yy1006;
		goto yy53;
yy1005:
		YYDEBUG(1005, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
yy1006:
		YYDEBUG(1006, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy1007:
		YYDEBUG(1007, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1008;
		if(yych <= '6') goto yy1009;
		goto yy53;
yy1008:
		YYDEBUG(1008, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy993;
		goto yy53;
yy1009:
		YYDEBUG(1009, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '0') goto yy993;
		goto yy53;
yy1010:
		YYDEBUG(1010, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1011;
		if(yych <= '9') goto yy1007;
		goto yy53;
yy1011:
		YYDEBUG(1011, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1012;
		if(yych <= '6') goto yy1013;
		if(yych <= '9') goto yy1007;
		goto yy53;
yy1012:
		YYDEBUG(1012, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1014;
		if(yych <= '6') goto yy1015;
		if(yych <= '9') goto yy993;
		goto yy53;
yy1013:
		YYDEBUG(1013, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy1014;
		if(yych <= '5') goto yy1008;
		if(yych <= '6') goto yy1009;
		goto yy53;
yy1014:
		YYDEBUG(1014, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy994;
		if(yych <= '9') goto yy993;
		goto yy994;
yy1015:
		YYDEBUG(1015, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '0') goto yy993;
		goto yy994;
yy1016:
		YYDEBUG(1016, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1025;
		if(yych <= '9') goto yy1018;
		if(yych <= ':') goto yy1019;
		goto yy53;
yy1017:
		YYDEBUG(1017, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy53;
			if(yych <= '3') goto yy1025;
			goto yy1006;
		} else {
			if(yych == ':') goto yy1019;
			goto yy53;
		}
yy1018:
		YYDEBUG(1018, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1006;
		if(yych != ':') goto yy53;
yy1019:
		YYDEBUG(1019, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= '6') goto yy53;
		YYDEBUG(1020, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(1021, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(1022, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1023;
		if(yych <= '6') goto yy1024;
		goto yy53;
yy1023:
		YYDEBUG(1023, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy993;
		goto yy53;
yy1024:
		YYDEBUG(1024, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '0') goto yy993;
		goto yy53;
yy1025:
		YYDEBUG(1025, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1011;
		if(yych <= '9') goto yy1007;
		if(yych <= ':') goto yy1019;
		goto yy53;
yy1026:
		YYDEBUG(1026, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy51;
		if(yych <= '9') goto yy972;
		goto yy57;
yy1027:
		YYDEBUG(1027, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy57;
			if(yych <= '0') goto yy996;
			goto yy997;
		} else {
			if(yych <= '3') goto yy998;
			if(yych <= '9') goto yy972;
			goto yy57;
		}
yy1028:
		YYDEBUG(1028, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy1029;
		if(yych != 'c') goto yy53;
yy1029:
		YYDEBUG(1029, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'E') goto yy1030;
		if(yych != 'e') goto yy945;
yy1030:
		YYDEBUG(1030, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy1031;
		if(yych != 'm') goto yy53;
yy1031:
		YYDEBUG(1031, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1032;
		if(yych != 'b') goto yy53;
yy1032:
		YYDEBUG(1032, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1033;
		if(yych != 'e') goto yy53;
yy1033:
		YYDEBUG(1033, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1034;
		if(yych != 'r') goto yy53;
yy1034:
		YYDEBUG(1034, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy945;
yy1035:
		YYDEBUG(1035, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy1036;
		if(yych != 'v') goto yy53;
yy1036:
		YYDEBUG(1036, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'E') goto yy1037;
		if(yych != 'e') goto yy945;
yy1037:
		YYDEBUG(1037, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy1038;
		if(yych != 'm') goto yy53;
yy1038:
		YYDEBUG(1038, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1039;
		if(yych != 'b') goto yy53;
yy1039:
		YYDEBUG(1039, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1040;
		if(yych != 'e') goto yy53;
yy1040:
		YYDEBUG(1040, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1034;
		if(yych == 'r') goto yy1034;
		goto yy53;
yy1041:
		YYDEBUG(1041, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1042;
		if(yych != 't') goto yy53;
yy1042:
		YYDEBUG(1042, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'O') goto yy1043;
		if(yych != 'o') goto yy945;
yy1043:
		YYDEBUG(1043, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1044;
		if(yych != 'b') goto yy53;
yy1044:
		YYDEBUG(1044, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1045;
		if(yych != 'e') goto yy53;
yy1045:
		YYDEBUG(1045, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1034;
		if(yych == 'r') goto yy1034;
		goto yy53;
yy1046:
		YYDEBUG(1046, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'P') {
			if(yych == 'C') goto yy125;
			if(yych <= 'O') goto yy53;
		} else {
			if(yych <= 'c') {
				if(yych <= 'b') goto yy53;
				goto yy125;
			} else {
				if(yych != 'p') goto yy53;
			}
		}
yy1047:
		YYDEBUG(1047, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1048;
		if(yych != 't') goto yy945;
yy1048:
		YYDEBUG(1048, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'E') goto yy1049;
		if(yych != 'e') goto yy945;
yy1049:
		YYDEBUG(1049, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'M') goto yy1050;
		if(yych != 'm') goto yy53;
yy1050:
		YYDEBUG(1050, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1051;
		if(yych != 'b') goto yy53;
yy1051:
		YYDEBUG(1051, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1052;
		if(yych != 'e') goto yy53;
yy1052:
		YYDEBUG(1052, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1034;
		if(yych == 'r') goto yy1034;
		goto yy53;
yy1053:
		YYDEBUG(1053, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy1057;
		if(yych == 'g') goto yy1057;
		goto yy53;
yy1054:
		YYDEBUG(1054, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1055;
		if(yych != 'r') goto yy53;
yy1055:
		YYDEBUG(1055, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'I') goto yy1056;
		if(yych != 'i') goto yy945;
yy1056:
		YYDEBUG(1056, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'L') goto yy1034;
		if(yych == 'l') goto yy1034;
		goto yy53;
yy1057:
		YYDEBUG(1057, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy1058;
		if(yych != 'u') goto yy945;
yy1058:
		YYDEBUG(1058, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'S') goto yy1059;
		if(yych != 's') goto yy53;
yy1059:
		YYDEBUG(1059, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1034;
		if(yych == 't') goto yy1034;
		goto yy53;
yy1060:
		YYDEBUG(1060, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy1061;
			if(yych <= 'X') goto yy53;
			goto yy1034;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy1034;
				goto yy53;
			}
		}
yy1061:
		YYDEBUG(1061, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'C') goto yy1062;
		if(yych != 'c') goto yy945;
yy1062:
		YYDEBUG(1062, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'H') goto yy1034;
		if(yych == 'h') goto yy1034;
		goto yy53;
yy1063:
		YYDEBUG(1063, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1064;
		if(yych != 'b') goto yy53;
yy1064:
		YYDEBUG(1064, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'R') goto yy1065;
		if(yych != 'r') goto yy945;
yy1065:
		YYDEBUG(1065, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'U') goto yy1066;
		if(yych != 'u') goto yy53;
yy1066:
		YYDEBUG(1066, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1067;
		if(yych != 'a') goto yy53;
yy1067:
		YYDEBUG(1067, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1068;
		if(yych != 'r') goto yy53;
yy1068:
		YYDEBUG(1068, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy1034;
		if(yych == 'y') goto yy1034;
		goto yy53;
yy1069:
		YYDEBUG(1069, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy1076;
			if(yych <= 'M') goto yy53;
			goto yy1075;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy1076;
			} else {
				if(yych == 'n') goto yy1075;
				goto yy53;
			}
		}
yy1070:
		YYDEBUG(1070, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy1071;
		if(yych != 'n') goto yy53;
yy1071:
		YYDEBUG(1071, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'U') goto yy1072;
		if(yych != 'u') goto yy945;
yy1072:
		YYDEBUG(1072, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1073;
		if(yych != 'a') goto yy53;
yy1073:
		YYDEBUG(1073, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1074;
		if(yych != 'r') goto yy53;
yy1074:
		YYDEBUG(1074, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy1034;
		if(yych == 'y') goto yy1034;
		goto yy53;
yy1075:
		YYDEBUG(1075, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1034;
		if(yych == 'e') goto yy1034;
		goto yy945;
yy1076:
		YYDEBUG(1076, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy1034;
		if(yych == 'y') goto yy1034;
		goto yy945;
yy1077:
		YYDEBUG(1077, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy1034;
		goto yy945;
yy1078:
		YYDEBUG(1078, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != 'I') goto yy945;
		YYDEBUG(1079, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy1034;
		goto yy945;
yy1080:
		YYDEBUG(1080, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'I') goto yy1034;
		goto yy945;
yy1081:
		YYDEBUG(1081, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy1096;
		if(yych <= '9') goto yy1095;
		goto yy53;
yy1082:
		YYDEBUG(1082, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1094;
		goto yy53;
yy1083:
		YYDEBUG(1083, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1092;
		if(yych <= '6') goto yy1091;
		goto yy53;
yy1084:
		YYDEBUG(1084, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1063;
		if(yych == 'e') goto yy1063;
		goto yy53;
yy1085:
		YYDEBUG(1085, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1060;
		if(yych == 'a') goto yy1060;
		goto yy53;
yy1086:
		YYDEBUG(1086, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1090;
		if(yych == 'e') goto yy1090;
		goto yy53;
yy1087:
		YYDEBUG(1087, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1028;
		if(yych == 'e') goto yy1028;
		goto yy53;
yy1088:
		YYDEBUG(1088, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
		yych = *YYCURSOR;
yy1089:
		YYDEBUG(1089, *YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:
		case ' ':
		case '-':
		case '.':	goto yy1088;
		case 'A':
		case 'a':	goto yy951;
		case 'D':
		case 'd':	goto yy1087;
		case 'F':
		case 'f':	goto yy1084;
		case 'I':	goto yy944;
		case 'J':
		case 'j':	goto yy948;
		case 'M':
		case 'm':	goto yy1085;
		case 'N':
		case 'n':	goto yy954;
		case 'O':
		case 'o':	goto yy953;
		case 'S':
		case 's':	goto yy1086;
		case 'V':	goto yy946;
		case 'X':	goto yy947;
		default:	goto yy53;
		}
yy1090:
		YYDEBUG(1090, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy1047;
		if(yych == 'p') goto yy1047;
		goto yy53;
yy1091:
		YYDEBUG(1091, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '6') goto yy1093;
		goto yy53;
yy1092:
		YYDEBUG(1092, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy1093:
		YYDEBUG(1093, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy973;
yy1094:
		YYDEBUG(1094, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1093;
		goto yy53;
yy1095:
		YYDEBUG(1095, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1093;
		goto yy53;
yy1096:
		YYDEBUG(1096, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '0') goto yy53;
		if(yych <= '9') goto yy1093;
		goto yy53;
yy1097:
		YYDEBUG(1097, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '.') goto yy53;
		if(yych <= '/') goto yy1100;
		if(yych <= '0') goto yy1099;
		if(yych <= '9') goto yy1110;
		goto yy53;
yy1098:
		YYDEBUG(1098, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '.') goto yy53;
		if(yych <= '/') goto yy1100;
		if(yych <= '2') goto yy1110;
		goto yy53;
yy1099:
		YYDEBUG(1099, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '/') goto yy53;
yy1100:
		YYDEBUG(1100, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy1101;
		if(yych <= '3') goto yy1103;
		if(yych <= '9') goto yy1104;
		goto yy53;
yy1101:
		YYDEBUG(1101, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1102;
			if(yych <= '9') goto yy1104;
			if(yych >= 'n') goto yy1106;
		} else {
			if(yych <= 'r') {
				if(yych >= 'r') goto yy1107;
			} else {
				if(yych <= 's') goto yy1105;
				if(yych <= 't') goto yy1108;
			}
		}
yy1102:
		YYDEBUG(1102, *YYCURSOR);
		{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1103:
		YYDEBUG(1103, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1102;
			if(yych <= '1') goto yy1104;
			if(yych <= 'm') goto yy1102;
			goto yy1106;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1102;
				goto yy1107;
			} else {
				if(yych <= 's') goto yy1105;
				if(yych <= 't') goto yy1108;
				goto yy1102;
			}
		}
yy1104:
		YYDEBUG(1104, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'q') {
			if(yych == 'n') goto yy1106;
			goto yy1102;
		} else {
			if(yych <= 'r') goto yy1107;
			if(yych <= 's') goto yy1105;
			if(yych <= 't') goto yy1108;
			goto yy1102;
		}
yy1105:
		YYDEBUG(1105, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 't') goto yy1109;
		goto yy53;
yy1106:
		YYDEBUG(1106, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1109;
		goto yy53;
yy1107:
		YYDEBUG(1107, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1109;
		goto yy53;
yy1108:
		YYDEBUG(1108, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != 'h') goto yy53;
yy1109:
		YYDEBUG(1109, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy1102;
yy1110:
		YYDEBUG(1110, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '/') goto yy53;
		YYDEBUG(1111, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy53;
			if(yych >= '1') goto yy1113;
		} else {
			if(yych <= '3') goto yy1114;
			if(yych <= '9') goto yy1104;
			goto yy53;
		}
		YYDEBUG(1112, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '0') {
				if(yych <= '/') goto yy1102;
				goto yy1104;
			} else {
				if(yych <= '9') goto yy1115;
				if(yych <= 'm') goto yy1102;
				goto yy1106;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1102;
				goto yy1107;
			} else {
				if(yych <= 's') goto yy1105;
				if(yych <= 't') goto yy1108;
				goto yy1102;
			}
		}
yy1113:
		YYDEBUG(1113, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1102;
			if(yych <= '9') goto yy1115;
			if(yych <= 'm') goto yy1102;
			goto yy1106;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1102;
				goto yy1107;
			} else {
				if(yych <= 's') goto yy1105;
				if(yych <= 't') goto yy1108;
				goto yy1102;
			}
		}
yy1114:
		YYDEBUG(1114, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych <= '/') goto yy1102;
			if(yych <= '1') goto yy1115;
			if(yych <= 'm') goto yy1102;
			goto yy1106;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1102;
				goto yy1107;
			} else {
				if(yych <= 's') goto yy1105;
				if(yych <= 't') goto yy1108;
				goto yy1102;
			}
		}
yy1115:
		YYDEBUG(1115, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == '/') goto yy1109;
			if(yych <= 'm') goto yy1102;
			goto yy1106;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1102;
				goto yy1107;
			} else {
				if(yych <= 's') goto yy1105;
				if(yych <= 't') goto yy1108;
				goto yy1102;
			}
		}
yy1116:
		YYDEBUG(1116, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'A') goto yy1193;
			if(yych <= 'T') goto yy53;
			goto yy1192;
		} else {
			if(yych <= 'a') {
				if(yych <= '`') goto yy53;
				goto yy1193;
			} else {
				if(yych == 'u') goto yy1192;
				goto yy53;
			}
		}
yy1117:
		YYDEBUG(1117, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1190;
		if(yych == 'e') goto yy1190;
		goto yy53;
yy1118:
		YYDEBUG(1118, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1187;
		if(yych == 'a') goto yy1187;
		goto yy53;
yy1119:
		YYDEBUG(1119, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych == 'P') goto yy1184;
			if(yych <= 'T') goto yy53;
			goto yy1183;
		} else {
			if(yych <= 'p') {
				if(yych <= 'o') goto yy53;
				goto yy1184;
			} else {
				if(yych == 'u') goto yy1183;
				goto yy53;
			}
		}
yy1120:
		YYDEBUG(1120, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1180;
		if(yych == 'e') goto yy1180;
		goto yy53;
yy1121:
		YYDEBUG(1121, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy1178;
		if(yych == 'c') goto yy1178;
		goto yy53;
yy1122:
		YYDEBUG(1122, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'O') goto yy1176;
		if(yych == 'o') goto yy1176;
		goto yy53;
yy1123:
		YYDEBUG(1123, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'E') goto yy1174;
		if(yych == 'e') goto yy1174;
		goto yy53;
yy1124:
		YYDEBUG(1124, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '0') goto yy962;
		if(yych <= '4') goto yy963;
		if(yych <= '5') goto yy964;
		goto yy53;
yy1125:
		YYDEBUG(1125, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '-') goto yy1129;
		} else {
			if(yych <= '0') goto yy1128;
			if(yych <= '9') goto yy1148;
		}
yy1126:
		YYDEBUG(1126, *YYCURSOR);
		{
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1127:
		YYDEBUG(1127, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '-') goto yy1129;
		if(yych <= '/') goto yy1126;
		if(yych <= '2') goto yy1148;
		goto yy1126;
yy1128:
		YYDEBUG(1128, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != '-') goto yy1126;
yy1129:
		YYDEBUG(1129, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '2') goto yy1130;
		if(yych <= '3') goto yy1131;
		if(yych <= '9') goto yy1132;
		goto yy53;
yy1130:
		YYDEBUG(1130, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '9') {
				if(yych <= '/') goto yy827;
				goto yy1132;
			} else {
				if(yych == 'T') goto yy1137;
				goto yy827;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1134;
				if(yych <= 'q') goto yy827;
				goto yy1135;
			} else {
				if(yych <= 's') goto yy1133;
				if(yych <= 't') goto yy1136;
				goto yy827;
			}
		}
yy1131:
		YYDEBUG(1131, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy827;
			} else {
				if(yych == 'T') goto yy1137;
				goto yy827;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1134;
				if(yych <= 'q') goto yy827;
				goto yy1135;
			} else {
				if(yych <= 's') goto yy1133;
				if(yych <= 't') goto yy1136;
				goto yy827;
			}
		}
yy1132:
		YYDEBUG(1132, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == 'T') goto yy1137;
			if(yych <= 'm') goto yy827;
			goto yy1134;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy827;
				goto yy1135;
			} else {
				if(yych <= 's') goto yy1133;
				if(yych <= 't') goto yy1136;
				goto yy827;
			}
		}
yy1133:
		YYDEBUG(1133, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 't') goto yy1147;
		goto yy53;
yy1134:
		YYDEBUG(1134, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1147;
		goto yy53;
yy1135:
		YYDEBUG(1135, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'd') goto yy1147;
		goto yy53;
yy1136:
		YYDEBUG(1136, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'h') goto yy1147;
		goto yy53;
yy1137:
		YYDEBUG(1137, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy1138;
		if(yych <= '2') goto yy1139;
		if(yych <= '9') goto yy1140;
		goto yy53;
yy1138:
		YYDEBUG(1138, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1140;
		if(yych <= ':') goto yy1141;
		goto yy53;
yy1139:
		YYDEBUG(1139, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '3') goto yy1140;
		if(yych == ':') goto yy1141;
		goto yy53;
yy1140:
		YYDEBUG(1140, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
yy1141:
		YYDEBUG(1141, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1142;
		if(yych <= '9') goto yy1143;
		goto yy53;
yy1142:
		YYDEBUG(1142, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1143;
		if(yych <= ':') goto yy1144;
		goto yy53;
yy1143:
		YYDEBUG(1143, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
yy1144:
		YYDEBUG(1144, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1145;
		if(yych <= '6') goto yy1146;
		if(yych <= '9') goto yy993;
		goto yy53;
yy1145:
		YYDEBUG(1145, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy994;
		if(yych <= '9') goto yy993;
		goto yy994;
yy1146:
		YYDEBUG(1146, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '0') goto yy993;
		goto yy994;
yy1147:
		YYDEBUG(1147, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == 'T') goto yy1137;
		goto yy827;
yy1148:
		YYDEBUG(1148, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != '-') goto yy1126;
		YYDEBUG(1149, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '2') {
			if(yych <= '/') goto yy53;
			if(yych >= '1') goto yy1151;
		} else {
			if(yych <= '3') goto yy1152;
			if(yych <= '9') goto yy1132;
			goto yy53;
		}
		YYDEBUG(1150, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '9') {
				if(yych <= '/') goto yy827;
				if(yych <= '0') goto yy1132;
				goto yy1153;
			} else {
				if(yych == 'T') goto yy1137;
				goto yy827;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1134;
				if(yych <= 'q') goto yy827;
				goto yy1135;
			} else {
				if(yych <= 's') goto yy1133;
				if(yych <= 't') goto yy1136;
				goto yy827;
			}
		}
yy1151:
		YYDEBUG(1151, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '9') {
				if(yych <= '/') goto yy827;
				goto yy1153;
			} else {
				if(yych == 'T') goto yy1137;
				goto yy827;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1134;
				if(yych <= 'q') goto yy827;
				goto yy1135;
			} else {
				if(yych <= 's') goto yy1133;
				if(yych <= 't') goto yy1136;
				goto yy827;
			}
		}
yy1152:
		YYDEBUG(1152, *YYCURSOR);
		yyaccept = 13;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'm') {
			if(yych <= '1') {
				if(yych <= '/') goto yy827;
			} else {
				if(yych == 'T') goto yy1137;
				goto yy827;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'n') goto yy1134;
				if(yych <= 'q') goto yy827;
				goto yy1135;
			} else {
				if(yych <= 's') goto yy1133;
				if(yych <= 't') goto yy1136;
				goto yy827;
			}
		}
yy1153:
		YYDEBUG(1153, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'n') {
			if(yych == 'T') goto yy1154;
			if(yych <= 'm') goto yy1102;
			goto yy1134;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy1102;
				goto yy1135;
			} else {
				if(yych <= 's') goto yy1133;
				if(yych <= 't') goto yy1136;
				goto yy1102;
			}
		}
yy1154:
		YYDEBUG(1154, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy1155;
		if(yych <= '2') goto yy1156;
		if(yych <= '9') goto yy1140;
		goto yy53;
yy1155:
		YYDEBUG(1155, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1157;
		if(yych <= ':') goto yy1141;
		goto yy53;
yy1156:
		YYDEBUG(1156, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '3') goto yy1157;
		if(yych == ':') goto yy1141;
		goto yy53;
yy1157:
		YYDEBUG(1157, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(1158, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1159;
		if(yych <= '9') goto yy1143;
		goto yy53;
yy1159:
		YYDEBUG(1159, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1160;
		if(yych <= ':') goto yy1144;
		goto yy53;
yy1160:
		YYDEBUG(1160, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != ':') goto yy53;
		YYDEBUG(1161, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1162;
		if(yych <= '6') goto yy1163;
		if(yych <= '9') goto yy993;
		goto yy53;
yy1162:
		YYDEBUG(1162, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy994;
		if(yych <= '9') goto yy1164;
		goto yy994;
yy1163:
		YYDEBUG(1163, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '0') goto yy994;
yy1164:
		YYDEBUG(1164, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych != '.') goto yy994;
		YYDEBUG(1165, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy1166:
		YYDEBUG(1166, *YYCURSOR);
		yyaccept = 22;
		YYMARKER = ++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(1167, *YYCURSOR);
		if(yych <= ',') {
			if(yych != '+') goto yy994;
		} else {
			if(yych <= '-') goto yy1168;
			if(yych <= '/') goto yy994;
			if(yych <= '9') goto yy1166;
			goto yy994;
		}
yy1168:
		YYDEBUG(1168, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '1') goto yy1169;
		if(yych <= '2') goto yy1170;
		if(yych <= '9') goto yy1171;
		goto yy53;
yy1169:
		YYDEBUG(1169, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy994;
		if(yych <= '9') goto yy1171;
		if(yych <= ':') goto yy1172;
		goto yy994;
yy1170:
		YYDEBUG(1170, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '5') {
			if(yych <= '/') goto yy994;
			if(yych >= '4') goto yy1173;
		} else {
			if(yych <= '9') goto yy993;
			if(yych <= ':') goto yy1172;
			goto yy994;
		}
yy1171:
		YYDEBUG(1171, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy994;
		if(yych <= '5') goto yy1173;
		if(yych <= '9') goto yy993;
		if(yych >= ';') goto yy994;
yy1172:
		YYDEBUG(1172, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy994;
		if(yych <= '5') goto yy1173;
		if(yych <= '9') goto yy993;
		goto yy994;
yy1173:
		YYDEBUG(1173, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy994;
		if(yych <= '9') goto yy993;
		goto yy994;
yy1174:
		YYDEBUG(1174, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'C') goto yy1175;
		if(yych != 'c') goto yy53;
yy1175:
		YYDEBUG(1175, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'E') goto yy1030;
			if(yych == 'e') goto yy1030;
			goto yy945;
		}
yy1176:
		YYDEBUG(1176, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'V') goto yy1177;
		if(yych != 'v') goto yy53;
yy1177:
		YYDEBUG(1177, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'E') goto yy1037;
			if(yych == 'e') goto yy1037;
			goto yy945;
		}
yy1178:
		YYDEBUG(1178, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1179;
		if(yych != 't') goto yy53;
yy1179:
		YYDEBUG(1179, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'O') goto yy1043;
			if(yych == 'o') goto yy1043;
			goto yy945;
		}
yy1180:
		YYDEBUG(1180, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'P') goto yy1181;
		if(yych != 'p') goto yy53;
yy1181:
		YYDEBUG(1181, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'T') goto yy1182;
			if(yych != 't') goto yy945;
		}
yy1182:
		YYDEBUG(1182, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'E') goto yy1049;
			if(yych == 'e') goto yy1049;
			goto yy945;
		}
yy1183:
		YYDEBUG(1183, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'G') goto yy1186;
		if(yych == 'g') goto yy1186;
		goto yy53;
yy1184:
		YYDEBUG(1184, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy1185;
		if(yych != 'r') goto yy53;
yy1185:
		YYDEBUG(1185, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'I') goto yy1056;
			if(yych == 'i') goto yy1056;
			goto yy945;
		}
yy1186:
		YYDEBUG(1186, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'U') goto yy1058;
			if(yych == 'u') goto yy1058;
			goto yy945;
		}
yy1187:
		YYDEBUG(1187, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych == 'R') goto yy1188;
			if(yych <= 'X') goto yy53;
			goto yy1189;
		} else {
			if(yych <= 'r') {
				if(yych <= 'q') goto yy53;
			} else {
				if(yych == 'y') goto yy1189;
				goto yy53;
			}
		}
yy1188:
		YYDEBUG(1188, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'C') goto yy1062;
			if(yych == 'c') goto yy1062;
			goto yy945;
		}
yy1189:
		YYDEBUG(1189, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '-') goto yy921;
		goto yy945;
yy1190:
		YYDEBUG(1190, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'B') goto yy1191;
		if(yych != 'b') goto yy53;
yy1191:
		YYDEBUG(1191, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Q') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'R') goto yy1065;
			if(yych == 'r') goto yy1065;
			goto yy945;
		}
yy1192:
		YYDEBUG(1192, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych == 'L') goto yy1196;
			if(yych <= 'M') goto yy53;
			goto yy1195;
		} else {
			if(yych <= 'l') {
				if(yych <= 'k') goto yy53;
				goto yy1196;
			} else {
				if(yych == 'n') goto yy1195;
				goto yy53;
			}
		}
yy1193:
		YYDEBUG(1193, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'N') goto yy1194;
		if(yych != 'n') goto yy53;
yy1194:
		YYDEBUG(1194, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'U') goto yy1072;
			if(yych == 'u') goto yy1072;
			goto yy945;
		}
yy1195:
		YYDEBUG(1195, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'E') goto yy1034;
			if(yych == 'e') goto yy1034;
			goto yy945;
		}
yy1196:
		YYDEBUG(1196, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'X') {
			if(yych == '-') goto yy921;
			goto yy945;
		} else {
			if(yych <= 'Y') goto yy1034;
			if(yych == 'y') goto yy1034;
			goto yy945;
		}
yy1197:
		YYDEBUG(1197, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') {
			if(yych <= 0x09) {
				if(yych <= 0x08) goto yy751;
				goto yy898;
			} else {
				if(yych <= ',') goto yy751;
				if(yych <= '.') goto yy898;
				goto yy897;
			}
		} else {
			if(yych <= 'U') {
				if(yych <= 'T') goto yy751;
				goto yy74;
			} else {
				if(yych == 'u') goto yy74;
				goto yy751;
			}
		}
yy1198:
		YYDEBUG(1198, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'P') {
			if(yych == 'C') goto yy125;
			if(yych <= 'O') goto yy53;
			goto yy759;
		} else {
			if(yych <= 'c') {
				if(yych <= 'b') goto yy53;
				goto yy125;
			} else {
				if(yych == 'p') goto yy759;
				goto yy53;
			}
		}
yy1199:
		YYDEBUG(1199, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '9') {
			if(yych <= ',') {
				if(yych != 0x09) goto yy1202;
			} else {
				if(yych <= '-') goto yy662;
				if(yych <= '.') goto yy898;
				if(yych <= '/') goto yy897;
				goto yy902;
			}
		} else {
			if(yych <= 'q') {
				if(yych == 'n') goto yy659;
				goto yy1202;
			} else {
				if(yych <= 'r') goto yy660;
				if(yych <= 's') goto yy653;
				if(yych <= 't') goto yy657;
				goto yy1202;
			}
		}
yy1200:
		YYDEBUG(1200, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy1202;
		if(yych <= '0') goto yy899;
		if(yych <= '1') goto yy900;
		if(yych <= '9') goto yy901;
		goto yy1202;
yy1201:
		YYDEBUG(1201, *YYCURSOR);
		++YYCURSOR;
		if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
		yych = *YYCURSOR;
yy1202:
		YYDEBUG(1202, *YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:
		case ' ':	goto yy1201;
		case '-':
		case '.':	goto yy750;
		case 'A':
		case 'a':	goto yy747;
		case 'D':
		case 'd':	goto yy655;
		case 'F':
		case 'f':	goto yy656;
		case 'H':
		case 'h':	goto yy60;
		case 'I':	goto yy664;
		case 'J':
		case 'j':	goto yy668;
		case 'M':
		case 'm':	goto yy654;
		case 'N':
		case 'n':	goto yy671;
		case 'O':
		case 'o':	goto yy670;
		case 'S':
		case 's':	goto yy652;
		case 'T':
		case 't':	goto yy65;
		case 'V':	goto yy666;
		case 'W':
		case 'w':	goto yy62;
		case 'X':	goto yy667;
		case 'Y':
		case 'y':	goto yy64;
		default:	goto yy53;
		}
yy1203:
		YYDEBUG(1203, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '9') {
			if(yych <= '-') {
				if(yych == 0x09) goto yy1200;
				if(yych <= ',') goto yy1202;
				goto yy662;
			} else {
				if(yych <= '.') goto yy1204;
				if(yych <= '/') goto yy897;
				if(yych <= '5') goto yy1206;
				goto yy902;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy1205;
				if(yych == 'n') goto yy659;
				goto yy1202;
			} else {
				if(yych <= 'r') goto yy660;
				if(yych <= 's') goto yy653;
				if(yych <= 't') goto yy657;
				goto yy1202;
			}
		}
yy1204:
		YYDEBUG(1204, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '1') {
			if(yych <= '/') goto yy751;
			if(yych <= '0') goto yy1228;
			goto yy1229;
		} else {
			if(yych <= '5') goto yy1230;
			if(yych <= '9') goto yy1231;
			goto yy751;
		}
yy1205:
		YYDEBUG(1205, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1223;
		if(yych <= '9') goto yy1224;
		goto yy53;
yy1206:
		YYDEBUG(1206, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '-') goto yy903;
		if(yych <= '/') goto yy57;
		if(yych >= ':') goto yy57;
		YYDEBUG(1207, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		YYDEBUG(-1, yych);
		switch(yych) {
		case 0x09:
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y':	goto yy942;
		case '-':	goto yy939;
		case '.':	goto yy943;
		case '/':	goto yy940;
		case '0':	goto yy1209;
		case '1':	goto yy1210;
		case '2':	goto yy1211;
		case '3':	goto yy1212;
		case '4':
		case '5':	goto yy1213;
		case '6':	goto yy1214;
		case '7':
		case '8':
		case '9':	goto yy51;
		case ':':	goto yy958;
		case 'W':	goto yy961;
		default:	goto yy1208;
		}
yy1208:
		YYDEBUG(1208, *YYCURSOR);
		{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1209:
		YYDEBUG(1209, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy1221;
		if(yych <= '9') goto yy1222;
		goto yy57;
yy1210:
		YYDEBUG(1210, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '2') goto yy1220;
		if(yych <= '9') goto yy1219;
		goto yy57;
yy1211:
		YYDEBUG(1211, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy1219;
		goto yy57;
yy1212:
		YYDEBUG(1212, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '5') goto yy1217;
		if(yych <= '6') goto yy1218;
		if(yych <= '9') goto yy1215;
		goto yy57;
yy1213:
		YYDEBUG(1213, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '9') goto yy1215;
		goto yy57;
yy1214:
		YYDEBUG(1214, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy57;
		if(yych <= '0') goto yy1215;
		if(yych <= '9') goto yy51;
		goto yy57;
yy1215:
		YYDEBUG(1215, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yybm[0+yych] & 4) {
			goto yy51;
		}
		if(yych <= 'W') {
			if(yych <= 'F') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych >= ' ') goto yy57;
				} else {
					if(yych == 'D') goto yy57;
					if(yych >= 'F') goto yy57;
				}
			} else {
				if(yych <= 'M') {
					if(yych == 'H') goto yy57;
					if(yych >= 'M') goto yy57;
				} else {
					if(yych <= 'R') goto yy1216;
					if(yych <= 'T') goto yy57;
					if(yych >= 'W') goto yy57;
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'd') {
					if(yych == 'Y') goto yy57;
					if(yych >= 'd') goto yy57;
				} else {
					if(yych == 'f') goto yy57;
					if(yych >= 'h') goto yy57;
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych >= 's') goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych >= 'w') goto yy57;
					} else {
						if(yych == 'y') goto yy57;
					}
				}
			}
		}
yy1216:
		YYDEBUG(1216, *YYCURSOR);
		{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1217:
		YYDEBUG(1217, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy1216;
					goto yy57;
				} else {
					if(yych <= '/') goto yy1216;
					if(yych <= '9') goto yy972;
					if(yych <= 'C') goto yy1216;
					goto yy57;
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy1216;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy1216;
						if(yych <= 'T') goto yy57;
						goto yy1216;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy1216;
					if(yych <= 'Y') goto yy57;
					goto yy1216;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy1216;
					} else {
						if(yych == 'g') goto yy1216;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy1216;
					}
				}
			}
		}
yy1218:
		YYDEBUG(1218, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy1216;
					goto yy57;
				} else {
					if(yych <= '6') {
						if(yych <= '/') goto yy1216;
						goto yy972;
					} else {
						if(yych <= '9') goto yy51;
						if(yych <= 'C') goto yy1216;
						goto yy57;
					}
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy1216;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy1216;
						if(yych <= 'T') goto yy57;
						goto yy1216;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy1216;
					if(yych <= 'Y') goto yy57;
					goto yy1216;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy1216;
					} else {
						if(yych == 'g') goto yy1216;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy1216;
					}
				}
			}
		}
yy1219:
		YYDEBUG(1219, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy1216;
					goto yy57;
				} else {
					if(yych <= '/') goto yy1216;
					if(yych <= '9') goto yy972;
					if(yych <= 'C') goto yy1216;
					goto yy57;
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy1216;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy1216;
						if(yych <= 'T') goto yy57;
						goto yy1216;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy1216;
					if(yych <= 'Y') goto yy57;
					goto yy1216;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy1216;
					} else {
						if(yych == 'g') goto yy1216;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy1216;
					}
				}
			}
		}
yy1220:
		YYDEBUG(1220, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '9') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy1216;
					goto yy57;
				} else {
					if(yych <= '0') {
						if(yych <= '/') goto yy1216;
						goto yy996;
					} else {
						if(yych <= '2') goto yy997;
						if(yych <= '3') goto yy998;
						goto yy972;
					}
				}
			} else {
				if(yych <= 'G') {
					if(yych <= 'D') {
						if(yych <= 'C') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'F') goto yy57;
						goto yy1216;
					}
				} else {
					if(yych <= 'L') {
						if(yych <= 'H') goto yy57;
						goto yy1216;
					} else {
						if(yych <= 'M') goto yy57;
						if(yych <= 'R') goto yy1216;
						goto yy57;
					}
				}
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Y') {
					if(yych == 'W') goto yy57;
					if(yych <= 'X') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'd') {
						if(yych <= 'c') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'f') goto yy57;
						goto yy1216;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'l') {
						if(yych <= 'h') goto yy57;
						goto yy1216;
					} else {
						if(yych <= 'm') goto yy57;
						if(yych <= 'r') goto yy1216;
						goto yy57;
					}
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy1216;
					}
				}
			}
		}
yy1221:
		YYDEBUG(1221, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'V') {
			if(yych <= 'D') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy1216;
					goto yy57;
				} else {
					if(yych <= '0') {
						if(yych <= '/') goto yy1216;
						goto yy51;
					} else {
						if(yych <= '9') goto yy972;
						if(yych <= 'C') goto yy1216;
						goto yy57;
					}
				}
			} else {
				if(yych <= 'H') {
					if(yych == 'F') goto yy57;
					if(yych <= 'G') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'M') {
						if(yych <= 'L') goto yy1216;
						goto yy57;
					} else {
						if(yych <= 'R') goto yy1216;
						if(yych <= 'T') goto yy57;
						goto yy1216;
					}
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'c') {
					if(yych == 'X') goto yy1216;
					if(yych <= 'Y') goto yy57;
					goto yy1216;
				} else {
					if(yych <= 'e') {
						if(yych <= 'd') goto yy57;
						goto yy1216;
					} else {
						if(yych == 'g') goto yy1216;
						goto yy57;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych == 'm') goto yy57;
					if(yych <= 'r') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy1216;
					}
				}
			}
		}
yy1222:
		YYDEBUG(1222, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '9') {
				if(yych <= ' ') {
					if(yych == 0x09) goto yy57;
					if(yych <= 0x1F) goto yy1216;
					goto yy57;
				} else {
					if(yych <= '0') {
						if(yych <= '/') goto yy1216;
						goto yy996;
					} else {
						if(yych <= '2') goto yy997;
						if(yych <= '3') goto yy998;
						goto yy972;
					}
				}
			} else {
				if(yych <= 'G') {
					if(yych <= 'D') {
						if(yych <= 'C') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'F') goto yy57;
						goto yy1216;
					}
				} else {
					if(yych <= 'L') {
						if(yych <= 'H') goto yy57;
						goto yy1216;
					} else {
						if(yych <= 'M') goto yy57;
						if(yych <= 'R') goto yy1216;
						goto yy57;
					}
				}
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Y') {
					if(yych == 'W') goto yy57;
					if(yych <= 'X') goto yy1216;
					goto yy57;
				} else {
					if(yych <= 'd') {
						if(yych <= 'c') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'f') goto yy57;
						goto yy1216;
					}
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'l') {
						if(yych <= 'h') goto yy57;
						goto yy1216;
					} else {
						if(yych <= 'm') goto yy57;
						if(yych <= 'r') goto yy1216;
						goto yy57;
					}
				} else {
					if(yych <= 'w') {
						if(yych <= 'v') goto yy1216;
						goto yy57;
					} else {
						if(yych == 'y') goto yy57;
						goto yy1216;
					}
				}
			}
		}
yy1223:
		YYDEBUG(1223, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy1225;
			goto yy680;
		} else {
			if(yych <= '9') goto yy1224;
			if(yych <= ':') goto yy1225;
			goto yy680;
		}
yy1224:
		YYDEBUG(1224, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy1225;
		if(yych != ':') goto yy680;
yy1225:
		YYDEBUG(1225, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1226;
		if(yych <= '6') goto yy1227;
		if(yych <= '9') goto yy685;
		goto yy53;
yy1226:
		YYDEBUG(1226, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych <= '/') goto yy680;
		if(yych <= '9') goto yy685;
		goto yy680;
yy1227:
		YYDEBUG(1227, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych == '0') goto yy685;
		goto yy680;
yy1228:
		YYDEBUG(1228, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
			goto yy1232;
		} else {
			if(yych <= '/') goto yy680;
			if(yych <= '9') goto yy1231;
			if(yych <= ':') goto yy1225;
			goto yy680;
		}
yy1229:
		YYDEBUG(1229, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
			if(yych <= '.') goto yy1232;
			goto yy680;
		} else {
			if(yych <= '2') goto yy1231;
			if(yych <= '9') goto yy1224;
			if(yych <= ':') goto yy1225;
			goto yy680;
		}
yy1230:
		YYDEBUG(1230, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
			goto yy1232;
		} else {
			if(yych <= '/') goto yy680;
			if(yych <= '9') goto yy1224;
			if(yych <= ':') goto yy1225;
			goto yy680;
		}
yy1231:
		YYDEBUG(1231, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ',') goto yy680;
			if(yych <= '-') goto yy774;
		} else {
			if(yych == ':') goto yy1225;
			goto yy680;
		}
yy1232:
		YYDEBUG(1232, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '5') goto yy1233;
		if(yych <= '6') goto yy1234;
		if(yych <= '9') goto yy778;
		goto yy53;
yy1233:
		YYDEBUG(1233, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych <= '/') goto yy680;
		if(yych <= '9') goto yy1235;
		goto yy680;
yy1234:
		YYDEBUG(1234, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych == '.') goto yy686;
			goto yy680;
		} else {
			if(yych <= '0') goto yy1235;
			if(yych <= '9') goto yy779;
			goto yy680;
		}
yy1235:
		YYDEBUG(1235, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych == '.') goto yy686;
		if(yych <= '/') goto yy680;
		if(yych <= '9') goto yy781;
		goto yy680;
yy1236:
		YYDEBUG(1236, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '9') {
			if(yych <= '-') {
				if(yych == 0x09) goto yy649;
				if(yych <= ',') goto yy651;
				goto yy662;
			} else {
				if(yych <= '.') goto yy663;
				if(yych <= '/') goto yy661;
				if(yych <= '5') goto yy1206;
				goto yy902;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy672;
				if(yych == 'n') goto yy659;
				goto yy651;
			} else {
				if(yych <= 'r') goto yy660;
				if(yych <= 's') goto yy653;
				if(yych <= 't') goto yy657;
				goto yy651;
			}
		}
yy1237:
		YYDEBUG(1237, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '9') {
			if(yych <= '-') {
				if(yych == 0x09) goto yy1200;
				if(yych <= ',') goto yy1202;
				goto yy662;
			} else {
				if(yych <= '.') goto yy1204;
				if(yych <= '/') goto yy661;
				if(yych <= '5') goto yy1206;
				goto yy902;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= ':') goto yy1205;
				if(yych == 'n') goto yy659;
				goto yy1202;
			} else {
				if(yych <= 'r') goto yy660;
				if(yych <= 's') goto yy653;
				if(yych <= 't') goto yy657;
				goto yy1202;
			}
		}
yy1238:
		YYDEBUG(1238, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
yy1239:
		YYDEBUG(1239, *YYCURSOR);
		++YYCURSOR;
		if(YYLIMIT == YYCURSOR) YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(1240, *YYCURSOR);
		if(yych <= '/') goto yy1241;
		if(yych <= '9') goto yy1239;
yy1241:
		YYDEBUG(1241, *YYCURSOR);
		{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1242:
		YYDEBUG(1242, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
				goto yy1282;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'n') goto yy1282;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1243:
		YYDEBUG(1243, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'U') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych == 'I') goto yy1276;
				if(yych <= 'T') goto yy138;
				goto yy1275;
			}
		} else {
			if(yych <= 'i') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'h') goto yy138;
				goto yy1276;
			} else {
				if(yych == 'u') goto yy1275;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1244:
		YYDEBUG(1244, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'M') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych == 'D') goto yy1264;
				if(yych <= 'L') goto yy138;
				goto yy1265;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'c') goto yy138;
				goto yy1264;
			} else {
				if(yych == 'm') goto yy1265;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1245:
		YYDEBUG(1245, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
				goto yy1260;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'e') goto yy1260;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1246:
		YYDEBUG(1246, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
				goto yy1256;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'e') goto yy1256;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1247:
		YYDEBUG(1247, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') {
			if(yych == '.') goto yy1205;
			goto yy53;
		} else {
			if(yych <= '9') goto yy1250;
			if(yych <= ':') goto yy1205;
			goto yy53;
		}
yy1248:
		YYDEBUG(1248, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') {
			if(yych == '.') goto yy1205;
			goto yy53;
		} else {
			if(yych <= '3') goto yy1250;
			if(yych == ':') goto yy1205;
			goto yy53;
		}
yy1249:
		YYDEBUG(1249, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == '.') goto yy1205;
		if(yych == ':') goto yy1205;
		goto yy53;
yy1250:
		YYDEBUG(1250, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') {
			if(yych == '.') goto yy1205;
			goto yy53;
		} else {
			if(yych <= '5') goto yy1251;
			if(yych == ':') goto yy1205;
			goto yy53;
		}
yy1251:
		YYDEBUG(1251, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych >= ':') goto yy53;
		YYDEBUG(1252, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') goto yy1208;
		if(yych <= '5') goto yy1253;
		if(yych <= '6') goto yy1254;
		goto yy1208;
yy1253:
		YYDEBUG(1253, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= '/') goto yy53;
		if(yych <= '9') goto yy1255;
		goto yy53;
yy1254:
		YYDEBUG(1254, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych != '0') goto yy53;
yy1255:
		YYDEBUG(1255, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy1216;
yy1256:
		YYDEBUG(1256, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'L') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'K') goto yy139;
			}
		} else {
			if(yych <= 'k') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'l') goto yy1257;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1257:
		YYDEBUG(1257, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'F') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'E') goto yy140;
			}
		} else {
			if(yych <= 'e') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'f') goto yy1258;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1258:
		YYDEBUG(1258, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy141;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 't') goto yy1259;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1259:
		YYDEBUG(1259, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy169;
			if(yych == 'h') goto yy169;
			goto yy3;
		}
yy1260:
		YYDEBUG(1260, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy285;
				goto yy136;
			} else {
				if(yych <= '@') goto yy285;
				if(yych <= 'R') goto yy139;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy285;
				goto yy139;
			} else {
				if(yych <= 's') goto yy1261;
				if(yych <= 'z') goto yy139;
				goto yy285;
			}
		}
yy1261:
		YYDEBUG(1261, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy140;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'd') goto yy1262;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1262:
		YYDEBUG(1262, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy1263;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1263:
		YYDEBUG(1263, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'Y') goto yy291;
			if(yych == 'y') goto yy291;
			goto yy3;
		}
yy1264:
		YYDEBUG(1264, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
			goto yy1272;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy1272;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1265:
		YYDEBUG(1265, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'O') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy139;
			}
		} else {
			if(yych <= 'n') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'o') goto yy1266;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1266:
		YYDEBUG(1266, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy140;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'r') goto yy1267;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1267:
		YYDEBUG(1267, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy141;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'r') goto yy1268;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1268:
		YYDEBUG(1268, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'O') goto yy1269;
			if(yych != 'o') goto yy3;
		}
yy1269:
		YYDEBUG(1269, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'W') goto yy1270;
		if(yych != 'w') goto yy53;
yy1270:
		YYDEBUG(1270, *YYCURSOR);
		++YYCURSOR;
yy1271:
		YYDEBUG(1271, *YYCURSOR);
		{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1272:
		YYDEBUG(1272, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy140;
			}
		} else {
			if(yych <= 'x') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'y') goto yy1273;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1273:
		YYDEBUG(1273, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '@') {
			if(yych == ')') goto yy136;
		} else {
			if(yych <= 'Z') goto yy141;
			if(yych <= '`') goto yy1274;
			if(yych <= 'z') goto yy141;
		}
yy1274:
		YYDEBUG(1274, *YYCURSOR);
		{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1275:
		YYDEBUG(1275, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy285;
				goto yy136;
			} else {
				if(yych <= '@') goto yy285;
				if(yych <= 'Q') goto yy139;
				goto yy1278;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy285;
				goto yy139;
			} else {
				if(yych <= 'r') goto yy1278;
				if(yych <= 'z') goto yy139;
				goto yy285;
			}
		}
yy1276:
		YYDEBUG(1276, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= 'Q') goto yy139;
				if(yych >= 'S') goto yy259;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'r') goto yy1277;
				if(yych <= 's') goto yy259;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1277:
		YYDEBUG(1277, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'd') goto yy272;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1278:
		YYDEBUG(1278, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy140;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 's') goto yy1279;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1279:
		YYDEBUG(1279, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy141;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'd') goto yy1280;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1280:
		YYDEBUG(1280, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'A') goto yy1281;
			if(yych != 'a') goto yy3;
		}
yy1281:
		YYDEBUG(1281, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy291;
		if(yych == 'y') goto yy291;
		goto yy53;
yy1282:
		YYDEBUG(1282, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 't') goto yy1283;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1283:
		YYDEBUG(1283, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'h') goto yy272;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1284:
		YYDEBUG(1284, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
				goto yy1282;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1313;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1285:
		YYDEBUG(1285, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'U') {
			if(yych <= '/') {
				if(yych == ')') goto yy136;
				if(yych <= '.') goto yy3;
				goto yy144;
			} else {
				if(yych <= 'H') {
					if(yych <= '@') goto yy3;
					goto yy138;
				} else {
					if(yych <= 'I') goto yy1276;
					if(yych <= 'T') goto yy138;
					goto yy1275;
				}
			}
		} else {
			if(yych <= 'h') {
				if(yych <= '^') {
					if(yych <= 'Z') goto yy138;
					goto yy3;
				} else {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy3;
					goto yy143;
				}
			} else {
				if(yych <= 't') {
					if(yych <= 'i') goto yy1307;
					goto yy143;
				} else {
					if(yych <= 'u') goto yy1306;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
yy1286:
		YYDEBUG(1286, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych <= '/') {
				if(yych == ')') goto yy136;
				if(yych <= '.') goto yy3;
				goto yy144;
			} else {
				if(yych <= 'C') {
					if(yych <= '@') goto yy3;
					goto yy138;
				} else {
					if(yych <= 'D') goto yy1264;
					if(yych <= 'L') goto yy138;
					goto yy1265;
				}
			}
		} else {
			if(yych <= 'c') {
				if(yych <= '^') {
					if(yych <= 'Z') goto yy138;
					goto yy3;
				} else {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy3;
					goto yy143;
				}
			} else {
				if(yych <= 'l') {
					if(yych <= 'd') goto yy1297;
					goto yy143;
				} else {
					if(yych <= 'm') goto yy1298;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
yy1287:
		YYDEBUG(1287, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
				goto yy1260;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy1293;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1288:
		YYDEBUG(1288, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy138;
				goto yy1256;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy1289;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1289:
		YYDEBUG(1289, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'L') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'K') goto yy139;
				goto yy1257;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'l') goto yy1290;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1290:
		YYDEBUG(1290, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'F') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'E') goto yy140;
				goto yy1258;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'f') goto yy1291;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1291:
		YYDEBUG(1291, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy141;
				goto yy1259;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy1292;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1292:
		YYDEBUG(1292, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'G') goto yy3;
				goto yy169;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy256;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy1293:
		YYDEBUG(1293, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy285;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy285;
				if(yych <= 'R') goto yy139;
				goto yy1261;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy285;
			} else {
				if(yych == 's') goto yy1294;
				if(yych <= 'z') goto yy148;
				goto yy285;
			}
		}
yy1294:
		YYDEBUG(1294, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy140;
				goto yy1262;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy1295;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1295:
		YYDEBUG(1295, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy1263;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy1296;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1296:
		YYDEBUG(1296, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'X') goto yy3;
				goto yy291;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'y') goto yy304;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy1297:
		YYDEBUG(1297, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy1272;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy1304;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1298:
		YYDEBUG(1298, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'N') goto yy139;
				goto yy1266;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'o') goto yy1299;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1299:
		YYDEBUG(1299, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy140;
				goto yy1267;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy1300;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1300:
		YYDEBUG(1300, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy141;
				goto yy1268;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy1301;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1301:
		YYDEBUG(1301, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'O') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'N') goto yy3;
				goto yy1269;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'o') goto yy1302;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy1302:
		YYDEBUG(1302, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'W') goto yy1270;
		if(yych != 'w') goto yy152;
		YYDEBUG(1303, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy144;
			goto yy1271;
		} else {
			if(yych <= '_') goto yy144;
			if(yych <= '`') goto yy1271;
			if(yych <= 'z') goto yy151;
			goto yy1271;
		}
yy1304:
		YYDEBUG(1304, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy140;
				goto yy1273;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'y') goto yy1305;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1305:
		YYDEBUG(1305, *YYCURSOR);
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy1274;
				goto yy136;
			} else {
				if(yych == '/') goto yy144;
				goto yy1274;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '^') goto yy1274;
				goto yy144;
			} else {
				if(yych <= '`') goto yy1274;
				if(yych <= 'z') goto yy150;
				goto yy1274;
			}
		}
yy1306:
		YYDEBUG(1306, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy285;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy285;
				if(yych <= 'Q') goto yy139;
				goto yy1278;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy285;
			} else {
				if(yych == 'r') goto yy1309;
				if(yych <= 'z') goto yy148;
				goto yy285;
			}
		}
yy1307:
		YYDEBUG(1307, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '/') {
				if(yych == ')') goto yy136;
				if(yych <= '.') goto yy3;
				goto yy144;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy139;
				if(yych <= 'R') goto yy1277;
				goto yy259;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych <= 'r') {
					if(yych <= 'q') goto yy148;
				} else {
					if(yych <= 's') goto yy262;
					if(yych <= 'z') goto yy148;
					goto yy3;
				}
			}
		}
		YYDEBUG(1308, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy282;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1309:
		YYDEBUG(1309, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy140;
				goto yy1279;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 's') goto yy1310;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1310:
		YYDEBUG(1310, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy141;
				goto yy1280;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy1311;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1311:
		YYDEBUG(1311, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy1281;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy1312;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy1312:
		YYDEBUG(1312, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy291;
		if(yych == 'y') goto yy304;
		goto yy152;
yy1313:
		YYDEBUG(1313, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy1283;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy1314;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1314:
		YYDEBUG(1314, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy282;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1315:
		YYDEBUG(1315, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych <= '@') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych == 'R') goto yy1327;
				if(yych <= 'X') goto yy138;
				goto yy1328;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'q') goto yy138;
				goto yy1327;
			} else {
				if(yych == 'y') goto yy1328;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1316:
		YYDEBUG(1316, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy138;
				goto yy1321;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'd') goto yy1321;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1317:
		YYDEBUG(1317, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'n') goto yy1318;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1318:
		YYDEBUG(1318, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'D') {
			if(yych <= ')') {
				if(yych <= '(') goto yy285;
				goto yy136;
			} else {
				if(yych <= '@') goto yy285;
				if(yych <= 'C') goto yy139;
			}
		} else {
			if(yych <= 'c') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy285;
				goto yy139;
			} else {
				if(yych <= 'd') goto yy1319;
				if(yych <= 'z') goto yy139;
				goto yy285;
			}
		}
yy1319:
		YYDEBUG(1319, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'A') {
			if(yych == ')') goto yy136;
			if(yych <= '@') goto yy3;
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if(yych <= 'a') goto yy1320;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1320:
		YYDEBUG(1320, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'Y') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy141;
				goto yy512;
			}
		} else {
			if(yych <= 'x') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'y') goto yy512;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1321:
		YYDEBUG(1321, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy139;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'n') goto yy1322;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1322:
		YYDEBUG(1322, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'I') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy140;
			}
		} else {
			if(yych <= 'h') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'i') goto yy1323;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1323:
		YYDEBUG(1323, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'G') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy141;
			}
		} else {
			if(yych <= 'f') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'g') goto yy1324;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1324:
		YYDEBUG(1324, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'H') goto yy1325;
			if(yych != 'h') goto yy3;
		}
yy1325:
		YYDEBUG(1325, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1326;
		if(yych != 't') goto yy53;
yy1326:
		YYDEBUG(1326, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy1274;
yy1327:
		YYDEBUG(1327, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych == 'C') goto yy1329;
					goto yy139;
				}
			} else {
				if(yych <= 'b') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'c') goto yy1329;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy1328:
		YYDEBUG(1328, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '-') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy312;
				goto yy314;
			} else {
				if(yych == ')') goto yy136;
				if(yych <= ',') goto yy312;
				goto yy315;
			}
		} else {
			if(yych <= '@') {
				if(yych == '/') goto yy312;
				if(yych <= '9') goto yy314;
				goto yy312;
			} else {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy312;
				if(yych <= 'z') goto yy139;
				goto yy312;
			}
		}
yy1329:
		YYDEBUG(1329, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy570;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'h') goto yy570;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1330:
		YYDEBUG(1330, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '/') {
				if(yych == ')') goto yy136;
				if(yych <= '.') goto yy3;
				goto yy144;
			} else {
				if(yych <= 'Q') {
					if(yych <= '@') goto yy3;
					goto yy138;
				} else {
					if(yych <= 'R') goto yy1327;
					if(yych <= 'X') goto yy138;
					goto yy1328;
				}
			}
		} else {
			if(yych <= 'q') {
				if(yych <= '^') {
					if(yych <= 'Z') goto yy138;
					goto yy3;
				} else {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy3;
					goto yy143;
				}
			} else {
				if(yych <= 'x') {
					if(yych <= 'r') goto yy1342;
					goto yy143;
				} else {
					if(yych <= 'y') goto yy1343;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
yy1331:
		YYDEBUG(1331, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'C') goto yy138;
				goto yy1321;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy1336;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1332:
		YYDEBUG(1332, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
				goto yy1318;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1333;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1333:
		YYDEBUG(1333, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy285;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy285;
				if(yych <= 'C') goto yy139;
				goto yy1319;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy285;
			} else {
				if(yych == 'd') goto yy1334;
				if(yych <= 'z') goto yy148;
				goto yy285;
			}
		}
yy1334:
		YYDEBUG(1334, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'A') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				goto yy1320;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '^') goto yy3;
				goto yy144;
			} else {
				if(yych <= '`') goto yy3;
				if(yych <= 'a') goto yy1335;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1335:
		YYDEBUG(1335, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'Y') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'X') goto yy141;
				goto yy512;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'y') goto yy541;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1336:
		YYDEBUG(1336, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy139;
				goto yy1322;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1337;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1337:
		YYDEBUG(1337, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'I') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'H') goto yy140;
				goto yy1323;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'i') goto yy1338;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1338:
		YYDEBUG(1338, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'G') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'F') goto yy141;
				goto yy1324;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'g') goto yy1339;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1339:
		YYDEBUG(1339, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'G') goto yy3;
				goto yy1325;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy1340;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy1340:
		YYDEBUG(1340, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'T') goto yy1326;
		if(yych != 't') goto yy152;
		YYDEBUG(1341, *YYCURSOR);
		yyaccept = 26;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy144;
			goto yy1274;
		} else {
			if(yych <= '_') goto yy144;
			if(yych <= '`') goto yy1274;
			if(yych <= 'z') goto yy151;
			goto yy1274;
		}
yy1342:
		YYDEBUG(1342, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'B') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'C') goto yy1329;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'b') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'c') goto yy1344;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy1343:
		YYDEBUG(1343, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '.') {
			if(yych <= ' ') {
				if(yych == 0x09) goto yy314;
				if(yych <= 0x1F) goto yy312;
				goto yy314;
			} else {
				if(yych <= ')') {
					if(yych <= '(') goto yy312;
					goto yy136;
				} else {
					if(yych <= ',') goto yy312;
					if(yych <= '-') goto yy315;
					goto yy314;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '/') goto yy144;
				if(yych <= '9') goto yy314;
				if(yych <= '@') goto yy312;
				goto yy139;
			} else {
				if(yych <= '_') {
					if(yych <= '^') goto yy312;
					goto yy144;
				} else {
					if(yych <= '`') goto yy312;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy1344:
		YYDEBUG(1344, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy570;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy581;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1345:
		YYDEBUG(1345, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'W') {
			if(yych <= 'N') {
				if(yych == ')') goto yy136;
				if(yych <= '@') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'O') goto yy1353;
				if(yych <= 'U') goto yy138;
				if(yych <= 'V') goto yy1354;
				goto yy1351;
			}
		} else {
			if(yych <= 'o') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				if(yych <= 'n') goto yy138;
				goto yy1353;
			} else {
				if(yych <= 'v') {
					if(yych <= 'u') goto yy138;
					goto yy1354;
				} else {
					if(yych <= 'w') goto yy1351;
					if(yych <= 'z') goto yy138;
					goto yy3;
				}
			}
		}
yy1346:
		YYDEBUG(1346, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'X') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy138;
				goto yy1350;
			}
		} else {
			if(yych <= 'w') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'x') goto yy1350;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1347:
		YYDEBUG(1347, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 'n') goto yy1348;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1348:
		YYDEBUG(1348, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 't') goto yy1349;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1349:
		YYDEBUG(1349, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'H') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= 'g') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'h') goto yy272;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1350:
		YYDEBUG(1350, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy259;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 't') goto yy259;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1351:
		YYDEBUG(1351, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '@') {
			if(yych == ')') goto yy136;
		} else {
			if(yych <= 'Z') goto yy139;
			if(yych <= '`') goto yy1352;
			if(yych <= 'z') goto yy139;
		}
yy1352:
		YYDEBUG(1352, *YYCURSOR);
		{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1353:
		YYDEBUG(1353, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'N') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy139;
				goto yy1359;
			}
		} else {
			if(yych <= 'm') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 'n') goto yy1359;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1354:
		YYDEBUG(1354, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '/') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= ',') {
					if(yych <= ')') goto yy136;
					goto yy312;
				} else {
					if(yych <= '-') goto yy315;
					if(yych <= '.') goto yy314;
					goto yy312;
				}
			}
		} else {
			if(yych <= 'Z') {
				if(yych <= '@') {
					if(yych <= '9') goto yy314;
					goto yy312;
				} else {
					if(yych != 'E') goto yy139;
				}
			} else {
				if(yych <= 'd') {
					if(yych <= '`') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'e') goto yy1355;
					if(yych <= 'z') goto yy139;
					goto yy312;
				}
			}
		}
yy1355:
		YYDEBUG(1355, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'M') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'L') goto yy140;
			}
		} else {
			if(yych <= 'l') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'm') goto yy1356;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1356:
		YYDEBUG(1356, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'B') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy141;
			}
		} else {
			if(yych <= 'a') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'b') goto yy1357;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1357:
		YYDEBUG(1357, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'E') goto yy1358;
			if(yych != 'e') goto yy3;
		}
yy1358:
		YYDEBUG(1358, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy324;
		if(yych == 'r') goto yy324;
		goto yy53;
yy1359:
		YYDEBUG(1359, *YYCURSOR);
		++YYCURSOR;
		if((yych = *YYCURSOR) <= '@') {
			if(yych == ')') goto yy136;
		} else {
			if(yych <= 'Z') goto yy140;
			if(yych <= '`') goto yy1360;
			if(yych <= 'z') goto yy140;
		}
yy1360:
		YYDEBUG(1360, *YYCURSOR);
		{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1361:
		YYDEBUG(1361, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'W') {
			if(yych <= '@') {
				if(yych <= ')') {
					if(yych <= '(') goto yy3;
					goto yy136;
				} else {
					if(yych == '/') goto yy144;
					goto yy3;
				}
			} else {
				if(yych <= 'O') {
					if(yych <= 'N') goto yy138;
					goto yy1353;
				} else {
					if(yych <= 'U') goto yy138;
					if(yych <= 'V') goto yy1354;
					goto yy1351;
				}
			}
		} else {
			if(yych <= 'n') {
				if(yych <= '^') {
					if(yych <= 'Z') goto yy138;
					goto yy3;
				} else {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy3;
					goto yy143;
				}
			} else {
				if(yych <= 'v') {
					if(yych <= 'o') goto yy1368;
					if(yych <= 'u') goto yy143;
					goto yy1369;
				} else {
					if(yych <= 'w') goto yy1367;
					if(yych <= 'z') goto yy143;
					goto yy3;
				}
			}
		}
yy1362:
		YYDEBUG(1362, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'X') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'W') goto yy138;
				goto yy1350;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'x') goto yy1366;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1363:
		YYDEBUG(1363, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy138;
				goto yy1348;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1364;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1364:
		YYDEBUG(1364, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy1349;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy1365;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1365:
		YYDEBUG(1365, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'H') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'G') goto yy140;
				goto yy272;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'h') goto yy282;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1366:
		YYDEBUG(1366, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy259;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy262;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1367:
		YYDEBUG(1367, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy1352;
				goto yy136;
			} else {
				if(yych == '/') goto yy144;
				goto yy1352;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '^') goto yy1352;
				goto yy144;
			} else {
				if(yych <= '`') goto yy1352;
				if(yych <= 'z') goto yy148;
				goto yy1352;
			}
		}
yy1368:
		YYDEBUG(1368, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'N') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'M') goto yy139;
				goto yy1359;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'n') goto yy1374;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1369:
		YYDEBUG(1369, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '9') {
			if(yych <= '(') {
				if(yych <= 0x09) {
					if(yych <= 0x08) goto yy312;
					goto yy314;
				} else {
					if(yych == ' ') goto yy314;
					goto yy312;
				}
			} else {
				if(yych <= '-') {
					if(yych <= ')') goto yy136;
					if(yych <= ',') goto yy312;
					goto yy315;
				} else {
					if(yych == '/') goto yy144;
					goto yy314;
				}
			}
		} else {
			if(yych <= '^') {
				if(yych <= 'D') {
					if(yych <= '@') goto yy312;
					goto yy139;
				} else {
					if(yych <= 'E') goto yy1355;
					if(yych <= 'Z') goto yy139;
					goto yy312;
				}
			} else {
				if(yych <= 'd') {
					if(yych <= '_') goto yy144;
					if(yych <= '`') goto yy312;
					goto yy148;
				} else {
					if(yych <= 'e') goto yy1370;
					if(yych <= 'z') goto yy148;
					goto yy312;
				}
			}
		}
yy1370:
		YYDEBUG(1370, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'M') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'L') goto yy140;
				goto yy1356;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'm') goto yy1371;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1371:
		YYDEBUG(1371, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'B') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'A') goto yy141;
				goto yy1357;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'b') goto yy1372;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1372:
		YYDEBUG(1372, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'D') goto yy3;
				goto yy1358;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy1373;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy1373:
		YYDEBUG(1373, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'R') goto yy324;
		if(yych == 'r') goto yy494;
		goto yy152;
yy1374:
		YYDEBUG(1374, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '@') {
			if(yych <= ')') {
				if(yych <= '(') goto yy1360;
				goto yy136;
			} else {
				if(yych == '/') goto yy144;
				goto yy1360;
			}
		} else {
			if(yych <= '_') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '^') goto yy1360;
				goto yy144;
			} else {
				if(yych <= '`') goto yy1360;
				if(yych <= 'z') goto yy149;
				goto yy1360;
			}
		}
yy1375:
		YYDEBUG(1375, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'S') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy138;
			}
		} else {
			if(yych <= 'r') {
				if(yych <= 'Z') goto yy138;
				if(yych <= '`') goto yy3;
				goto yy138;
			} else {
				if(yych <= 's') goto yy1376;
				if(yych <= 'z') goto yy138;
				goto yy3;
			}
		}
yy1376:
		YYDEBUG(1376, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'T') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
			}
		} else {
			if(yych <= 's') {
				if(yych <= 'Z') goto yy139;
				if(yych <= '`') goto yy3;
				goto yy139;
			} else {
				if(yych <= 't') goto yy1377;
				if(yych <= 'z') goto yy139;
				goto yy3;
			}
		}
yy1377:
		YYDEBUG(1377, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'E') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy140;
			}
		} else {
			if(yych <= 'd') {
				if(yych <= 'Z') goto yy140;
				if(yych <= '`') goto yy3;
				goto yy140;
			} else {
				if(yych <= 'e') goto yy1378;
				if(yych <= 'z') goto yy140;
				goto yy3;
			}
		}
yy1378:
		YYDEBUG(1378, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych <= 'R') {
			if(yych <= ')') {
				if(yych <= '(') goto yy3;
				goto yy136;
			} else {
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy141;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= 'Z') goto yy141;
				if(yych <= '`') goto yy3;
				goto yy141;
			} else {
				if(yych <= 'r') goto yy1379;
				if(yych <= 'z') goto yy141;
				goto yy3;
			}
		}
yy1379:
		YYDEBUG(1379, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'C') {
			if(yych == ')') goto yy136;
			goto yy3;
		} else {
			if(yych <= 'D') goto yy1380;
			if(yych != 'd') goto yy3;
		}
yy1380:
		YYDEBUG(1380, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1381;
		if(yych != 'a') goto yy53;
yy1381:
		YYDEBUG(1381, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy1382;
		if(yych != 'y') goto yy53;
yy1382:
		YYDEBUG(1382, *YYCURSOR);
		++YYCURSOR;
yy1383:
		YYDEBUG(1383, *YYCURSOR);
		{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1384:
		YYDEBUG(1384, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'S') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'R') goto yy138;
				goto yy1376;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy138;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 's') goto yy1385;
				if(yych <= 'z') goto yy143;
				goto yy3;
			}
		}
yy1385:
		YYDEBUG(1385, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'T') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'S') goto yy139;
				goto yy1377;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy139;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 't') goto yy1386;
				if(yych <= 'z') goto yy148;
				goto yy3;
			}
		}
yy1386:
		YYDEBUG(1386, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'E') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'D') goto yy140;
				goto yy1378;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy140;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'e') goto yy1387;
				if(yych <= 'z') goto yy149;
				goto yy3;
			}
		}
yy1387:
		YYDEBUG(1387, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'R') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= '@') goto yy3;
				if(yych <= 'Q') goto yy141;
				goto yy1379;
			}
		} else {
			if(yych <= '`') {
				if(yych <= 'Z') goto yy141;
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'r') goto yy1388;
				if(yych <= 'z') goto yy150;
				goto yy3;
			}
		}
yy1388:
		YYDEBUG(1388, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= 'D') {
			if(yych <= '.') {
				if(yych == ')') goto yy136;
				goto yy3;
			} else {
				if(yych <= '/') goto yy144;
				if(yych <= 'C') goto yy3;
				goto yy1380;
			}
		} else {
			if(yych <= '`') {
				if(yych == '_') goto yy144;
				goto yy3;
			} else {
				if(yych == 'd') goto yy1389;
				if(yych <= 'z') goto yy151;
				goto yy3;
			}
		}
yy1389:
		YYDEBUG(1389, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'A') goto yy1381;
		if(yych != 'a') goto yy152;
		YYDEBUG(1390, *YYCURSOR);
		yych = *++YYCURSOR;
		if(yych == 'Y') goto yy1382;
		if(yych != 'y') goto yy152;
		YYDEBUG(1391, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if(yych <= '^') {
			if(yych == '/') goto yy144;
			goto yy1383;
		} else {
			if(yych <= '_') goto yy144;
			if(yych <= '`') goto yy1383;
			if(yych <= 'z') goto yy151;
			goto yy1383;
		}
	}
}

}

#define YYMAXFILL 29

timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 1) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = -1;
		in.time->z = -999999;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -999999;
	in.time->dst = -1;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -999999) parsed->z = now->z != -999999 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
