.\"
.\" "$Id: lp.man 12854 2015-08-28 14:08:00Z msweet $"
.\"
.\" lp man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lp 1 "CUPS" "11 June 2014" "Apple Inc."
.SH NAME
lp \- print files
.SH SYNOPSIS
.B lp
[
.B \-E
] [
.B \-U
.I username
] [
.B \-c
] [
\fB\-d \fIdestination\fR[\fB/\fIinstance\fR]
] [
\fB\-h \fIhostname\fR[\fB:\fIport\fR]
] [
.B \-m
] [
.B \-n
.I num-copies
] [
\fB\-o \fIoption\fR[\fB=\fIvalue\fR]
] [
.B \-q
.I priority
] [
.B \-s
] [
.B \-t
.I title
] [
.B \-H
.I handling
] [
.B \-P
.I page-list
] [
.B \-\-
] [
.I file(s)
]
.br
.B lp
[
.B \-E
] [
.B \-U
.I username
] [
.B \-c
] [
\fB\-h \fIhostname\fR[\fB:\fIport\fR]
] [
.B \-i
.I job-id
] [
.B \-n
.I num-copies
] [
\fB\-o \fIoption\fR[\fB=\fIvalue\fR]
] [
.B \-q
.I priority
] [
.B \-t
.I title
] [
.B \-H
.I handling
] [
.B \-P
.I page-list
]
.SH DESCRIPTION
\fBlp\fR submits files for printing or alters a pending job.
Use a filename of "-" to force printing from the standard input.
.SS THE DEFAULT DESTINATION
CUPS provides many ways to set the default destination. The \fBLPDEST\fR and \fBPRINTER\fR environment variables are consulted first.
If neither are set, the current default set using the
.BR lpoptions (1)
command is used, followed by the default set using the
.BR lpadmin (8)
command.
.SH OPTIONS
The following options are recognized by \fIlp\fR:
.TP 5
.B \-\-
Marks the end of options; use this to print a file whose name begins with a dash (\-).
.TP 5
.B \-E
Forces encryption when connecting to the server.
.TP 5
\fB\-U \fIusername\fR
Specifies the username to use when connecting to the server.
.TP 5
.B \-c
This option is provided for backwards-compatibility only. On systems that support it, this option forces the print file to be copied to the spool directory before printing.
In CUPS, print files are always sent to the scheduler via IPP which has the same effect.
.TP 5
\fB\-d \fIdestination\fR
Prints files to the named printer.
.TP 5
\fB\-h \fIhostname\fR[\fB:\fIport\fR]
Chooses an alternate server.
.TP 5
\fB\-i \fIjob-id\fR
Specifies an existing job to modify.
.TP 5
.B \-m
Sends an email when the job is completed.
.TP 5
\fB\-n \fIcopies\fR
Sets the number of copies to print.
.TP 5
\fB\-o "\fIname\fB=\fIvalue \fR[ ... \fIname\fB=\fIvalue \fR]\fB"\fR
Sets one or more job options.
.TP 5
\fB\-q \fIpriority\fR
Sets the job priority from 1 (lowest) to 100 (highest).
The default priority is 50.
.TP 5
.B \-s
Do not report the resulting job IDs (silent mode.)
.TP 5
\fB\-t "\fIname\fB"\fR
Sets the job name.
.TP 5
\fB\-H \fIhh:mm\fR
.TP 5
\fB\-H hold\fR
.TP 5
\fB-H immediate\fR
.TP 5
\fB-H restart\fR
.TP 5
\fB-H resume\fR
Specifies when the job should be printed.
A value of \fIimmediate\fR will print the file immediately, a value of \fIhold\fR will hold the job indefinitely, and a UTC time value (HH:MM) will hold the job until the specified UTC (not local) time.
Use a value of \fIresume\fR with the \fI-i\fR option to resume a held job.
Use a value of \fIrestart\fR with the \fI-i\fR option to restart a completed job.
.TP 5
\fB\-P \fIpage-list\fR
Specifies which pages to print in the document.
The list can contain a list of numbers and ranges (#-#) separated by commas, e.g., "1,3-5,16".
The page numbers refer to the output pages and not the document's original pages - options like "number-up" can affect the numbering of the pages.
.SS COMMON JOB OPTIONS
Aside from the printer-specific options reported by the
.BR lpoptions (1)
command, the following generic options are available:
.TP 5
\fB\-o media=\fIsize\fR
Sets the page size to \fIsize\fR. Most printers support at least the size names "a4", "letter", and "legal".
.TP 5
\fB\-o orientation\-requested=4\fR
Prints the job in landscape (rotated 90 degrees).
.TP 5
\fB\-o sides=one\-sided\fR
Prints on one side of the paper.
.TP 5
\fB\-o sides=two\-sided\-long\-edge\fR
Prints on both sides of the paper for portrait output.
.TP 5
\fB\-o sides=two\-sided\-short\-edge\fR
Prints on both sides of the paper for landscape output.
.TP 5
\fB\-o fit\-to\-page\fR
Scales the print file to fit on the page.
.TP 5
\fB\-o number\-up=\fR{\fI2|4|6|9|16\fR}
Prints 2, 4, 6, 9, or 16 document (input) pages on each output page.
.SH CONFORMING TO
Unlike the System V printing system, CUPS allows printer names to contain any printable character except SPACE, TAB, "/", or "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
The \fI-q\fR option accepts a different range of values than the Solaris lp command, matching the IPP job priority values (1-100, 100 is highest priority) instead of the Solaris values (0-39, 0 is highest priority).
.SH EXAMPLES
Print two copies of a document to the default printer:
.nf

    lp -n 2 filename

.fi
Print a double-sided legal document to a printer called "foo":
.nf

    lp -d foo -o media=legal -o sides=two-sided-long-edge filename

.fi
Print a presentation document 2-up to a printer called "foo":
.nf

    lp -d foo -o number-up=2 filename
.fi
.SH SEE ALSO
.BR cancel (1),
.BR lpadmin (8),
.BR lpoptions (1),
.BR lpq (1),
.BR lpr (1),
.BR lprm (1),
.BR lpstat (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2015 by Apple Inc.
.\"
.\" End of "$Id: lp.man 12854 2015-08-28 14:08:00Z msweet $".
.\"
