#include <termios.h>
#include <sys/ioctl.h>
#include <stdio.h>

#ifdef ELF_LIBRARY
#define tcsetattr _tcsetattr
#define ioctl _ioctl
#endif

int tcsetattr(int fildes, int optional, struct termios *termios_p)
  {
    switch(optional) {
    case TCSANOW:
      return ioctl(fildes, TCSETS, termios_p);
      break;
    case TCSADRAIN:
    case TCSAFLUSH:
      fprintf(stderr,"tcsetattr option %d not supported yet.\n", optional);
      break;
    };
  }

#ifdef ELF_LIBRARY
__asm__(".weak tcsetattr; tcsetattr = _tcsetattr");
#endif
