/*
 *   Copyright (c) International Business Machines  Corp., 2002
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#ifndef _H_UJFS_ENDIAN
#define _H_UJFS_ENDIAN

#include "jfs_types.h"
#include "jfs_byteorder.h"
#include "jfs_superblock.h"
#include "jfs_dmap.h"
#include "jfs_imap.h"
#include "jfs_dinode.h"
#include "jfs_logmgr.h"
#include "fsckwsp.h"

#if __BYTE_ORDER == __BIG_ENDIAN
void ujfs_swap_dbmap_t(dbmap_t *);
void ujfs_swap_dinode(dinode_t *, int32_t, uint32_t);
void ujfs_swap_dinomap_t(dinomap_t *);
void ujfs_swap_dmap_t(dmap_t *);
void ujfs_swap_dmapctl_t(dmapctl_t *);
void ujfs_swap_dtpage_t(dtpage_t *, uint32_t);
void ujfs_swap_fsck_blk_map_hdr(fsck_blk_map_hdr_t *);
void ujfs_swap_fsck_blk_map_page(fsck_blk_map_page_t *);
void ujfs_swap_fscklog_entry_hdr_t(logent_hdptr);
void ujfs_swap_iag_t(iag_t *);
void ujfs_swap_logpage_t(logpage_t *, uint8_t);
void ujfs_swap_logsuper_t(logsuper_t *);
void ujfs_swap_lrd_t(lrd_t *);
void ujfs_swap_superblock(struct superblock *);
void ujfs_swap_xtpage_t(xtpage_t *);

static inline void ujfs_swap_inoext(struct dinode *ptr, int32_t mode,
				    uint32_t flag)
{
	int i;
	for (i = 0; i < INOSPEREXT; i++, ptr++)
		ujfs_swap_dinode(ptr, mode, flag);
}

#define swap_multiple(swap_func, ptr, num)	\
do {						\
	int i;					\
	for (i = 0; i < num; i++, (ptr)++)	\
		swap_func(ptr);			\
} while (0)

#else	/* Little endian */

#define ujfs_swap_dbmap_t(dbmap)		do {} while (0)
#define ujfs_swap_dinode(dinode, mode, flag)	do {} while (0)
#define ujfs_swap_dinomap_t(dinomap)		do {} while (0)
#define ujfs_swap_dmap_t(dmap)			do {} while (0)
#define ujfs_swap_dmapctl_t(dmapctl)		do {} while (0)
#define ujfs_swap_dtpage_t(dtpage, flag)	do {} while (0)
#define ujfs_swap_fsck_blk_map_hdr(map_hdr)	do {} while (0)
#define ujfs_swap_fsck_blk_map_page(map_page)	do {} while (0)
#define ujfs_swap_fscklog_entry_hdr_t(ent_hdr)	do {} while (0)
#define ujfs_swap_iag_t(iag)			do {} while (0)
#define ujfs_swap_inoext(inoext, mode, flag)	do {} while (0)
#define ujfs_swap_logpage_t(logpage, pages)	do {} while (0)
#define ujfs_swap_logsuper_t(logsuper)		do {} while (0)
#define ujfs_swap_lrd_t(lrd)			do {} while (0)
#define ujfs_swap_superblock(sb)		do {} while (0)
#define ujfs_swap_xtpage_t(xtpage)		do {} while (0)
#define swap_multiple(swap_func, ptr, num)	do {} while (0)

#endif 

#endif	/* _H_UJFS_ENDIAN */
