//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMTEXTURE_H
#define PMTEXTURE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmtexturebase.h"

/**
 * Class for povray textures
 */
class PMTexture : public PMTextureBase
{
   typedef PMTextureBase Base;
public:
   /** Creates an PMTexture */
   PMTexture( );
   /** Deletes the object */
   virtual ~PMTexture( );
   
   /** */
   virtual PMObject* newObject( ) const { return new PMTexture( ); }
   /** */
   virtual QString className( ) const { return QString( "texture" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTTexture; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;
   /** */
   virtual int canInsert( const QValueList<PMObjectType>& list,
                          const PMObject* after ) const;
   /** */
   virtual int canInsert( const PMObjectList& list,
                          const PMObject* after ) const;
   /** */
   virtual QValueList<PMDeclare::PMDeclareType> linkPossibilities( ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;

   /** Returns a new @ref PMTextureEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmtexture" ); }

private:
   void countChild( PMObjectType t,
                    int& materialmap, int& pigment, int& finish, int& pattern, 
                    int& listpattern, int& map, int& summap, int& normal, 
                    int& warprepeat, int& blend, int& sumpigment, 
                    bool& afterPattern, bool& afterMap, bool& afterWarp, 
                    bool& afterBlend, bool& afterTransform, 
                    bool insertPoint ) const;
   bool canInsert( PMObjectType t,
                   int materialmap, int pigment, int finish, int pattern, 
                   int listpattern, int map, int summap, int normal, 
                   int warprepeat, int blend,
                   int sumpigment, bool afterPattern, bool afterMap,
                   bool afterWarp, bool afterBlend, bool afterTransform ) const;
   
   
   /** IDs for @ref PMMementoData */
   static bool s_linkPossibilitiesCreated;
   static QValueList<PMDeclare::PMDeclareType> s_linkPossibilities;
};


#endif
