// -*- C++ -*-

//
//  kjots
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KJotsMain_included
#define KJotsMain_included

#include <qlayout.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <kdialogbase.h>
#include <kmainwindow.h>
#include <ktextedit.h>

class KJotsMain;
class KToolBar;
class KAccel;
class SubjList;
class KPopupMenu;
class ConfigureDialog;
class KEdFind;
class KEdReplace;

class TextEntry
{
  friend class KJotsMain;
  friend class SubjList;
public:
  TextEntry() {}
  virtual ~TextEntry() {}

protected:
  QString   text;
  QString   subject;
};


/////////////////////////////////////////////////////////////////////////////
class MyMultiEdit : public KTextEdit
{
  Q_OBJECT
public:
  MyMultiEdit (QWidget* parent=0, const char* name=0);
  ~MyMultiEdit ();

  void search();
  void repeatSearch();
  void replace() {}
  void print(QString title = QString::null);

protected slots:
  void openUrl();
  void slotSearch();

protected:
  virtual void mousePressEvent (QMouseEvent *e);

  KPopupMenu *web_menu;

  // search / replace dialogs
  KEdFind       *mSearchDialog;
  KEdReplace *mReplaceDialog;
  QString           mSearchFor;
};


/////////////////////////////////////////////////////////////////////////////
class KJotsMain : public KMainWindow
{
  Q_OBJECT
public:
  KJotsMain( const char* name = NULL );
  virtual ~KJotsMain();

signals:
  void entryMoved(int);
  void entryChanged(int);
  void folderChanged(QPtrList<TextEntry> *);

public slots:
  void saveFolder();

protected slots:
  void openFolder(int id);
  void createFolder();
  void deleteFolder();
  void nextEntry();
  void prevEntry();
  void newEntry();
  void deleteEntry();
  void barMoved(int);
  void addToHotlist();
  void removeFromHotlist();
  void toggleSubjList();
  void configure();
  void configureHide();
  void configureDestroy();
  void updateConfiguration();
  void writeBook();
  void writePage();
  void moveFocus();
  void configureKeys();
  void copySelection();
  void insertDate();
  void updateMenu();
  void slotEditBookTitle();
  void slotPrintPage();
  void slotSearch();
  void slotRepeatSearch();
  void slotReplace();
  void slotQuit();

protected:
  int readFile(QString name);
  int writeFile( QString name);
  void writeEntry( QTextStream &st, TextEntry *entry );
  void saveProperties( void );

  QBoxLayout    *bg_bot_layout;
  QBoxLayout   *bg_top_layout;
  KAccel        *keys;

  QPtrList<TextEntry> entrylist;
  int                 current;
  int                 currentFolder;
  int                 currentFolderID;
  bool             folderOpen;
  QString          current_folder_name;
  QStringList         folder_list;
  QStringList         hotlist;
  QPtrList<QPushButton> button_list;
  QPopupMenu      *folders_menu;
  int              unique_id;
  SubjList        *subj_list;
  ConfigureDialog *mOptionDialog;

  QButtonGroup  *bg_top;
  QScrollBar    *s_bar;
  MyMultiEdit   *me_text;
  QLabel        *l_folder;
  QLineEdit     *le_subject;
 
  // save id's for updateMenu()
  int id_f_save_book_ascii;
  int id_f_save_page_ascii;

  int id_fav_add;
  int id_fav_del;
};

#endif // KJotsMain_included
