
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGBREAKPOINTSIMPL_H 
#define XSLDBGBREAKPOINTSIMPL_H 
 
/** 
  *@author Keith Isdale 
  */ 
 
#include "ui_xsldbgbreakpoints.h" 
#include "xsldbgdialogbase.h" 

#include <QWidget>
 
class XsldbgDebugger; 
 
class XsldbgBreakpointsImpl : public QWidget, Ui::XsldbgBreakpoints, public XsldbgDialogBase  { 
  Q_OBJECT 
 
public: 
	explicit XsldbgBreakpointsImpl(XsldbgDebugger *debugger, QWidget *parent=0); 
	~XsldbgBreakpointsImpl(); 
 
	/* Return >= 0 if line number entered is valid */ 
	int getLineNumber(); 
 
	/* Return >= 0 if breakpoint id entered is valid */	 
	int getId(); 

	// this must match the order of columns in tableWidget
	enum ColumnDataTypes {IDColumn, NameColumn, ModeColumn, FileNameColumn, LineNumberColumn, EnabledColumn};
 
 
public slots: 
	 
	void slotAddBreakpoint(); 
	void slotAddAllTemplateBreakpoints(); 
	void slotDeleteBreakpoint(); 
	void slotDeleteAllBreakpoints(); 
	void slotEnableBreakpoint(); 
	void itemSelectionChanged(); 
	 
	/** Receive notification about breakpoint to add to view, first parameter is QString()
			to indicate start of breakpoint list notfication */ 
	void slotProcBreakpointItem(QString file, int lineNumber,  
				    QString templateName, QString modeName, 
				    bool enabled, int  id ); 
 
	/** Called to resize the table widget contents after enough time has lapsed */
	void resizeContents();

	/** refresh data from source */ 
	void refresh(); 
	 
	/**Clear data from all fields */ 
	void slotClear(); 
	 
private: 
	XsldbgDebugger *debugger; 
 
}; 
 
#endif 
