/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/******

  This file contains the list of all editor nsIAtoms and their values

  It is designed to be used as inline input to nsEditProperty.cpp *only*
  through the magic of C preprocessing.

  All entries must be enclosed in the macro EDITOR_ATOM which will have cruel
  and unusual things done to it

  It is recommended (but not strictly necessary) to keep all entries
  in alphabetical order

  The first argument to EDITOR_ATOM is the C++ identifier of the atom
  The second argument is the string value of the atom

 ******/

EDITOR_ATOM(a, "a")
EDITOR_ATOM(abbr, "abbr")
EDITOR_ATOM(acronym, "acronym")
EDITOR_ATOM(address, "address")
EDITOR_ATOM(article, "article")
EDITOR_ATOM(aside, "aside")
EDITOR_ATOM(b, "b")
EDITOR_ATOM(bdo, "bdo")
EDITOR_ATOM(big, "big")
EDITOR_ATOM(blink, "blink")
EDITOR_ATOM(blockquote, "blockquote")
EDITOR_ATOM(body, "body")
EDITOR_ATOM(br, "br")
EDITOR_ATOM(button, "button")
EDITOR_ATOM(caption, "caption")
EDITOR_ATOM(center, "center")
EDITOR_ATOM(cite, "cite")
EDITOR_ATOM(code, "code")
EDITOR_ATOM(col, "col")
EDITOR_ATOM(colgroup, "colgroup")
EDITOR_ATOM(color, "color")
EDITOR_ATOM(cssBackgroundColor, "background-color")
EDITOR_ATOM(cssBackgroundImage, "background-image")
EDITOR_ATOM(cssBorder, "border")
EDITOR_ATOM(cssBottom, "bottom")
EDITOR_ATOM(cssCaptionSide, "caption-side")
EDITOR_ATOM(cssCmUnit, "cm")
EDITOR_ATOM(cssColor, "color")
EDITOR_ATOM(cssDirection, "direction")
EDITOR_ATOM(cssEmUnit, "em")
EDITOR_ATOM(cssExUnit, "ex")
EDITOR_ATOM(cssFloat, "float")
EDITOR_ATOM(cssFontFamily, "font-family")
EDITOR_ATOM(cssFontSize, "font-size")
EDITOR_ATOM(cssFontStyle, "font-style")
EDITOR_ATOM(cssFontWeight, "font-weight")
EDITOR_ATOM(cssHeight, "height")
EDITOR_ATOM(cssInUnit, "in")
EDITOR_ATOM(cssLeft, "left")
EDITOR_ATOM(cssListStyleType, "list-style-type")
EDITOR_ATOM(cssMarginLeft, "margin-left")
EDITOR_ATOM(cssMarginRight, "margin-right")
EDITOR_ATOM(cssMmUnit, "mm")
EDITOR_ATOM(cssMozUserModify, "-moz-user-modify")
EDITOR_ATOM(cssMozUserSelect, "-moz-user-select")
EDITOR_ATOM(cssPcUnit, "pc")
EDITOR_ATOM(cssPercentUnit, "%")
EDITOR_ATOM(cssPosition, "position")
EDITOR_ATOM(cssPtUnit, "pt")
EDITOR_ATOM(cssPxUnit, "px")
EDITOR_ATOM(cssRight, "right")
EDITOR_ATOM(cssTextAlign, "text-align")
EDITOR_ATOM(cssTextDecoration, "text-decoration")
EDITOR_ATOM(cssTop, "top")
EDITOR_ATOM(cssVerticalAlign, "vertical-align")
EDITOR_ATOM(cssWhitespace, "white-space")
EDITOR_ATOM(cssWidth, "width")
EDITOR_ATOM(cssZIndex, "z-index")
EDITOR_ATOM(datalist, "datalist")
EDITOR_ATOM(dd, "dd")
EDITOR_ATOM(dfn, "dfn")
EDITOR_ATOM(div, "div")
EDITOR_ATOM(dl, "dl")
EDITOR_ATOM(dt, "dt")
EDITOR_ATOM(em, "em")
EDITOR_ATOM(face, "face")
EDITOR_ATOM(fieldset, "fieldset")
EDITOR_ATOM(figcaption, "figcaption")
EDITOR_ATOM(figure, "figure")
EDITOR_ATOM(font, "font")
EDITOR_ATOM(footer, "footer")
EDITOR_ATOM(form, "form")
EDITOR_ATOM(h1, "h1")
EDITOR_ATOM(h2, "h2")
EDITOR_ATOM(h3, "h3")
EDITOR_ATOM(h4, "h4")
EDITOR_ATOM(h5, "h5")
EDITOR_ATOM(h6, "h6")
EDITOR_ATOM(header, "header")
EDITOR_ATOM(head, "head")
EDITOR_ATOM(hgroup, "hgroup")
EDITOR_ATOM(href, "href") // Use to differentiate between "a" for link, "a" for named anchor
EDITOR_ATOM(hr, "hr")
EDITOR_ATOM(html, "html")
EDITOR_ATOM(i, "i")
EDITOR_ATOM(img, "img")
EDITOR_ATOM(input, "input")
EDITOR_ATOM(kbd, "kbd")
EDITOR_ATOM(keygen, "keygen")
EDITOR_ATOM(label, "label")
EDITOR_ATOM(legend, "legend")
EDITOR_ATOM(li, "li")
EDITOR_ATOM(map, "map")
EDITOR_ATOM(mark, "mark")
EDITOR_ATOM(menuitem, "menuitem")
EDITOR_ATOM(mozdirty, "_moz_dirty")
EDITOR_ATOM(mozEditorBogusNode, "_moz_editor_bogus_node")
EDITOR_ATOM(name, "name")
EDITOR_ATOM(nav, "nav")
EDITOR_ATOM(noscript, "noscript")
EDITOR_ATOM(object, "object")
EDITOR_ATOM(ol, "ol")
EDITOR_ATOM(output, "output")
EDITOR_ATOM(p, "p")
EDITOR_ATOM(pre, "pre")
EDITOR_ATOM(progress, "progress")
EDITOR_ATOM(q, "q")
EDITOR_ATOM(samp, "samp")
EDITOR_ATOM(script, "script")
EDITOR_ATOM(section, "section")
EDITOR_ATOM(select, "select")
EDITOR_ATOM(size, "size")
EDITOR_ATOM(small, "small")
EDITOR_ATOM(span, "span")
EDITOR_ATOM(s, "s")
EDITOR_ATOM(strike, "strike")
EDITOR_ATOM(strong, "strong")
EDITOR_ATOM(sub, "sub")
EDITOR_ATOM(sup, "sup")
EDITOR_ATOM(table, "table")
EDITOR_ATOM(tbody, "tbody")
EDITOR_ATOM(td, "td")
EDITOR_ATOM(textarea, "textarea")
EDITOR_ATOM(tfoot, "tfoot")
EDITOR_ATOM(thead, "thead")
EDITOR_ATOM(th, "th")
EDITOR_ATOM(tr, "tr")
EDITOR_ATOM(tt, "tt")
EDITOR_ATOM(ul, "ul")
EDITOR_ATOM(u, "u")
EDITOR_ATOM(var, "var")
