// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// validationESEXT_autogen.h:
//   Validation functions for the OpenGL ES extension entry points.

#ifndef LIBANGLE_VALIDATION_ESEXT_AUTOGEN_H_
#define LIBANGLE_VALIDATION_ESEXT_AUTOGEN_H_

#include "common/PackedEnums.h"

namespace gl
{
class Context;

// GL_ANGLE_base_vertex_base_instance
bool ValidateDrawArraysInstancedBaseInstanceANGLE(const Context *context,
                                                  PrimitiveMode modePacked,
                                                  GLint first,
                                                  GLsizei count,
                                                  GLsizei instanceCount,
                                                  GLuint baseInstance);
bool ValidateDrawElementsInstancedBaseVertexBaseInstanceANGLE(const Context *context,
                                                              PrimitiveMode modePacked,
                                                              GLsizei count,
                                                              DrawElementsType typePacked,
                                                              const GLvoid *indices,
                                                              GLsizei instanceCounts,
                                                              GLint baseVertex,
                                                              GLuint baseInstance);
bool ValidateMultiDrawArraysInstancedBaseInstanceANGLE(const Context *context,
                                                       PrimitiveMode modePacked,
                                                       const GLint *firsts,
                                                       const GLsizei *counts,
                                                       const GLsizei *instanceCounts,
                                                       const GLuint *baseInstances,
                                                       GLsizei drawcount);
bool ValidateMultiDrawElementsInstancedBaseVertexBaseInstanceANGLE(const Context *context,
                                                                   PrimitiveMode modePacked,
                                                                   const GLsizei *counts,
                                                                   DrawElementsType typePacked,
                                                                   const GLvoid *const *indices,
                                                                   const GLsizei *instanceCounts,
                                                                   const GLint *baseVertices,
                                                                   const GLuint *baseInstances,
                                                                   GLsizei drawcount);

// GL_ANGLE_copy_texture_3d
bool ValidateCopyTexture3DANGLE(const Context *context,
                                TextureID sourceIdPacked,
                                GLint sourceLevel,
                                TextureTarget destTargetPacked,
                                TextureID destIdPacked,
                                GLint destLevel,
                                GLint internalFormat,
                                GLenum destType,
                                GLboolean unpackFlipY,
                                GLboolean unpackPremultiplyAlpha,
                                GLboolean unpackUnmultiplyAlpha);
bool ValidateCopySubTexture3DANGLE(const Context *context,
                                   TextureID sourceIdPacked,
                                   GLint sourceLevel,
                                   TextureTarget destTargetPacked,
                                   TextureID destIdPacked,
                                   GLint destLevel,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLint zoffset,
                                   GLint x,
                                   GLint y,
                                   GLint z,
                                   GLint width,
                                   GLint height,
                                   GLint depth,
                                   GLboolean unpackFlipY,
                                   GLboolean unpackPremultiplyAlpha,
                                   GLboolean unpackUnmultiplyAlpha);

// GL_ANGLE_framebuffer_blit
bool ValidateBlitFramebufferANGLE(const Context *context,
                                  GLint srcX0,
                                  GLint srcY0,
                                  GLint srcX1,
                                  GLint srcY1,
                                  GLint dstX0,
                                  GLint dstY0,
                                  GLint dstX1,
                                  GLint dstY1,
                                  GLbitfield mask,
                                  GLenum filter);

// GL_ANGLE_framebuffer_multisample
bool ValidateRenderbufferStorageMultisampleANGLE(const Context *context,
                                                 GLenum target,
                                                 GLsizei samples,
                                                 GLenum internalformat,
                                                 GLsizei width,
                                                 GLsizei height);

// GL_ANGLE_get_image
bool ValidateGetTexImageANGLE(const Context *context,
                              TextureTarget targetPacked,
                              GLint level,
                              GLenum format,
                              GLenum type,
                              const void *pixels);
bool ValidateGetRenderbufferImageANGLE(const Context *context,
                                       GLenum target,
                                       GLenum format,
                                       GLenum type,
                                       const void *pixels);

// GL_ANGLE_get_tex_level_parameter
bool ValidateGetTexLevelParameterivANGLE(const Context *context,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLenum pname,
                                         const GLint *params);
bool ValidateGetTexLevelParameterfvANGLE(const Context *context,
                                         TextureTarget targetPacked,
                                         GLint level,
                                         GLenum pname,
                                         const GLfloat *params);

// GL_ANGLE_instanced_arrays
bool ValidateDrawArraysInstancedANGLE(const Context *context,
                                      PrimitiveMode modePacked,
                                      GLint first,
                                      GLsizei count,
                                      GLsizei primcount);
bool ValidateDrawElementsInstancedANGLE(const Context *context,
                                        PrimitiveMode modePacked,
                                        GLsizei count,
                                        DrawElementsType typePacked,
                                        const void *indices,
                                        GLsizei primcount);
bool ValidateVertexAttribDivisorANGLE(const Context *context, GLuint index, GLuint divisor);

// GL_ANGLE_memory_object_flags
bool ValidateTexStorageMemFlags2DANGLE(const Context *context,
                                       TextureType targetPacked,
                                       GLsizei levels,
                                       GLenum internalFormat,
                                       GLsizei width,
                                       GLsizei height,
                                       MemoryObjectID memoryPacked,
                                       GLuint64 offset,
                                       GLbitfield createFlags,
                                       GLbitfield usageFlags);
bool ValidateTexStorageMemFlags2DMultisampleANGLE(const Context *context,
                                                  TextureType targetPacked,
                                                  GLsizei samples,
                                                  GLenum internalFormat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLboolean fixedSampleLocations,
                                                  MemoryObjectID memoryPacked,
                                                  GLuint64 offset,
                                                  GLbitfield createFlags,
                                                  GLbitfield usageFlags);
bool ValidateTexStorageMemFlags3DANGLE(const Context *context,
                                       TextureType targetPacked,
                                       GLsizei levels,
                                       GLenum internalFormat,
                                       GLsizei width,
                                       GLsizei height,
                                       GLsizei depth,
                                       MemoryObjectID memoryPacked,
                                       GLuint64 offset,
                                       GLbitfield createFlags,
                                       GLbitfield usageFlags);
bool ValidateTexStorageMemFlags3DMultisampleANGLE(const Context *context,
                                                  TextureType targetPacked,
                                                  GLsizei samples,
                                                  GLenum internalFormat,
                                                  GLsizei width,
                                                  GLsizei height,
                                                  GLsizei depth,
                                                  GLboolean fixedSampleLocations,
                                                  MemoryObjectID memoryPacked,
                                                  GLuint64 offset,
                                                  GLbitfield createFlags,
                                                  GLbitfield usageFlags);

// GL_ANGLE_memory_object_fuchsia
bool ValidateImportMemoryZirconHandleANGLE(const Context *context,
                                           MemoryObjectID memoryPacked,
                                           GLuint64 size,
                                           HandleType handleTypePacked,
                                           GLuint handle);

// GL_ANGLE_multi_draw
bool ValidateMultiDrawArraysANGLE(const Context *context,
                                  PrimitiveMode modePacked,
                                  const GLint *firsts,
                                  const GLsizei *counts,
                                  GLsizei drawcount);
bool ValidateMultiDrawArraysInstancedANGLE(const Context *context,
                                           PrimitiveMode modePacked,
                                           const GLint *firsts,
                                           const GLsizei *counts,
                                           const GLsizei *instanceCounts,
                                           GLsizei drawcount);
bool ValidateMultiDrawElementsANGLE(const Context *context,
                                    PrimitiveMode modePacked,
                                    const GLsizei *counts,
                                    DrawElementsType typePacked,
                                    const GLvoid *const *indices,
                                    GLsizei drawcount);
bool ValidateMultiDrawElementsInstancedANGLE(const Context *context,
                                             PrimitiveMode modePacked,
                                             const GLsizei *counts,
                                             DrawElementsType typePacked,
                                             const GLvoid *const *indices,
                                             const GLsizei *instanceCounts,
                                             GLsizei drawcount);

// GL_ANGLE_program_binary

// GL_ANGLE_provoking_vertex
bool ValidateProvokingVertexANGLE(const Context *context, ProvokingVertexConvention modePacked);

// GL_ANGLE_request_extension
bool ValidateRequestExtensionANGLE(const Context *context, const GLchar *name);
bool ValidateDisableExtensionANGLE(const Context *context, const GLchar *name);

// GL_ANGLE_robust_client_memory
bool ValidateGetBooleanvRobustANGLE(const Context *context,
                                    GLenum pname,
                                    GLsizei bufSize,
                                    const GLsizei *length,
                                    const GLboolean *params);
bool ValidateGetBufferParameterivRobustANGLE(const Context *context,
                                             BufferBinding targetPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLsizei *length,
                                             const GLint *params);
bool ValidateGetFloatvRobustANGLE(const Context *context,
                                  GLenum pname,
                                  GLsizei bufSize,
                                  const GLsizei *length,
                                  const GLfloat *params);
bool ValidateGetFramebufferAttachmentParameterivRobustANGLE(const Context *context,
                                                            GLenum target,
                                                            GLenum attachment,
                                                            GLenum pname,
                                                            GLsizei bufSize,
                                                            const GLsizei *length,
                                                            const GLint *params);
bool ValidateGetIntegervRobustANGLE(const Context *context,
                                    GLenum pname,
                                    GLsizei bufSize,
                                    const GLsizei *length,
                                    const GLint *data);
bool ValidateGetProgramivRobustANGLE(const Context *context,
                                     ShaderProgramID programPacked,
                                     GLenum pname,
                                     GLsizei bufSize,
                                     const GLsizei *length,
                                     const GLint *params);
bool ValidateGetRenderbufferParameterivRobustANGLE(const Context *context,
                                                   GLenum target,
                                                   GLenum pname,
                                                   GLsizei bufSize,
                                                   const GLsizei *length,
                                                   const GLint *params);
bool ValidateGetShaderivRobustANGLE(const Context *context,
                                    ShaderProgramID shaderPacked,
                                    GLenum pname,
                                    GLsizei bufSize,
                                    const GLsizei *length,
                                    const GLint *params);
bool ValidateGetTexParameterfvRobustANGLE(const Context *context,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          const GLsizei *length,
                                          const GLfloat *params);
bool ValidateGetTexParameterivRobustANGLE(const Context *context,
                                          TextureType targetPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          const GLsizei *length,
                                          const GLint *params);
bool ValidateGetUniformfvRobustANGLE(const Context *context,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei bufSize,
                                     const GLsizei *length,
                                     const GLfloat *params);
bool ValidateGetUniformivRobustANGLE(const Context *context,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei bufSize,
                                     const GLsizei *length,
                                     const GLint *params);
bool ValidateGetVertexAttribfvRobustANGLE(const Context *context,
                                          GLuint index,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          const GLsizei *length,
                                          const GLfloat *params);
bool ValidateGetVertexAttribivRobustANGLE(const Context *context,
                                          GLuint index,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          const GLsizei *length,
                                          const GLint *params);
bool ValidateGetVertexAttribPointervRobustANGLE(const Context *context,
                                                GLuint index,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                const GLsizei *length,
                                                void *const *pointer);
bool ValidateReadPixelsRobustANGLE(const Context *context,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   const GLsizei *length,
                                   const GLsizei *columns,
                                   const GLsizei *rows,
                                   const void *pixels);
bool ValidateTexImage2DRobustANGLE(const Context *context,
                                   TextureTarget targetPacked,
                                   GLint level,
                                   GLint internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLint border,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   const void *pixels);
bool ValidateTexParameterfvRobustANGLE(const Context *context,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       GLsizei bufSize,
                                       const GLfloat *params);
bool ValidateTexParameterivRobustANGLE(const Context *context,
                                       TextureType targetPacked,
                                       GLenum pname,
                                       GLsizei bufSize,
                                       const GLint *params);
bool ValidateTexSubImage2DRobustANGLE(const Context *context,
                                      TextureTarget targetPacked,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLenum format,
                                      GLenum type,
                                      GLsizei bufSize,
                                      const void *pixels);
bool ValidateTexImage3DRobustANGLE(const Context *context,
                                   TextureTarget targetPacked,
                                   GLint level,
                                   GLint internalformat,
                                   GLsizei width,
                                   GLsizei height,
                                   GLsizei depth,
                                   GLint border,
                                   GLenum format,
                                   GLenum type,
                                   GLsizei bufSize,
                                   const void *pixels);
bool ValidateTexSubImage3DRobustANGLE(const Context *context,
                                      TextureTarget targetPacked,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint zoffset,
                                      GLsizei width,
                                      GLsizei height,
                                      GLsizei depth,
                                      GLenum format,
                                      GLenum type,
                                      GLsizei bufSize,
                                      const void *pixels);
bool ValidateCompressedTexImage2DRobustANGLE(const Context *context,
                                             TextureTarget targetPacked,
                                             GLint level,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLint border,
                                             GLsizei imageSize,
                                             GLsizei dataSize,
                                             const GLvoid *data);
bool ValidateCompressedTexSubImage2DRobustANGLE(const Context *context,
                                                TextureTarget targetPacked,
                                                GLint level,
                                                GLsizei xoffset,
                                                GLsizei yoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLenum format,
                                                GLsizei imageSize,
                                                GLsizei dataSize,
                                                const GLvoid *data);
bool ValidateCompressedTexImage3DRobustANGLE(const Context *context,
                                             TextureTarget targetPacked,
                                             GLint level,
                                             GLenum internalformat,
                                             GLsizei width,
                                             GLsizei height,
                                             GLsizei depth,
                                             GLint border,
                                             GLsizei imageSize,
                                             GLsizei dataSize,
                                             const GLvoid *data);
bool ValidateCompressedTexSubImage3DRobustANGLE(const Context *context,
                                                TextureTarget targetPacked,
                                                GLint level,
                                                GLint xoffset,
                                                GLint yoffset,
                                                GLint zoffset,
                                                GLsizei width,
                                                GLsizei height,
                                                GLsizei depth,
                                                GLenum format,
                                                GLsizei imageSize,
                                                GLsizei dataSize,
                                                const GLvoid *data);
bool ValidateGetQueryivRobustANGLE(const Context *context,
                                   QueryType targetPacked,
                                   GLenum pname,
                                   GLsizei bufSize,
                                   const GLsizei *length,
                                   const GLint *params);
bool ValidateGetQueryObjectuivRobustANGLE(const Context *context,
                                          QueryID idPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          const GLsizei *length,
                                          const GLuint *params);
bool ValidateGetBufferPointervRobustANGLE(const Context *context,
                                          BufferBinding targetPacked,
                                          GLenum pname,
                                          GLsizei bufSize,
                                          const GLsizei *length,
                                          void *const *params);
bool ValidateGetIntegeri_vRobustANGLE(const Context *context,
                                      GLenum target,
                                      GLuint index,
                                      GLsizei bufSize,
                                      const GLsizei *length,
                                      const GLint *data);
bool ValidateGetInternalformativRobustANGLE(const Context *context,
                                            GLenum target,
                                            GLenum internalformat,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLsizei *length,
                                            const GLint *params);
bool ValidateGetVertexAttribIivRobustANGLE(const Context *context,
                                           GLuint index,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLsizei *length,
                                           const GLint *params);
bool ValidateGetVertexAttribIuivRobustANGLE(const Context *context,
                                            GLuint index,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLsizei *length,
                                            const GLuint *params);
bool ValidateGetUniformuivRobustANGLE(const Context *context,
                                      ShaderProgramID programPacked,
                                      UniformLocation locationPacked,
                                      GLsizei bufSize,
                                      const GLsizei *length,
                                      const GLuint *params);
bool ValidateGetActiveUniformBlockivRobustANGLE(const Context *context,
                                                ShaderProgramID programPacked,
                                                UniformBlockIndex uniformBlockIndexPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                const GLsizei *length,
                                                const GLint *params);
bool ValidateGetInteger64vRobustANGLE(const Context *context,
                                      GLenum pname,
                                      GLsizei bufSize,
                                      const GLsizei *length,
                                      const GLint64 *data);
bool ValidateGetInteger64i_vRobustANGLE(const Context *context,
                                        GLenum target,
                                        GLuint index,
                                        GLsizei bufSize,
                                        const GLsizei *length,
                                        const GLint64 *data);
bool ValidateGetBufferParameteri64vRobustANGLE(const Context *context,
                                               BufferBinding targetPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLsizei *length,
                                               const GLint64 *params);
bool ValidateSamplerParameterivRobustANGLE(const Context *context,
                                           SamplerID samplerPacked,
                                           GLuint pname,
                                           GLsizei bufSize,
                                           const GLint *param);
bool ValidateSamplerParameterfvRobustANGLE(const Context *context,
                                           SamplerID samplerPacked,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLfloat *param);
bool ValidateGetSamplerParameterivRobustANGLE(const Context *context,
                                              SamplerID samplerPacked,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLsizei *length,
                                              const GLint *params);
bool ValidateGetSamplerParameterfvRobustANGLE(const Context *context,
                                              SamplerID samplerPacked,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLsizei *length,
                                              const GLfloat *params);
bool ValidateGetFramebufferParameterivRobustANGLE(const Context *context,
                                                  GLenum target,
                                                  GLenum pname,
                                                  GLsizei bufSize,
                                                  const GLsizei *length,
                                                  const GLint *params);
bool ValidateGetProgramInterfaceivRobustANGLE(const Context *context,
                                              ShaderProgramID programPacked,
                                              GLenum programInterface,
                                              GLenum pname,
                                              GLsizei bufSize,
                                              const GLsizei *length,
                                              const GLint *params);
bool ValidateGetBooleani_vRobustANGLE(const Context *context,
                                      GLenum target,
                                      GLuint index,
                                      GLsizei bufSize,
                                      const GLsizei *length,
                                      const GLboolean *data);
bool ValidateGetMultisamplefvRobustANGLE(const Context *context,
                                         GLenum pname,
                                         GLuint index,
                                         GLsizei bufSize,
                                         const GLsizei *length,
                                         const GLfloat *val);
bool ValidateGetTexLevelParameterivRobustANGLE(const Context *context,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLsizei *length,
                                               const GLint *params);
bool ValidateGetTexLevelParameterfvRobustANGLE(const Context *context,
                                               TextureTarget targetPacked,
                                               GLint level,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLsizei *length,
                                               const GLfloat *params);
bool ValidateGetPointervRobustANGLERobustANGLE(const Context *context,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLsizei *length,
                                               void *const *params);
bool ValidateReadnPixelsRobustANGLE(const Context *context,
                                    GLint x,
                                    GLint y,
                                    GLsizei width,
                                    GLsizei height,
                                    GLenum format,
                                    GLenum type,
                                    GLsizei bufSize,
                                    const GLsizei *length,
                                    const GLsizei *columns,
                                    const GLsizei *rows,
                                    const void *data);
bool ValidateGetnUniformfvRobustANGLE(const Context *context,
                                      ShaderProgramID programPacked,
                                      UniformLocation locationPacked,
                                      GLsizei bufSize,
                                      const GLsizei *length,
                                      const GLfloat *params);
bool ValidateGetnUniformivRobustANGLE(const Context *context,
                                      ShaderProgramID programPacked,
                                      UniformLocation locationPacked,
                                      GLsizei bufSize,
                                      const GLsizei *length,
                                      const GLint *params);
bool ValidateGetnUniformuivRobustANGLE(const Context *context,
                                       ShaderProgramID programPacked,
                                       UniformLocation locationPacked,
                                       GLsizei bufSize,
                                       const GLsizei *length,
                                       const GLuint *params);
bool ValidateTexParameterIivRobustANGLE(const Context *context,
                                        TextureType targetPacked,
                                        GLenum pname,
                                        GLsizei bufSize,
                                        const GLint *params);
bool ValidateTexParameterIuivRobustANGLE(const Context *context,
                                         TextureType targetPacked,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         const GLuint *params);
bool ValidateGetTexParameterIivRobustANGLE(const Context *context,
                                           TextureType targetPacked,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLsizei *length,
                                           const GLint *params);
bool ValidateGetTexParameterIuivRobustANGLE(const Context *context,
                                            TextureType targetPacked,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLsizei *length,
                                            const GLuint *params);
bool ValidateSamplerParameterIivRobustANGLE(const Context *context,
                                            SamplerID samplerPacked,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLint *param);
bool ValidateSamplerParameterIuivRobustANGLE(const Context *context,
                                             SamplerID samplerPacked,
                                             GLenum pname,
                                             GLsizei bufSize,
                                             const GLuint *param);
bool ValidateGetSamplerParameterIivRobustANGLE(const Context *context,
                                               SamplerID samplerPacked,
                                               GLenum pname,
                                               GLsizei bufSize,
                                               const GLsizei *length,
                                               const GLint *params);
bool ValidateGetSamplerParameterIuivRobustANGLE(const Context *context,
                                                SamplerID samplerPacked,
                                                GLenum pname,
                                                GLsizei bufSize,
                                                const GLsizei *length,
                                                const GLuint *params);
bool ValidateGetQueryObjectivRobustANGLE(const Context *context,
                                         QueryID idPacked,
                                         GLenum pname,
                                         GLsizei bufSize,
                                         const GLsizei *length,
                                         const GLint *params);
bool ValidateGetQueryObjecti64vRobustANGLE(const Context *context,
                                           QueryID idPacked,
                                           GLenum pname,
                                           GLsizei bufSize,
                                           const GLsizei *length,
                                           const GLint64 *params);
bool ValidateGetQueryObjectui64vRobustANGLE(const Context *context,
                                            QueryID idPacked,
                                            GLenum pname,
                                            GLsizei bufSize,
                                            const GLsizei *length,
                                            const GLuint64 *params);

// GL_ANGLE_semaphore_fuchsia
bool ValidateImportSemaphoreZirconHandleANGLE(const Context *context,
                                              SemaphoreID semaphorePacked,
                                              HandleType handleTypePacked,
                                              GLuint handle);

// GL_ANGLE_texture_external_update
bool ValidateTexImage2DExternalANGLE(const Context *context,
                                     TextureTarget targetPacked,
                                     GLint level,
                                     GLint internalformat,
                                     GLsizei width,
                                     GLsizei height,
                                     GLint border,
                                     GLenum format,
                                     GLenum type);
bool ValidateInvalidateTextureANGLE(const Context *context, TextureType targetPacked);

// GL_ANGLE_texture_multisample
bool ValidateTexStorage2DMultisampleANGLE(const Context *context,
                                          TextureType targetPacked,
                                          GLsizei samples,
                                          GLenum internalformat,
                                          GLsizei width,
                                          GLsizei height,
                                          GLboolean fixedsamplelocations);
bool ValidateGetMultisamplefvANGLE(const Context *context,
                                   GLenum pname,
                                   GLuint index,
                                   const GLfloat *val);
bool ValidateSampleMaskiANGLE(const Context *context, GLuint maskNumber, GLbitfield mask);

// GL_ANGLE_translated_shader_source
bool ValidateGetTranslatedShaderSourceANGLE(const Context *context,
                                            ShaderProgramID shaderPacked,
                                            GLsizei bufsize,
                                            const GLsizei *length,
                                            const GLchar *source);

// GL_CHROMIUM_bind_uniform_location
bool ValidateBindUniformLocationCHROMIUM(const Context *context,
                                         ShaderProgramID programPacked,
                                         UniformLocation locationPacked,
                                         const GLchar *name);

// GL_CHROMIUM_copy_compressed_texture
bool ValidateCompressedCopyTextureCHROMIUM(const Context *context,
                                           TextureID sourceIdPacked,
                                           TextureID destIdPacked);

// GL_CHROMIUM_copy_texture
bool ValidateCopyTextureCHROMIUM(const Context *context,
                                 TextureID sourceIdPacked,
                                 GLint sourceLevel,
                                 TextureTarget destTargetPacked,
                                 TextureID destIdPacked,
                                 GLint destLevel,
                                 GLint internalFormat,
                                 GLenum destType,
                                 GLboolean unpackFlipY,
                                 GLboolean unpackPremultiplyAlpha,
                                 GLboolean unpackUnmultiplyAlpha);
bool ValidateCopySubTextureCHROMIUM(const Context *context,
                                    TextureID sourceIdPacked,
                                    GLint sourceLevel,
                                    TextureTarget destTargetPacked,
                                    TextureID destIdPacked,
                                    GLint destLevel,
                                    GLint xoffset,
                                    GLint yoffset,
                                    GLint x,
                                    GLint y,
                                    GLint width,
                                    GLint height,
                                    GLboolean unpackFlipY,
                                    GLboolean unpackPremultiplyAlpha,
                                    GLboolean unpackUnmultiplyAlpha);

// GL_CHROMIUM_framebuffer_mixed_samples
bool ValidateCoverageModulationCHROMIUM(const Context *context, GLenum components);

// GL_CHROMIUM_lose_context
bool ValidateLoseContextCHROMIUM(const Context *context,
                                 GraphicsResetStatus currentPacked,
                                 GraphicsResetStatus otherPacked);

// GL_EXT_EGL_image_array

// GL_EXT_YUV_target

// GL_EXT_blend_func_extended
bool ValidateBindFragDataLocationEXT(const Context *context,
                                     ShaderProgramID programPacked,
                                     GLuint color,
                                     const GLchar *name);
bool ValidateBindFragDataLocationIndexedEXT(const Context *context,
                                            ShaderProgramID programPacked,
                                            GLuint colorNumber,
                                            GLuint index,
                                            const GLchar *name);
bool ValidateGetFragDataIndexEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 const GLchar *name);
bool ValidateGetProgramResourceLocationIndexEXT(const Context *context,
                                                ShaderProgramID programPacked,
                                                GLenum programInterface,
                                                const GLchar *name);

// GL_EXT_buffer_storage
bool ValidateBufferStorageEXT(const Context *context,
                              BufferBinding targetPacked,
                              GLsizeiptr size,
                              const void *data,
                              GLbitfield flags);

// GL_EXT_clip_control
bool ValidateClipControlEXT(const Context *context, GLenum origin, GLenum depth);

// GL_EXT_copy_image
bool ValidateCopyImageSubDataEXT(const Context *context,
                                 GLuint srcName,
                                 GLenum srcTarget,
                                 GLint srcLevel,
                                 GLint srcX,
                                 GLint srcY,
                                 GLint srcZ,
                                 GLuint dstName,
                                 GLenum dstTarget,
                                 GLint dstLevel,
                                 GLint dstX,
                                 GLint dstY,
                                 GLint dstZ,
                                 GLsizei srcWidth,
                                 GLsizei srcHeight,
                                 GLsizei srcDepth);

// GL_EXT_debug_label
bool ValidateGetObjectLabelEXT(const Context *context,
                               GLenum type,
                               GLuint object,
                               GLsizei bufSize,
                               const GLsizei *length,
                               const GLchar *label);
bool ValidateLabelObjectEXT(const Context *context,
                            GLenum type,
                            GLuint object,
                            GLsizei length,
                            const GLchar *label);

// GL_EXT_debug_marker
bool ValidateInsertEventMarkerEXT(const Context *context, GLsizei length, const GLchar *marker);
bool ValidatePopGroupMarkerEXT(const Context *context);
bool ValidatePushGroupMarkerEXT(const Context *context, GLsizei length, const GLchar *marker);

// GL_EXT_discard_framebuffer
bool ValidateDiscardFramebufferEXT(const Context *context,
                                   GLenum target,
                                   GLsizei numAttachments,
                                   const GLenum *attachments);

// GL_EXT_disjoint_timer_query
bool ValidateBeginQueryEXT(const Context *context, QueryType targetPacked, QueryID idPacked);
bool ValidateDeleteQueriesEXT(const Context *context, GLsizei n, const QueryID *idsPacked);
bool ValidateEndQueryEXT(const Context *context, QueryType targetPacked);
bool ValidateGenQueriesEXT(const Context *context, GLsizei n, const QueryID *idsPacked);
bool ValidateGetInteger64vEXT(const Context *context, GLenum pname, const GLint64 *data);
bool ValidateGetQueryObjecti64vEXT(const Context *context,
                                   QueryID idPacked,
                                   GLenum pname,
                                   const GLint64 *params);
bool ValidateGetQueryObjectivEXT(const Context *context,
                                 QueryID idPacked,
                                 GLenum pname,
                                 const GLint *params);
bool ValidateGetQueryObjectui64vEXT(const Context *context,
                                    QueryID idPacked,
                                    GLenum pname,
                                    const GLuint64 *params);
bool ValidateGetQueryObjectuivEXT(const Context *context,
                                  QueryID idPacked,
                                  GLenum pname,
                                  const GLuint *params);
bool ValidateGetQueryivEXT(const Context *context,
                           QueryType targetPacked,
                           GLenum pname,
                           const GLint *params);
bool ValidateIsQueryEXT(const Context *context, QueryID idPacked);
bool ValidateQueryCounterEXT(const Context *context, QueryID idPacked, QueryType targetPacked);

// GL_EXT_draw_buffers
bool ValidateDrawBuffersEXT(const Context *context, GLsizei n, const GLenum *bufs);

// GL_EXT_draw_buffers_indexed
bool ValidateBlendEquationSeparateiEXT(const Context *context,
                                       GLuint buf,
                                       GLenum modeRGB,
                                       GLenum modeAlpha);
bool ValidateBlendEquationiEXT(const Context *context, GLuint buf, GLenum mode);
bool ValidateBlendFuncSeparateiEXT(const Context *context,
                                   GLuint buf,
                                   GLenum srcRGB,
                                   GLenum dstRGB,
                                   GLenum srcAlpha,
                                   GLenum dstAlpha);
bool ValidateBlendFunciEXT(const Context *context, GLuint buf, GLenum src, GLenum dst);
bool ValidateColorMaskiEXT(const Context *context,
                           GLuint index,
                           GLboolean r,
                           GLboolean g,
                           GLboolean b,
                           GLboolean a);
bool ValidateDisableiEXT(const Context *context, GLenum target, GLuint index);
bool ValidateEnableiEXT(const Context *context, GLenum target, GLuint index);
bool ValidateIsEnablediEXT(const Context *context, GLenum target, GLuint index);

// GL_EXT_draw_elements_base_vertex
bool ValidateDrawElementsBaseVertexEXT(const Context *context,
                                       PrimitiveMode modePacked,
                                       GLsizei count,
                                       DrawElementsType typePacked,
                                       const void *indices,
                                       GLint basevertex);
bool ValidateDrawElementsInstancedBaseVertexEXT(const Context *context,
                                                PrimitiveMode modePacked,
                                                GLsizei count,
                                                DrawElementsType typePacked,
                                                const void *indices,
                                                GLsizei instancecount,
                                                GLint basevertex);
bool ValidateDrawRangeElementsBaseVertexEXT(const Context *context,
                                            PrimitiveMode modePacked,
                                            GLuint start,
                                            GLuint end,
                                            GLsizei count,
                                            DrawElementsType typePacked,
                                            const void *indices,
                                            GLint basevertex);
bool ValidateMultiDrawElementsBaseVertexEXT(const Context *context,
                                            PrimitiveMode modePacked,
                                            const GLsizei *count,
                                            DrawElementsType typePacked,
                                            const void *const *indices,
                                            GLsizei primcount,
                                            const GLint *basevertex);

// GL_EXT_external_buffer
bool ValidateBufferStorageExternalEXT(const Context *context,
                                      BufferBinding targetPacked,
                                      GLintptr offset,
                                      GLsizeiptr size,
                                      GLeglClientBufferEXT clientBuffer,
                                      GLbitfield flags);
bool ValidateNamedBufferStorageExternalEXT(const Context *context,
                                           GLuint buffer,
                                           GLintptr offset,
                                           GLsizeiptr size,
                                           GLeglClientBufferEXT clientBuffer,
                                           GLbitfield flags);

// GL_EXT_geometry_shader
bool ValidateFramebufferTextureEXT(const Context *context,
                                   GLenum target,
                                   GLenum attachment,
                                   TextureID texturePacked,
                                   GLint level);

// GL_EXT_instanced_arrays
bool ValidateDrawArraysInstancedEXT(const Context *context,
                                    PrimitiveMode modePacked,
                                    GLint start,
                                    GLsizei count,
                                    GLsizei primcount);
bool ValidateDrawElementsInstancedEXT(const Context *context,
                                      PrimitiveMode modePacked,
                                      GLsizei count,
                                      DrawElementsType typePacked,
                                      const void *indices,
                                      GLsizei primcount);
bool ValidateVertexAttribDivisorEXT(const Context *context, GLuint index, GLuint divisor);

// GL_EXT_map_buffer_range
bool ValidateFlushMappedBufferRangeEXT(const Context *context,
                                       BufferBinding targetPacked,
                                       GLintptr offset,
                                       GLsizeiptr length);
bool ValidateMapBufferRangeEXT(const Context *context,
                               BufferBinding targetPacked,
                               GLintptr offset,
                               GLsizeiptr length,
                               GLbitfield access);

// GL_EXT_memory_object
bool ValidateBufferStorageMemEXT(const Context *context,
                                 TextureType targetPacked,
                                 GLsizeiptr size,
                                 MemoryObjectID memoryPacked,
                                 GLuint64 offset);
bool ValidateCreateMemoryObjectsEXT(const Context *context,
                                    GLsizei n,
                                    const MemoryObjectID *memoryObjectsPacked);
bool ValidateDeleteMemoryObjectsEXT(const Context *context,
                                    GLsizei n,
                                    const MemoryObjectID *memoryObjectsPacked);
bool ValidateGetMemoryObjectParameterivEXT(const Context *context,
                                           MemoryObjectID memoryObjectPacked,
                                           GLenum pname,
                                           const GLint *params);
bool ValidateGetUnsignedBytevEXT(const Context *context, GLenum pname, const GLubyte *data);
bool ValidateGetUnsignedBytei_vEXT(const Context *context,
                                   GLenum target,
                                   GLuint index,
                                   const GLubyte *data);
bool ValidateIsMemoryObjectEXT(const Context *context, MemoryObjectID memoryObjectPacked);
bool ValidateMemoryObjectParameterivEXT(const Context *context,
                                        MemoryObjectID memoryObjectPacked,
                                        GLenum pname,
                                        const GLint *params);
bool ValidateTexStorageMem2DEXT(const Context *context,
                                TextureType targetPacked,
                                GLsizei levels,
                                GLenum internalFormat,
                                GLsizei width,
                                GLsizei height,
                                MemoryObjectID memoryPacked,
                                GLuint64 offset);
bool ValidateTexStorageMem2DMultisampleEXT(const Context *context,
                                           TextureType targetPacked,
                                           GLsizei samples,
                                           GLenum internalFormat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLboolean fixedSampleLocations,
                                           MemoryObjectID memoryPacked,
                                           GLuint64 offset);
bool ValidateTexStorageMem3DEXT(const Context *context,
                                TextureType targetPacked,
                                GLsizei levels,
                                GLenum internalFormat,
                                GLsizei width,
                                GLsizei height,
                                GLsizei depth,
                                MemoryObjectID memoryPacked,
                                GLuint64 offset);
bool ValidateTexStorageMem3DMultisampleEXT(const Context *context,
                                           TextureType targetPacked,
                                           GLsizei samples,
                                           GLenum internalFormat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLboolean fixedSampleLocations,
                                           MemoryObjectID memoryPacked,
                                           GLuint64 offset);

// GL_EXT_memory_object_fd
bool ValidateImportMemoryFdEXT(const Context *context,
                               MemoryObjectID memoryPacked,
                               GLuint64 size,
                               HandleType handleTypePacked,
                               GLint fd);

// GL_EXT_multisampled_render_to_texture
bool ValidateFramebufferTexture2DMultisampleEXT(const Context *context,
                                                GLenum target,
                                                GLenum attachment,
                                                TextureTarget textargetPacked,
                                                TextureID texturePacked,
                                                GLint level,
                                                GLsizei samples);
bool ValidateRenderbufferStorageMultisampleEXT(const Context *context,
                                               GLenum target,
                                               GLsizei samples,
                                               GLenum internalformat,
                                               GLsizei width,
                                               GLsizei height);

// GL_EXT_occlusion_query_boolean

// GL_EXT_primitive_bounding_box
bool ValidatePrimitiveBoundingBoxEXT(const Context *context,
                                     GLfloat minX,
                                     GLfloat minY,
                                     GLfloat minZ,
                                     GLfloat minW,
                                     GLfloat maxX,
                                     GLfloat maxY,
                                     GLfloat maxZ,
                                     GLfloat maxW);

// GL_EXT_read_format_bgra

// GL_EXT_robustness
bool ValidateGetGraphicsResetStatusEXT(const Context *context);
bool ValidateGetnUniformfvEXT(const Context *context,
                              ShaderProgramID programPacked,
                              UniformLocation locationPacked,
                              GLsizei bufSize,
                              const GLfloat *params);
bool ValidateGetnUniformivEXT(const Context *context,
                              ShaderProgramID programPacked,
                              UniformLocation locationPacked,
                              GLsizei bufSize,
                              const GLint *params);
bool ValidateReadnPixelsEXT(const Context *context,
                            GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height,
                            GLenum format,
                            GLenum type,
                            GLsizei bufSize,
                            const void *data);

// GL_EXT_sRGB

// GL_EXT_semaphore
bool ValidateDeleteSemaphoresEXT(const Context *context,
                                 GLsizei n,
                                 const SemaphoreID *semaphoresPacked);
bool ValidateGenSemaphoresEXT(const Context *context,
                              GLsizei n,
                              const SemaphoreID *semaphoresPacked);
bool ValidateGetSemaphoreParameterui64vEXT(const Context *context,
                                           SemaphoreID semaphorePacked,
                                           GLenum pname,
                                           const GLuint64 *params);
bool ValidateIsSemaphoreEXT(const Context *context, SemaphoreID semaphorePacked);
bool ValidateSemaphoreParameterui64vEXT(const Context *context,
                                        SemaphoreID semaphorePacked,
                                        GLenum pname,
                                        const GLuint64 *params);
bool ValidateSignalSemaphoreEXT(const Context *context,
                                SemaphoreID semaphorePacked,
                                GLuint numBufferBarriers,
                                const BufferID *buffersPacked,
                                GLuint numTextureBarriers,
                                const TextureID *texturesPacked,
                                const GLenum *dstLayouts);
bool ValidateWaitSemaphoreEXT(const Context *context,
                              SemaphoreID semaphorePacked,
                              GLuint numBufferBarriers,
                              const BufferID *buffersPacked,
                              GLuint numTextureBarriers,
                              const TextureID *texturesPacked,
                              const GLenum *srcLayouts);

// GL_EXT_semaphore_fd
bool ValidateImportSemaphoreFdEXT(const Context *context,
                                  SemaphoreID semaphorePacked,
                                  HandleType handleTypePacked,
                                  GLint fd);

// GL_EXT_separate_shader_objects
bool ValidateActiveShaderProgramEXT(const Context *context,
                                    ProgramPipelineID pipelinePacked,
                                    ShaderProgramID programPacked);
bool ValidateBindProgramPipelineEXT(const Context *context, ProgramPipelineID pipelinePacked);
bool ValidateCreateShaderProgramvEXT(const Context *context,
                                     ShaderType typePacked,
                                     GLsizei count,
                                     const GLchar **strings);
bool ValidateDeleteProgramPipelinesEXT(const Context *context,
                                       GLsizei n,
                                       const ProgramPipelineID *pipelinesPacked);
bool ValidateGenProgramPipelinesEXT(const Context *context,
                                    GLsizei n,
                                    const ProgramPipelineID *pipelinesPacked);
bool ValidateGetProgramPipelineInfoLogEXT(const Context *context,
                                          ProgramPipelineID pipelinePacked,
                                          GLsizei bufSize,
                                          const GLsizei *length,
                                          const GLchar *infoLog);
bool ValidateGetProgramPipelineivEXT(const Context *context,
                                     ProgramPipelineID pipelinePacked,
                                     GLenum pname,
                                     const GLint *params);
bool ValidateIsProgramPipelineEXT(const Context *context, ProgramPipelineID pipelinePacked);
bool ValidateProgramParameteriEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  GLenum pname,
                                  GLint value);
bool ValidateProgramUniform1fEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLfloat v0);
bool ValidateProgramUniform1fvEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLfloat *value);
bool ValidateProgramUniform1iEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLint v0);
bool ValidateProgramUniform1ivEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLint *value);
bool ValidateProgramUniform1uiEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLuint v0);
bool ValidateProgramUniform1uivEXT(const Context *context,
                                   ShaderProgramID programPacked,
                                   UniformLocation locationPacked,
                                   GLsizei count,
                                   const GLuint *value);
bool ValidateProgramUniform2fEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLfloat v0,
                                 GLfloat v1);
bool ValidateProgramUniform2fvEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLfloat *value);
bool ValidateProgramUniform2iEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLint v0,
                                 GLint v1);
bool ValidateProgramUniform2ivEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLint *value);
bool ValidateProgramUniform2uiEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLuint v0,
                                  GLuint v1);
bool ValidateProgramUniform2uivEXT(const Context *context,
                                   ShaderProgramID programPacked,
                                   UniformLocation locationPacked,
                                   GLsizei count,
                                   const GLuint *value);
bool ValidateProgramUniform3fEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLfloat v0,
                                 GLfloat v1,
                                 GLfloat v2);
bool ValidateProgramUniform3fvEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLfloat *value);
bool ValidateProgramUniform3iEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLint v0,
                                 GLint v1,
                                 GLint v2);
bool ValidateProgramUniform3ivEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLint *value);
bool ValidateProgramUniform3uiEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLuint v0,
                                  GLuint v1,
                                  GLuint v2);
bool ValidateProgramUniform3uivEXT(const Context *context,
                                   ShaderProgramID programPacked,
                                   UniformLocation locationPacked,
                                   GLsizei count,
                                   const GLuint *value);
bool ValidateProgramUniform4fEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLfloat v0,
                                 GLfloat v1,
                                 GLfloat v2,
                                 GLfloat v3);
bool ValidateProgramUniform4fvEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLfloat *value);
bool ValidateProgramUniform4iEXT(const Context *context,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLint v0,
                                 GLint v1,
                                 GLint v2,
                                 GLint v3);
bool ValidateProgramUniform4ivEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLsizei count,
                                  const GLint *value);
bool ValidateProgramUniform4uiEXT(const Context *context,
                                  ShaderProgramID programPacked,
                                  UniformLocation locationPacked,
                                  GLuint v0,
                                  GLuint v1,
                                  GLuint v2,
                                  GLuint v3);
bool ValidateProgramUniform4uivEXT(const Context *context,
                                   ShaderProgramID programPacked,
                                   UniformLocation locationPacked,
                                   GLsizei count,
                                   const GLuint *value);
bool ValidateProgramUniformMatrix2fvEXT(const Context *context,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        GLboolean transpose,
                                        const GLfloat *value);
bool ValidateProgramUniformMatrix2x3fvEXT(const Context *context,
                                          ShaderProgramID programPacked,
                                          UniformLocation locationPacked,
                                          GLsizei count,
                                          GLboolean transpose,
                                          const GLfloat *value);
bool ValidateProgramUniformMatrix2x4fvEXT(const Context *context,
                                          ShaderProgramID programPacked,
                                          UniformLocation locationPacked,
                                          GLsizei count,
                                          GLboolean transpose,
                                          const GLfloat *value);
bool ValidateProgramUniformMatrix3fvEXT(const Context *context,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        GLboolean transpose,
                                        const GLfloat *value);
bool ValidateProgramUniformMatrix3x2fvEXT(const Context *context,
                                          ShaderProgramID programPacked,
                                          UniformLocation locationPacked,
                                          GLsizei count,
                                          GLboolean transpose,
                                          const GLfloat *value);
bool ValidateProgramUniformMatrix3x4fvEXT(const Context *context,
                                          ShaderProgramID programPacked,
                                          UniformLocation locationPacked,
                                          GLsizei count,
                                          GLboolean transpose,
                                          const GLfloat *value);
bool ValidateProgramUniformMatrix4fvEXT(const Context *context,
                                        ShaderProgramID programPacked,
                                        UniformLocation locationPacked,
                                        GLsizei count,
                                        GLboolean transpose,
                                        const GLfloat *value);
bool ValidateProgramUniformMatrix4x2fvEXT(const Context *context,
                                          ShaderProgramID programPacked,
                                          UniformLocation locationPacked,
                                          GLsizei count,
                                          GLboolean transpose,
                                          const GLfloat *value);
bool ValidateProgramUniformMatrix4x3fvEXT(const Context *context,
                                          ShaderProgramID programPacked,
                                          UniformLocation locationPacked,
                                          GLsizei count,
                                          GLboolean transpose,
                                          const GLfloat *value);
bool ValidateUseProgramStagesEXT(const Context *context,
                                 ProgramPipelineID pipelinePacked,
                                 GLbitfield stages,
                                 ShaderProgramID programPacked);
bool ValidateValidateProgramPipelineEXT(const Context *context, ProgramPipelineID pipelinePacked);

// GL_EXT_shader_framebuffer_fetch_non_coherent
bool ValidateFramebufferFetchBarrierEXT(const Context *context);

// GL_EXT_shader_io_blocks

// GL_EXT_tessellation_shader
bool ValidatePatchParameteriEXT(const Context *context, GLenum pname, GLint value);

// GL_EXT_texture_border_clamp
bool ValidateGetSamplerParameterIivEXT(const Context *context,
                                       SamplerID samplerPacked,
                                       GLenum pname,
                                       const GLint *params);
bool ValidateGetSamplerParameterIuivEXT(const Context *context,
                                        SamplerID samplerPacked,
                                        GLenum pname,
                                        const GLuint *params);
bool ValidateGetTexParameterIivEXT(const Context *context,
                                   TextureType targetPacked,
                                   GLenum pname,
                                   const GLint *params);
bool ValidateGetTexParameterIuivEXT(const Context *context,
                                    TextureType targetPacked,
                                    GLenum pname,
                                    const GLuint *params);
bool ValidateSamplerParameterIivEXT(const Context *context,
                                    SamplerID samplerPacked,
                                    GLenum pname,
                                    const GLint *param);
bool ValidateSamplerParameterIuivEXT(const Context *context,
                                     SamplerID samplerPacked,
                                     GLenum pname,
                                     const GLuint *param);
bool ValidateTexParameterIivEXT(const Context *context,
                                TextureType targetPacked,
                                GLenum pname,
                                const GLint *params);
bool ValidateTexParameterIuivEXT(const Context *context,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 const GLuint *params);

// GL_EXT_texture_buffer
bool ValidateTexBufferEXT(const Context *context,
                          TextureType targetPacked,
                          GLenum internalformat,
                          BufferID bufferPacked);
bool ValidateTexBufferRangeEXT(const Context *context,
                               TextureType targetPacked,
                               GLenum internalformat,
                               BufferID bufferPacked,
                               GLintptr offset,
                               GLsizeiptr size);

// GL_EXT_texture_compression_bptc

// GL_EXT_texture_compression_dxt1

// GL_EXT_texture_compression_rgtc

// GL_EXT_texture_compression_s3tc

// GL_EXT_texture_compression_s3tc_srgb

// GL_EXT_texture_cube_map_array

// GL_EXT_texture_filter_anisotropic

// GL_EXT_texture_format_BGRA8888

// GL_EXT_texture_sRGB_R8

// GL_EXT_texture_sRGB_RG8

// GL_EXT_texture_storage
bool ValidateTexStorage1DEXT(const Context *context,
                             GLenum target,
                             GLsizei levels,
                             GLenum internalformat,
                             GLsizei width);
bool ValidateTexStorage2DEXT(const Context *context,
                             TextureType targetPacked,
                             GLsizei levels,
                             GLenum internalformat,
                             GLsizei width,
                             GLsizei height);
bool ValidateTexStorage3DEXT(const Context *context,
                             TextureType targetPacked,
                             GLsizei levels,
                             GLenum internalformat,
                             GLsizei width,
                             GLsizei height,
                             GLsizei depth);

// GL_KHR_blend_equation_advanced
bool ValidateBlendBarrierKHR(const Context *context);

// GL_KHR_debug
bool ValidateDebugMessageCallbackKHR(const Context *context,
                                     GLDEBUGPROCKHR callback,
                                     const void *userParam);
bool ValidateDebugMessageControlKHR(const Context *context,
                                    GLenum source,
                                    GLenum type,
                                    GLenum severity,
                                    GLsizei count,
                                    const GLuint *ids,
                                    GLboolean enabled);
bool ValidateDebugMessageInsertKHR(const Context *context,
                                   GLenum source,
                                   GLenum type,
                                   GLuint id,
                                   GLenum severity,
                                   GLsizei length,
                                   const GLchar *buf);
bool ValidateGetDebugMessageLogKHR(const Context *context,
                                   GLuint count,
                                   GLsizei bufSize,
                                   const GLenum *sources,
                                   const GLenum *types,
                                   const GLuint *ids,
                                   const GLenum *severities,
                                   const GLsizei *lengths,
                                   const GLchar *messageLog);
bool ValidateGetObjectLabelKHR(const Context *context,
                               GLenum identifier,
                               GLuint name,
                               GLsizei bufSize,
                               const GLsizei *length,
                               const GLchar *label);
bool ValidateGetObjectPtrLabelKHR(const Context *context,
                                  const void *ptr,
                                  GLsizei bufSize,
                                  const GLsizei *length,
                                  const GLchar *label);
bool ValidateGetPointervKHR(const Context *context, GLenum pname, void *const *params);
bool ValidateObjectLabelKHR(const Context *context,
                            GLenum identifier,
                            GLuint name,
                            GLsizei length,
                            const GLchar *label);
bool ValidateObjectPtrLabelKHR(const Context *context,
                               const void *ptr,
                               GLsizei length,
                               const GLchar *label);
bool ValidatePopDebugGroupKHR(const Context *context);
bool ValidatePushDebugGroupKHR(const Context *context,
                               GLenum source,
                               GLuint id,
                               GLsizei length,
                               const GLchar *message);

// GL_KHR_parallel_shader_compile
bool ValidateMaxShaderCompilerThreadsKHR(const Context *context, GLuint count);

// GL_NV_fence
bool ValidateDeleteFencesNV(const Context *context, GLsizei n, const FenceNVID *fencesPacked);
bool ValidateFinishFenceNV(const Context *context, FenceNVID fencePacked);
bool ValidateGenFencesNV(const Context *context, GLsizei n, const FenceNVID *fencesPacked);
bool ValidateGetFenceivNV(const Context *context,
                          FenceNVID fencePacked,
                          GLenum pname,
                          const GLint *params);
bool ValidateIsFenceNV(const Context *context, FenceNVID fencePacked);
bool ValidateSetFenceNV(const Context *context, FenceNVID fencePacked, GLenum condition);
bool ValidateTestFenceNV(const Context *context, FenceNVID fencePacked);

// GL_NV_framebuffer_blit
bool ValidateBlitFramebufferNV(const Context *context,
                               GLint srcX0,
                               GLint srcY0,
                               GLint srcX1,
                               GLint srcY1,
                               GLint dstX0,
                               GLint dstY0,
                               GLint dstX1,
                               GLint dstY1,
                               GLbitfield mask,
                               GLenum filter);

// GL_OES_EGL_image
bool ValidateEGLImageTargetRenderbufferStorageOES(const Context *context,
                                                  GLenum target,
                                                  GLeglImageOES image);
bool ValidateEGLImageTargetTexture2DOES(const Context *context,
                                        TextureType targetPacked,
                                        GLeglImageOES image);

// GL_OES_compressed_ETC1_RGB8_texture

// GL_OES_copy_image
bool ValidateCopyImageSubDataOES(const Context *context,
                                 GLuint srcName,
                                 GLenum srcTarget,
                                 GLint srcLevel,
                                 GLint srcX,
                                 GLint srcY,
                                 GLint srcZ,
                                 GLuint dstName,
                                 GLenum dstTarget,
                                 GLint dstLevel,
                                 GLint dstX,
                                 GLint dstY,
                                 GLint dstZ,
                                 GLsizei srcWidth,
                                 GLsizei srcHeight,
                                 GLsizei srcDepth);

// GL_OES_depth32

// GL_OES_draw_buffers_indexed
bool ValidateBlendEquationSeparateiOES(const Context *context,
                                       GLuint buf,
                                       GLenum modeRGB,
                                       GLenum modeAlpha);
bool ValidateBlendEquationiOES(const Context *context, GLuint buf, GLenum mode);
bool ValidateBlendFuncSeparateiOES(const Context *context,
                                   GLuint buf,
                                   GLenum srcRGB,
                                   GLenum dstRGB,
                                   GLenum srcAlpha,
                                   GLenum dstAlpha);
bool ValidateBlendFunciOES(const Context *context, GLuint buf, GLenum src, GLenum dst);
bool ValidateColorMaskiOES(const Context *context,
                           GLuint index,
                           GLboolean r,
                           GLboolean g,
                           GLboolean b,
                           GLboolean a);
bool ValidateDisableiOES(const Context *context, GLenum target, GLuint index);
bool ValidateEnableiOES(const Context *context, GLenum target, GLuint index);
bool ValidateIsEnablediOES(const Context *context, GLenum target, GLuint index);

// GL_OES_draw_elements_base_vertex
bool ValidateDrawElementsBaseVertexOES(const Context *context,
                                       PrimitiveMode modePacked,
                                       GLsizei count,
                                       DrawElementsType typePacked,
                                       const void *indices,
                                       GLint basevertex);
bool ValidateDrawElementsInstancedBaseVertexOES(const Context *context,
                                                PrimitiveMode modePacked,
                                                GLsizei count,
                                                DrawElementsType typePacked,
                                                const void *indices,
                                                GLsizei instancecount,
                                                GLint basevertex);
bool ValidateDrawRangeElementsBaseVertexOES(const Context *context,
                                            PrimitiveMode modePacked,
                                            GLuint start,
                                            GLuint end,
                                            GLsizei count,
                                            DrawElementsType typePacked,
                                            const void *indices,
                                            GLint basevertex);

// GL_OES_draw_texture
bool ValidateDrawTexfOES(const Context *context,
                         GLfloat x,
                         GLfloat y,
                         GLfloat z,
                         GLfloat width,
                         GLfloat height);
bool ValidateDrawTexfvOES(const Context *context, const GLfloat *coords);
bool ValidateDrawTexiOES(const Context *context,
                         GLint x,
                         GLint y,
                         GLint z,
                         GLint width,
                         GLint height);
bool ValidateDrawTexivOES(const Context *context, const GLint *coords);
bool ValidateDrawTexsOES(const Context *context,
                         GLshort x,
                         GLshort y,
                         GLshort z,
                         GLshort width,
                         GLshort height);
bool ValidateDrawTexsvOES(const Context *context, const GLshort *coords);
bool ValidateDrawTexxOES(const Context *context,
                         GLfixed x,
                         GLfixed y,
                         GLfixed z,
                         GLfixed width,
                         GLfixed height);
bool ValidateDrawTexxvOES(const Context *context, const GLfixed *coords);

// GL_OES_framebuffer_object
bool ValidateBindFramebufferOES(const Context *context,
                                GLenum target,
                                FramebufferID framebufferPacked);
bool ValidateBindRenderbufferOES(const Context *context,
                                 GLenum target,
                                 RenderbufferID renderbufferPacked);
bool ValidateCheckFramebufferStatusOES(const Context *context, GLenum target);
bool ValidateDeleteFramebuffersOES(const Context *context,
                                   GLsizei n,
                                   const FramebufferID *framebuffersPacked);
bool ValidateDeleteRenderbuffersOES(const Context *context,
                                    GLsizei n,
                                    const RenderbufferID *renderbuffersPacked);
bool ValidateFramebufferRenderbufferOES(const Context *context,
                                        GLenum target,
                                        GLenum attachment,
                                        GLenum renderbuffertarget,
                                        RenderbufferID renderbufferPacked);
bool ValidateFramebufferTexture2DOES(const Context *context,
                                     GLenum target,
                                     GLenum attachment,
                                     TextureTarget textargetPacked,
                                     TextureID texturePacked,
                                     GLint level);
bool ValidateGenFramebuffersOES(const Context *context,
                                GLsizei n,
                                const FramebufferID *framebuffersPacked);
bool ValidateGenRenderbuffersOES(const Context *context,
                                 GLsizei n,
                                 const RenderbufferID *renderbuffersPacked);
bool ValidateGenerateMipmapOES(const Context *context, TextureType targetPacked);
bool ValidateGetFramebufferAttachmentParameterivOES(const Context *context,
                                                    GLenum target,
                                                    GLenum attachment,
                                                    GLenum pname,
                                                    const GLint *params);
bool ValidateGetRenderbufferParameterivOES(const Context *context,
                                           GLenum target,
                                           GLenum pname,
                                           const GLint *params);
bool ValidateIsFramebufferOES(const Context *context, FramebufferID framebufferPacked);
bool ValidateIsRenderbufferOES(const Context *context, RenderbufferID renderbufferPacked);
bool ValidateRenderbufferStorageOES(const Context *context,
                                    GLenum target,
                                    GLenum internalformat,
                                    GLsizei width,
                                    GLsizei height);

// GL_OES_get_program_binary
bool ValidateGetProgramBinaryOES(const Context *context,
                                 ShaderProgramID programPacked,
                                 GLsizei bufSize,
                                 const GLsizei *length,
                                 const GLenum *binaryFormat,
                                 const void *binary);
bool ValidateProgramBinaryOES(const Context *context,
                              ShaderProgramID programPacked,
                              GLenum binaryFormat,
                              const void *binary,
                              GLint length);

// GL_OES_mapbuffer
bool ValidateGetBufferPointervOES(const Context *context,
                                  BufferBinding targetPacked,
                                  GLenum pname,
                                  void *const *params);
bool ValidateMapBufferOES(const Context *context, BufferBinding targetPacked, GLenum access);
bool ValidateUnmapBufferOES(const Context *context, BufferBinding targetPacked);

// GL_OES_matrix_palette
bool ValidateCurrentPaletteMatrixOES(const Context *context, GLuint matrixpaletteindex);
bool ValidateLoadPaletteFromModelViewMatrixOES(const Context *context);
bool ValidateMatrixIndexPointerOES(const Context *context,
                                   GLint size,
                                   GLenum type,
                                   GLsizei stride,
                                   const void *pointer);
bool ValidateWeightPointerOES(const Context *context,
                              GLint size,
                              GLenum type,
                              GLsizei stride,
                              const void *pointer);

// GL_OES_point_size_array
bool ValidatePointSizePointerOES(const Context *context,
                                 VertexAttribType typePacked,
                                 GLsizei stride,
                                 const void *pointer);

// GL_OES_query_matrix
bool ValidateQueryMatrixxOES(const Context *context,
                             const GLfixed *mantissa,
                             const GLint *exponent);

// GL_OES_sample_shading
bool ValidateMinSampleShadingOES(const Context *context, GLfloat value);

// GL_OES_shader_io_blocks

// GL_OES_texture_3D
bool ValidateCompressedTexImage3DOES(const Context *context,
                                     TextureTarget targetPacked,
                                     GLint level,
                                     GLenum internalformat,
                                     GLsizei width,
                                     GLsizei height,
                                     GLsizei depth,
                                     GLint border,
                                     GLsizei imageSize,
                                     const void *data);
bool ValidateCompressedTexSubImage3DOES(const Context *context,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLint xoffset,
                                        GLint yoffset,
                                        GLint zoffset,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLenum format,
                                        GLsizei imageSize,
                                        const void *data);
bool ValidateCopyTexSubImage3DOES(const Context *context,
                                  TextureTarget targetPacked,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLint zoffset,
                                  GLint x,
                                  GLint y,
                                  GLsizei width,
                                  GLsizei height);
bool ValidateFramebufferTexture3DOES(const Context *context,
                                     GLenum target,
                                     GLenum attachment,
                                     TextureTarget textargetPacked,
                                     TextureID texturePacked,
                                     GLint level,
                                     GLint zoffset);
bool ValidateTexImage3DOES(const Context *context,
                           TextureTarget targetPacked,
                           GLint level,
                           GLenum internalformat,
                           GLsizei width,
                           GLsizei height,
                           GLsizei depth,
                           GLint border,
                           GLenum format,
                           GLenum type,
                           const void *pixels);
bool ValidateTexSubImage3DOES(const Context *context,
                              TextureTarget targetPacked,
                              GLint level,
                              GLint xoffset,
                              GLint yoffset,
                              GLint zoffset,
                              GLsizei width,
                              GLsizei height,
                              GLsizei depth,
                              GLenum format,
                              GLenum type,
                              const void *pixels);

// GL_OES_texture_border_clamp
bool ValidateGetSamplerParameterIivOES(const Context *context,
                                       SamplerID samplerPacked,
                                       GLenum pname,
                                       const GLint *params);
bool ValidateGetSamplerParameterIuivOES(const Context *context,
                                        SamplerID samplerPacked,
                                        GLenum pname,
                                        const GLuint *params);
bool ValidateGetTexParameterIivOES(const Context *context,
                                   TextureType targetPacked,
                                   GLenum pname,
                                   const GLint *params);
bool ValidateGetTexParameterIuivOES(const Context *context,
                                    TextureType targetPacked,
                                    GLenum pname,
                                    const GLuint *params);
bool ValidateSamplerParameterIivOES(const Context *context,
                                    SamplerID samplerPacked,
                                    GLenum pname,
                                    const GLint *param);
bool ValidateSamplerParameterIuivOES(const Context *context,
                                     SamplerID samplerPacked,
                                     GLenum pname,
                                     const GLuint *param);
bool ValidateTexParameterIivOES(const Context *context,
                                TextureType targetPacked,
                                GLenum pname,
                                const GLint *params);
bool ValidateTexParameterIuivOES(const Context *context,
                                 TextureType targetPacked,
                                 GLenum pname,
                                 const GLuint *params);

// GL_OES_texture_buffer
bool ValidateTexBufferOES(const Context *context,
                          TextureType targetPacked,
                          GLenum internalformat,
                          BufferID bufferPacked);
bool ValidateTexBufferRangeOES(const Context *context,
                               TextureType targetPacked,
                               GLenum internalformat,
                               BufferID bufferPacked,
                               GLintptr offset,
                               GLsizeiptr size);

// GL_OES_texture_cube_map
bool ValidateGetTexGenfvOES(const Context *context,
                            GLenum coord,
                            GLenum pname,
                            const GLfloat *params);
bool ValidateGetTexGenivOES(const Context *context,
                            GLenum coord,
                            GLenum pname,
                            const GLint *params);
bool ValidateGetTexGenxvOES(const Context *context,
                            GLenum coord,
                            GLenum pname,
                            const GLfixed *params);
bool ValidateTexGenfOES(const Context *context, GLenum coord, GLenum pname, GLfloat param);
bool ValidateTexGenfvOES(const Context *context, GLenum coord, GLenum pname, const GLfloat *params);
bool ValidateTexGeniOES(const Context *context, GLenum coord, GLenum pname, GLint param);
bool ValidateTexGenivOES(const Context *context, GLenum coord, GLenum pname, const GLint *params);
bool ValidateTexGenxOES(const Context *context, GLenum coord, GLenum pname, GLfixed param);
bool ValidateTexGenxvOES(const Context *context, GLenum coord, GLenum pname, const GLfixed *params);

// GL_OES_texture_cube_map_array

// GL_OES_texture_half_float

// GL_OES_texture_stencil8

// GL_OES_texture_storage_multisample_2d_array
bool ValidateTexStorage3DMultisampleOES(const Context *context,
                                        TextureType targetPacked,
                                        GLsizei samples,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLboolean fixedsamplelocations);

// GL_OES_vertex_array_object
bool ValidateBindVertexArrayOES(const Context *context, VertexArrayID arrayPacked);
bool ValidateDeleteVertexArraysOES(const Context *context,
                                   GLsizei n,
                                   const VertexArrayID *arraysPacked);
bool ValidateGenVertexArraysOES(const Context *context,
                                GLsizei n,
                                const VertexArrayID *arraysPacked);
bool ValidateIsVertexArrayOES(const Context *context, VertexArrayID arrayPacked);

// GL_OVR_multiview
bool ValidateFramebufferTextureMultiviewOVR(const Context *context,
                                            GLenum target,
                                            GLenum attachment,
                                            TextureID texturePacked,
                                            GLint level,
                                            GLint baseViewIndex,
                                            GLsizei numViews);

// GL_OVR_multiview2
}  // namespace gl

#endif  // LIBANGLE_VALIDATION_ESEXT_AUTOGEN_H_
